/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.langid;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.LangIDSession;
import com.ibm.dltj.LanguageGuess;
import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.implBase.Analyzer_ImplBase;
import com.ibm.dltj.uima_annotator.langid.ConfigurationMgr;
import com.ibm.dltj.uima_annotator.langid.LangIDAnalyzerContext;
import com.ibm.dltj.uima_annotator.langid.ResultSpecMgr;
import com.ibm.dltj.uima_annotator.langid.TypeSystemMgr;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import com.ibm.langware.annotator.jFrostAEProcessException;
import com.ibm.langware.annotator.jFrostResourceConfigException;
import com.ibm.langware.annotator.jFrostResourceInitException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public final class LangIDAnalyzer
extends Analyzer_ImplBase {
    private static final String CLASS_NAME = LangIDAnalyzer.class.getName();
    private final ConfigurationMgr mConfigMgr;
    private final TypeSystemMgr mTSMgr;
    private final ResultSpecMgr mRsltSpecMgr;
    private LangIDSession mLangIdSession;
    private final StringCharacterIterator mDocumentTextItr;

    public LangIDAnalyzer(UimaContext uimaContext) throws ResourceInitializationException {
        super(uimaContext);
        this.mConfigMgr = (ConfigurationMgr)this.mContext.getConfigurationManager();
        this.mTSMgr = (TypeSystemMgr)this.mContext.getTypeSystemManager();
        this.mRsltSpecMgr = (ResultSpecMgr)this.mContext.getResultSpecManager();
        this.mDocumentTextItr = new StringCharacterIterator("");
    }

    @Override
    public void init() throws ResourceInitializationException {
        try {
            this.mLangIdSession = new LangIDSession();
            this.mLangIdSession.unknownProcessing(this.mConfigMgr.mUnknownProcessing);
            this.mLangIdSession.setTieDelta(this.mConfigMgr.mTieDelta);
            this.mLangIdSession.setMaxCharsToExamine(this.mConfigMgr.mMaxCharsToExamine);
            CapMatrix.Entry entry = ((LangIDAnalyzerContext)this.mContext).getLangIDDictEntry(this.mConfigMgr.mLangIDDict);
            if (entry == null) {
                throw new jFrostResourceConfigException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LangIDAnalyzer__Error_Finding_Frost_LangID_dicts__SEVERE.name(), new Object[]{this.mConfigMgr.mLangIDDict, this.mConfigMgr.getjFrostDataSpec()});
            }
            try {
                entry.activate();
            }
            catch (DLTException dLTException) {
                throw new DLTException(Messages.getFormattedMessage(Messages.MessageKeys.LangIDAnalyzer__Cannot_Open_LangID_dict__SEVERE.name(), this.mConfigMgr.mLangIDDict));
            }
        }
        catch (Exception exception) {
            throw new jFrostResourceInitException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], exception);
        }
    }

    @Override
    public void destroy() {
        this.mLangIdSession.dispose();
    }

    @Override
    public void process(CAS cAS) throws AnalysisEngineProcessException {
        String string = cAS.getDocumentLanguage();
        if (this.mConfigMgr.mAcceptOnlyUnspecifiedInputLang && !"x-unspecified".equals(Language.normalize((String)string))) {
            return;
        }
        String string2 = cAS.getDocumentText();
        if (string2 == null || string2.length() == 0) {
            this.mContext.logMsg(Level.FINER, CLASS_NAME, "process", Messages.MessageKeys.LangIDAnalyzer__Empty_Document_Encountered__FINER.name());
            return;
        }
        if (this.mRsltSpecMgr.isResultSpecChanged()) {
            this.mRsltSpecMgr.readResultSpec();
        }
        if (!this.mRsltSpecMgr.mIsDocumentLangFeatReq) {
            return;
        }
        try {
            CapMatrix.Entry entry = ((LangIDAnalyzerContext)this.mContext).getLangIDDictEntry(this.mConfigMgr.mLangIDDict);
            if (entry == null) {
                throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LangIDAnalyzer__Error_Finding_Frost_LangID_dicts__SEVERE.name(), new Object[]{this.mConfigMgr.mLangIDDict, this.mConfigMgr.getjFrostDataSpec()});
            }
            Dictionary[] dictionaryArray = new Dictionary[]{entry.activate()};
            this.mLangIdSession.open(dictionaryArray);
            LowLevelCAS lowLevelCAS = cAS.getLowLevelCAS();
            int n = lowLevelCAS.ll_getFSRef((FeatureStructure)cAS.getDocumentAnnotation());
            LanguageGuess[] languageGuessArray = this.detectLanguages(string2);
            Object[] objectArray = this.getAcceptLanguages(lowLevelCAS, n);
            String string3 = this.getBestLanguage(languageGuessArray, (String[])objectArray);
            if (this.mContext.isTraceEnabled()) {
                for (LanguageGuess languageGuess : languageGuessArray) {
                    this.mContext.log(Level.FINER, languageGuess.getLanguage() + "(" + languageGuess.getConfidence() + "),");
                }
                this.mContext.logMsg(Level.FINER, CLASS_NAME, "process", Messages.MessageKeys.LangIDAnalyzer__Chars_To_Examine__FINER.name(), this.mConfigMgr.mMaxCharsToExamine);
                this.mContext.logMsg(Level.FINER, CLASS_NAME, "process", Messages.MessageKeys.LangIDAnalyzer__Setting_Accept_Languages__FINER.name(), Arrays.toString(objectArray));
                this.mContext.logMsg(Level.FINER, CLASS_NAME, "process", Messages.MessageKeys.LangIDAnalyzer__Setting_Language_To__FINER.name(), string3);
                if (string3.compareToIgnoreCase("x-unspecified") == 0) {
                    this.mContext.logMsg(Level.FINER, CLASS_NAME, "process", Messages.MessageKeys.LangIDAnalyzer__Unknown_Language_Encountered__FINER.name(), string2.length() > 80 ? string2.substring(80) : string2);
                }
            }
            if (string3.equals("x-unspecified")) {
                String string4 = this.getFallbackLanguage(lowLevelCAS, n);
                if (string4 != null) {
                    string3 = string4;
                }
                if (this.mContext.isTraceEnabled()) {
                    this.mContext.logMsg(Level.FINER, CLASS_NAME, "process", Messages.MessageKeys.LangIDAnalyzer__Setting_Fallback_Language__FINER.name(), string4);
                    if (string4 != null) {
                        this.mContext.logMsg(Level.FINER, CLASS_NAME, "process", Messages.MessageKeys.LangIDAnalyzer__Setting_Language_To__FINER.name(), string4);
                    }
                }
            }
            cAS.setDocumentLanguage(string3);
            if (this.mRsltSpecMgr.mIsLanguageCandidatesFeatReq) {
                this.createLanguageConfidenceList(lowLevelCAS, n, languageGuessArray);
            }
        }
        catch (DLTException dLTException) {
            this.mContext.logErrorMsg(Level.WARNING, CLASS_NAME, "process", Messages.MessageKeys.LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE.name(), (Exception)((Object)dLTException));
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
        }
        finally {
            this.mLangIdSession.close();
        }
    }

    private String getBestLanguage(LanguageGuess[] languageGuessArray, String[] stringArray) {
        if (stringArray == null) {
            return languageGuessArray.length == 0 ? "x-unspecified" : LangIDAnalyzer.adjustLanguageNames(languageGuessArray[0].getLanguage());
        }
        for (LanguageGuess languageGuess : languageGuessArray) {
            String string = languageGuess.getLanguage();
            Language language = new Language(languageGuess.getLanguage());
            for (String string2 : stringArray) {
                Language language2 = new Language(string2);
                if (language.getFullLanguage().equals(language2.getFullLanguage())) {
                    return string;
                }
                if (!language.getLanguagePart().equals(language2.getFullLanguage())) continue;
                return string;
            }
        }
        return this.mConfigMgr.mUseTheFirstAcceptLangAsFallBack ? stringArray[0] : "x-unspecified";
    }

    private String[] getAcceptLanguages(LowLevelCAS lowLevelCAS, int n) {
        if (this.mConfigMgr.mAcceptLanguages != null) {
            return this.mConfigMgr.mAcceptLanguages;
        }
        if (this.mTSMgr.mAcceptLangFeatCode < 0) {
            return null;
        }
        int n2 = lowLevelCAS.ll_getRefValue(n, this.mTSMgr.mAcceptLangFeatCode);
        if (n2 <= 0) {
            return null;
        }
        int n3 = lowLevelCAS.ll_getArraySize(n2);
        if (n3 == 0) {
            return null;
        }
        String[] stringArray = new String[n3];
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = lowLevelCAS.ll_getStringArrayValue(n2, i);
        }
        return stringArray;
    }

    private String getFallbackLanguage(LowLevelCAS lowLevelCAS, int n) {
        if (this.mConfigMgr.mFallbackLanguage != null) {
            return this.mConfigMgr.mFallbackLanguage;
        }
        if (this.mTSMgr.mFallbackLangFeatCode < 0) {
            return null;
        }
        String string = lowLevelCAS.ll_getStringValue(n, this.mTSMgr.mFallbackLangFeatCode);
        return string != null && string.length() != 0 ? string : null;
    }

    private LanguageGuess[] detectLanguages(String string) throws AnalysisEngineProcessException {
        try {
            this.mDocumentTextItr.setText(string);
            LanguageGuess[] languageGuessArray = this.mLangIdSession.identifyLanguage((CharacterIterator)this.mDocumentTextItr);
            return languageGuessArray;
        }
        catch (DLTException dLTException) {
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LANGWARE_LANGID_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
        }
        finally {
            this.mLangIdSession.reset();
        }
    }

    private void createLanguageConfidenceList(LowLevelCAS lowLevelCAS, int n, LanguageGuess[] languageGuessArray) {
        int n2 = lowLevelCAS.ll_createFS(this.mTSMgr.mEFsListTypeCode);
        int n3 = languageGuessArray.length;
        if (this.mConfigMgr.mMaxNumTopLanguages > 0 && this.mConfigMgr.mMaxNumTopLanguages < n3) {
            n3 = this.mConfigMgr.mMaxNumTopLanguages;
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = --n3; i >= 0; --i) {
            n5 = lowLevelCAS.ll_createFS(this.mTSMgr.mLanguageConfidencePairTypeCode);
            lowLevelCAS.ll_setStringValue(n5, this.mTSMgr.mLanguageConfidencePairLanguageFeatCode, LangIDAnalyzer.adjustLanguageNames(languageGuessArray[i].getLanguage()));
            lowLevelCAS.ll_setFloatValue(n5, this.mTSMgr.mLanguageConfidencePairConfidenceFeatCode, (float)languageGuessArray[i].getConfidence());
            n4 = lowLevelCAS.ll_createFS(this.mTSMgr.mNeFsListTypeCode);
            lowLevelCAS.ll_setRefValue(n4, this.mTSMgr.mHeadFeatCode, n5);
            lowLevelCAS.ll_setRefValue(n4, this.mTSMgr.mTailFeatCode, n2);
            n2 = n4;
        }
        lowLevelCAS.ll_setRefValue(n, this.mTSMgr.mDocLanguageCandidatesFeatCode, n2);
    }

    private static String adjustLanguageNames(String string) {
        if (string.compareToIgnoreCase("STL") == 0) {
            return "x-unspecified";
        }
        if (string.compareToIgnoreCase("x-STL") == 0) {
            return "x-unspecified";
        }
        if (string.compareToIgnoreCase("CTL") == 0) {
            return "x-unspecified";
        }
        if (string.compareToIgnoreCase("x-CTL") == 0) {
            return "x-unspecified";
        }
        return string;
    }

    @Override
    protected AnalyzerContext getNewAnalyzerContextInstance(UimaContext uimaContext) throws ResourceInitializationException {
        return new LangIDAnalyzerContext(uimaContext);
    }
}

