/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis;

import com.ibm.dltj.CapMatrix;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.uima_annotator.AnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.ConfigurationMgr;
import com.ibm.dltj.uima_annotator.lex_analysis.DictionariesCacheManager;
import com.ibm.dltj.uima_annotator.util.Language;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import com.ibm.langware.annotator.jFrostAEProcessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class LanguageDictionaries {
    private static final String CLASS_NAME = LanguageDictionaries.class.getName();
    private static final int[] GLOSS_TYPES_LEXICAL = new int[]{15, -17, -22, -56, -26};
    private static final int[] GLOSS_TYPES_LEXICAL_ZH = new int[]{1, 80, -17, -22, -56, -26};
    private static final int[] GLOSS_TYPES_VARIANT = new int[]{4};
    private static final int[] GLOSS_TYPES_TCR = new int[]{17};
    private static final int[] GLOSS_TYPES_SYNONYM = new int[]{22, 2};
    private static final int[] GLOSS_TYPES_MW = new int[]{56};
    private static final int[] GLOSS_TYPES_OOV = new int[]{26};
    public static String DICT_TYPE_LEXICAL = "LexicalDicts";
    public static String DICT_TYPE_VARIANT = "VariantDicts";
    public static String DICT_TYPE_TCR = "SpellCorrectionDicts";
    public static String DICT_TYPE_SYNONYM = "SynonymDicts";
    public static String DICT_TYPE_MW = "MultiWordDicts";
    public static String DICT_TYPE_OOV = "OOVDicts";
    public static String DICT_TYPE_LOOKUP = "LookupDicts";
    private final AnalyzerContext mContext;
    private final ConfigurationMgr mConfigMgr;
    private final CapMatrix mCapMatrix;
    private final DictionariesCacheManager mDictsCacheMgr;
    private Language mLanguage;
    protected Hashtable<String, Object> mDictsTable = new Hashtable();
    private static final Dictionary[] mEmptyDictsArray = new Dictionary[0];
    public String mBreakRulesSpec = null;
    public String mDecompositionRulesSpec = null;
    private static EntryComparator entryComparator = new EntryComparator();

    public LanguageDictionaries(AnalyzerContext analyzerContext) throws DLTException {
        this.mContext = analyzerContext;
        this.mConfigMgr = (ConfigurationMgr)this.mContext.getConfigurationManager();
        this.mCapMatrix = this.mConfigMgr.getjFrostCapabilityMatrix();
        this.mDictsCacheMgr = DictionariesCacheManager.getInstance();
        this.mDictsCacheMgr.updateDataSpec(this.mCapMatrix.getDataSpec());
    }

    public final void resetForLanguage(String string) throws AnalysisEngineProcessException {
        this.mLanguage = new Language(string);
        this.mBreakRulesSpec = this.mConfigMgr.getLanguageSpecificFileName(this.mContext.getUimaContext(), this.mLanguage, "BreakRulesSpec");
        this.mDecompositionRulesSpec = this.mConfigMgr.getLanguageSpecificFileName(this.mContext.getUimaContext(), this.mLanguage, "DecompositionRulesSpec");
        this.mDictsTable.clear();
        this.load();
    }

    public Language getLanguage() {
        return this.mLanguage;
    }

    public final Dictionary[] getDictsOfType(String string) {
        Dictionary[] dictionaryArray = (Dictionary[])this.mDictsTable.get(string);
        if (dictionaryArray == null) {
            if (string.equals(DICT_TYPE_LOOKUP)) {
                Dictionary[] dictionaryArray2 = this.getDictsOfType(DICT_TYPE_LEXICAL);
                int n = 0;
                Dictionary[] dictionaryArray3 = new Dictionary[dictionaryArray2.length];
                for (Dictionary dictionary : dictionaryArray2) {
                    if (dictionary.getSummary().hasFunction(85)) continue;
                    dictionaryArray3[n] = dictionary;
                    ++n;
                }
                dictionaryArray = new Dictionary[n];
                for (int i = 0; i < n; ++i) {
                    dictionaryArray[i] = dictionaryArray3[i];
                }
            } else {
                dictionaryArray = mEmptyDictsArray;
            }
            this.mDictsTable.put(string, dictionaryArray);
        }
        return dictionaryArray;
    }

    private void load() throws AnalysisEngineProcessException {
        if (this.mConfigMgr.mUseExplicitDicts) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "load", Messages.MessageKeys.LanguageDictionaries__Using_Explicit_Dictionaries__CONFIG.name());
            this.findByConfig(this.mContext.getUimaContext());
        } else {
            this.findByGlossTypes();
        }
        this.loadDicts();
    }

    protected void findByConfig(UimaContext uimaContext) {
        String[] stringArray = null;
        CapMatrix.Entry[] entryArray = null;
        stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.mLanguage, DICT_TYPE_LEXICAL);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__lexical__CONFIG.name()), stringArray);
        this.mDictsTable.put(DICT_TYPE_LEXICAL, entryArray);
        stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.mLanguage, DICT_TYPE_VARIANT);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__variant__CONFIG.name()), stringArray);
        this.mDictsTable.put(DICT_TYPE_VARIANT, entryArray);
        stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.mLanguage, DICT_TYPE_TCR);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__rule__CONFIG.name()), stringArray);
        this.mDictsTable.put(DICT_TYPE_TCR, entryArray);
        stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.mLanguage, DICT_TYPE_SYNONYM);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__synonym__CONFIG.name()), stringArray);
        this.mDictsTable.put(DICT_TYPE_SYNONYM, entryArray);
        stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.mLanguage, DICT_TYPE_MW);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__mwu__CONFIG.name()), stringArray);
        this.mDictsTable.put(DICT_TYPE_MW, entryArray);
        stringArray = this.mConfigMgr.getDictsForLang(uimaContext, this.mLanguage, DICT_TYPE_OOV);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__oov__CONFIG.name()), stringArray);
        this.mDictsTable.put(DICT_TYPE_OOV, entryArray);
    }

    protected void findByGlossTypes() throws AnalysisEngineProcessException {
        CapMatrix.Entry[] entryArray = null;
        entryArray = this.mLanguage.getLanguageWithNoTerritory().equals("zh") ? this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__lexical__CONFIG.name()), GLOSS_TYPES_LEXICAL_ZH) : this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__lexical__CONFIG.name()), GLOSS_TYPES_LEXICAL);
        this.mDictsTable.put(DICT_TYPE_LEXICAL, entryArray);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__variant__CONFIG.name()), GLOSS_TYPES_VARIANT);
        this.mDictsTable.put(DICT_TYPE_VARIANT, entryArray);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__rule__CONFIG.name()), GLOSS_TYPES_TCR);
        this.mDictsTable.put(DICT_TYPE_TCR, entryArray);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__synonym__CONFIG.name()), GLOSS_TYPES_SYNONYM);
        this.mDictsTable.put(DICT_TYPE_SYNONYM, entryArray);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__mwu__CONFIG.name()), GLOSS_TYPES_MW);
        this.mDictsTable.put(DICT_TYPE_MW, entryArray);
        entryArray = this.getCapMatrixEntries(Messages.getMessage(Messages.MessageKeys.LanguageDictionaries__oov__CONFIG.name()), GLOSS_TYPES_OOV);
        this.mDictsTable.put(DICT_TYPE_OOV, entryArray);
    }

    protected final CapMatrix.Entry[] getCapMatrixEntries(String string, String[] stringArray) {
        if (this.mContext.isTraceEnabled()) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "getCapMatrixEntries", Messages.MessageKeys.LanguageDictionaries__Finding_Frost_X_dictionaries__CONFIG.name(), string);
        }
        String[] stringArray2 = this.mConfigMgr.resolveDictionaryEntries(this.mContext, stringArray);
        ArrayList<CapMatrix.Entry> arrayList = new ArrayList<CapMatrix.Entry>(stringArray2.length);
        CapMatrix.Entry entry = null;
        for (String string2 : stringArray2) {
            try {
                File file = new File(string2);
                entry = file.isFile() ? this.mCapMatrix.getEntryByFile(file) : this.mCapMatrix.getEntryByFilename(string2);
            }
            catch (DLTException dLTException) {
                this.mContext.logErrorMsg(Level.SEVERE, CLASS_NAME, "getCapMatrixEntries", Messages.MessageKeys.LanguageDictionaries__Invalid_dictionary__SEVERE.name(), (Exception)((Object)dLTException));
                continue;
            }
            if (entry == null) continue;
            arrayList.add(entry);
        }
        String[] stringArray3 = new CapMatrix.Entry[arrayList.size()];
        stringArray3 = (CapMatrix.Entry[])arrayList.toArray(stringArray3);
        if (this.mContext.isTraceEnabled()) {
            this.logAvailableEntries(string, (CapMatrix.Entry[])stringArray3);
        }
        return stringArray3;
    }

    protected final CapMatrix.Entry[] getCapMatrixEntries(String string, int[] nArray) throws AnalysisEngineProcessException {
        if (this.mContext.isTraceEnabled()) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "getCapMatrixEntries", Messages.MessageKeys.LanguageDictionaries__Finding_Frost_X_dictionaries__CONFIG.name(), string);
        }
        try {
            CapMatrix.Entry[] entryArray = this.mCapMatrix.getAvailableEntries(this.mLanguage.getLanguageFullName() + "*", nArray);
            if (entryArray.length == 0 && this.mLanguage.hasTerritoryInformation()) {
                entryArray = this.mCapMatrix.getAvailableEntries(this.mLanguage.getLanguageWithNoTerritory() + "-*", nArray);
            }
            if (entryArray != null) {
                Arrays.sort(entryArray, entryComparator);
                if (this.mContext.isTraceEnabled()) {
                    this.logAvailableEntries(string, entryArray);
                }
                return entryArray;
            }
            return new CapMatrix.Entry[0];
        }
        catch (DLTException dLTException) {
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.FROST_EXCEPTION_ENCOUNTERED__SEVERE.name(), new Object[0], dLTException);
        }
    }

    private synchronized void loadDicts() throws AnalysisEngineProcessException {
        Iterator<Map.Entry<String, Object>> iterator = this.mDictsTable.entrySet().iterator();
        try {
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "loadDicts", Messages.MessageKeys.LanguageDictionaries__Loading_Frost_X_dictionaries__CONFIG.name(), entry.getKey());
                entry.setValue(this.mDictsCacheMgr.getDictionaries((CapMatrix.Entry[])entry.getValue()));
            }
        }
        catch (DLTException dLTException) {
            throw new jFrostAEProcessException("com.ibm.langware.annotator.messages", Messages.MessageKeys.LanguageDictionaries__could_not_activate_required_dictionaries__SEVERE.name(), new Object[0], dLTException);
        }
    }

    private void logAvailableEntries(String string, CapMatrix.Entry[] entryArray) {
        for (CapMatrix.Entry entry : entryArray) {
            this.mContext.logMsg(Level.CONFIG, CLASS_NAME, "logAvailableEntries", Messages.MessageKeys.LanguageDictionaries__Using_Frost_X_dictionary__CONFIG.name(), string, entry);
        }
    }

    static final class EntryComparator
    implements Comparator<CapMatrix.Entry> {
        EntryComparator() {
        }

        @Override
        public int compare(CapMatrix.Entry entry, CapMatrix.Entry entry2) {
            if (entry == entry2) {
                return 0;
            }
            return entry.getFile().getAbsolutePath().compareTo(entry2.getFile().getAbsolutePath());
        }
    }
}

