/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.uima_annotator.lex_analysis.es;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.TCRGloss;
import com.ibm.dltj.uima_annotator.lex_analysis.AnnotationsCreator;
import com.ibm.dltj.uima_annotator.lex_analysis.LexicalAnalyzerContext;
import com.ibm.dltj.uima_annotator.lex_analysis.TokenInfo;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ConfigurationMgrOF;
import com.ibm.dltj.uima_annotator.lex_analysis.es.LexicalAnalyzerOFContext;
import com.ibm.dltj.uima_annotator.lex_analysis.es.ResultHandlerQP;
import com.ibm.dltj.uima_annotator.lex_analysis.es.TypeSystemMgrOF;
import com.ibm.langware.annotator.Copyright;
import com.ibm.langware.annotator.Messages;
import java.text.CharacterIterator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.util.Level;

@Copyright(value="\n\n(C) Copyright IBM Corp. 2006, 2013.\n\n")
public class AnnotationsCreatorOF
extends AnnotationsCreator {
    private final LexicalAnalyzerOFContext mContext;
    private final ConfigurationMgrOF mConfigMgr;
    private final TypeSystemMgrOF mTSMgr;
    private CAS mCAS;

    public AnnotationsCreatorOF(LexicalAnalyzerContext lexicalAnalyzerContext) {
        super(lexicalAnalyzerContext);
        this.mContext = (LexicalAnalyzerOFContext)lexicalAnalyzerContext;
        this.mConfigMgr = (ConfigurationMgrOF)this.mContext.getConfigurationManager();
        this.mTSMgr = (TypeSystemMgrOF)this.mContext.getTypeSystemManager();
        this.mTSMgr.setUseTokenSubType(this.mConfigMgr.mUseTokenSubType);
    }

    @Override
    public void init(CAS cAS) throws AnalysisEngineProcessException {
        this.mCAS = cAS;
        super.init(cAS);
    }

    @Override
    public void reset() throws AnalysisEngineProcessException {
        this.mCAS = null;
        super.reset();
    }

    public void createNewBoostTermAnnotation(int n, int n2, int n3) {
        int n4 = this.mLLCas.ll_createFS(this.mTSMgr.mBoostTypeCode);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mEndFeatCode, n2);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
        this.mLLCas.ll_setIntValue(n4, this.mTSMgr.mBoostValueFeatCode, n3);
        this.mLLIndexRep.ll_addFS(n4);
    }

    public void createNewSynonymAnnotation(int n, int n2, GlossCollection glossCollection) {
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mQuerySynTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
        HashSet hashSet = new HashSet();
        hashSet.addAll(glossCollection);
        Iterator iterator = hashSet.iterator();
        int n4 = hashSet.size();
        int n5 = this.mLLCas.ll_createArray(this.mTSMgr.mStringArrayTypeCode, n4);
        for (int i = 0; i < n4; ++i) {
            TCRGloss tCRGloss = (TCRGloss)iterator.next();
            this.mLLCas.ll_setStringArrayValue(n5, i, tCRGloss.getValue());
        }
        this.mLLCas.ll_setRefValue(n3, this.mTSMgr.mQuerySynSynArrayFeatCode, n5);
        this.mLLIndexRep.ll_addFS(n3);
    }

    public void createNewStopwordAnnotation(int n, int n2) {
        int n3 = this.mLLCas.ll_createFS(this.mTSMgr.mStopwordTypeCode);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mStartFeatCode, n);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mEndFeatCode, n2);
        this.mLLCas.ll_setIntValue(n3, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
        this.mLLIndexRep.ll_addFS(n3);
    }

    @Override
    public int createNewCompoundAnnotation(TokenInfo tokenInfo, boolean bl) throws AnalysisEngineProcessException {
        if (this.mConfigMgr.mQueryProcessingMode) {
            int n = this.mLLCas.ll_createFS(this.mTSMgr.mCompoundTypeCode);
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mStartFeatCode, tokenInfo.begin);
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mEndFeatCode, tokenInfo.end);
            this.mLLCas.ll_setIntValue(n, this.mTSMgr.mSofaFeatCode, this.mSofaFSAddr);
            this.mLLIndexRep.ll_addFS(n);
            this.checkAndMarkNextBoundaryBegin(tokenInfo.begin);
            if (!bl) {
                return n;
            }
        }
        return super.createNewCompoundAnnotation(tokenInfo, bl);
    }

    public void processPreTokenizedQuery(Dictionary[] dictionaryArray, CharacterIterator characterIterator, ResultHandlerQP.QueryProcessingType queryProcessingType) {
        MatchBuffer matchBuffer = new MatchBuffer();
        LowLevelIterator lowLevelIterator = this.mLLIndexRep.ll_getIndex("AnnotationIndex", this.mTSMgr.mTokenTypeCode).ll_iterator();
        LowLevelIterator lowLevelIterator2 = this.mLLIndexRep.ll_getIndex("AnnotationIndex", this.mTSMgr.mTokenTypeCode).ll_iterator();
        for (Dictionary dictionary : dictionaryArray) {
            lowLevelIterator.moveToFirst();
            while (lowLevelIterator.isValid()) {
                int n = lowLevelIterator.ll_get();
                characterIterator.setIndex(this.mLLCas.ll_getIntValue(n, this.mTSMgr.mStartFeatCode));
                matchBuffer.clear();
                dictionary.traverse(characterIterator, matchBuffer);
                int n2 = matchBuffer.mpos;
                lowLevelIterator2.moveToLast();
                while (n2 > 0) {
                    int n3;
                    int n4;
                    int n5 = matchBuffer.index[--n2];
                    do {
                        n3 = lowLevelIterator2.ll_get();
                        n4 = this.mLLCas.ll_getIntValue(n3, this.mTSMgr.mEndFeatCode);
                        if (n3 == n) break;
                        lowLevelIterator2.moveToPrevious();
                    } while (lowLevelIterator2.isValid() && n5 < n4);
                    if (n5 == n4) {
                        int n6 = this.mLLCas.ll_getIntValue(n, this.mTSMgr.mStartFeatCode);
                        int n7 = matchBuffer.index[n2];
                        GlossCollection glossCollection = matchBuffer.gloss[n2];
                        queryProcessingType.createStd(this, n6, n7, glossCollection);
                        while (n != n3 && lowLevelIterator.isValid()) {
                            lowLevelIterator.moveToNext();
                            if (!lowLevelIterator.isValid()) continue;
                            n = lowLevelIterator.ll_get();
                        }
                        break;
                    }
                    if (lowLevelIterator2.isValid()) {
                        lowLevelIterator2.moveToNext();
                        if (lowLevelIterator2.isValid()) continue;
                        lowLevelIterator2.moveToLast();
                        continue;
                    }
                    lowLevelIterator2.moveToFirst();
                }
                lowLevelIterator.moveToNext();
            }
        }
    }

    public void processTokensInCompounds(Dictionary[] dictionaryArray, CharacterIterator characterIterator, ResultHandlerQP.QueryProcessingType queryProcessingType) {
        Type type = this.mCAS.getTypeSystem().getType("uima.tt.CompoundAnnotation");
        Type type2 = this.mCAS.getTypeSystem().getType("uima.tt.TokenAnnotation");
        FSIterator fSIterator = this.mCAS.getAnnotationIndex(type).iterator();
        fSIterator.moveToFirst();
        while (fSIterator.isValid()) {
            AnnotationFS annotationFS = (AnnotationFS)fSIterator.get();
            AnnotationIndex annotationIndex = this.mCAS.getAnnotationIndex(type2);
            FSIterator fSIterator2 = annotationIndex.subiterator(annotationFS);
            fSIterator2.moveToFirst();
            while (fSIterator2.isValid()) {
                AnnotationFS annotationFS2 = (AnnotationFS)fSIterator2.get();
                int n = annotationFS2.getBegin();
                int n2 = annotationFS2.getEnd();
                for (Dictionary dictionary : dictionaryArray) {
                    characterIterator.setIndex(n);
                    try {
                        GlossCollection glossCollection = dictionary.lookupWord(characterIterator, n2 - n);
                        if (glossCollection == null) continue;
                        queryProcessingType.createStd(this, n, n2, glossCollection);
                    }
                    catch (DLTException dLTException) {
                        this.mContext.logError(Level.WARNING, Messages.getFormattedMessage(Messages.MessageKeys.AnnotationsCreatorOF__Error_looking_up_dicts_for_token__WARNING.name(), dictionary, this.getTextSpan(n, n2)), (Exception)((Object)dLTException));
                    }
                }
                fSIterator2.moveToNext();
            }
            fSIterator.moveToNext();
        }
    }
}

