/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.system.rest.handlers;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.system.rest.handlers.SystemBaseRestApi;
import com.ibm.smarts.system.rest.handlers.SystemSemanticApiImpl;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="smarts/semantic")
public class SystemSemanticApi
extends SystemBaseRestApi {
    final SystemSemanticApiImpl semanticImpl;

    public SystemSemanticApi() {
        this.setUpContext();
        this.semanticImpl = new SystemSemanticApiImpl(this.system);
    }

    @GET
    @Produces(value={"application/json"})
    public Response syncGet(@QueryParam(value="question") String question, @QueryParam(value="smartsModuleRef") String smartsModuleRef) {
        return this.handleRequest(question, smartsModuleRef);
    }

    @POST
    @Produces(value={"application/json"})
    public Response syncPost(@QueryParam(value="question") String question, @QueryParam(value="smartsModuleRef") String smartsModuleRef) {
        return this.handleRequest(question, smartsModuleRef);
    }

    private Response handleRequest(String question, String smartsModuleRef) {
        if (question == null || question.isEmpty()) {
            return this.badRequest();
        }
        return this.handleRest(context -> this.semanticImpl.search((RequestContext)context, question, smartsModuleRef));
    }
}

