/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ir.visualizer;

import com.ibm.smarts.content.recommender.api.content.IRContent;
import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.visualization.recommender.api.IVisualizationRecommender;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IRVisualizerUtilParams {
    private final IVisualizationRecommender visRecommender;
    private final SmartsModule smartsModule;
    private final Locale locale;
    private final IRContent ir;
    private List<String> includedChartTypes;
    private List<String> excludedChartTypes;
    private boolean predictiveOnly = false;
    private double chartConfidenceRange = 0.15;
    private int maxChartFamilyFrequency = 2;
    private final Map<String, AggregationType> aggregationMap;

    public IRVisualizerUtilParams(IVisualizationRecommender visRecommender, SmartsModule smartsModule, IRContent ir, Locale locale) {
        this(visRecommender, smartsModule, ir, locale, Collections.emptyMap());
    }

    public IRVisualizerUtilParams(IVisualizationRecommender visRecommender, SmartsModule smartsModule, IRContent ir, Locale locale, Map<String, AggregationType> aggregationMap) {
        this.visRecommender = visRecommender;
        this.smartsModule = smartsModule;
        this.ir = ir;
        this.locale = locale;
        this.aggregationMap = aggregationMap;
    }

    public IVisualizationRecommender getVisRec() {
        return this.visRecommender;
    }

    public SmartsModule getSmartsModule() {
        return this.smartsModule;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public IRContent getIRContent() {
        return this.ir;
    }

    public List<String> getIncludedChartTypes() {
        return this.includedChartTypes;
    }

    public void setIncludedChartTypes(List<String> includedCharts) {
        this.includedChartTypes = includedCharts != null ? includedCharts : Collections.emptyList();
    }

    public List<String> getExcludedChartTypes() {
        return this.excludedChartTypes;
    }

    public void setExcludedChartTypes(List<String> excludedCharts) {
        this.excludedChartTypes = excludedCharts != null ? excludedCharts : Collections.emptyList();
    }

    public boolean isPredictiveOnly() {
        return this.predictiveOnly;
    }

    public void setPredictiveOnly(boolean is) {
        this.predictiveOnly = is;
    }

    public double getChartConfidenceRange() {
        return this.chartConfidenceRange;
    }

    public void setChartConfidenceRange(double d) {
        this.chartConfidenceRange = d;
    }

    public int getMaxChartFamilyFrequency() {
        return this.maxChartFamilyFrequency;
    }

    public void setMaxChartFamilyFrequency(int max) {
        this.maxChartFamilyFrequency = max;
    }

    public Map<String, AggregationType> getAggregationMap() {
        return this.aggregationMap;
    }
}

