/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.bi.recommendationmodel.Categorical;
import com.ibm.bi.recommendationmodel.ContextKeySerializer;
import com.ibm.bi.recommendationmodel.Geography;
import com.ibm.bi.recommendationmodel.Measure;
import com.ibm.bi.recommendationmodel.Temporal;

@JsonSerialize(using=ContextKeySerializer.class)
public class ContextKey {
    private Categorical categorical;
    private Geography geography;
    private Measure measure;
    private Temporal temporal;

    @JsonCreator
    protected ContextKey(@JsonProperty(value="categorical") Categorical categorical, @JsonProperty(value="geography") Geography geography, @JsonProperty(value="measure") Measure measure, @JsonProperty(value="temporal") Temporal temporal) {
        this.categorical = categorical;
        this.geography = geography;
        this.measure = measure;
        this.temporal = temporal;
    }

    protected ContextKey(ContextKey contextKey) {
        this.categorical = new Categorical(contextKey.getCategorical());
        this.geography = new Geography(contextKey.getGeography());
        this.measure = new Measure(contextKey.getMeasure());
        this.temporal = new Temporal(contextKey.getTemporal());
    }

    public int hashCode() {
        int result = 1;
        int prime = 31;
        result = prime * result + this.categorical.hashCode();
        result = prime * result + this.geography.hashCode();
        result = prime * result + this.measure.hashCode();
        result = prime * result + this.temporal.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContextKey contextKey = (ContextKey)obj;
        return this.categorical.equals(contextKey.categorical) && this.geography.equals(contextKey.geography) && this.measure.equals(contextKey.measure) && this.temporal.equals(contextKey.temporal);
    }

    public Categorical getCategorical() {
        return this.categorical;
    }

    public Geography getGeography() {
        return this.geography;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public Temporal getTemporal() {
        return this.temporal;
    }
}

