/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.ibm.bi.recommendationmodel.Context;
import com.ibm.bi.recommendationmodel.SlotMapping;
import java.io.IOException;
import java.util.List;

public class ContextSerializer
extends StdSerializer<Context> {
    private static final long serialVersionUID = 2282594312988853048L;

    public ContextSerializer() {
        this(null);
    }

    public ContextSerializer(Class<Context> context) {
        super(context);
    }

    public void serialize(Context context, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        provider.defaultSerializeValue((Object)context.getContextKey(), jgen);
        jgen.writeNumberField("score", context.getScore());
        jgen.writeNumberField("frequency", context.getFrequency());
        jgen.writeStringField("sentiment", context.getSentiment().name());
        List<SlotMapping> slotMappings = context.getMostFrequentSlotMappings(5);
        jgen.writeFieldName("slotMappings");
        jgen.writeStartArray();
        for (SlotMapping slotMapping : slotMappings) {
            provider.defaultSerializeValue((Object)slotMapping, jgen);
        }
        jgen.writeEndArray();
        jgen.writeEndObject();
    }
}

