/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.core.corenlp.annotator;

import com.ibm.smarts.nlp.core.uima.LWTokenizer;
import com.ibm.smarts.nlp.core.uima.UIMALexicalInfo;
import com.ibm.smarts.nlp.core.uima.UIMALexicalInfoList;
import com.ibm.smarts.nlp.core.uima.UIMAServiceProvider;
import com.ibm.smarts.nlp.core.uima.UIMAServiceProviderException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class LemmaAnnotatorLW
implements Annotator {
    private Locale locale;
    private LWTokenizer tokenizer;

    public LemmaAnnotatorLW(String name, Properties props) {
        if (UIMAServiceProvider.getInstance() == null) {
            throw new UIMAServiceProviderException("UIMA service provider not initialized");
        }
        this.locale = new Locale(props.getProperty("language", "en"));
        this.tokenizer = new LWTokenizer(UIMAServiceProvider.getInstance());
    }

    public void annotate(Annotation annotation) {
        for (CoreLabel token : (List)annotation.get(CoreAnnotations.TokensAnnotation.class)) {
            UIMALexicalInfoList outTemp = this.tokenizer.lemmatizeWithLW(token.word(), this.locale, true);
            if (outTemp != null) {
                token.set(CoreAnnotations.LemmaAnnotation.class, (Object)((UIMALexicalInfo)outTemp.get(0)).getLemma());
                continue;
            }
            token.set(CoreAnnotations.LemmaAnnotation.class, token.get(CoreAnnotations.TextAnnotation.class));
        }
    }

    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class)));
    }

    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(CoreAnnotations.LemmaAnnotation.class);
    }
}

