/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.recommenders.core.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ChartFamilyUtil {
    public static ChartFamily getChartFamily(String chartType) {
        for (ChartFamily family : ChartFamily.values()) {
            if (!family.getFamilyMembers().contains(chartType)) continue;
            return family;
        }
        return ChartFamily.NON_FAMILY;
    }

    public static enum ChartFamily {
        COLUMN_BAR_FAMILY("Column", "Bar"),
        FANCY_COLUMN_BAR_FAMILY("StackedColumn", "StackedBar", "ClusteredColumn", "ClusteredBar"),
        BUBBLE_FAMILY("Bubble", "PackedBubble", "Scatter", "Point"),
        AREA_FAMILY("Area", "StackedArea", "Line", "ClusteredLine"),
        NON_FAMILY(new String[0]);

        private final Set<String> members = new HashSet<String>();

        public Set<String> getFamilyMembers() {
            return this.members;
        }

        private ChartFamily(String ... strings) {
            this.members.addAll(Arrays.asList(strings));
        }
    }
}

