/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.recommenders.core.utils;

import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.recommenders.core.utils.ChartDescriptorLoader;
import com.ibm.smarts.recommenders.core.utils.ModelGenerator;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.exceptions.ChartDescriptorLoaderException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidChartDescriptor;
import com.ibm.smarts.visualization.recommender.internal.ChartDescriptorRegistery;
import com.ibm.smarts.visualization.recommender.internal.LabelChartsMapper;
import com.ibm.smarts.visualization.recommender.internal.modeling.ModelChartDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingSetGenerator {
    private static final String INVALID_NUM_PARAMETERS_ERR = "Invalid number of parameters";
    private static final String TRAINING_COMPLETE = "Trainingset generation tool - Training set generation complete";
    static final String HEADER = "CHART,X_CATEGORY,X_DATE,X_LOCATION,X_NUMERIC,X_CONCEPT,Y_CATEGORY,Y_DATE,Y_LOCATION,Y_NUMERIC,Y_CONCEPT,SERIES_CATEGORY,SERIES_DATE,SERIES_LOCATION,SERIES_NUMERIC,SERIES_CONCEPT,SIZE_CATEGORY,SIZE_DATE,SIZE_LOCATION,SIZE_NUMERIC,SIZE_CONCEPT";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelGenerator.class);
    private List<ModelChartDescriptor> descriptors = new ArrayList<ModelChartDescriptor>();
    private LabelChartsMapper mapper = new LabelChartsMapper();

    private void handleEquivelantCase(ModelChartDescriptor desc1, ModelChartDescriptor equivelant) {
        if (!desc1.getName().equals(equivelant.getName())) {
            desc1.addEquivelant(equivelant.getName());
            desc1.addEquivelants(equivelant.getEquivelants());
        }
    }

    private List<ModelChartDescriptor> handleSuperserCase(ModelChartDescriptor desc1, ModelChartDescriptor desc2) {
        List<ModelChartDescriptor> results = desc1.subtract(desc2);
        desc2.addEquivelant(desc1.getName());
        desc2.addEquivelants(desc1.getEquivelants());
        return results;
    }

    private List<ModelChartDescriptor> handleSubsetCase(ModelChartDescriptor desc1, ModelChartDescriptor desc2) {
        if (!desc1.getName().equals(desc2.getName())) {
            desc1.addEquivelant(desc2.getName());
            desc1.addEquivelants(desc2.getEquivelants());
        }
        return desc2.subtract(desc1);
    }

    private List<ModelChartDescriptor> handleIntersectionCase(ModelChartDescriptor desc1, ModelChartDescriptor desc2) {
        ArrayList<ModelChartDescriptor> result = new ArrayList<ModelChartDescriptor>();
        ModelChartDescriptor intersection = desc1.getIntersection(desc2);
        result.addAll(desc1.subtractIntersection(intersection));
        result.addAll(desc2.subtractIntersection(intersection));
        result.add(intersection);
        return result;
    }

    private List<ModelChartDescriptor> process(ModelChartDescriptor desc) {
        boolean isConcluded = false;
        ArrayList<ModelChartDescriptor> resultantCharts = new ArrayList<ModelChartDescriptor>();
        ListIterator<ModelChartDescriptor> iter = this.descriptors.listIterator();
        while (iter.hasNext() && !isConcluded) {
            ModelChartDescriptor d = iter.next();
            if (d.equaluivelant(desc)) {
                this.handleEquivelantCase(d, desc);
                isConcluded = true;
                continue;
            }
            if (d.isSupersetOf(desc)) {
                if (d.getName().equals(desc.getName())) continue;
                resultantCharts.addAll(this.handleSuperserCase(d, desc));
                iter.set(desc);
                isConcluded = true;
                continue;
            }
            if (d.isSubsetOf(desc)) {
                resultantCharts.addAll(this.handleSubsetCase(d, desc));
                isConcluded = true;
                continue;
            }
            if (!d.isIntersecting(desc)) continue;
            resultantCharts.addAll(this.handleIntersectionCase(d, desc));
            iter.remove();
            isConcluded = true;
        }
        if (!isConcluded) {
            this.descriptors.add(desc);
        }
        return resultantCharts;
    }

    private void processCharts(ChartDescriptorRegistery<IChartDescriptor> inDescriptors) throws InvalidChartDescriptor {
        for (IChartDescriptor descHl : inDescriptors) {
            ModelChartDescriptor desc = ModelChartDescriptor.getModelChartDescriptor(descHl);
            List<ModelChartDescriptor> subCharts = this.process(desc);
            while (!subCharts.isEmpty()) {
                ArrayList<ModelChartDescriptor> newSubCharts = new ArrayList<ModelChartDescriptor>();
                for (ModelChartDescriptor d : subCharts) {
                    newSubCharts.addAll(this.process(d));
                }
                subCharts = newSubCharts;
            }
        }
        int id = 1;
        for (ModelChartDescriptor desc : this.descriptors) {
            desc.setLabel("" + id++);
        }
    }

    public static void loadStdCharts(ChartDescriptorRegistery<IChartDescriptor> reg, String path) throws ChartDescriptorLoaderException {
        ChartDescriptorLoader.loadStdChartDescriptors(reg, path);
    }

    public static void loadExtCharts(ChartDescriptorRegistery<IChartDescriptor> reg, String extenstionChartsPath, String extenstionChartTypesPath) throws ChartDescriptorLoaderException {
        ChartDescriptorLoader.loadExtensionChartDescriptors(reg, extenstionChartsPath == null ? Optional.empty() : Optional.of(extenstionChartsPath), extenstionChartTypesPath == null ? Optional.empty() : Optional.of(extenstionChartTypesPath));
    }

    private List<ModelChartDescriptor> combineDescriptors() {
        ArrayList<ModelChartDescriptor> combined = new ArrayList<ModelChartDescriptor>();
        HashMap<String, ArrayList<ModelChartDescriptor>> map = new HashMap<String, ArrayList<ModelChartDescriptor>>();
        for (ModelChartDescriptor modelChartDescriptor : this.descriptors) {
            ArrayList<ModelChartDescriptor> list = (ArrayList<ModelChartDescriptor>)map.get(modelChartDescriptor.getName());
            if (list == null) {
                list = new ArrayList<ModelChartDescriptor>();
                list.add(modelChartDescriptor);
                map.put(modelChartDescriptor.getName(), list);
                continue;
            }
            list.add(modelChartDescriptor);
        }
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<ModelChartDescriptor> subCombined = new ArrayList<ModelChartDescriptor>();
            List list = (List)entry.getValue();
            while (!list.isEmpty()) {
                ModelChartDescriptor first = (ModelChartDescriptor)list.remove(0);
                ListIterator iter = list.listIterator();
                while (iter.hasNext()) {
                    ModelChartDescriptor other = (ModelChartDescriptor)iter.next();
                    if (!first.isCombinable(other)) continue;
                    first = first.combine(other);
                    iter.remove();
                }
                subCombined.add(first);
            }
            combined.addAll(subCombined);
        }
        int id = 1;
        for (ModelChartDescriptor desc : combined) {
            desc.setLabel("" + id++);
        }
        return combined;
    }

    public void generateTrainingSet(String stdChartsPath, String extenstionChartsPath, String extenstionChartTypesPath, String traininsetFile, String traininsetSpecFile) {
        try {
            ChartDescriptorRegistery<IChartDescriptor> inDescriptors = new ChartDescriptorRegistery<IChartDescriptor>();
            TrainingSetGenerator.loadStdCharts(inDescriptors, stdChartsPath);
            TrainingSetGenerator.loadExtCharts(inDescriptors, extenstionChartsPath, extenstionChartTypesPath);
            this.processCharts(inDescriptors);
            List<ModelChartDescriptor> combined = this.combineDescriptors();
            File trainingsetFile = new File(traininsetFile);
            File labelMapFile = new File(traininsetSpecFile);
            try (PrintWriter trainingsetWriter = new PrintWriter(trainingsetFile, "UTF-8");
                 PrintWriter mapperWriter = new PrintWriter(labelMapFile, "UTF-8");){
                trainingsetWriter.println(HEADER);
                for (ModelChartDescriptor desc : combined) {
                    List<String> examples = desc.generateExamples();
                    for (String example : examples) {
                        trainingsetWriter.println(desc.getLabel() + "," + example.replaceAll("\\[", "").replaceAll("\\]", ""));
                    }
                    HashSet<String> charts = new HashSet<String>();
                    charts.add(desc.getName());
                    charts.addAll(desc.getEquivelants());
                    this.mapper.addLabelmappings(desc.getLabel(), charts);
                }
                mapperWriter.println(JsonParserHelper.toJson((Object)this.mapper));
            }
        }
        catch (ChartDescriptorLoaderException | InvalidChartDescriptor | FileNotFoundException | UnsupportedEncodingException e) {
            LOGGER.error(e.toString());
        }
    }

    public static void main(String[] params) {
        if (params.length != 5) {
            LOGGER.error(INVALID_NUM_PARAMETERS_ERR);
        }
        TrainingSetGenerator parser = new TrainingSetGenerator();
        parser.generateTrainingSet(params[0], params[1], params[2], params[3], params[4]);
        LOGGER.info(TRAINING_COMPLETE);
    }
}

