/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.api;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBaseChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.exceptions.RecommendationException;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IExternalChartDescriptor
extends IBaseChartDescriptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(IExternalChartDescriptor.class);
    public static final int MAX_DISTINCT_COUNT = 100;

    default public double getScore() {
        return this.getMinChartScore();
    }

    default public Map<String, String> getMapColumnIdForExpresionToColumnName(List<IDataColumn> columns) {
        List allColumns = columns.stream().flatMap(c -> {
            if (c.isHierchical()) {
                return c.getHierarchy().stream();
            }
            return Stream.of(c);
        }).collect(Collectors.toList());
        return allColumns.stream().collect(Collectors.toMap(IDataColumn::getIdForExpression, IDataColumn::getName, (c1, c2) -> c1));
    }

    default public void addNaturalLanguageToBinding(Locale locale, List<IDataColumn> columns, BindingResult binding) {
        String ALL = "_ALL";
        if (locale != null) {
            Map<String, String> mapColumnIdForExpresionToColumnName = this.getMapColumnIdForExpresionToColumnName(columns);
            HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
            parameters.putAll(binding.getBinding().stream().collect(Collectors.toMap(Binding::getSlot, b -> b.getColumns().stream().map(c -> mapColumnIdForExpresionToColumnName.getOrDefault(c, (String)c)).collect(Collectors.toList()), (l1, l2) -> {
                l1.addAll(l2);
                return l1;
            })));
            parameters.put("_ALL", binding.getBinding().stream().flatMap(b -> b.getColumns().stream().map(c -> mapColumnIdForExpresionToColumnName.getOrDefault(c, (String)c))).collect(Collectors.toList()));
            binding.setNaturalLanguage(this.getLabel(parameters, locale), this.getTitle(parameters, locale), this.getDescription(parameters, locale), locale);
        }
    }

    public String getLabel(Map<String, List<String>> var1, Locale var2);

    public String getTitle(Map<String, List<String>> var1, Locale var2);

    public String getDescription(Map<String, List<String>> var1, Locale var2);

    public List<String> getSlots();

    public ExternalRecommendedVisualization recommend(String var1, List<IDataColumn> var2, List<Binding> var3, VisualizationParameters var4) throws RecommendationException;

    public List<IBindingResult> bind(Locale var1, List<Binding> var2, Map<String, IDataColumn> var3, List<IDataColumn> var4, boolean var5) throws BindingException;

    public boolean validateBindings(List<IDataColumn> var1, List<Binding> var2);

    public long getNumberOfChartsElements();
}

