/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.generated.parser.ParseException;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.BaseMultiMeasureSlotChart;
import com.ibm.smarts.visualization.recommender.external.charts.extensions.FeatureType;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGUtils;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiMeasureCrosstabAbstract
extends BaseMultiMeasureSlotChart {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiMeasureCrosstabAbstract.class);
    private static final double PREFERABLE_SCORE = 1.0;
    private static final String NLG_LABEL_ID = "IDS_LBL_BY_PLAIN_FOR";
    private static final String NLG_TITLE_ID = "IDS_TITLE_CROSSTAB";
    private static final String NLG_VIS_ID_PREFIX = "IDS_CHART_TYPE_";
    private static final String NLG_CODE = "strings.nlgRecommender";
    private static final String VALUE_SLOT = "VALUE";
    protected static final String CHART_NAME = "Crosstab";
    private List<SlotType> mandatorySlots = Arrays.asList(SlotType.ROW, SlotType.COLUMN, SlotType.VALUE);
    private static final int MAX_COLUMNS = 50;

    protected MultiMeasureCrosstabAbstract(String labelId, String titleId, String descriptionId, List<ChartElement> elements, PreferenceLevel preference) {
        super(CHART_NAME, labelId, titleId, descriptionId, elements, preference);
    }

    protected List<SlotType> getMandatorySlots() {
        return this.mandatorySlots;
    }

    @Override
    public long getNumberOfChartsElements() {
        return 50L;
    }

    @Override
    public List<String> getSlots() {
        return this.getMandatorySlots().stream().map(s -> ((SlotType)s).slotName).collect(Collectors.toList());
    }

    @Override
    public boolean acceptsNoneAggregation() {
        return true;
    }

    protected static List<String> getColumnIdForExpression(IDataColumn column) {
        if (column.isHierchical()) {
            return column.getHierarchy().stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList());
        }
        return Arrays.asList(column.getIdForExpression());
    }

    protected static List<String> getColumnsIdForExpression(Collection<IDataColumn> columns) {
        return columns.stream().flatMap(c -> MultiMeasureCrosstabAbstract.getColumnIdForExpression(c).stream()).collect(Collectors.toList());
    }

    private List<Binding> bindColumns(List<SlotType> inSlots, List<IDataColumn> hierarchies, List<IDataColumn> entities, List<IDataColumn> measures, List<IDataColumn> mixed) {
        EnumMap<ColumnType, List<IDataColumn>> columnTypeMap = new EnumMap<ColumnType, List<IDataColumn>>(ColumnType.class);
        columnTypeMap.put(ColumnType.HIERARCHY, hierarchies);
        columnTypeMap.put(ColumnType.ENTITY, entities);
        columnTypeMap.put(ColumnType.MIXED, mixed);
        columnTypeMap.put(ColumnType.MEASURE, measures);
        inSlots.sort(Comparator.comparingInt(SlotType::getPriority));
        Function<SlotType, Binding> binder = slot -> {
            List<ColumnType> slotTypes = slot.getCompatibleTypes();
            Binding binding = null;
            for (ColumnType slotType : slotTypes) {
                List columns = (List)columnTypeMap.get((Object)slotType);
                if (columns.isEmpty()) continue;
                if (slot.isMultiColumn()) {
                    binding = new Binding(MultiMeasureCrosstabAbstract.getColumnsIdForExpression(columns), slot.getSlotName());
                    columns.clear();
                    continue;
                }
                IDataColumn column = (IDataColumn)columns.remove(0);
                binding = new Binding(MultiMeasureCrosstabAbstract.getColumnIdForExpression(column), slot.getSlotName());
                break;
            }
            return binding;
        };
        return inSlots.stream().map(binder::apply).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public ExternalRecommendedVisualization recommend(String combinationId, List<IDataColumn> columns, List<Binding> constraints, VisualizationParameters parameters) {
        double targetScore;
        Map<Boolean, List<IDataColumn>> partitioned = columns.stream().collect(Collectors.partitioningBy(IDataColumn::isHierchical));
        Map<FeatureType, List<IDataColumn>> classifications = this.classifyColumns(partitioned.get(false));
        List<IDataColumn> hierarchies = partitioned.get(true);
        List<IDataColumn> entities = classifications.getOrDefault((Object)FeatureType.ENTITY, Collections.emptyList());
        List<IDataColumn> mixed = classifications.getOrDefault((Object)FeatureType.MIXED, Collections.emptyList());
        List<IDataColumn> measures = classifications.getOrDefault((Object)FeatureType.MEASURE, Collections.emptyList());
        double d = targetScore = hierarchies.isEmpty() ? this.getMinChartScore() : 1.0;
        if (hierarchies.isEmpty() && entities.isEmpty() && mixed.isEmpty()) {
            return null;
        }
        List<Binding> bindings = this.bindColumns(this.getMandatorySlots(), hierarchies, entities, measures, mixed);
        if (!hierarchies.isEmpty() || !entities.isEmpty()) {
            return null;
        }
        Set boundSlots = bindings.stream().map(Binding::getSlot).collect(Collectors.toSet());
        if (this.getMandatorySlots().stream().map(SlotType::getSlotName).anyMatch(s -> !boundSlots.contains(s))) {
            return null;
        }
        ExternalRecommendedVisualization recommendation = new ExternalRecommendedVisualization(this, bindings, targetScore, 0, combinationId);
        recommendation.setBaseFilterList(parameters.getBaseFilterList());
        recommendation.setAggregationMap(parameters.getAggregationMap());
        Locale locale = parameters != null && parameters.getRequestContext() != null ? parameters.getRequestContext().locale : null;
        Optional<ChartDescription> des = this.getDescription(bindings, columns, locale);
        if (des.isPresent()) {
            recommendation.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
        }
        return recommendation;
    }

    @Override
    public List<IBindingResult> bind(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unboundColumns, boolean forceBinding) throws BindingException {
        Set validSlotNames = this.getMandatorySlots().stream().map(SlotType::getSlotName).collect(Collectors.toSet());
        List<Binding> wrong = bound.stream().filter(b -> !validSlotNames.contains(b.getSlot())).collect(Collectors.toList());
        if (!wrong.isEmpty()) {
            throw new BindingException(new InvalidColumnBindingException(wrong));
        }
        Map<Boolean, List<IDataColumn>> partitioned = IDataColumn.formHierarchy(unboundColumns).stream().collect(Collectors.partitioningBy(IDataColumn::isHierchical));
        Map<FeatureType, List<IDataColumn>> classifications = this.classifyColumns(partitioned.get(false));
        List<IDataColumn> hierarchies = partitioned.get(true);
        List<IDataColumn> entities = classifications.getOrDefault((Object)FeatureType.ENTITY, Collections.emptyList());
        List<IDataColumn> mixed = classifications.getOrDefault((Object)FeatureType.MIXED, Collections.emptyList());
        List<IDataColumn> measures = classifications.getOrDefault((Object)FeatureType.MEASURE, Collections.emptyList());
        ArrayList<Binding> bindings = new ArrayList<Binding>(bound);
        ArrayList<String> unboundColumnNames = new ArrayList<String>();
        Set boundSlots = bound.stream().map(Binding::getSlot).collect(Collectors.toSet());
        ArrayList<SlotType> availableSlots = new ArrayList<SlotType>();
        availableSlots.add(SlotType.VALUE);
        availableSlots.addAll(this.getMandatorySlots().stream().filter(s -> !boundSlots.contains(s.getSlotName())).collect(Collectors.toList()));
        bindings.addAll(this.bindColumns(availableSlots, hierarchies, entities, measures, mixed));
        hierarchies.forEach(e -> unboundColumnNames.add(e.getIdForExpression()));
        entities.forEach(e -> unboundColumnNames.add(e.getIdForExpression()));
        Stream<IDataColumn> boundColumns = boundColumnInfo.entrySet().stream().map(Map.Entry::getValue);
        List<IDataColumn> columns = Stream.concat(boundColumns, unboundColumns.stream()).collect(Collectors.toList());
        int remainingSlots = this.getMandatorySlots().size() - (int)bindings.stream().map(b -> b.getSlot()).distinct().count();
        BindingResult binding = new BindingResult(locale, this.getName(), bindings, unboundColumnNames, remainingSlots, this.preference);
        Optional<ChartDescription> des = this.getDescription(bindings, columns, locale);
        if (des.isPresent()) {
            binding.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
        }
        return Arrays.asList(binding);
    }

    Optional<ChartDescription> getDescription(List<Binding> bindings, List<IDataColumn> columns, Locale locale) {
        Map<String, String> idToName = this.getMapColumnIdForExpresionToColumnName(columns);
        if (ChartNLGUtils.NLGSupported(locale)) {
            ResourceBundle bundle = ResourceBundle.getBundle(NLG_CODE, locale);
            ArrayList<Object> labelParams = new ArrayList<Object>();
            ArrayList one = new ArrayList();
            ArrayList two = new ArrayList();
            labelParams.add(one);
            labelParams.add(two);
            bindings.forEach(b -> {
                if (b.getSlot().equals(VALUE_SLOT)) {
                    b.getColumns().forEach(c -> one.add(idToName.get(c)));
                } else {
                    b.getColumns().forEach(c -> two.add(idToName.get(c)));
                }
            });
            ArrayList<Object> titleParams = new ArrayList<Object>();
            ArrayList<String> vis = new ArrayList<String>();
            vis.add(bundle.getString(NLG_VIS_ID_PREFIX + this.getName()));
            titleParams.add(vis);
            titleParams.add(one);
            titleParams.add(two);
            try {
                String label = ChartNLGUtils.realiseNLG(bundle.getString(NLG_LABEL_ID), labelParams);
                String title = ChartNLGUtils.realiseNLG(bundle.getString(NLG_TITLE_ID), titleParams);
                String description = ChartNLGUtils.generateDescription(ChartNLGUtils.getFeaturesForDescription(columns), idToName, bundle);
                return Optional.of(new ChartDescription(label, title, description, locale));
            }
            catch (ParseException e) {
                LOGGER.error("Parsing error generating description for MultiMeasureCrosstab." + (Object)((Object)e));
            }
        } else if (locale != null) {
            Map<String, List<String>> parameters = this.getParameters(bindings, idToName);
            return Optional.of(new ChartDescription(this.getLabel(parameters, locale), this.getTitle(parameters, locale), this.getDescription(parameters, locale), locale));
        }
        return Optional.empty();
    }

    static enum SlotType {
        ROW("ROW_HIERARCHY", 1, Arrays.asList(ColumnType.HIERARCHY, ColumnType.ENTITY, ColumnType.MIXED), false),
        COLUMN("COLUMN_HIERARCHY", 2, Arrays.asList(ColumnType.HIERARCHY, ColumnType.ENTITY, ColumnType.MIXED), false),
        VALUE("VALUE", 3, Arrays.asList(ColumnType.MIXED, ColumnType.MEASURE), true);

        private String slotName;
        private List<ColumnType> compatibleTypes;
        private int priority;
        private boolean multiColumn;

        private SlotType(String name, int prio, List<ColumnType> compatibleTypes, boolean multiColumn) {
            this.slotName = name;
            this.priority = prio;
            this.compatibleTypes = compatibleTypes;
            this.multiColumn = multiColumn;
        }

        String getSlotName() {
            return this.slotName;
        }

        public int getPriority() {
            return this.priority;
        }

        public List<ColumnType> getCompatibleTypes() {
            return this.compatibleTypes;
        }

        public boolean isMultiColumn() {
            return this.multiColumn;
        }
    }

    static enum ColumnType {
        HIERARCHY,
        ENTITY,
        MIXED,
        MEASURE;

    }
}

