/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.external.charts.extensions;

import com.ibm.icu.text.MessageFormat;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.generated.parser.ParseException;
import com.ibm.smarts.ontology.registry.util.ConceptsUtil;
import com.ibm.smarts.recommenders.core.utils.VisNLGUtils;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.IExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.api.VisualizationParameters;
import com.ibm.smarts.visualization.recommender.exceptions.BindingException;
import com.ibm.smarts.visualization.recommender.exceptions.RecommendationException;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGUtils;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartElements;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tiledmap
implements IExternalChartDescriptor {
    private static final String INVALID_SLOT = "Invalid Slot: ";
    private static final String NAME = "Tiledmap";
    private static final String LAYER_SLOT_SEPARATOR = "_";
    private static final double SCORE = 1.0;
    private static final String NLG_CODE = "strings.nlgRecommender";
    private static final String IDS_LBL_PLAIN = "IDS_LBL_PLAIN";
    private static final String IDS_TITLE_SIMPLE_SHOW = "IDS_TITLE_SIMPLE_SHOW";
    private static final String IDS_CHART_TYPE_PREFIX = "IDS_CHART_TYPE_";
    private static final int NLG_TWO_PARAMS = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(Tiledmap.class);
    private Map<String, ResourceBundle> resourceBundles = new HashMap<String, ResourceBundle>();
    private static final String BASE_STRING_NAME = "strings.visRecommenderExtStrings";
    private static final String ALL = "_ALL";
    private int rank;
    private static final String IDS_REGION = "IDS_REGION";
    private static final String IDS_REGION_COLOR = "IDS_REGION_COLOR";
    private static final String IDS_REGION_TITLE = "IDS_REGION_TITLE";
    private static final String IDS_REGION_COLOR_TITLE = "IDS_REGION_COLOR_TITLE";
    private static final String IDS_POINT = "IDS_POINT";
    private static final String IDS_POINT_TITLE = "IDS_POINT_TITLE";
    private static final String IDS_POINT_COLOR = "IDS_POINT_COLOR";
    private static final String IDS_POINT_COLOR_TITLE = "IDS_POINT_COLOR_TITLE";
    private static final String IDS_POINT_SIZE = "IDS_POINT_SIZE";
    private static final String IDS_POINT_SIZE_TITLE = "IDS_POINT_SIZE_TITLE";
    private static final String IDS_POINT_COLOR_SIZE = "IDS_POINT_COLOR_SIZE";
    private static final String IDS_POINT_COLOR_SIZE_TITLE = "IDS_POINT_COLOR_SIZE_TITLE";
    private static final String IDS_COORDS = "IDS_COORDS";
    private static final String IDS_COORDS_SIZE = "IDS_COORDS_SIZE";
    private static final String IDS_COORDS_COLOR = "IDS_COORDS_COLOR";
    private static final String IDS_COORDS_COLOR_SIZE = "IDS_COORDS_COLOR_SIZE";
    private static final String IDS_COORDS_TITLE = "IDS_COORDS_TITLE";
    private static final String IDS_COORDS_SIZE_TITLE = "IDS_COORDS_SIZE_TITLE";
    private static final String IDS_COORDS_COLOR_TITLE = "IDS_COORDS_COLOR_TITLE";
    private static final String IDS_COORDS_COLOR_SIZE_TITLE = "IDS_COORDS_COLOR_SIZE_TITLE";
    private static final String IDS_GENERIC_MEASURES = "IDS_GENERIC_MEASURES";
    private static final String IDS_MAP_TITLE = "IDS_MAP_TITLE";
    private static final String IDS_MAP_REGION_TITLE = "IDS_MAP_REGION_TITLE";
    private static final String IDS_MAP_COORD_TITLE = "IDS_MAP_COORD_TITLE";
    private static final String IDS_MAP_COORD_SIZE = "IDS_MAP_COORD_SIZE";
    private static final String IDS_MAP_COORD_COLOR = "IDS_MAP_COORD_COLOR";
    private static final String IDS_MAP_POINT_TITLE = "IDS_MAP_POINT_TITLE";
    private static final String IDS_MAP_AND = "IDS_MAP_AND";
    private static final String IDS_MAP_COMMA = "IDS_MAP_COMMA";
    private static final String IDS_MAP_REGION_COLOR = "IDS_MAP_REGION_COLOR";
    private static final String IDS_MAP_POINT_COLOR = "IDS_MAP_POINT_COLOR";
    private static final String IDS_MAP_POINT_SIZE = "IDS_MAP_POINT_SIZE";
    private static final String IDS_MAP_POINTS = "IDS_MAP_POINTS";
    private static final String IDS_MAP_BUBBLES = "IDS_MAP_BUBBLES";
    private static final String IDS_MAP_DESCRIPTION = "IDS_MAP_DESCRIPTION";
    private static final String IDS_MAP_REGION = "IDS_MAP_REGION";
    private static final String IDS_MAP_POINT = "IDS_MAP_POINT";
    private static final String IDS_MAP_COORDINATE = "IDS_MAP_COORDINATE";
    private static final String REGION_LOCATION = "REGION_LOCATION";
    private static final String REGION_COLOR = "REGION_COLOR";
    private static final String POINT_LOCATION = "POINT_LOCATION";
    private static final String POINT_COLOR = "POINT_COLOR";
    private static final String POINT_SIZE = "POINT_SIZE";
    private static final String POINT_COLOR_SIZE = "POINT_COLOR_SIZE";
    private static final String COORDINATE_LATITUDE = "COORDINATE_LATITUDE";
    private static final String COORDINATE_LONGITUDE = "COORDINATE_LONGITUDE";
    private static final String COORDINATE_SIZE = "COORDINATE_SIZE";
    private static final String COORDINATE_COLOR = "COORDINATE_COLOR";
    protected static Set<Quantity> quantities = new HashSet<Quantity>(Arrays.asList(Quantity.NONE, Quantity.FEW, Quantity.MODERATE, Quantity.MANY));
    private final PreferenceLevel preference = PreferenceLevel.HIGH;
    private static List<ChartElement> chartElements = Arrays.asList(new ChartElement(StdChartElements.REGION_LOCATION.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.REGION_COLOR.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.POINT_LOCATION.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.POINT_COLOR.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.POINT_SIZE.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.COORDINATE_LONGITUDE.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.COORDINATE_LATITUDE.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.COORDINATE_COLOR.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.COORDINATE_SIZE.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1), new ChartElement(StdChartElements.COORDINATE_LABEL.name(), quantities, Requirment.ANY, Requirment.ANY, Requirment.ANY, 1));

    @Override
    public List<ChartElement> getElements() {
        return chartElements;
    }

    private Features extractMapFeatures(List<Feature> features) {
        return new Features(features);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public PreferenceLevel getPreference() {
        return this.preference;
    }

    private void unpackBinding(Binding binding, Optional<Feature> feature, List<BaseLayer> layerList) throws BindingException {
        String[] tokens = binding.getSlot().trim().split(LAYER_SLOT_SEPARATOR);
        if (tokens.length != 2) {
            throw new BindingException(INVALID_SLOT + binding.getSlot());
        }
        LayerType layerType = LayerType.fromString(tokens[0]);
        if (layerType == null) {
            throw new BindingException(INVALID_SLOT + binding.getSlot());
        }
        SlotType slotType = SlotType.fromString(tokens[1]);
        if (slotType == null) {
            throw new BindingException(INVALID_SLOT + binding.getSlot());
        }
        if (feature.isPresent() && slotType.featureTypes.stream().noneMatch(s -> s.concept.equals(((Feature)feature.get()).concept))) {
            throw new BindingException("Invalid binding - types do not match " + binding);
        }
        if (layerList == null) {
            return;
        }
        for (BaseLayer layer : layerList) {
            Slot slot;
            if (layer.getLayerType() != layerType || !layer.contains(slotType) || (slot = layer.getSlotOfType(slotType)) == null) continue;
            layer.setActive(true);
            slot.addColumns(binding.getColumns());
            return;
        }
    }

    private void unpackBindings(List<Binding> inBindings, List<BaseLayer> layerList) throws BindingException {
        for (Binding b : inBindings) {
            this.unpackBinding(b, Optional.empty(), layerList);
        }
    }

    private boolean validateFeatureBindings(List<Feature> features, List<Binding> bindings) {
        Map<String, List> featuresMap = features.stream().collect(Collectors.toMap(f -> f.column.getIdForExpression(), f -> Stream.of(f).collect(Collectors.toList()), (f1, f2) -> Stream.concat(f1.stream(), f2.stream()).collect(Collectors.toList())));
        return bindings.stream().allMatch(b -> {
            try {
                List matchingFeatures = featuresMap.getOrDefault(b.getColumns().get(0), Collections.emptyList());
                if (matchingFeatures.isEmpty()) {
                    return false;
                }
                Feature feature = (Feature)matchingFeatures.remove(0);
                this.unpackBinding((Binding)b, Optional.of(feature), null);
                return true;
            }
            catch (BindingException e) {
                return false;
            }
        });
    }

    private List<Binding> bind(List<BaseLayer> layerList, List<Binding> inBindings, List<IDataColumn> unboundColumns, Features featuresMap) throws BindingException {
        ArrayList<String> layerColumns = new ArrayList<String>();
        this.unpackBindings(inBindings, layerList);
        List<FeatureType> geoFeatureTypes = FeatureType.getGeoFeatureTypes();
        List<IDataColumn> remainingColumns = unboundColumns;
        if (featuresMap != null) {
            if (!featuresMap.hasGeoColumns()) {
                return Collections.emptyList();
            }
            this.useFeaturesMapToPopulateLayers(layerColumns, featuresMap, geoFeatureTypes, layerList, unboundColumns);
        } else {
            remainingColumns = this.addSlotsForGeoColumns(layerList, unboundColumns, layerColumns);
        }
        if (!remainingColumns.isEmpty()) {
            this.useColumnsToPopulateLayers(layerList, remainingColumns);
        }
        if (featuresMap != null) {
            if (!unboundColumns.isEmpty()) {
                return Collections.emptyList();
            }
            List<FeatureType> geoFeatures = FeatureType.getGeoFeatureTypes();
            boolean mandatoryGeoFeatureMissing = layerList.stream().filter(layer -> layer.getSlotList().stream().anyMatch(s -> !((Slot)s).columns.isEmpty())).anyMatch(layer -> layer.getSlotList().stream().filter(s -> ((Slot)s).type.featureTypes.stream().allMatch(ft -> geoFeatures.contains(ft))).anyMatch(s -> ((Slot)s).columns.isEmpty()));
            if (mandatoryGeoFeatureMissing) {
                return Collections.emptyList();
            }
        }
        return layerList.stream().flatMap(l -> l.getSlotList().stream()).filter(s -> !((Slot)s).columns.isEmpty()).map(Slot::getBinding).distinct().collect(Collectors.toList());
    }

    private List<IDataColumn> addSlotsForGeoColumns(List<BaseLayer> layerList, List<IDataColumn> unboundColumns, List<String> layerColumns) {
        ArrayList<LayerType> layerTypesWithSlotsAssigned = new ArrayList<LayerType>();
        ArrayList<LayerType> layerTypesWithNoSlotsAssigned = new ArrayList<LayerType>();
        for (BaseLayer locationLayer : layerList) {
            List<Slot> list = locationLayer.getSlotList();
            if (list.stream().anyMatch(Slot::hasColumns)) {
                layerTypesWithSlotsAssigned.add(locationLayer.type);
                continue;
            }
            layerTypesWithNoSlotsAssigned.add(locationLayer.type);
        }
        unboundColumns.forEach(unboundColumn -> {
            List concepts = unboundColumn.getFlatListOfConcepts();
            for (SlotType slotType : SlotType.values()) {
                if (!this.isGeoSlot(slotType, concepts)) continue;
                List<String> addedColumnNames = this.addColumnToSlots(layerList, (IDataColumn)unboundColumn, slotType, (List<LayerType>)layerTypesWithSlotsAssigned);
                if (addedColumnNames.isEmpty()) {
                    addedColumnNames = this.addColumnToSlots(layerList, (IDataColumn)unboundColumn, slotType, (List<LayerType>)layerTypesWithNoSlotsAssigned);
                }
                layerColumns.addAll(addedColumnNames);
                break;
            }
        });
        return unboundColumns.stream().filter(unboundColumn -> !layerColumns.contains(unboundColumn.getIdForExpression())).collect(Collectors.toList());
    }

    private boolean isGeoSlot(SlotType slotType, List<String> concepts) {
        FeatureType featureType = slotType.featureTypes.get(0);
        return FeatureType.getGeoFeatureTypes().contains((Object)featureType) && (!this.isGeoNonLocation(concepts) || slotType != SlotType.LOCATION) && concepts.contains(featureType.concept);
    }

    private void useFeaturesMapToPopulateLayers(List<String> layerColumns, Features featuresMap, List<FeatureType> geoFeatureTypes, List<BaseLayer> layerList, List<IDataColumn> unboundColumns) {
        for (SlotType slotType : SlotType.values()) {
            FeatureType featureType = slotType.featureTypes.get(0);
            if (slotType.featureTypes.size() > 1 || !geoFeatureTypes.contains((Object)featureType)) continue;
            List<IDataColumn> dataColumnList = featuresMap.getFeature(featureType);
            for (IDataColumn dataColumn : dataColumnList) {
                layerColumns.addAll(this.addColumnToSlots(layerList, dataColumn, slotType, Arrays.asList(LayerType.values())));
                this.removeColumn(unboundColumns, dataColumn);
            }
        }
    }

    private void useColumnsToPopulateLayers(List<BaseLayer> layerList, List<IDataColumn> remainingColumns) {
        List<Slot> sortedSlots = this.getNonGeoSlots(layerList, true);
        sortedSlots.addAll(this.getNonGeoSlots(layerList, false));
        this.addColumnsToActiveLayers(remainingColumns, true, true, sortedSlots);
        List regionAndPointSlots = layerList.stream().filter(l -> l.getLayerType().equals((Object)LayerType.REGION) || l.getLayerType().equals((Object)LayerType.POINT)).flatMap(l -> l.getSlotList().stream()).collect(Collectors.toList());
        boolean hasRegionNonLocationSlotsWithColumns = layerList.stream().filter(l -> l.getLayerType().equals((Object)LayerType.REGION)).flatMap(l -> l.getSlotList().stream()).anyMatch(s -> ((Slot)s).type != SlotType.LOCATION && !((Slot)s).columns.isEmpty());
        boolean hasPointNonLocationSlotsWithColumns = layerList.stream().filter(l -> l.getLayerType().equals((Object)LayerType.POINT)).flatMap(l -> l.getSlotList().stream()).anyMatch(s -> ((Slot)s).type != SlotType.LOCATION && !((Slot)s).columns.isEmpty());
        List locationSlots = regionAndPointSlots.stream().filter(s -> ((Slot)s).type == SlotType.LOCATION).collect(Collectors.toList());
        List locationSlotsWithColumns = locationSlots.stream().filter(s -> !((Slot)s).columns.isEmpty()).collect(Collectors.toList());
        if (hasRegionNonLocationSlotsWithColumns && hasPointNonLocationSlotsWithColumns && locationSlotsWithColumns.size() == 1) {
            locationSlots.stream().filter(s -> ((Slot)s).columns.isEmpty()).forEach(s -> ((Slot)s).columns = ((Slot)locationSlotsWithColumns.get(0)).columns);
        }
    }

    private void removeColumn(List<IDataColumn> unboundColumns, IDataColumn dataColumn) {
        ArrayList<String> dataColumnNames = new ArrayList<String>();
        List hierarchyList = dataColumn.getHierarchy();
        if (hierarchyList != null && !hierarchyList.isEmpty()) {
            hierarchyList.forEach(h -> dataColumnNames.add(h.getIdForExpression()));
        } else {
            dataColumnNames.add(dataColumn.getIdForExpression());
        }
        ListIterator<IDataColumn> iterator = unboundColumns.listIterator();
        while (iterator.hasNext()) {
            String id = iterator.next().getIdForExpression();
            if (!dataColumnNames.contains(id)) continue;
            iterator.remove();
            dataColumnNames.remove(id);
        }
    }

    private List<Slot> getNonGeoSlots(List<BaseLayer> layerList, boolean active) {
        ArrayList<Slot> nonGeoSlots = new ArrayList<Slot>();
        List<SlotType> nonGeoSlotTypes = SlotType.getNonGeoSlotTypes();
        layerList.stream().filter(layer -> !(active ^ layer.isActive())).forEach(layer -> nonGeoSlotTypes.forEach(slotType -> {
            Slot slot = layer.getSlotOfType((SlotType)((Object)((Object)slotType)));
            if (slot != null && !slot.hasColumns()) {
                nonGeoSlots.add(slot);
            }
        }));
        nonGeoSlots.sort(Comparator.comparing(s -> {
            if (((Slot)s).layer == LayerType.REGION) {
                return 0;
            }
            if (((Slot)s).layer == LayerType.POINT) {
                return 1;
            }
            return 2;
        }).thenComparing(s -> {
            if (s.getSlotType().slotTypePreference == SlotTypePreference.HIGH) {
                return 0;
            }
            if (s.getSlotType().slotTypePreference == SlotTypePreference.MEDIUM) {
                return 1;
            }
            return 2;
        }));
        return nonGeoSlots;
    }

    private boolean isGeoNonLocation(List<String> concepts) {
        List<FeatureType> geoFeatureTypes = FeatureType.getGeoFeatureTypes();
        for (String concept : concepts) {
            for (FeatureType featureType : geoFeatureTypes) {
                if (!concept.equals(featureType.concept) || featureType == FeatureType.LOCATION) continue;
                return true;
            }
        }
        return false;
    }

    private List<String> addColumnsToActiveLayers(List<IDataColumn> remainingColumns, boolean initialPreference, boolean addColumnsFlag, List<Slot> sortedSlots) {
        ArrayList<String> addedColumnIds = new ArrayList<String>();
        block0: for (Slot slot : sortedSlots) {
            if (slot.hasColumns()) continue;
            Iterator<IDataColumn> iterator = remainingColumns.iterator();
            while (iterator.hasNext()) {
                IDataColumn cd = iterator.next();
                List concepts = cd.getFlatListOfConcepts();
                Set slotConcepts = ((Slot)slot).type.featureTypes.stream().map(f -> f.concept).collect(Collectors.toSet());
                if (!concepts.stream().anyMatch(c -> slotConcepts.contains(c))) continue;
                if (addColumnsFlag) {
                    if (cd.isHierchical()) {
                        List<String> idList = cd.getHierarchy().stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList());
                        slot.addColumns(idList);
                    } else {
                        slot.addColumn(cd.getIdForExpression());
                    }
                    iterator.remove();
                }
                addedColumnIds.add(cd.getIdForExpression());
                continue block0;
            }
        }
        return addedColumnIds;
    }

    private List<String> addColumnToSlots(List<BaseLayer> layerList, IDataColumn columnData, SlotType slotType, List<LayerType> selectedLayerTypes) {
        ArrayList<String> addedColumnIds = new ArrayList<String>();
        for (BaseLayer locationLayer : layerList) {
            Slot slot;
            if (!selectedLayerTypes.contains((Object)locationLayer.type) || (slot = locationLayer.getSlotOfType(slotType)) == null || !slot.columns.isEmpty()) continue;
            List hierarchyList = null;
            ArrayList<String> columns = new ArrayList<String>();
            hierarchyList = columnData.getHierarchy();
            if (hierarchyList != null && !hierarchyList.isEmpty()) {
                hierarchyList.forEach(h -> columns.add(h.getIdForExpression()));
            } else {
                columns.add(columnData.getIdForExpression());
            }
            slot.addColumns(columns);
            locationLayer.setActive(true);
            addedColumnIds.addAll(columns);
            return addedColumnIds;
        }
        return addedColumnIds;
    }

    private List<Feature> classify(IDataColumn column) {
        List conceptInfos;
        List conceptMatches;
        SemanticInfo semanticInfo;
        ArrayList<Feature> features = new ArrayList<Feature>();
        List concepts = column.getFlatListOfConcepts();
        if (concepts.contains(BasicType.ENTITY.getOntologyConcept()) || concepts.contains(BasicType.DATE.getOntologyConcept())) {
            features.add(new Feature(column, BasicType.ENTITY.getOntologyConcept()));
        }
        if (!(concepts.contains(FeatureType.LATITUDE.concept) || concepts.contains(FeatureType.LONGITUDE.concept) || (semanticInfo = column.getSemanticInfo()) == null || (conceptMatches = ConceptsUtil.getDescendantsOfConcept((List)(conceptInfos = semanticInfo.getConcepts()), (String)BasicType.LOCATION.getOntologyConcept())).isEmpty())) {
            features.add(new Feature(column, BasicType.LOCATION.getOntologyConcept()));
        }
        if (concepts.contains(BasicType.MEASURE.getOntologyConcept())) {
            features.add(new Feature(column, BasicType.MEASURE.getOntologyConcept()));
        }
        if (concepts.contains(FeatureType.LATITUDE.concept)) {
            features.add(new Feature(column, FeatureType.LATITUDE.concept));
        }
        if (concepts.contains(FeatureType.LONGITUDE.concept)) {
            features.add(new Feature(column, FeatureType.LONGITUDE.concept));
        }
        return features;
    }

    private List<Binding> bindFeatures(List<BaseLayer> layerList, Features featuresMap, List<IDataColumn> input) {
        try {
            return this.bind(layerList, Collections.emptyList(), input, featuresMap);
        }
        catch (BindingException exc) {
            return Collections.emptyList();
        }
    }

    private List<IDataColumn> getColumnsFromConstraints(List<IDataColumn> input, List<Binding> constraints) throws RecommendationException {
        if (constraints.stream().anyMatch(b -> !this.getSlots().contains(b.getSlot()))) {
            throw new RecommendationException("Invalid binding slots");
        }
        Map columnMap = input.stream().collect(Collectors.toMap(IDataColumn::getIdForExpression, Function.identity(), (c1, c2) -> c1));
        return constraints.stream().map(c -> (IDataColumn)columnMap.get(c.getColumns().get(0))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<IDataColumn> getColumns(List<Binding> constraints, List<IDataColumn> input) throws RecommendationException {
        List<IDataColumn> columns = null;
        if (constraints != null && !constraints.isEmpty()) {
            columns = this.getColumnsFromConstraints(input, constraints);
            if (columns.size() != constraints.size()) {
                throw new RecommendationException("Invalid binding columns");
            }
        } else {
            columns = IDataColumn.formHierarchy(input);
        }
        return columns;
    }

    @Override
    public ExternalRecommendedVisualization recommend(String combinationId, List<IDataColumn> input, List<Binding> constraints, VisualizationParameters inParameters) throws RecommendationException {
        Locale locale;
        Map<String, String> mapColumnIdForExpresionToColumnName = this.getMapColumnIdForExpresionToColumnName(input);
        ArrayList<BaseLayer> layerList = new ArrayList<BaseLayer>();
        layerList.add(new LocationRegion());
        layerList.add(new LocationPoint());
        layerList.add(new CoordinatePoint());
        List<IDataColumn> columns = this.getColumns(constraints, input);
        List featureList = columns.stream().map(this::classify).collect(Collectors.toList());
        List cartesianProducts = VisRecommenderUtils.cartesianProduct(featureList);
        List<Binding> bindings = null;
        if (constraints != null && !constraints.isEmpty()) {
            Optional<List> solution = cartesianProducts.stream().filter(f -> this.validateFeatureBindings((List<Feature>)f, constraints)).findFirst();
            if (!solution.isPresent()) {
                return null;
            }
            bindings = constraints;
        } else {
            boolean found = false;
            Set geoConcepts = FeatureType.getGeoFeatureTypes().stream().map(f -> f.concept).collect(Collectors.toSet());
            List sortedProducts = cartesianProducts.stream().sorted(Comparator.comparingDouble(cp -> cp.stream().filter(f -> geoConcepts.contains(f.concept)).count()).reversed()).collect(Collectors.toList());
            for (List cartesianProduct : sortedProducts) {
                layerList.clear();
                layerList.add(new LocationRegion());
                layerList.add(new LocationPoint());
                layerList.add(new CoordinatePoint());
                ArrayList<IDataColumn> copyColumns = new ArrayList<IDataColumn>(columns);
                Features featuresMap = this.extractMapFeatures(cartesianProduct);
                bindings = this.bindFeatures(layerList, featuresMap, copyColumns);
                List columnsFromBindings = bindings.stream().flatMap(b -> b.getColumns().stream()).collect(Collectors.toList());
                found = columns.stream().allMatch(c -> columnsFromBindings.contains(c.getIdForExpression()));
                if (!found) continue;
                break;
            }
            if (!found) {
                return null;
            }
        }
        ExternalRecommendedVisualization recommendation = new ExternalRecommendedVisualization(this, bindings, this.getScore(), this.rank, combinationId);
        recommendation.setBaseFilterList(inParameters.getBaseFilterList());
        recommendation.setAggregationMap(inParameters.getAggregationMap());
        Locale locale2 = locale = inParameters != null && inParameters.getRequestContext() != null ? inParameters.getRequestContext().locale : null;
        if (locale != null) {
            HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
            recommendation.getColumnBindings().forEach(b -> parameters.put(b.getSlot(), b.getColumns().stream().map(mapColumnIdForExpresionToColumnName::get).collect(Collectors.toList())));
            parameters.put(ALL, recommendation.getColumnBindings().stream().flatMap(b -> b.getColumns().stream().map(mapColumnIdForExpresionToColumnName::get)).collect(Collectors.toList()));
            if (ChartNLGUtils.NLGSupported(locale)) {
                Optional<ChartDescription> des = this.getDescription(input, layerList, locale);
                if (des.isPresent()) {
                    recommendation.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
                } else {
                    LOGGER.error("Failed to get chart description for tiledmap for a recommendation.");
                    recommendation.setNaturalLanguage(this.getLabel(parameters, locale), this.getTitle(parameters, locale), this.getDescription(parameters, locale), locale);
                }
            } else {
                recommendation.setNaturalLanguage(this.getLabel(parameters, locale), this.getTitle(parameters, locale), this.getDescription(parameters, locale), locale);
            }
        }
        return recommendation;
    }

    @Override
    public List<IBindingResult> bind(Locale locale, List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unboundColumns, boolean forceBinding) throws BindingException {
        List<Binding> solutions;
        this.formHierarchies(bound, boundColumnInfo, unboundColumns);
        ArrayList<BaseLayer> layerList = new ArrayList<BaseLayer>();
        layerList.add(new LocationRegion());
        layerList.add(new LocationPoint());
        layerList.add(new CoordinatePoint());
        List<Binding> bindings = solutions = this.bind(layerList, bound, unboundColumns, null);
        Set boundSet = bindings.stream().map(Binding::getColumns).flatMap(Collection::stream).collect(Collectors.toSet());
        List<String> unboundColumnNames = unboundColumns.stream().map(IDataColumn::getIdForExpression).filter(id -> !boundSet.contains(id)).collect(Collectors.toList());
        BindingResult binding = new BindingResult(locale, this.getName(), bindings, unboundColumnNames, 0, this.preference);
        Stream<IDataColumn> boundColumns = boundColumnInfo.entrySet().stream().map(Map.Entry::getValue);
        List<IDataColumn> columns = Stream.concat(boundColumns, unboundColumns.stream()).collect(Collectors.toList());
        if (ChartNLGUtils.NLGSupported(locale)) {
            Optional<ChartDescription> des = this.getDescription(columns, layerList, locale);
            if (des.isPresent()) {
                binding.setNaturalLanguage(des.get().getLabel(), des.get().getTitle(), des.get().getDescription(), locale);
            } else {
                LOGGER.error("Failed to get a description for tiled map during binding.");
                this.addNaturalLanguageToBinding(locale, columns, binding);
            }
        } else {
            this.addNaturalLanguageToBinding(locale, columns, binding);
        }
        return Arrays.asList(binding);
    }

    @Override
    public boolean validateBindings(List<IDataColumn> columns, List<Binding> bindings) {
        List featresList = columns.stream().map(this::classify).collect(Collectors.toList());
        List alternatives = VisRecommenderUtils.cartesianProduct(featresList);
        return alternatives.stream().anyMatch(f -> this.validateFeatureBindings((List<Feature>)f, bindings));
    }

    private Optional<ChartDescription> getDescription(List<IDataColumn> columns, List<BaseLayer> mapLayers, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(NLG_CODE, locale);
        Map<String, String> idToName = this.getMapColumnIdForExpresionToColumnName(columns);
        ArrayList<String> layers = new ArrayList<String>();
        for (BaseLayer layer : mapLayers) {
            ArrayList<String> locations = new ArrayList<String>();
            ArrayList<String> nonLocations = new ArrayList<String>();
            for (Slot slot : layer.getSlotList()) {
                if (slot.getColumns().isEmpty()) continue;
                if (slot.getSlotType() == SlotType.LOCATION || slot.getSlotType() == SlotType.LATITUDE || slot.getSlotType() == SlotType.LONGITUDE) {
                    slot.getColumns().forEach(s -> locations.add((String)idToName.get(s)));
                    continue;
                }
                slot.getColumns().forEach(s -> nonLocations.add((String)idToName.get(s)));
            }
            if (locations.isEmpty()) continue;
            layers.add(this.getLayerText(layer.getLayerType(), locations, nonLocations, bundle));
        }
        try {
            String chartName = bundle.getString(IDS_CHART_TYPE_PREFIX + this.getName());
            ArrayList<String> titleChartName = new ArrayList<String>();
            titleChartName.add(chartName);
            ArrayList<Object> lblParams = new ArrayList<Object>();
            lblParams.add(layers);
            ArrayList<Object> ttlParams = new ArrayList<Object>();
            ttlParams.add(titleChartName);
            ttlParams.add(layers);
            String label = ChartNLGUtils.realiseNLG(bundle.getString(IDS_LBL_PLAIN), lblParams);
            String title = ChartNLGUtils.realiseNLG(bundle.getString(IDS_TITLE_SIMPLE_SHOW), ttlParams);
            String description = ChartNLGUtils.generateDescription(ChartNLGUtils.getFeaturesForDescription(columns), this.getMapColumnIdForExpresionToColumnName(columns), bundle);
            return Optional.of(new ChartDescription(label == null ? "" : label, title == null ? "" : title, description == null ? "" : description, locale));
        }
        catch (ParseException e) {
            LOGGER.error("Failed to get chart description for tiled map.", (Throwable)e);
            return Optional.empty();
        }
    }

    private String getLayerText(LayerType layerType, List<String> locations, List<String> nonLocations, ResourceBundle bundle) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (!nonLocations.isEmpty()) {
            params.add(nonLocations);
        }
        if (!locations.isEmpty()) {
            params.add(locations);
        }
        String resourceId = "IDS_LBL_" + (Object)((Object)layerType) + "_LAYER";
        if (params.size() < 2) {
            resourceId = resourceId + "_ONLY";
        }
        return ChartNLGUtils.realiseNLG(bundle.getString(resourceId), params);
    }

    private Optional<Binding> checkColumnsFitInHierarchy(List<IDataColumn> boundColumns, List<IDataColumn> unbound, String slot) {
        IDataColumn processedColumn = boundColumns.get(0);
        LinkedList<IDataColumn> unboundTemp = new LinkedList<IDataColumn>(unbound);
        Iterator unboundIterator = unboundTemp.iterator();
        while (unboundIterator.hasNext()) {
            IDataColumn potentialCol = (IDataColumn)unboundIterator.next();
            List res = IDataColumn.formHierarchy(Arrays.asList(processedColumn, potentialCol));
            if (res.size() != 1) continue;
            processedColumn = (IDataColumn)res.get(0);
            unboundIterator.remove();
        }
        Binding outBinding = new Binding(processedColumn.isHierchical() ? processedColumn.getHierarchy().stream().map(IDataColumn::getIdForExpression).collect(Collectors.toList()) : Arrays.asList(processedColumn.getIdForExpression()), slot);
        unbound.clear();
        unbound.addAll(unboundTemp);
        return Optional.of(outBinding);
    }

    private void formHierarchies(List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, List<IDataColumn> unbound) {
        ListIterator<Binding> itr = bound.listIterator();
        while (itr.hasNext()) {
            Optional<Binding> outBining;
            Binding binding = itr.next();
            List boundColumns = binding.getColumns().stream().map(boundColumnInfo::get).collect(Collectors.toList());
            if (boundColumns.contains(null) || (boundColumns = IDataColumn.formHierarchy(boundColumns)).size() != 1 || !(outBining = this.checkColumnsFitInHierarchy(boundColumns, unbound, binding.getSlot())).isPresent()) continue;
            itr.set(outBining.get());
        }
        ArrayList<IDataColumn> unboundCopy = new ArrayList<IDataColumn>(unbound);
        unbound.clear();
        unbound.addAll(IDataColumn.formHierarchy(unboundCopy));
    }

    @Override
    public double getScore() {
        return 1.0;
    }

    @Override
    public String getLabel(Map<String, List<String>> parameters, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        List<String> labelStringIds = this.getLabelStringId(parameters);
        StringBuffer labelStringIdBuffer = new StringBuffer();
        if (labelStringIds.size() == 1 && labelStringIds.get(0).equals(IDS_GENERIC_MEASURES)) {
            List columnNames = parameters.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            return String.join((CharSequence)", ", columnNames);
        }
        for (int i = 0; i < labelStringIds.size(); ++i) {
            if (i < labelStringIds.size() - 2) {
                labelStringIdBuffer.append(this.getStringFromBundle(bundle, labelStringIds.get(i)));
                labelStringIdBuffer.append(this.getStringFromBundle(bundle, IDS_MAP_COMMA));
                continue;
            }
            if (i == labelStringIds.size() - 2) {
                labelStringIdBuffer.append(this.getStringFromBundle(bundle, labelStringIds.get(i)));
                labelStringIdBuffer.append(" ");
                labelStringIdBuffer.append(this.getStringFromBundle(bundle, IDS_MAP_AND));
                continue;
            }
            labelStringIdBuffer.append(this.getStringFromBundle(bundle, labelStringIds.get(i)));
        }
        MessageFormat fLabel = new MessageFormat(labelStringIdBuffer.toString(), bundle.getLocale());
        return fLabel.format(VisNLGUtils.flattenParameters(parameters));
    }

    @Override
    public String getTitle(Map<String, List<String>> parameters, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        String title = this.buildTitleString(parameters, bundle);
        title = VisNLGUtils.removeUnusedParameters(title, parameters);
        MessageFormat fLabel = new MessageFormat(title, bundle.getLocale());
        return fLabel.format(VisNLGUtils.flattenParameters(parameters));
    }

    @Override
    public String getDescription(Map<String, List<String>> parameters, Locale locale) {
        ResourceBundle bundle = this.getBundle(locale);
        String description = this.getStringFromBundle(bundle, IDS_MAP_DESCRIPTION);
        if (this.region(parameters)) {
            description = description + this.getStringFromBundle(bundle, IDS_MAP_REGION);
        }
        if (this.points(parameters)) {
            description = description + this.getStringFromBundle(bundle, IDS_MAP_POINT);
        }
        if (this.coord(parameters)) {
            description = description + this.getStringFromBundle(bundle, IDS_MAP_COORDINATE);
        }
        description = VisNLGUtils.removeUnusedParameters(description, parameters);
        MessageFormat fLabel = new MessageFormat(description, bundle.getLocale());
        return fLabel.format(VisNLGUtils.flattenParameters(parameters));
    }

    private ResourceBundle getBundle(Locale locale) {
        String localeString = locale.toString();
        ResourceBundle bundle = this.resourceBundles.get(localeString);
        if (bundle == null) {
            this.resourceBundles.put(localeString, ResourceBundle.getBundle(BASE_STRING_NAME, locale));
            bundle = this.resourceBundles.get(localeString);
        }
        return bundle;
    }

    private List<String> getLabelStringId(Map<String, List<String>> parameters) {
        ArrayList<String> labelIds = new ArrayList<String>();
        if (this.region(parameters)) {
            this.addRegionLayerToLabel(parameters, labelIds);
        }
        if (this.points(parameters)) {
            this.addPointsLayerToLabel(parameters, labelIds);
        }
        if (this.coord(parameters)) {
            this.addCoordsLayerToLabel(parameters, labelIds);
        }
        if (labelIds.isEmpty() && this.measures(parameters)) {
            labelIds.add(IDS_GENERIC_MEASURES);
        }
        return labelIds;
    }

    private void addRegionLayerToLabel(Map<String, List<String>> parameters, List<String> labels) {
        if (parameters.containsKey(REGION_COLOR)) {
            labels.add(IDS_REGION_COLOR);
        } else {
            labels.add(IDS_REGION);
        }
    }

    private void addPointsLayerToLabel(Map<String, List<String>> parameters, List<String> labels) {
        if (parameters.containsKey(POINT_COLOR) && parameters.containsKey(POINT_SIZE)) {
            labels.add(IDS_POINT_COLOR_SIZE);
        } else if (parameters.containsKey(POINT_SIZE)) {
            labels.add(IDS_POINT_SIZE);
        } else if (parameters.containsKey(POINT_COLOR)) {
            labels.add(IDS_POINT_COLOR);
        } else {
            labels.add(IDS_POINT);
        }
    }

    private void addCoordsLayerToLabel(Map<String, List<String>> parameters, List<String> labels) {
        if (parameters.containsKey(COORDINATE_SIZE) && parameters.containsKey(COORDINATE_COLOR)) {
            labels.add(IDS_COORDS_COLOR_SIZE);
        } else if (parameters.containsKey(COORDINATE_SIZE)) {
            labels.add(IDS_COORDS_SIZE);
        } else if (parameters.containsKey(COORDINATE_COLOR)) {
            labels.add(IDS_COORDS_COLOR);
        } else {
            labels.add(IDS_COORDS);
        }
    }

    private String buildTitleString(Map<String, List<String>> parameters, ResourceBundle bundle) {
        String title = "";
        String id = this.getTitleStringId(parameters);
        if (id != null) {
            return this.getStringFromBundle(bundle, id);
        }
        if (this.region(parameters)) {
            title = title + this.getStringFromBundle(bundle, IDS_MAP_REGION_TITLE);
            if (parameters.containsKey(REGION_COLOR)) {
                title = title + this.getStringFromBundle(bundle, IDS_MAP_REGION_COLOR);
            }
        }
        if (this.points(parameters)) {
            title = this.addPointsLayerToTitle(parameters, bundle, title);
        }
        if (this.coord(parameters)) {
            title = this.addCoordsLayerToTitle(parameters, bundle, title);
        }
        if (title.isEmpty()) {
            List columnNames = parameters.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            title = String.join((CharSequence)", ", columnNames);
        }
        title = this.getStringFromBundle(bundle, IDS_MAP_TITLE) + title;
        return title;
    }

    private String addCoordsLayerToTitle(Map<String, List<String>> parameters, ResourceBundle bundle, String title) {
        if (this.region(parameters) || this.points(parameters)) {
            title = title + this.getStringFromBundle(bundle, IDS_MAP_AND);
        }
        title = parameters.containsKey(COORDINATE_SIZE) ? title + this.getStringFromBundle(bundle, IDS_MAP_BUBBLES) : title + this.getStringFromBundle(bundle, IDS_MAP_POINTS);
        title = title + this.getStringFromBundle(bundle, IDS_MAP_COORD_TITLE);
        if (parameters.containsKey(COORDINATE_COLOR)) {
            title = title + this.getStringFromBundle(bundle, IDS_MAP_COORD_COLOR);
        }
        if (parameters.containsKey(COORDINATE_SIZE)) {
            if (parameters.containsKey(COORDINATE_COLOR)) {
                title = title + this.getStringFromBundle(bundle, IDS_MAP_AND);
            }
            title = title + this.getStringFromBundle(bundle, IDS_MAP_COORD_SIZE);
        }
        return title;
    }

    private String addPointsLayerToTitle(Map<String, List<String>> parameters, ResourceBundle bundle, String title) {
        if (this.region(parameters)) {
            title = title + this.getStringFromBundle(bundle, IDS_MAP_AND);
        }
        title = parameters.containsKey(POINT_SIZE) ? title + this.getStringFromBundle(bundle, IDS_MAP_BUBBLES) : title + this.getStringFromBundle(bundle, IDS_MAP_POINTS);
        title = title + this.getStringFromBundle(bundle, IDS_MAP_POINT_TITLE);
        if (parameters.containsKey(POINT_COLOR)) {
            title = title + this.getStringFromBundle(bundle, IDS_MAP_POINT_COLOR);
        }
        if (parameters.containsKey(POINT_SIZE)) {
            if (parameters.containsKey(POINT_COLOR)) {
                title = title + this.getStringFromBundle(bundle, IDS_MAP_AND);
            }
            title = title + this.getStringFromBundle(bundle, IDS_MAP_POINT_SIZE);
        }
        return title;
    }

    private String getTitleStringIdForPoint(Map<String, List<String>> parameters) {
        if (parameters.containsKey(POINT_COLOR)) {
            return IDS_POINT_COLOR_TITLE;
        }
        if (parameters.containsKey(POINT_SIZE)) {
            return IDS_POINT_SIZE_TITLE;
        }
        if (parameters.containsKey(POINT_COLOR_SIZE)) {
            return IDS_POINT_COLOR_SIZE_TITLE;
        }
        return IDS_POINT_TITLE;
    }

    private String getTitleStringIdForCoordinate(Map<String, List<String>> parameters) {
        if (parameters.containsKey(COORDINATE_SIZE) && parameters.containsKey(COORDINATE_COLOR)) {
            return IDS_COORDS_COLOR_SIZE_TITLE;
        }
        if (parameters.containsKey(COORDINATE_SIZE)) {
            return IDS_COORDS_SIZE_TITLE;
        }
        if (parameters.containsKey(COORDINATE_COLOR)) {
            return IDS_COORDS_COLOR_TITLE;
        }
        return IDS_COORDS_TITLE;
    }

    private String getTitleStringId(Map<String, List<String>> parameters) {
        if (this.region(parameters) && !this.points(parameters) && !this.coord(parameters)) {
            if (parameters.containsKey(REGION_COLOR)) {
                return IDS_REGION_COLOR_TITLE;
            }
            return IDS_REGION_TITLE;
        }
        if (!this.region(parameters) && this.points(parameters) && !this.coord(parameters)) {
            return this.getTitleStringIdForPoint(parameters);
        }
        if (!this.region(parameters) && !this.points(parameters) && this.coord(parameters)) {
            return this.getTitleStringIdForCoordinate(parameters);
        }
        return null;
    }

    private boolean region(Map<String, List<String>> parameters) {
        return parameters.containsKey(REGION_LOCATION);
    }

    private boolean coord(Map<String, List<String>> parameters) {
        return parameters.containsKey(COORDINATE_LATITUDE) && parameters.containsKey(COORDINATE_LONGITUDE);
    }

    private boolean points(Map<String, List<String>> parameters) {
        return parameters.containsKey(POINT_LOCATION);
    }

    private boolean measures(Map<String, List<String>> parameters) {
        return parameters.containsKey(REGION_COLOR) || parameters.containsKey(POINT_COLOR) || parameters.containsKey(POINT_SIZE) || parameters.containsKey(COORDINATE_COLOR) || parameters.containsKey(COORDINATE_SIZE);
    }

    @Override
    public List<String> getSlots() {
        ArrayList<BaseLayer> layerList = new ArrayList<BaseLayer>();
        layerList.add(new LocationRegion());
        layerList.add(new LocationPoint());
        layerList.add(new CoordinatePoint());
        return layerList.stream().flatMap(l -> l.getSlotNames().stream()).collect(Collectors.toList());
    }

    @Override
    public long getNumberOfChartsElements() {
        ArrayList<BaseLayer> layerList = new ArrayList<BaseLayer>();
        layerList.add(new LocationRegion());
        layerList.add(new LocationPoint());
        layerList.add(new CoordinatePoint());
        return layerList.stream().flatMap(l -> l.getSlotTypes().stream()).collect(Collectors.toList()).size();
    }

    @Override
    public boolean acceptsNoneAggregation() {
        return true;
    }

    static class Feature {
        final IDataColumn column;
        final String concept;

        Feature(IDataColumn column, String concept) {
            this.column = column;
            this.concept = concept;
        }

        public String toString() {
            return "Feature [column=" + this.column + ", concept=" + this.concept + "]";
        }

        public int hashCode() {
            return Objects.hash(this.column, this.concept);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Feature feature = (Feature)o;
            return Objects.equals(this.column, feature.column) && Objects.equals(this.concept, feature.concept);
        }
    }

    private static class Features {
        private Map<FeatureType, List<IDataColumn>> featuresMap = new EnumMap<FeatureType, List<IDataColumn>>(FeatureType.class);
        Map<String, Feature> columnFeatureMap = new HashMap<String, Feature>();

        Features(List<Feature> features) {
            Arrays.asList(FeatureType.values()).stream().filter(k -> this.featuresMap.get(k) == null).forEach(k -> {
                List cfr_ignored_0 = this.featuresMap.put((FeatureType)((Object)k), new ArrayList());
            });
            features.forEach(f -> {
                FeatureType key = null;
                if (f.concept.equals(BasicType.LOCATION.getOntologyConcept())) {
                    key = FeatureType.LOCATION;
                }
                if (f.concept.equals(FeatureType.LATITUDE.concept)) {
                    key = FeatureType.LATITUDE;
                }
                if (f.concept.equals(FeatureType.LONGITUDE.concept)) {
                    key = FeatureType.LONGITUDE;
                }
                if (f.concept.equals(BasicType.ENTITY.getOntologyConcept())) {
                    key = FeatureType.ENTITY;
                }
                if (f.concept.equals(BasicType.MEASURE.getOntologyConcept())) {
                    key = FeatureType.MEASURE;
                }
                this.featuresMap.get((Object)key).add(f.column);
            });
        }

        boolean hasGeoColumns() {
            List<FeatureType> geoFeat = FeatureType.getGeoFeatureTypes();
            return geoFeat.stream().anyMatch(f -> !this.featuresMap.get(f).isEmpty());
        }

        Feature getFeature(String column) {
            return this.columnFeatureMap.get(column);
        }

        List<IDataColumn> getFeature(FeatureType featureType) {
            return this.featuresMap.get((Object)featureType);
        }

        List<IDataColumn> getLocations() {
            return this.featuresMap.get((Object)FeatureType.LOCATION);
        }

        List<IDataColumn> getMeasures() {
            return this.featuresMap.get((Object)FeatureType.MEASURE);
        }

        List<IDataColumn> getCategories() {
            return this.featuresMap.get((Object)FeatureType.ENTITY);
        }

        List<IDataColumn> getLongitudes() {
            return this.featuresMap.get((Object)FeatureType.LONGITUDE);
        }

        List<IDataColumn> getLatitudes() {
            return this.featuresMap.get((Object)FeatureType.LATITUDE);
        }

        public String toString() {
            return "Features [featuresMap=" + this.featuresMap + ", columnFeatureMap=" + this.columnFeatureMap + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Features features = (Features)o;
            return Objects.equals(this.featuresMap, features.featuresMap) && Objects.equals(this.columnFeatureMap, features.columnFeatureMap);
        }

        public int hashCode() {
            return Objects.hash(this.featuresMap, this.columnFeatureMap);
        }
    }

    private static class CoordinatePoint
    extends BaseLayer {
        private CoordinatePoint() {
            super(LayerType.COORDINATE, Arrays.asList(SlotType.LATITUDE, SlotType.LONGITUDE, SlotType.COLOR, SlotType.SIZE, SlotType.LABEL));
        }
    }

    private static class LocationPoint
    extends BaseLayer {
        private LocationPoint() {
            super(LayerType.POINT, Arrays.asList(SlotType.LOCATION, SlotType.COLOR, SlotType.SIZE));
        }
    }

    private static class LocationRegion
    extends BaseLayer {
        private LocationRegion() {
            super(LayerType.REGION, Arrays.asList(SlotType.LOCATION, SlotType.COLOR));
        }
    }

    private static abstract class BaseLayer {
        private List<Slot> slotList = new ArrayList<Slot>();
        private List<SlotType> slotTypes;
        private boolean active;
        private LayerType type;
        private List<String> slotNames;

        BaseLayer(LayerType layerType, List<SlotType> slotTypes) {
            slotTypes.forEach(slotType -> this.slotList.add(new Slot(layerType, (SlotType)((Object)slotType))));
            this.type = layerType;
            this.slotTypes = slotTypes;
            this.active = false;
            this.slotNames = slotTypes.stream().map(slot -> (Object)((Object)this.type) + Tiledmap.LAYER_SLOT_SEPARATOR + slot.name()).collect(Collectors.toList());
        }

        public List<Slot> getSlotList() {
            return this.slotList;
        }

        public List<SlotType> getSlotTypes() {
            return this.slotTypes;
        }

        public List<String> getSlotNames() {
            return this.slotNames;
        }

        boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        LayerType getLayerType() {
            return this.type;
        }

        public boolean contains(SlotType slotType) {
            return this.slotTypes.contains((Object)slotType);
        }

        public String toString() {
            return "BaseLayer [slotList=" + this.slotList + ", active=" + this.active + ", type=" + (Object)((Object)this.type) + "]";
        }

        public Slot getSlotOfType(SlotType slotType) {
            Optional<Slot> result = this.slotList.stream().filter(slot -> ((Slot)slot).type == slotType).findFirst();
            return result.isPresent() ? result.get() : null;
        }
    }

    private static class Slot {
        private LayerType layer;
        private SlotType type;
        private List<String> columns = new ArrayList<String>();
        private FeatureType preferenceFeatureType;

        Slot(LayerType layer, SlotType type) {
            this.layer = layer;
            this.type = type;
        }

        Binding getBinding() {
            return new Binding(new ArrayList<String>(this.columns), this.layer.name() + Tiledmap.LAYER_SLOT_SEPARATOR + this.type.name());
        }

        public FeatureType getPreferenceFeatureType() {
            return this.preferenceFeatureType;
        }

        public void setPreferenceFeatureType(FeatureType featureType) {
            this.preferenceFeatureType = featureType;
        }

        public LayerType getLayerType() {
            return this.layer;
        }

        public SlotType getSlotType() {
            return this.type;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public String toString() {
            return "Slot [layer=" + (Object)((Object)this.layer) + ", type=" + (Object)((Object)this.type) + ", columns=" + this.columns + ", preference=" + (Object)((Object)this.preferenceFeatureType) + "]";
        }

        public boolean addColumns(List<String> columns1) {
            if (this.columns.isEmpty()) {
                this.columns.addAll(columns1);
            }
            return false;
        }

        public void addColumn(String columnName) {
            this.columns.add(columnName);
        }

        public boolean hasColumns() {
            return !this.columns.isEmpty();
        }
    }

    private static enum SlotTypePreference {
        HIGH,
        MEDIUM,
        LOW;

    }

    private static enum SlotType {
        LOCATION(FeatureType.LOCATION, SlotTypePreference.HIGH),
        COLOR(Arrays.asList(FeatureType.MEASURE), SlotTypePreference.MEDIUM),
        SIZE(Arrays.asList(FeatureType.MEASURE), SlotTypePreference.HIGH),
        LATITUDE(FeatureType.LATITUDE, SlotTypePreference.HIGH),
        LONGITUDE(FeatureType.LONGITUDE, SlotTypePreference.HIGH),
        LABEL(Arrays.asList(FeatureType.ENTITY, FeatureType.LOCATION, FeatureType.DATE), SlotTypePreference.LOW);

        List<FeatureType> featureTypes = new ArrayList<FeatureType>();
        SlotTypePreference slotTypePreference;

        private SlotType(FeatureType type, SlotTypePreference slotTypePreference) {
            this.featureTypes.add(type);
            this.slotTypePreference = slotTypePreference;
        }

        private SlotType(List<FeatureType> types, SlotTypePreference slotTypePreference) {
            this.featureTypes.addAll(types);
            this.slotTypePreference = slotTypePreference;
        }

        static List<SlotType> getNonGeoSlotTypes() {
            return Arrays.asList(SlotType.values()).stream().filter(slotType -> !FeatureType.getGeoFeatureTypes().contains((Object)slotType.featureTypes.get(0))).collect(Collectors.toList());
        }

        static SlotType fromString(String t) {
            for (SlotType e : SlotType.values()) {
                if (!e.name().equals(t)) continue;
                return e;
            }
            return null;
        }
    }

    private static enum FeatureType {
        LOCATION(BasicType.LOCATION.getOntologyConcept()),
        MEASURE(BasicType.MEASURE.getOntologyConcept()),
        DATE(BasicType.DATE.getOntologyConcept()),
        ENTITY(BasicType.ENTITY.getOntologyConcept()),
        LATITUDE("http://www.ibm.com/ontologies/waca/domain/common#Latitude"),
        LONGITUDE("http://www.ibm.com/ontologies/waca/domain/common#Longitude");

        String concept;

        private FeatureType(String concept) {
            this.concept = concept;
        }

        static List<FeatureType> getGeoFeatureTypes() {
            return Arrays.asList(LOCATION, LONGITUDE, LATITUDE);
        }
    }

    private static enum LayerType {
        REGION,
        POINT,
        COORDINATE;


        static LayerType fromString(String layer) {
            for (LayerType e : LayerType.values()) {
                if (!e.name().equals(layer)) continue;
                return e;
            }
            return null;
        }
    }
}

