/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.charts;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementFeatureSimilarity;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementType;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementTypes;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.charts.Requirment;
import com.ibm.smarts.visualization.recommender.internal.modeling.Axis;
import com.ibm.smarts.visualization.recommender.internal.modeling.AxisType;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.charts.ChartElementFeatureMismatch;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ChartElement {
    private ChartElementType type;
    private Set<Quantity> quantities = new HashSet<Quantity>();
    private Requirment nullable = Requirment.ANY;
    private Requirment positive = Requirment.ANY;
    private Requirment highVariance = Requirment.ANY;
    private int maxOccurence = 1;
    private int instance = 0;

    @JsonCreator
    public ChartElement(@JsonProperty(value="type") String typename, @JsonProperty(value="quantities") Set<Quantity> quantities, @JsonProperty(value="nullable") Requirment nullable, @JsonProperty(value="positive") Requirment positive, @JsonProperty(value="high_variance") Requirment highVariance, @JsonProperty(value="max_occurences") Integer max) {
        this.type = ChartElementTypes.getTypes().get(typename);
        if (quantities != null) {
            this.quantities = quantities;
        } else {
            this.quantities = new HashSet<Quantity>();
            this.quantities.add(Quantity.NONE);
        }
        if (nullable != null) {
            this.nullable = nullable;
        }
        if (nullable != null) {
            this.positive = positive;
        }
        if (max != null) {
            this.maxOccurence = max;
        }
        if (highVariance != null) {
            this.highVariance = highVariance;
        }
    }

    public ChartElement(ChartElement other, int instance) {
        this.type = other.type;
        this.quantities.addAll(other.quantities);
        this.nullable = other.nullable;
        this.positive = other.positive;
        this.highVariance = other.highVariance;
        this.maxOccurence = other.maxOccurence;
        this.instance = instance;
    }

    public static boolean isValid(ChartElement element) {
        return element.getType() != null && !element.getQuantities().isEmpty();
    }

    public ChartElementType getCompatibleType(BasicType inType) {
        ChartElementType target = null;
        if (this.type.getTypes().contains((Object)inType)) {
            target = this.type;
        }
        return target;
    }

    public Axis mapOnAxis(AxisType inType) {
        HashSet<BasicType> featureTypes = new HashSet<BasicType>();
        HashSet<String> concepts = new HashSet<String>();
        featureTypes.addAll(this.type.getTypes());
        concepts.add(this.type.getConcept());
        return new Axis(inType, featureTypes, this.quantities, concepts, this.nullable, this.positive, this.highVariance);
    }

    public ChartElementType getType() {
        return this.type;
    }

    public List<BasicType> getBasicTypes() {
        return new ArrayList<BasicType>(this.type.getTypes());
    }

    public String getConcept() {
        return this.type.getConcept();
    }

    public Set<Quantity> getQuantities() {
        return this.quantities;
    }

    public Requirment getNullable() {
        return this.nullable;
    }

    public Requirment getPositive() {
        return this.positive;
    }

    public int getMaxOccurence() {
        return this.maxOccurence;
    }

    public Requirment getHighVariance() {
        return this.highVariance;
    }

    public int getInstance() {
        return this.instance;
    }

    public void setInstance(int instance) {
        this.instance = instance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.instance;
        result = 31 * result + this.maxOccurence;
        result = 31 * result + (this.nullable == null ? 0 : this.nullable.hashCode());
        result = 31 * result + (this.positive == null ? 0 : this.positive.hashCode());
        result = 31 * result + (this.quantities == null ? 0 : this.quantities.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.highVariance == null ? 0 : this.highVariance.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartElement other = (ChartElement)obj;
        if (this.instance != other.instance) {
            return false;
        }
        if (this.maxOccurence != other.maxOccurence) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.positive != other.positive) {
            return false;
        }
        if (this.quantities == null ? other.quantities != null : !this.quantities.equals(other.quantities)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return this.highVariance == other.highVariance;
    }

    public String toString() {
        return "ChartElement [type=" + this.type + ", quantities=" + this.quantities + ", nullable=" + (Object)((Object)this.nullable) + ", positive=" + (Object)((Object)this.positive) + ", highVariance=" + (Object)((Object)this.highVariance) + ", maxOccurence=" + this.maxOccurence + ", instance=" + this.instance + "]";
    }

    public ChartElementFeatureSimilarity matchFeature(ExtractedFeatureSet feature) {
        HashSet<ChartElementFeatureMismatch> mismatches = new HashSet<ChartElementFeatureMismatch>();
        if (!this.getQuantities().contains((Object)feature.getQuantity())) {
            mismatches.add(ChartElementFeatureMismatch.QUANTITY_MISMATCH);
        }
        if (feature.isNullable() && this.getNullable() == Requirment.MUST_NOT || !feature.isNullable() && this.getNullable() == Requirment.MUST) {
            mismatches.add(ChartElementFeatureMismatch.NULLABLE_MISMATCH);
        }
        if (feature.isPositive() && this.getPositive() == Requirment.MUST_NOT || !feature.isPositive() && this.getPositive() == Requirment.MUST) {
            mismatches.add(ChartElementFeatureMismatch.SIGN_MISMATCH);
        }
        if (!this.getBasicTypes().contains((Object)feature.getFeatureType()) || !this.getType().getConcept().equals("NONE") && !this.getType().getConcept().equals(feature.getConcept())) {
            mismatches.add(ChartElementFeatureMismatch.TYPE_MISMATCH);
        } else if (!this.getType().getConcept().equals(feature.getConcept())) {
            mismatches.add(ChartElementFeatureMismatch.CONCEPT_MISMATCH);
        }
        return new ChartElementFeatureSimilarity(this, feature, mismatches);
    }

    public boolean isMultiMeasure() {
        return false;
    }
}

