/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.featureAdapters;

import com.ibm.smarts.schema.AggregationType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.Numeric;
import com.ibm.smarts.visualization.recommender.internal.charts.Quantity;
import com.ibm.smarts.visualization.recommender.internal.featureAdapters.FeatureAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import java.util.List;
import java.util.Map;

public class ConvertCategoryAdapter
implements FeatureAdapter {
    private Map<String, AggregationType> aggregationMap;
    private static final int MIN_COLUMNS_REQUIRED = 2;

    public ConvertCategoryAdapter(Map<String, AggregationType> aggregationMap) {
        this.aggregationMap = aggregationMap;
    }

    @Override
    public List<List<ExtractedFeatureSet>> apply(List<List<ExtractedFeatureSet>> featuresList) {
        for (List<ExtractedFeatureSet> extractedFeatures : featuresList) {
            String colId = extractedFeatures.get(0).getColumnId();
            if (!this.aggregationMap.containsKey(colId) || this.aggregationMap.get(colId) != AggregationType.COUNT_DISTINCT || !extractedFeatures.stream().noneMatch(f -> f.getFeatureType() == BasicType.MEASURE)) continue;
            ExtractedFeatureSet measure = new ExtractedFeatureSet(extractedFeatures.get(0));
            measure.setQuantity(Quantity.NONE);
            measure.setType(BasicType.MEASURE);
            measure.setNumeric(Numeric.NUMERIC);
            measure.setConcept("NONE");
            measure.setAggregation(AggregationType.COUNT_DISTINCT);
            extractedFeatures.clear();
            extractedFeatures.add(measure);
        }
        return featuresList;
    }
}

