/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.learning;

import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.IBaseChartDescriptor;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElement;
import com.ibm.smarts.visualization.recommender.internal.learning.BindingFeaturesMatch;
import com.ibm.smarts.visualization.recommender.internal.learning.SpecAnalyserAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureExtracter;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LearningUtils {
    public static final int MAX_COLUMNS_ON_MULTIMEASURE_SLOT = 2;
    private static final double FAST_DECAY_RATE = 0.9;
    private static final double SLOW_DECAY_RATE = 0.1;

    private LearningUtils() {
        throw new IllegalStateException("utility class");
    }

    public static List<Double> getContextVector(List<ExtractedFeatureSet> features) {
        return SpecAnalyserAdapter.createContextVectorFromFeatures(features);
    }

    public static List<Double> getContextVector(List<Binding> bindings, Map<String, IDataColumn> labelToIDataColumnMap, Map<BindingParams, Double> threshold, IBaseChartDescriptor c) {
        try {
            List<ExtractedFeatureSet> mappings = LearningUtils.getFeaturesFromBindings(bindings, labelToIDataColumnMap, threshold, c);
            if (mappings != null && LearningUtils.validate(mappings, c)) {
                mappings = LearningUtils.shrinkMultiMeasureSlotsToTwoEFS(mappings, c);
                return LearningUtils.getContextVector(mappings);
            }
            return null;
        }
        catch (InvalidColumnBindingException ex) {
            return null;
        }
    }

    private static List<ExtractedFeatureSet> shrinkMultiMeasureSlotsToTwoEFS(List<ExtractedFeatureSet> mappings, IBaseChartDescriptor chart) {
        Map<ChartElement, List<ExtractedFeatureSet>> ceToEFS = mappings.stream().collect(Collectors.groupingBy(ExtractedFeatureSet::getChartElement));
        for (ChartElement element : chart.getElements()) {
            List<ExtractedFeatureSet> efs;
            if (!element.isMultiMeasure() || (efs = ceToEFS.get(element)).size() <= 1) continue;
            ceToEFS.put(element, efs.subList(0, 2));
        }
        return ceToEFS.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean validate(List<ExtractedFeatureSet> mappings, IBaseChartDescriptor c) {
        Map<String, List<ExtractedFeatureSet>> groupings = mappings.stream().collect(Collectors.groupingBy(efs -> efs.getChartElement().getType().getSlot()));
        for (Map.Entry<String, List<ExtractedFeatureSet>> entry : groupings.entrySet()) {
            int numOfMeasures;
            int numOfEFS = entry.getValue().size();
            if (numOfEFS != (numOfMeasures = (int)entry.getValue().stream().filter(efs -> efs.getFeatureType().equals((Object)BasicType.MEASURE)).count()) || numOfEFS <= 1) continue;
            String slot = entry.getKey();
            Optional<ChartElement> ce = c.getElements().stream().filter(e -> e.getType().getSlot().equals(slot)).findFirst();
            if (ce.isPresent() && ce.get().isMultiMeasure()) continue;
            return false;
        }
        return true;
    }

    public static List<ExtractedFeatureSet> getColumnFeature(Map<String, List<ExtractedFeatureSet>> columnToFeatures, Binding binding) {
        for (String col : binding.getColumns()) {
            List<ExtractedFeatureSet> features = columnToFeatures.getOrDefault(col, Collections.emptyList());
            if (features.isEmpty()) continue;
            return features;
        }
        return Collections.emptyList();
    }

    public static Map<String, List<ExtractedFeatureSet>> getColumnFeatures(Map<String, IDataColumn> boundColumnInfo, Map<BindingParams, Double> thresholds) {
        return boundColumnInfo.entrySet().stream().flatMap(e -> {
            List<ExtractedFeatureSet> features = FeatureExtracter.extractFeatureSetFromColumn((IDataColumn)e.getValue(), thresholds, true, 0, false);
            Stream<ExtractedFeatureSet> converted = features.stream().filter(f -> f.getFeatureType() == BasicType.LOCATION).map(f -> {
                ExtractedFeatureSet categorical = new ExtractedFeatureSet((ExtractedFeatureSet)f);
                categorical.setType(BasicType.CATEGORY);
                return categorical;
            });
            return Stream.concat(features.stream(), converted);
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(ExtractedFeatureSet::getColumnId));
    }

    public static List<ExtractedFeatureSet> getFeaturesFromBindings(List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, Map<BindingParams, Double> thresholds, IBaseChartDescriptor chart) throws InvalidColumnBindingException {
        List slots = chart.getElements().stream().map(e -> e.getType().getSlot()).collect(Collectors.toList());
        if (bound.stream().anyMatch(b -> !slots.contains(b.getSlot()))) {
            throw new InvalidColumnBindingException(bound);
        }
        Map<String, List<ExtractedFeatureSet>> columnToFeatures = LearningUtils.getColumnFeatures(boundColumnInfo, thresholds);
        List<Candidate> slotToCandidatesMap = LearningUtils.createSlotToCandidatesMap(bound, columnToFeatures, chart);
        return slotToCandidatesMap.stream().map(Candidate::getEfs).collect(Collectors.toList());
    }

    public static List<ExtractedFeatureSet> getFeaturesFromBindingsWithValidation(List<Binding> bindings, Map<String, IDataColumn> colIdToIDataColumn, Map<BindingParams, Double> bindingParams, IBaseChartDescriptor candidate) {
        List<Object> featuresFromBindings = new ArrayList();
        try {
            List<ExtractedFeatureSet> mappings = LearningUtils.getFeaturesFromBindings(bindings, colIdToIDataColumn, bindingParams, candidate);
            if (mappings != null && LearningUtils.validate(mappings, candidate)) {
                featuresFromBindings = LearningUtils.shrinkMultiMeasureSlotsToTwoEFS(mappings, candidate);
            }
        }
        catch (InvalidColumnBindingException e) {
            featuresFromBindings = Collections.emptyList();
        }
        return featuresFromBindings;
    }

    public static BindingFeaturesMatch getFeaturesFromBindingsWithScore(List<Binding> bound, Map<String, IDataColumn> boundColumnInfo, Map<BindingParams, Double> thresholds, IBaseChartDescriptor chart) throws InvalidColumnBindingException {
        List slots = chart.getElements().stream().map(e -> e.getType().getSlot()).collect(Collectors.toList());
        if (bound.stream().anyMatch(b -> !slots.contains(b.getSlot()))) {
            throw new InvalidColumnBindingException(bound);
        }
        Map<String, List<ExtractedFeatureSet>> columnToFeatures = LearningUtils.getColumnFeatures(boundColumnInfo, thresholds);
        List<Candidate> slotToEFSMap = LearningUtils.createSlotToCandidatesMap(bound, columnToFeatures, chart);
        int score = slotToEFSMap.stream().mapToInt(Candidate::getScore).sum();
        List<ExtractedFeatureSet> efss = slotToEFSMap.stream().map(Candidate::getEfs).collect(Collectors.toList());
        return new BindingFeaturesMatch(chart, efss, score);
    }

    private static List<Candidate> createSlotToCandidatesMap(List<Binding> bounds, Map<String, List<ExtractedFeatureSet>> columnToFeatures, IBaseChartDescriptor c) {
        ArrayList<Candidate> result = new ArrayList<Candidate>();
        for (Binding bound : bounds) {
            String slot = bound.getSlot();
            Optional<ChartElement> chartElement = c.getElements().stream().filter(ce -> ce.getType().getSlot().equals(slot)).findFirst();
            List columns = bound.getColumns();
            if (!chartElement.isPresent()) continue;
            List<Candidate> bestFeatures = LearningUtils.getBestFeatures(chartElement.get(), columns, columnToFeatures);
            result.addAll(bestFeatures);
        }
        return result;
    }

    private static List<Candidate> getBestFeatures(ChartElement chartElement, List<String> columns, Map<String, List<ExtractedFeatureSet>> columnToFeatures) {
        ArrayList<Candidate> result = new ArrayList<Candidate>();
        for (String column : columns) {
            List<ExtractedFeatureSet> features = columnToFeatures.get(column);
            if (features == null) continue;
            Candidate bestFeature = LearningUtils.getBestCandidate(chartElement, features);
            result.add(bestFeature);
        }
        return result;
    }

    private static Candidate getBestCandidate(ChartElement chartElement, List<ExtractedFeatureSet> features) {
        List<Candidate> candidates = LearningUtils.getCandidates(chartElement, features);
        Collections.sort(candidates);
        return candidates.get(0);
    }

    private static List<Candidate> getCandidates(ChartElement chartElement, List<ExtractedFeatureSet> featureSets) {
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (ExtractedFeatureSet f : featureSets) {
            int score = LearningUtils.getScore(chartElement, f);
            f.setChartElement(chartElement);
            candidates.add(new Candidate(f, score));
        }
        return candidates;
    }

    private static int getScore(ChartElement chartElement, ExtractedFeatureSet f) {
        HashSet<BasicType> types = new HashSet<BasicType>(chartElement.getType().getTypes());
        String concept = chartElement.getConcept();
        int score = 0;
        if (types.contains((Object)f.getFeatureType())) {
            ++score;
        }
        if (concept.equals(f.getConcept())) {
            ++score;
        }
        return score;
    }

    public static Map<String, List<Double>> getColumnVectors(List<Binding> bindings, Map<String, IDataColumn> labelToIDataColumnMap, Map<BindingParams, Double> threshold, IBaseChartDescriptor c) {
        try {
            List<ExtractedFeatureSet> featureSets = LearningUtils.getFeaturesFromBindings(bindings, labelToIDataColumnMap, threshold, c);
            if (featureSets.isEmpty()) {
                throw new InvalidColumnBindingException(bindings);
            }
            HashMap<String, List<Double>> result = new HashMap<String, List<Double>>();
            for (ExtractedFeatureSet feature : featureSets) {
                List<Double> vector = LearningUtils.getColumnVector(feature);
                result.put(feature.getColumnId(), vector);
            }
            return result;
        }
        catch (InvalidColumnBindingException e) {
            return Collections.emptyMap();
        }
    }

    public static List<Double> getColumnVector(ExtractedFeatureSet feature) {
        return SpecAnalyserAdapter.createColumnVectorFromFeatures(feature);
    }

    public static double normalize(double value, double min, double max) {
        return max - min == 0.0 ? 0.0 : (value - min) / (max - min);
    }

    public static double decayPreference(boolean fastDecay, double score) {
        return score * (1.0 - (fastDecay ? 0.9 : 0.1));
    }

    public static List<Double> normalizeVector(List<Double> vector) {
        double sqrtSum = Math.sqrt(vector.stream().map(d -> d * d).mapToDouble(Double::doubleValue).sum());
        return vector.stream().map(d -> sqrtSum == 0.0 ? 0.0 : d / sqrtSum).collect(Collectors.toList());
    }

    static class Candidate
    implements Comparable<Candidate> {
        private ExtractedFeatureSet efs;
        private int score;

        public Candidate(ExtractedFeatureSet efs, int score) {
            this.efs = efs;
            this.score = score;
        }

        public ExtractedFeatureSet getEfs() {
            return this.efs;
        }

        public int getScore() {
            return this.score;
        }

        @Override
        public int compareTo(Candidate o) {
            if (this.score < o.score) {
                return 1;
            }
            if (this.score > o.score) {
                return -1;
            }
            return 0;
        }
    }
}

