/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.learning;

import com.ibm.bi.recommendationmodel.RecommendationModel;
import com.ibm.smarts.combinations.generator.api.IDataColumn;
import com.ibm.smarts.common.learning.Sentiment;
import com.ibm.smarts.recommenders.core.utils.VisRecommenderUtils;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.api.BindingParams;
import com.ibm.smarts.visualization.recommender.api.BindingResult;
import com.ibm.smarts.visualization.recommender.api.IBaseChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IBindingResult;
import com.ibm.smarts.visualization.recommender.api.IChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.IChartNLGDescription;
import com.ibm.smarts.visualization.recommender.api.IExternalChartDescriptor;
import com.ibm.smarts.visualization.recommender.api.PreferenceLevel;
import com.ibm.smarts.visualization.recommender.exceptions.InvalidColumnBindingException;
import com.ibm.smarts.visualization.recommender.internal.BaseRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.ChartDescription;
import com.ibm.smarts.visualization.recommender.internal.ChartNLGUtils;
import com.ibm.smarts.visualization.recommender.internal.ExternalRecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.NLGProperties;
import com.ibm.smarts.visualization.recommender.internal.RecommendedVisualization;
import com.ibm.smarts.visualization.recommender.internal.learning.ChartPreferenceContext;
import com.ibm.smarts.visualization.recommender.internal.learning.LearningUtils;
import com.ibm.smarts.visualization.recommender.internal.learning.PreferedChart;
import com.ibm.smarts.visualization.recommender.internal.learning.RecommenderUtil;
import com.ibm.smarts.visualization.recommender.internal.learning.SpecAnalyserAdapter;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.internal.modeling.FeatureExtracter;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceRecommender {
    private static final double MAX_PREFERENCE = 1.0;
    protected static final double PREFERENCE_INCREMENT = 0.2;
    protected static final double DISTINCT_COUNT_BOOST_WEIGHT = 2.0;
    protected static final double TYPE_COUNT_BOOST_WEIGHT = 4.0;
    private static final double PREFERENCE_SCORE_WEIGHT = 0.3;
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferenceRecommender.class);
    private Comparator<List<SlotSimilarityScore>> scoreSorter = Comparator.comparingDouble(slotSimList -> slotSimList.stream().mapToDouble(slotSimilarityScore -> slotSimilarityScore.score).sum()).reversed();
    private Comparator<List<SlotSimilarityScore>> consistencySorter = (a, b) -> {
        a.sort(Comparator.comparing(s -> s.slot));
        b.sort(Comparator.comparing(s -> s.slot));
        String stringRep1 = a.stream().map(sss -> sss.toString()).reduce((s1, s2) -> s1 + s2).get();
        String stringRep2 = b.stream().map(sss -> sss.toString()).reduce((s1, s2) -> s1 + s2).get();
        return stringRep1.compareTo(stringRep2);
    };
    private Predicate<List<SlotSimilarityScore>> minScoreFilter = slotSimilarityScoreList -> {
        for (SlotSimilarityScore score : slotSimilarityScoreList) {
            if (!(score.score < 0.5)) continue;
            return false;
        }
        return true;
    };

    private Optional<ChartPreferenceContext> findContext(List<ChartPreferenceContext> contexts, List<Double> context) {
        return contexts.stream().map(c -> new ChartPreferenceContextSimilarity((ChartPreferenceContext)c, RecommenderUtil.cosineSimilarity(c.getContextVector(), context))).filter(sim -> sim.getSimilarity() > 0.89).sorted(Comparator.comparingDouble(sim -> sim.getSimilarity()).reversed()).map(sim -> sim.getContext()).findFirst();
    }

    private ChartPreferenceContext createChartContext(List<ChartPreferenceContext> contexts, List<Double> vector) {
        ChartPreferenceContext context = new ChartPreferenceContext(vector);
        contexts.add(context);
        return context;
    }

    public double calculateScore(double original, double preference) {
        double score = original * 0.7 + 0.3 * preference;
        return (score += score * 0.3) > 1.0 ? 1.0 : score;
    }

    private int caclulateRank(double score, int originalRank, double preference) {
        int rank = originalRank - (int)((double)originalRank * preference);
        rank = score == 1.0 ? -1 : (rank < 0 ? -1 : rank);
        return rank;
    }

    public List<IBindingResult> getBindRecommendation(Map<BindingParams, Double> bindingParams, RecommendationModel recommendationModel, Map<String, IDataColumn> idToIDataColumn, List<Binding> bound, List<String> unbound, String chart, NLGProperties properties) {
        List boundColumns = bound.stream().flatMap(b -> b.getColumns().stream()).map(colString -> (IDataColumn)idToIDataColumn.get(colString)).collect(Collectors.toList());
        List<IDataColumn> unboundColumns = unbound.stream().map(s -> (IDataColumn)idToIDataColumn.get(s)).collect(Collectors.toList());
        List<IDataColumn> allColumns = Stream.concat(boundColumns.stream(), unboundColumns.stream()).collect(Collectors.toList());
        SpecAnalyserAdapter specAnalyserAdapter = null;
        if (recommendationModel != null) {
            specAnalyserAdapter = new SpecAnalyserAdapter(recommendationModel);
        }
        List<ChartPreferenceContext> contexts = specAnalyserAdapter != null ? specAnalyserAdapter.getContexts() : Collections.emptyList();
        List columnsInfoHolders = this.prepColumns(bindingParams, allColumns);
        List combinations = VisRecommenderUtils.cartesianProduct(columnsInfoHolders);
        ArrayList<IBindingResult> result = new ArrayList<IBindingResult>();
        for (List<ColumnInfoHolder> list : combinations) {
            IBindingResult res;
            List<ExtractedFeatureSet> efscombination = list.stream().map(ColumnInfoHolder::getSet).collect(Collectors.toList());
            List<Double> contextVector = LearningUtils.getContextVector(efscombination);
            Optional<ChartPreferenceContext> context = this.findContext(contexts, contextVector);
            if (context.isPresent()) {
                res = this.processContext(bound, unboundColumns, allColumns, chart, properties, list, context.get());
                if (res == null) continue;
                result.add(res);
                continue;
            }
            while (!context.isPresent() && this.getNumOfMeasureEFS(efscombination) >= 2) {
                efscombination = this.shrinkByOneMeasure(efscombination);
                contextVector = LearningUtils.getContextVector(efscombination);
                context = this.findContext(contexts, contextVector);
            }
            if (!context.isPresent() || (res = this.processContext(bound, unboundColumns, allColumns, chart, properties, list, context.get())) == null) continue;
            result.add(res);
        }
        return this.removeDuplicateBindings(result);
    }

    private int getNumOfMeasureEFS(List<ExtractedFeatureSet> efscombination) {
        int counter = 0;
        for (int i = 0; i < efscombination.size(); ++i) {
            ExtractedFeatureSet efs = efscombination.get(i);
            if (!efs.getFeatureType().getOntologyConcept().equals(BasicType.MEASURE.getOntologyConcept())) continue;
            ++counter;
        }
        return counter;
    }

    private List<ExtractedFeatureSet> shrinkByOneMeasure(List<ExtractedFeatureSet> efscombination) {
        boolean removed = false;
        ArrayList<ExtractedFeatureSet> result = new ArrayList<ExtractedFeatureSet>();
        for (int i = 0; i < efscombination.size(); ++i) {
            ExtractedFeatureSet efs = efscombination.get(i);
            if (!removed) {
                if (efs.getFeatureType().getOntologyConcept().equals(BasicType.MEASURE.getOntologyConcept())) {
                    removed = true;
                    continue;
                }
                result.add(efs);
                continue;
            }
            result.add(efs);
        }
        return result;
    }

    private List<IBindingResult> removeDuplicateBindings(List<IBindingResult> result) {
        ArrayList<IBindingResult> newResults = new ArrayList<IBindingResult>();
        if (result.isEmpty()) {
            return newResults;
        }
        return result.stream().map(x$0 -> new BindingResultWrapper((IBindingResult)x$0)).distinct().map(BindingResultWrapper::getBindingResult).collect(Collectors.toList());
    }

    public IBindingResult processContext(List<Binding> bound, List<IDataColumn> unbound, List<IDataColumn> allColumns, String chart, NLGProperties properties, List<ColumnInfoHolder> combination, ChartPreferenceContext chartPrefcontext) {
        List<PreferedChart> preferredBindings = this.getPreferredBindings(chart, chartPrefcontext);
        ArrayList<ColumnInfoHolder> combinationCopy = new ArrayList<ColumnInfoHolder>(combination);
        List<BindingWrapper> boundWrapper = this.toBindingWrapper(bound, combinationCopy);
        List<ExtractedFeatureSet> unboundEFS = this.toExtractedFeatureSet(unbound, combinationCopy);
        for (PreferedChart prefBinding : preferredBindings) {
            IBindingResult bindingResult;
            if (!this.isBindingSimilarToLearnedBinding(boundWrapper, prefBinding) || (bindingResult = this.getBindingResult(boundWrapper, unboundEFS, allColumns, prefBinding, properties)) == null) continue;
            return bindingResult;
        }
        return null;
    }

    private List<ExtractedFeatureSet> toExtractedFeatureSet(List<IDataColumn> unbound, List<ColumnInfoHolder> combination) {
        ArrayList<ExtractedFeatureSet> result = new ArrayList<ExtractedFeatureSet>();
        for (IDataColumn col : unbound) {
            Optional<ColumnInfoHolder> match = combination.stream().filter(colInfoHolder -> colInfoHolder.getColumn().getIdForExpression().equals(col.getIdForExpression())).findFirst();
            if (match.isPresent()) {
                combination.remove(match.get());
                result.add(match.get().getSet());
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn(String.format("Couldn't find %s in the combination", col.getIdForExpression()));
        }
        return result;
    }

    private List<BindingWrapper> toBindingWrapper(List<Binding> bound, List<ColumnInfoHolder> combination) {
        ArrayList<BindingWrapper> result = new ArrayList<BindingWrapper>();
        for (Binding binding : bound) {
            List columns = binding.getColumns();
            ArrayList<ColumnInfoHolder> columnInfoHolders = new ArrayList<ColumnInfoHolder>();
            for (String colId : columns) {
                Optional<ColumnInfoHolder> match = combination.stream().filter(colInfoHolder -> colInfoHolder.getColumn().getIdForExpression().equals(colId)).findFirst();
                if (!match.isPresent()) continue;
                combination.remove(match.get());
                columnInfoHolders.add(match.get());
            }
            result.add(new BindingWrapper(binding, columnInfoHolders));
        }
        return result;
    }

    private IBindingResult getBindingResult(List<BindingWrapper> bound, List<ExtractedFeatureSet> unboundColumns, List<IDataColumn> allColumns, PreferedChart prefChart, NLGProperties properties) {
        List<Binding> bindings = bound.stream().map(b -> b.getBinding()).collect(Collectors.toList());
        Set<String> boundSLots = bindings.stream().map(b -> b.getSlot()).collect(Collectors.toSet());
        BindingResultState brs = this.getBindings(unboundColumns, prefChart, boundSLots);
        if (brs.isAllBounded()) {
            bindings.addAll(brs.getBindings());
            BindingResult res = new BindingResult(properties.getLocale(), prefChart.getChartName(), bindings, Collections.emptyList(), 0, PreferenceLevel.HIGH, false, true);
            this.generateNLGForResult(bound, allColumns, properties, bindings, unboundColumns, res, brs.getFlexibleSlotCapacitySet());
            return res;
        }
        return null;
    }

    private void generateNLGForResult(List<BindingWrapper> bound, List<IDataColumn> allColumns, NLGProperties properties, List<Binding> bindings, List<ExtractedFeatureSet> unboundColsExtractedFS, BindingResult res, Set<String> flexableCapacitySlot) {
        List<IChartDescriptor> internalCharts = properties.getInternalChartDescriptors();
        List<IExternalChartDescriptor> externalCharts = properties.getExternalChartDescriptors();
        Locale locale = properties.getLocale();
        List<ExtractedFeatureSet> allColumnsEFS = bound.stream().flatMap(b -> b.getExtractedFeatureSets().stream()).collect(Collectors.toList());
        allColumnsEFS.addAll(unboundColsExtractedFS);
        Map<String, String> idForExpressionToColumnName = allColumns.stream().collect(Collectors.toMap(c -> c.getIdForExpression(), c -> c.getName(), (l1, l2) -> l2));
        List allBoundSlots = res.getBinding().stream().map(b -> b.getSlot()).collect(Collectors.toList());
        List allDescriptors = Stream.concat(internalCharts.stream(), externalCharts.stream()).collect(Collectors.toList());
        Optional<IBaseChartDescriptor> chartDescriptorOpt = allDescriptors.stream().filter(cd -> {
            List chartElements = cd.getElements().stream().filter(e -> flexableCapacitySlot.contains(e.getType().getSlot())).filter(e -> e.isMultiMeasure()).collect(Collectors.toList());
            return chartElements.size() == flexableCapacitySlot.size();
        }).filter(cd -> {
            Set slots = cd.getElements().stream().map(ce -> ce.getType().getSlot()).collect(Collectors.toSet());
            return slots.containsAll(allBoundSlots);
        }).sorted(Comparator.comparingInt(e -> e.getElements().size())).findFirst();
        if (chartDescriptorOpt.isPresent()) {
            IBaseChartDescriptor chartDescriptor = chartDescriptorOpt.get();
            if (chartDescriptor instanceof IExternalChartDescriptor) {
                ((IExternalChartDescriptor)chartDescriptor).addNaturalLanguageToBinding(locale, allColumns, res);
            } else {
                res.generateNaturalLanguage(locale, (IChartDescriptor)chartDescriptor, allColumnsEFS, bindings, idForExpressionToColumnName);
            }
        } else {
            LOGGER.warn("a matching chart descriptor to the current binding was not found");
        }
    }

    private boolean isBindingSimilarToLearnedBinding(List<BindingWrapper> bound, PreferedChart prefChart) {
        for (BindingWrapper binding : bound) {
            List<List<Double>> boundColumnsVectors;
            String slot = binding.getSlot();
            List<List<Double>> slotBindingVectors = prefChart.getSlotBinding(slot);
            if (this.isBoundColumnOk(slotBindingVectors, boundColumnsVectors = binding.getColumnVectors())) continue;
            return false;
        }
        return true;
    }

    private boolean isBoundColumnOk(List<List<Double>> slotBindingVectors, List<List<Double>> columnsVectors) {
        ArrayList<List<Double>> columnVectorsCopy = new ArrayList<List<Double>>(columnsVectors);
        for (List<Double> slotBindingVector : slotBindingVectors) {
            columnVectorsCopy.removeIf(columnVector -> RecommenderUtil.cosineSimilarity(columnVector, slotBindingVector) >= 0.89);
        }
        return columnVectorsCopy.isEmpty();
    }

    private List<PreferedChart> getPreferredBindings(String chart, ChartPreferenceContext chartPreferenceContext) {
        List<PreferedChart> preferredCharts = chartPreferenceContext.getChartPreference(chart);
        return preferredCharts.stream().sorted(Comparator.comparingDouble(chartee -> chartee.getPreference()).reversed()).collect(Collectors.toList());
    }

    private List<List<ColumnInfoHolder>> prepColumns(Map<BindingParams, Double> bindingParams, List<IDataColumn> allColumns) {
        ArrayList<List<ColumnInfoHolder>> columnsInfoHolders = new ArrayList<List<ColumnInfoHolder>>(allColumns.size());
        for (IDataColumn col : allColumns) {
            List<ExtractedFeatureSet> extractedFeatureSets = FeatureExtracter.extractFeatureSetFromColumn(col, bindingParams, true, 0, false);
            ArrayList<ColumnInfoHolder> columnInfoHolders = new ArrayList<ColumnInfoHolder>(extractedFeatureSets.size());
            for (ExtractedFeatureSet set : extractedFeatureSets) {
                ColumnInfoHolder holder = new ColumnInfoHolder(col, set, LearningUtils.getColumnVector(set));
                columnInfoHolders.add(holder);
            }
            columnsInfoHolders.add(columnInfoHolders);
        }
        return columnsInfoHolders;
    }

    private RecommendedVisualization adjustRecommendation(List<ChartPreferenceContext> contexts, Locale locale, RecommendedVisualization recommendation) {
        List<Double> contextVector = SpecAnalyserAdapter.createContextVectorFromFeatures(recommendation.getFeatures());
        if (contextVector == null) {
            return recommendation;
        }
        Optional<ChartPreferenceContext> context = this.findContext(contexts, contextVector);
        if (!context.isPresent()) {
            return recommendation;
        }
        ChartPreferenceContext matchingContext = context.get();
        Optional<PreferedChart> preferedChart = matchingContext.getChartPreference(recommendation.getLabel()).stream().sorted(Comparator.comparingDouble(chart -> chart.getPreference()).reversed()).findFirst();
        if (!preferedChart.isPresent()) {
            return recommendation;
        }
        PreferedChart chart2 = preferedChart.get();
        if (recommendation.getColumnBindings().size() != chart2.getBindings().size()) {
            return recommendation;
        }
        List columns = recommendation.getFeatures().stream().map(f -> f.getColumn()).collect(Collectors.toList());
        ArrayList<ExtractedFeatureSet> featuresWithConcepts = new ArrayList<ExtractedFeatureSet>();
        for (IDataColumn col : columns) {
            List<ExtractedFeatureSet> extractedFeatures = FeatureExtracter.extractFeatureSetFromColumn(col, new EnumMap<BindingParams, Double>(BindingParams.class), true, 0, false);
            Optional<ExtractedFeatureSet> featureMatch = extractedFeatures.stream().filter(fs -> !fs.getConcept().equals("NONE")).findFirst();
            if (featureMatch.isPresent()) {
                featuresWithConcepts.add(featureMatch.get());
                continue;
            }
            featuresWithConcepts.add(extractedFeatures.get(0));
        }
        BindingResultState brs = this.getBindings(featuresWithConcepts, chart2, Collections.EMPTY_SET);
        if (!brs.allBounded) {
            return recommendation;
        }
        List bindings = brs.bindings;
        double score = this.calculateScore(recommendation.getScore(), chart2.getPreference());
        int rank = this.caclulateRank(score, recommendation.getRank(), chart2.getPreference());
        RecommendedVisualization adjustedRecommendation = new RecommendedVisualization(recommendation, bindings, score, rank);
        adjustedRecommendation.setSentiment(chart2.getSentiment());
        if (locale != null) {
            Map<String, String> mapColumnIdForExpresionToColumnName = VisRecommenderUtils.getColumnIdNameMap(recommendation.getFeatures().stream().map(ExtractedFeatureSet::getColumn).collect(Collectors.toSet()));
            adjustedRecommendation.generateNaturalLanguage(locale, mapColumnIdForExpresionToColumnName);
        }
        return adjustedRecommendation;
    }

    private BindingResultState getBindings(List<ExtractedFeatureSet> features, PreferedChart chart, Set<String> boundSlots) {
        Set<String> flexibleSlotCapacitySet = chart.getFlexibleSlotCapacitySet();
        List<String> availableSlots = chart.getSlots().stream().filter(s -> flexibleSlotCapacitySet.contains(s) || !boundSlots.contains(s)).collect(Collectors.toList());
        List<SlotSimilarityScore> scores = this.getSlotSimilarityScores(features, chart, availableSlots);
        scores = scores.stream().filter(s -> !flexibleSlotCapacitySet.contains(s.slot) || s.column.getFlatListOfConcepts().contains(BasicType.MEASURE.getOntologyConcept())).collect(Collectors.toList());
        Map<IDataColumn, List<SlotSimilarityScore>> columnBindings = scores.stream().sorted(Comparator.comparingDouble(slotSim -> slotSim.score).reversed()).collect(Collectors.groupingBy(sim -> sim.column));
        Map<String, List<IDataColumn>> slotBindings = this.getBestSlotToColumnBindingMap(columnBindings, flexibleSlotCapacitySet);
        ArrayList<Binding> result = new ArrayList<Binding>();
        for (Map.Entry<String, List<IDataColumn>> entry : slotBindings.entrySet()) {
            String slot = entry.getKey();
            List columnIds = entry.getValue().stream().flatMap(col -> this.columnToIds((IDataColumn)col)).collect(Collectors.toList());
            result.add(new Binding(columnIds, slot));
        }
        if (slotBindings.isEmpty() || result.size() != slotBindings.size()) {
            return new BindingResultState(result, false, flexibleSlotCapacitySet);
        }
        return new BindingResultState(result, true, flexibleSlotCapacitySet);
    }

    private Stream<String> columnToIds(IDataColumn column) {
        if (column.isHierchical()) {
            return column.getHierarchy().stream().map(c -> c.getIdForExpression());
        }
        return Stream.of(column.getIdForExpression());
    }

    private Map<String, List<IDataColumn>> getBestSlotToColumnBindingMap(Map<IDataColumn, List<SlotSimilarityScore>> columnBindings, Set<String> flexibleSlotCapacitySet) {
        ArrayList scores = new ArrayList(columnBindings.values());
        List sortedCombinations = VisRecommenderUtils.cartesianProduct(scores).stream().sorted(this.consistencySorter).sorted(this.scoreSorter).filter(s -> this.preventMultipleColsOnSameSlot((List<SlotSimilarityScore>)s, flexibleSlotCapacitySet)).collect(Collectors.toList());
        List topCombinationsAllScoresAboveThreshhold = sortedCombinations.stream().filter(this.minScoreFilter).collect(Collectors.toList());
        if (!topCombinationsAllScoresAboveThreshhold.isEmpty()) {
            return this.createSlotToColumnBindingMap((List)topCombinationsAllScoresAboveThreshhold.get(0));
        }
        if (!sortedCombinations.isEmpty()) {
            return this.createSlotToColumnBindingMap((List)sortedCombinations.get(0));
        }
        return Collections.emptyMap();
    }

    private boolean preventMultipleColsOnSameSlot(List<SlotSimilarityScore> scores, Set<String> flexibleSlotCapacitySet) {
        HashSet<String> seenSlots = new HashSet<String>();
        for (SlotSimilarityScore score : scores) {
            if (flexibleSlotCapacitySet.contains(score.slot) || seenSlots.add(score.slot)) continue;
            return false;
        }
        return true;
    }

    private Map<String, List<IDataColumn>> createSlotToColumnBindingMap(List<SlotSimilarityScore> slotSimilarityScoreList) {
        Map<String, List<SlotSimilarityScore>> slotToSimScore = slotSimilarityScoreList.stream().collect(Collectors.groupingBy(c -> c.slot));
        return slotToSimScore.entrySet().stream().collect(Collectors.toMap(c -> (String)c.getKey(), c -> ((List)c.getValue()).stream().map(v -> v.column).collect(Collectors.toList())));
    }

    private List<SlotSimilarityScore> getSlotSimilarityScores(List<ExtractedFeatureSet> features, PreferedChart chart, List<String> availableSlots) {
        ArrayList<SlotSimilarityScore> scores = new ArrayList<SlotSimilarityScore>();
        for (ExtractedFeatureSet columnEFS : features) {
            List<Double> columnVector = LearningUtils.getColumnVector(columnEFS);
            for (String slot : availableSlots) {
                List<List<Double>> slotBindingVectors = chart.getSlotBinding(slot);
                List<Object> similarityScores = new ArrayList();
                for (List<Double> slotBindingVector : slotBindingVectors) {
                    double cosineSimilarityScore = RecommenderUtil.cosineSimilarity(columnVector, slotBindingVector);
                    SlotSimilarityScore similarityScore = new SlotSimilarityScore(columnEFS.getColumn(), slot, slotBindingVector, slotBindingVectors.size(), cosineSimilarityScore);
                    similarityScores.add(similarityScore);
                }
                ToDoubleFunction<SlotSimilarityScore> scorer = b -> b.score;
                similarityScores = similarityScores.stream().sorted(Comparator.comparingDouble(scorer).reversed()).collect(Collectors.toList());
                scores.add((SlotSimilarityScore)similarityScores.get(0));
            }
        }
        return scores;
    }

    private ExternalRecommendedVisualization adjustExternalRecommendation(List<ChartPreferenceContext> contexts, Locale locale, ExternalRecommendedVisualization recommendation, Map<BindingParams, Double> thresholds, Map<String, IDataColumn> labelToIDataColumnmap) {
        Map<String, String> mapColumnIdForExpresionToColumnName;
        List<IDataColumn> columns;
        List<ExtractedFeatureSet> features;
        IChartNLGDescription chartNLG;
        Optional<ChartDescription> cd;
        List<Double> contextVector = LearningUtils.getContextVector(recommendation.getColumnBindings(), labelToIDataColumnmap, thresholds, recommendation.getDescriptor());
        if (contextVector == null) {
            return recommendation;
        }
        Optional<ChartPreferenceContext> context = this.findContext(contexts, contextVector);
        if (!context.isPresent()) {
            return recommendation;
        }
        ChartPreferenceContext matchingContext = context.get();
        Optional<PreferedChart> preferedChart = matchingContext.getChartPreference(recommendation.getLabel()).stream().sorted(Comparator.comparingDouble(chart -> chart.getPreference()).reversed()).findFirst();
        if (!preferedChart.isPresent()) {
            return recommendation;
        }
        PreferedChart chart2 = preferedChart.get();
        Set<String> flexibleSlotCapacitySet = chart2.getFlexibleSlotCapacitySet();
        Map<String, List<Double>> columnVectorMapString = LearningUtils.getColumnVectors(recommendation.getColumnBindings(), labelToIDataColumnmap, thresholds, recommendation.getDescriptor());
        Map<IDataColumn, List> columnVectorMap = columnVectorMapString.entrySet().stream().collect(Collectors.toMap(c -> (IDataColumn)labelToIDataColumnmap.get(c.getKey()), c -> (List)c.getValue()));
        Map<String, List<SlotSimilarityScore>> columnBindings = columnVectorMap.entrySet().stream().flatMap(entry -> {
            List columnVector = (List)entry.getValue();
            return chart2.getSlots().stream().map(slot -> chart2.getSlotBinding((String)slot).stream().map(v -> new SlotSimilarityScore((IDataColumn)entry.getKey(), (String)slot, (List<Double>)v, chart2.getSlotBinding((String)slot).size(), RecommenderUtil.cosineSimilarity(columnVector, v))).max(Comparator.comparingDouble(slotSim -> slotSim.score).reversed())).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparingDouble(slotSim -> slotSim.score).reversed());
        }).collect(Collectors.groupingBy(sim -> sim.column.getIdForExpression()));
        HashMap slotBindings = new HashMap();
        recommendation.getColumnBindings().forEach(binding -> {
            block0: for (String column : binding.getColumns()) {
                List candidates = columnBindings.getOrDefault(column, Collections.emptyList());
                for (SlotSimilarityScore candidate : candidates) {
                    List columns = slotBindings.computeIfAbsent(candidate.slot, slot -> new ArrayList());
                    if (!flexibleSlotCapacitySet.contains(candidate.slot) && columns.size() >= candidate.slotCapacity) continue;
                    slotBindings.compute(candidate.slot, (slot, cols) -> {
                        cols.add(candidate.column);
                        return cols;
                    });
                    continue block0;
                }
            }
        });
        List<Binding> bindings = slotBindings.entrySet().stream().map(e -> new Binding(((List)e.getValue()).stream().map(col -> col.getIdForExpression()).collect(Collectors.toList()), (String)e.getKey())).collect(Collectors.toList());
        double score = this.calculateScore(recommendation.getScore(), chart2.getPreference());
        int rank = this.caclulateRank(score, recommendation.getRank(), chart2.getPreference());
        ExternalRecommendedVisualization adjustedRecommendation = new ExternalRecommendedVisualization(recommendation, bindings, score, rank);
        adjustedRecommendation.setSentiment(chart2.getSentiment());
        if (locale != null && adjustedRecommendation.getDescriptor() instanceof IChartNLGDescription && (cd = (chartNLG = (IChartNLGDescription)((Object)adjustedRecommendation.getDescriptor())).processNaturalLanguage(features = ChartNLGUtils.getFeaturesForDescription(columns = columnVectorMap.keySet().stream().collect(Collectors.toList())), mapColumnIdForExpresionToColumnName = VisRecommenderUtils.getColumnIdNameMap(features.stream().map(ExtractedFeatureSet::getColumn).collect(Collectors.toSet())), adjustedRecommendation.getColumnBindings(), locale)).isPresent()) {
            ChartDescription des = cd.get();
            adjustedRecommendation.setNaturalLanguage(des.getLabel(), des.getTitle(), des.getDescription(), locale);
        }
        return adjustedRecommendation;
    }

    public void rankRecommendations(List<ChartPreferenceContext> contexts, Locale locale, List<RecommendedVisualization> recommendations, List<ExternalRecommendedVisualization> extRecommendations, Map<BindingParams, Double> thresholds, Map<String, IDataColumn> labelToIDataColumnMap) {
        ArrayList<RecommendedVisualization> unchangedCharts = new ArrayList<RecommendedVisualization>();
        List<RecommendedVisualization> adjustedCharts = new ArrayList<RecommendedVisualization>();
        for (RecommendedVisualization chart : recommendations) {
            RecommendedVisualization adjusted = this.adjustRecommendation(contexts, locale, chart);
            if (adjusted.equals(chart)) {
                unchangedCharts.add(chart);
                continue;
            }
            adjustedCharts.add(adjusted);
        }
        ArrayList<ExternalRecommendedVisualization> extUnchangedCharts = new ArrayList<ExternalRecommendedVisualization>();
        List<ExternalRecommendedVisualization> extAdjustedCharts = new ArrayList<ExternalRecommendedVisualization>();
        for (ExternalRecommendedVisualization externalRecommendedVisualization : extRecommendations) {
            ExternalRecommendedVisualization adjusted = this.adjustExternalRecommendation(contexts, locale, externalRecommendedVisualization, thresholds, labelToIDataColumnMap);
            if (adjusted.equals(externalRecommendedVisualization)) {
                extUnchangedCharts.add(externalRecommendedVisualization);
                continue;
            }
            extAdjustedCharts.add(adjusted);
        }
        if (!adjustedCharts.isEmpty() || !extAdjustedCharts.isEmpty()) {
            for (RecommendedVisualization recommendedVisualization : unchangedCharts) {
                recommendedVisualization.setScore(this.calculateScore(recommendedVisualization.getScore(), 0.0));
            }
            adjustedCharts.addAll(unchangedCharts);
            for (ExternalRecommendedVisualization externalRecommendedVisualization : extUnchangedCharts) {
                externalRecommendedVisualization.setScore(this.calculateScore(externalRecommendedVisualization.getScore(), 0.0));
            }
            extAdjustedCharts.addAll(extUnchangedCharts);
        } else {
            adjustedCharts.addAll(unchangedCharts);
            extAdjustedCharts.addAll(extUnchangedCharts);
        }
        adjustedCharts = adjustedCharts.stream().sorted(Comparator.comparingDouble(BaseRecommendedVisualization::getScore).reversed()).collect(Collectors.toList());
        recommendations.clear();
        recommendations.addAll(adjustedCharts);
        extAdjustedCharts = extAdjustedCharts.stream().sorted(Comparator.comparingDouble(BaseRecommendedVisualization::getScore).reversed()).collect(Collectors.toList());
        extRecommendations.clear();
        extRecommendations.addAll(extAdjustedCharts);
    }

    public static double calculateWeight(double originalWeight, Sentiment sentiment) {
        double weight = 0.0;
        switch (sentiment) {
            case LIKE: {
                weight = 1.0;
                break;
            }
            case DISLIKE: {
                weight = -1.0;
                break;
            }
            case USE: {
                weight = originalWeight + 0.2;
            }
        }
        return weight > 1.0 ? 1.0 : weight;
    }

    public boolean learn(SpecAnalyserAdapter specAnalyserAdapter, IBaseChartDescriptor candidate, List<Binding> bindings, Sentiment sentiment, Map<BindingParams, Double> bindingParams, Map<String, IDataColumn> colIdToIDataColumn) throws InvalidColumnBindingException {
        List<ExtractedFeatureSet> mappings = LearningUtils.getFeaturesFromBindingsWithValidation(bindings, colIdToIDataColumn, bindingParams, candidate);
        if (mappings.isEmpty()) {
            return false;
        }
        specAnalyserAdapter.learn(candidate.getName(), bindings, mappings, sentiment);
        return true;
    }

    private class BindingResultWrapper {
        String bindingID;
        IBindingResult bindingResult;

        public BindingResultWrapper(IBindingResult r) {
            this.bindingResult = r;
            StringBuilder builder = new StringBuilder();
            builder.append(r.getChart());
            List<Binding> bindings = r.getBinding();
            for (Binding b : bindings) {
                builder.append(b.getSlot());
                builder.append(b.getColumns());
            }
            this.bindingID = builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingResultWrapper that = (BindingResultWrapper)o;
            return Objects.equals(this.bindingID, that.bindingID);
        }

        public int hashCode() {
            return Objects.hash(this.bindingID);
        }

        public IBindingResult getBindingResult() {
            return this.bindingResult;
        }
    }

    class BindingResultState {
        private final List<Binding> bindings;
        private final boolean allBounded;
        private final Set<String> flexibleSlotCapacitySet;

        public BindingResultState(List<Binding> bindings, boolean allBounded, Set<String> flexibleSlotCapacitySet) {
            this.bindings = bindings;
            this.allBounded = allBounded;
            this.flexibleSlotCapacitySet = flexibleSlotCapacitySet;
        }

        public List<Binding> getBindings() {
            return this.bindings;
        }

        public Set<String> getFlexibleSlotCapacitySet() {
            return this.flexibleSlotCapacitySet;
        }

        public boolean isAllBounded() {
            return this.allBounded;
        }
    }

    class BindingWrapper {
        private Binding binding;
        private List<List<Double>> columnVectors = new ArrayList<List<Double>>();
        private List<ExtractedFeatureSet> extractedFeatureSets = new ArrayList<ExtractedFeatureSet>();

        public BindingWrapper(Binding binding, List<ColumnInfoHolder> columnInfoHolders) {
            this.binding = binding;
            for (ColumnInfoHolder cih : columnInfoHolders) {
                this.columnVectors.add(cih.getColumnVector());
                this.extractedFeatureSets.add(cih.getSet());
            }
        }

        public Binding getBinding() {
            return this.binding;
        }

        public String getSlot() {
            return this.binding.getSlot();
        }

        public List<List<Double>> getColumnVectors() {
            return this.columnVectors;
        }

        public List<String> getColumns() {
            return this.binding.getColumns();
        }

        public List<ExtractedFeatureSet> getExtractedFeatureSets() {
            return this.extractedFeatureSets;
        }
    }

    class ColumnInfoHolder {
        private IDataColumn column;
        private ExtractedFeatureSet set;
        private List<Double> columnVector;

        public ColumnInfoHolder(IDataColumn column, ExtractedFeatureSet set, List<Double> columnVector) {
            this.column = column;
            this.set = set;
            this.columnVector = columnVector;
        }

        public ExtractedFeatureSet getSet() {
            return this.set;
        }

        public IDataColumn getColumn() {
            return this.column;
        }

        public List<Double> getColumnVector() {
            return this.columnVector;
        }
    }

    private class ChartPreferenceContextSimilarity {
        private final ChartPreferenceContext context;
        private final double similarity;

        public ChartPreferenceContextSimilarity(ChartPreferenceContext context, double similarity) {
            this.context = context;
            this.similarity = similarity;
        }

        public ChartPreferenceContext getContext() {
            return this.context;
        }

        public double getSimilarity() {
            return this.similarity;
        }
    }

    private class SlotSimilarityScore {
        final IDataColumn column;
        final String slot;
        final List<Double> vector;
        final int slotCapacity;
        final double score;

        public SlotSimilarityScore(IDataColumn column, String slot, List<Double> vector, int slotCapacity, double score) {
            this.column = column;
            this.slot = slot;
            this.vector = vector;
            this.slotCapacity = slotCapacity;
            this.score = score;
        }

        public String toString() {
            return "Slot:" + this.slot + ", column:" + this.column;
        }
    }
}

