/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.learning;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.bi.recommendationmodel.Categorical;
import com.ibm.bi.recommendationmodel.Chart;
import com.ibm.bi.recommendationmodel.Concept;
import com.ibm.bi.recommendationmodel.Context;
import com.ibm.bi.recommendationmodel.ContextKey;
import com.ibm.bi.recommendationmodel.Geography;
import com.ibm.bi.recommendationmodel.Measure;
import com.ibm.bi.recommendationmodel.RecommendationModel;
import com.ibm.bi.recommendationmodel.Slot;
import com.ibm.bi.recommendationmodel.SlotMapping;
import com.ibm.bi.recommendationmodel.StatisticBucket;
import com.ibm.bi.recommendationmodel.StatisticBucketRange;
import com.ibm.bi.recommendationmodel.Temporal;
import com.ibm.smarts.common.learning.Sentiment;
import com.ibm.smarts.schema.StatisticType;
import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.StdChartConcepts;
import com.ibm.smarts.visualization.recommender.internal.learning.ChartPreferenceContext;
import com.ibm.smarts.visualization.recommender.internal.learning.LearningUtils;
import com.ibm.smarts.visualization.recommender.internal.learning.PreferedChart;
import com.ibm.smarts.visualization.recommender.internal.learning.PreferenceRecommender;
import com.ibm.smarts.visualization.recommender.internal.learning.RecommenderUtil;
import com.ibm.smarts.visualization.recommender.internal.modeling.ExtractedFeatureSet;
import com.ibm.smarts.visualization.recommender.schema.Binding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SpecAnalyserAdapter {
    private RecommendationModel recommendationModel;
    private static final String HIERARCHY = "HIERARCHY";
    private static final String BIVALUED = "BIVALUED";
    private static final String ORDINAL = "ORDINAL";
    private static final int MAX_COLUMN_COUNT = 50;
    private static final double TYPE_COUNT_BOOST_WEIGHT = 4.0;
    protected static final double DISTINCT_COUNT_BOOST_WEIGHT = 2.0;
    private static final double MAX_DISTINCT_COUNT_BUCKET = StatisticBucketRange.getFiniteUpperLimitForBucket((com.ibm.bi.recommendationmodel.StatisticType)com.ibm.bi.recommendationmodel.StatisticType.DISTINCT_COUNT);
    private static final double BUCKET_CEILING_FOR_MAX_MIN = StatisticBucketRange.getFiniteUpperLimitForBucket((com.ibm.bi.recommendationmodel.StatisticType)com.ibm.bi.recommendationmodel.StatisticType.MAX_VALUE);
    private static final List<Double> CATEGORY_VECTOR = Arrays.asList(1.0, 0.0, 0.0, 0.0);
    private static final List<Double> DATE_VECTOR = Arrays.asList(0.0, 1.0, 0.0, 0.0);
    private static final List<Double> LOCATION_VECTOR = Arrays.asList(0.0, 0.0, 1.0, 0.0);
    private static final List<Double> MEASURE_VECTOR = Arrays.asList(0.0, 0.0, 0.0, 1.0);
    private static List<String> chartConcepts = Stream.of(StdChartConcepts.values()).map(Enum::name).collect(Collectors.toList());

    @JsonCreator
    public SpecAnalyserAdapter(@JsonProperty(value="recommendationModel") RecommendationModel recommendationModel) {
        this.recommendationModel = recommendationModel;
    }

    public RecommendationModel getRecommendationModel() {
        return this.recommendationModel;
    }

    public List<ChartPreferenceContext> getContexts() {
        if (this.recommendationModel.getCharts().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ChartPreferenceContext> contexts = new ArrayList<ChartPreferenceContext>();
        HashMap<List<Double>, ChartPreferenceContext> contextVectorToContextMap = new HashMap<List<Double>, ChartPreferenceContext>();
        for (Chart chart : this.recommendationModel.getCharts()) {
            for (Context context : chart.getContexts()) {
                for (SlotMapping slotMapping : context.getSlotMappings()) {
                    HashSet<String> flexibleSlotCapacitySet = new HashSet<String>();
                    for (Slot slot : slotMapping.getSlots()) {
                        Optional<Concept> measureConcept = slot.getColumns().getConcepts().stream().filter(concept -> concept.getConceptId().equals(BasicType.MEASURE.getOntologyConcept())).findAny();
                        if (!measureConcept.isPresent() || slot.getColumns().getColumnCount() <= 1) continue;
                        flexibleSlotCapacitySet.add(slot.getName());
                    }
                    List<Double> contextVectorFromSlotMappings = this.createContextVectorFromRecModel(context, slotMapping);
                    Map<String, List<List<Double>>> columnVectorsFromSlotMappings = this.createColumnVectorFromRecModel(slotMapping);
                    Optional<ChartPreferenceContext> matchedChartPrefContext = contextVectorToContextMap.entrySet().stream().map(entry -> {
                        if (RecommenderUtil.cosineSimilarity((List)entry.getKey(), contextVectorFromSlotMappings) > 0.89) {
                            return (ChartPreferenceContext)entry.getValue();
                        }
                        return null;
                    }).filter(Objects::nonNull).findFirst();
                    if (matchedChartPrefContext.isPresent()) {
                        boolean bindingMatch = matchedChartPrefContext.get().getChartPreference(chart.getName()).stream().anyMatch(preferredChart -> preferredChart.getBindings().equals(columnVectorsFromSlotMappings));
                        if (bindingMatch) continue;
                        PreferedChart preferredChartToAdd = new PreferedChart(chart.getName(), columnVectorsFromSlotMappings, context.getScore(), flexibleSlotCapacitySet);
                        preferredChartToAdd.setSentiment(context.getSentiment());
                        matchedChartPrefContext.get().getChartPreferenceMap().compute(chart.getName(), (k, v) -> {
                            ArrayList<PreferedChart> updatedCharts = new ArrayList<PreferedChart>();
                            if (v == null) {
                                updatedCharts.add(preferredChartToAdd);
                            } else {
                                updatedCharts.addAll((Collection<PreferedChart>)v);
                                updatedCharts.add(preferredChartToAdd);
                            }
                            return updatedCharts;
                        });
                        continue;
                    }
                    ChartPreferenceContext chartPreferenceContext = new ChartPreferenceContext(contextVectorFromSlotMappings);
                    ArrayList<PreferedChart> preferredChartsList = new ArrayList<PreferedChart>();
                    PreferedChart preferedChart = new PreferedChart(chart.getName(), columnVectorsFromSlotMappings, context.getScore(), flexibleSlotCapacitySet);
                    preferedChart.setSentiment(context.getSentiment());
                    preferredChartsList.add(preferedChart);
                    chartPreferenceContext.getChartPreferenceMap().putIfAbsent(chart.getName(), preferredChartsList);
                    contexts.add(chartPreferenceContext);
                    contextVectorToContextMap.put(contextVectorFromSlotMappings, chartPreferenceContext);
                }
            }
        }
        return contexts;
    }

    public void learn(String candidate, List<Binding> bindings, List<ExtractedFeatureSet> mappings, Sentiment sentiment) {
        Chart chart = this.recommendationModel.putIfAbsentAndReturn(candidate);
        int measureFrequency = 0;
        int temporalFrequency = 0;
        int geographicalFrequency = 0;
        int categoryFrequency = 0;
        for (ExtractedFeatureSet fs : mappings) {
            if (fs.getFeatureType().getOntologyConcept().equals(BasicType.MEASURE.getOntologyConcept())) {
                ++measureFrequency;
            }
            if (fs.getFeatureType().getOntologyConcept().equals(BasicType.CATEGORY.getOntologyConcept())) {
                ++categoryFrequency;
            }
            if (fs.getFeatureType().getOntologyConcept().equals(BasicType.LOCATION.getOntologyConcept())) {
                ++geographicalFrequency;
            }
            if (!fs.getFeatureType().getOntologyConcept().equals(BasicType.DATE.getOntologyConcept())) continue;
            ++temporalFrequency;
        }
        Map<String, Integer> slotMappingMap = bindings.stream().collect(Collectors.toMap(b -> b.getSlot(), b -> b.getColumns().size(), (a, b) -> a + b));
        boolean isMultiColumnSlot = slotMappingMap.values().stream().anyMatch(colSize -> colSize >= 2);
        Measure measure = new Measure(measureFrequency, isMultiColumnSlot);
        Temporal temporal = new Temporal(temporalFrequency);
        Geography geography = new Geography(geographicalFrequency);
        Categorical categorical = new Categorical(categoryFrequency);
        Context context = chart.putIfAbsentAndReturn(categorical, geography, measure, temporal);
        context.setScore(PreferenceRecommender.calculateWeight(context.getScore(), sentiment));
        switch (sentiment) {
            case LIKE: {
                context.setSentiment(Sentiment.LIKE);
                break;
            }
            case DISLIKE: {
                context.setSentiment(Sentiment.DISLIKE);
            }
        }
        SlotMapping slotmapping = context.putIfAbsentAndReturn(slotMappingMap);
        context.incrementFrequency();
        for (Map.Entry<String, Integer> entry : slotMappingMap.entrySet()) {
            ArrayList concepts = new ArrayList();
            Slot slot = slotmapping.putIfAbsentAndReturn(entry.getKey(), entry.getValue().intValue());
            Optional<Binding> boundSlot = bindings.stream().filter(b -> b.getSlot().equals(slot.getName())).findFirst();
            if (!boundSlot.isPresent()) continue;
            boundSlot.get().getColumns().forEach(c -> {
                Optional<ExtractedFeatureSet> match = mappings.stream().filter(fs -> fs.getColumn().getIdForExpression().equals(c)).findFirst();
                if (match.isPresent()) {
                    double distinctCountValue;
                    ExtractedFeatureSet fs2 = match.get();
                    double min = fs2.getFeatureType().equals((Object)BasicType.MEASURE) ? fs2.getColumn().getMin().doubleValue() : 0.0;
                    double max = fs2.getFeatureType().equals((Object)BasicType.MEASURE) ? fs2.getColumn().getMax().doubleValue() : 0.0;
                    double densityValue = fs2.getColumn().getDensity();
                    double d = distinctCountValue = fs2.getFeatureType().equals((Object)BasicType.MEASURE) ? 0.0 : (double)fs2.getColumn().getQuantity();
                    if (min == Double.MIN_VALUE) {
                        min = Double.NEGATIVE_INFINITY;
                    }
                    if (max == Double.MIN_VALUE) {
                        max = Double.NEGATIVE_INFINITY;
                    }
                    double minStat = min;
                    double maxStat = max;
                    slot.getColumns().getMin().forEach(bucket -> {
                        if (bucket.isValueWithinRange(Double.valueOf(minStat)).booleanValue()) {
                            bucket.incrementFrequency();
                        }
                    });
                    slot.getColumns().getMax().forEach(bucket -> {
                        if (bucket.isValueWithinRange(Double.valueOf(maxStat)).booleanValue()) {
                            bucket.incrementFrequency();
                        }
                    });
                    slot.getColumns().getDistinctCount().forEach(distinctCount -> {
                        if (distinctCount.isValueWithinRange(Double.valueOf(distinctCountValue)).booleanValue()) {
                            distinctCount.incrementFrequency();
                        }
                    });
                    slot.getColumns().getDensity().forEach(density -> {
                        if (density.isValueWithinRange(Double.valueOf(densityValue)).booleanValue()) {
                            density.incrementFrequency();
                        }
                    });
                    if (fs2.getFeatureType().equals((Object)BasicType.CATEGORY)) {
                        concepts.add(BasicType.CATEGORY.getOntologyConcept());
                        slot.getColumns().addConcepts(concepts);
                    }
                    if (fs2.getFeatureType().equals((Object)BasicType.MEASURE)) {
                        concepts.add(BasicType.MEASURE.getOntologyConcept());
                        slot.getColumns().addConcepts(concepts);
                    }
                    if (fs2.getFeatureType().equals((Object)BasicType.LOCATION)) {
                        concepts.add(BasicType.LOCATION.getOntologyConcept());
                        slot.getColumns().addConcepts(concepts);
                    }
                    if (fs2.getFeatureType().equals((Object)BasicType.DATE)) {
                        concepts.add(BasicType.DATE.getOntologyConcept());
                        slot.getColumns().addConcepts(concepts);
                    }
                    if (!fs2.getConcept().equals("NONE")) {
                        slot.getColumns().addConcepts(Arrays.asList(fs2.getConcept()));
                    }
                    slot.getColumns().getConcepts().forEach(concept -> concept.incrementFrequency());
                }
            });
        }
        slotmapping.incrementFrequency();
        this.decay(this.recommendationModel, context.getContextKey(), sentiment, chart.getName());
    }

    private void decay(RecommendationModel recommendationModel, ContextKey contextKey, Sentiment sentiment, String excludedChart) {
        List<Context> contexts = recommendationModel.getCharts().stream().filter(ch -> !ch.getName().equals(excludedChart)).flatMap(ch -> ch.getContexts().stream().filter(context -> context.getContextKey().equals((Object)contextKey))).collect(Collectors.toList());
        contexts.forEach(context -> context.setScore(LearningUtils.decayPreference(sentiment == Sentiment.LIKE, context.getScore())));
    }

    public List<Double> createContextVectorFromRecModel(Context context, SlotMapping slotMapping) {
        ArrayList<Double> contextVector = new ArrayList<Double>();
        Set basicConcepts = Stream.of(BasicType.values()).map(BasicType::getOntologyConcept).collect(Collectors.toSet());
        List slotsOrdered = slotMapping.getSlots().stream().sorted(Comparator.comparing(s -> {
            Optional<Concept> conceptOptional = s.getColumns().getConcepts().stream().filter(c -> basicConcepts.contains(c.getConceptId())).findFirst();
            if (!conceptOptional.isPresent()) {
                return "";
            }
            return conceptOptional.get().getConceptId();
        }).thenComparingDouble(s -> this.getWeightedAverageStats(s.getColumns().getDistinctCount())).thenComparingDouble(s -> this.getWeightedAverageStats(s.getColumns().getDensity()))).collect(Collectors.toList());
        int totalColumns = (context.getCategorical().getEnd() == Integer.MAX_VALUE ? 0 : context.getCategorical().getEnd()) + (context.getGeography().getEnd() == Integer.MAX_VALUE ? 0 : context.getGeography().getEnd()) + (context.getTemporal().getEnd() == Integer.MAX_VALUE ? 0 : context.getTemporal().getEnd()) + (context.getMeasure().getStart() == Integer.MAX_VALUE ? 0 : context.getMeasure().getStart());
        contextVector.add(4.0 * ((double)context.getCategorical().getEnd() / (double)totalColumns));
        contextVector.add(4.0 * ((double)context.getGeography().getEnd() / (double)totalColumns));
        contextVector.add(4.0 * ((double)context.getTemporal().getEnd() / (double)totalColumns));
        contextVector.add(4.0 * ((double)context.getMeasure().getEnd() / (double)totalColumns));
        ArrayList<Double> distinctCountsToAdd = new ArrayList<Double>();
        ArrayList<Double> densitiesToAdd = new ArrayList<Double>();
        ArrayList<Double> conceptsToAdd = new ArrayList<Double>();
        for (Slot slot : slotsOrdered) {
            distinctCountsToAdd.addAll(this.getStatsFromSlot(com.ibm.bi.recommendationmodel.StatisticType.DISTINCT_COUNT, slot));
            densitiesToAdd.addAll(this.getStatsFromSlot(com.ibm.bi.recommendationmodel.StatisticType.DENSITY, slot));
            conceptsToAdd.addAll(this.getStatsForConceptsFromSlot(slot));
        }
        contextVector.addAll(distinctCountsToAdd);
        contextVector.addAll(IntStream.range(0, 50 - totalColumns).mapToObj(i -> 0.0).collect(Collectors.toList()));
        contextVector.addAll(densitiesToAdd);
        contextVector.addAll(IntStream.range(0, 50 - totalColumns).mapToObj(i -> 0.0).collect(Collectors.toList()));
        contextVector.addAll(conceptsToAdd);
        contextVector.addAll(IntStream.range(0, chartConcepts.size() * (50 - totalColumns)).mapToObj(i -> 0.0).collect(Collectors.toList()));
        return LearningUtils.normalizeVector(contextVector);
    }

    public static List<Double> createContextVectorFromFeatures(List<ExtractedFeatureSet> features) {
        Map<BasicType, List<ExtractedFeatureSet>> typeMap = features.stream().collect(Collectors.groupingBy(ExtractedFeatureSet::getFeatureType));
        HashMap<String, List> slotToFeatures = new HashMap<String, List>();
        for (ExtractedFeatureSet extractedFeatureSet : features) {
            if (extractedFeatureSet.getChartElement() == null) continue;
            String string = extractedFeatureSet.getChartElement().getType().getSlot();
            List list = slotToFeatures.computeIfAbsent(string, s -> new ArrayList());
            list.add(extractedFeatureSet);
        }
        HashMap<ExtractedFeatureSet, Double> fsToDistinctCount = new HashMap<ExtractedFeatureSet, Double>();
        for (Map.Entry entry : slotToFeatures.entrySet()) {
            double d = ((List)entry.getValue()).stream().mapToDouble(ExtractedFeatureSet::getDistinctCount).average().orElse(0.0);
            for (Object fs : (List)entry.getValue()) {
                fsToDistinctCount.put((ExtractedFeatureSet)fs, d);
            }
        }
        HashMap<ExtractedFeatureSet, Double> hashMap = new HashMap<ExtractedFeatureSet, Double>();
        for (Map.Entry entry : slotToFeatures.entrySet()) {
            double average = ((List)entry.getValue()).stream().mapToDouble(f -> f.getColumn().getDensity()).average().orElse(0.0);
            for (ExtractedFeatureSet fs : (List)entry.getValue()) {
                hashMap.put(fs, average);
            }
        }
        List list = features.stream().sorted(Comparator.comparing(f -> f.getFeatureType().getOntologyConcept()).thenComparingDouble(f -> fsToDistinctCount.getOrDefault(f, Double.valueOf(f.getDistinctCount()))).thenComparingDouble(f -> f.getColumn().getDensity())).collect(Collectors.toList());
        int n = typeMap.getOrDefault((Object)BasicType.CATEGORY, Collections.emptyList()).size();
        int numberOfLocations = typeMap.getOrDefault((Object)BasicType.LOCATION, Collections.emptyList()).size();
        int numberOfDates = typeMap.getOrDefault((Object)BasicType.DATE, Collections.emptyList()).size();
        int numberOfMeasures = typeMap.getOrDefault((Object)BasicType.MEASURE, Collections.emptyList()).size();
        double totalNumberOfConcepts = list.stream().map(ExtractedFeatureSet::getConcept).filter(c -> !c.equals("NONE")).count();
        ArrayList<Double> distinctCounts = new ArrayList<Double>();
        for (Object fs : list) {
            distinctCounts.add(2.0 * (SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.DISTINCT_COUNT, fsToDistinctCount.getOrDefault(fs, Double.valueOf(((ExtractedFeatureSet)fs).getDistinctCount()))) / MAX_DISTINCT_COUNT_BUCKET));
        }
        ArrayList<Double> densities = new ArrayList<Double>();
        for (ExtractedFeatureSet fs : list) {
            densities.add(SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.DENSITY, hashMap.getOrDefault(fs, fs.getColumn().getDensity())));
        }
        ArrayList<Double> vector = new ArrayList<Double>();
        int totalColumnNumber = n + numberOfLocations + numberOfDates + numberOfMeasures;
        vector.add(4.0 * ((double)n / (double)totalColumnNumber));
        vector.add(4.0 * ((double)numberOfLocations / (double)totalColumnNumber));
        vector.add(4.0 * ((double)numberOfDates / (double)totalColumnNumber));
        vector.add(4.0 * ((double)numberOfMeasures / (double)totalColumnNumber));
        vector.addAll(distinctCounts);
        vector.addAll(IntStream.range(0, 50 - features.size()).mapToObj(i -> 0.0).collect(Collectors.toList()));
        vector.addAll(densities);
        vector.addAll(IntStream.range(0, 50 - features.size()).mapToObj(i -> 0.0).collect(Collectors.toList()));
        for (ExtractedFeatureSet fs : list) {
            for (StdChartConcepts concept : StdChartConcepts.values()) {
                if (fs.getConcept().equals(concept.getId())) {
                    vector.add(1.0 / totalNumberOfConcepts);
                    continue;
                }
                vector.add(0.0);
            }
        }
        vector.addAll(IntStream.range(0, StdChartConcepts.values().length * (50 - features.size())).mapToObj(i -> 0.0).collect(Collectors.toList()));
        return LearningUtils.normalizeVector(vector);
    }

    private Map<String, List<List<Double>>> createColumnVectorFromRecModel(SlotMapping slotMapping) {
        HashMap<String, List<List<Double>>> slotToColumnVector = new HashMap<String, List<List<Double>>>();
        for (Slot slot : slotMapping.getSlots()) {
            ArrayList<List<Double>> listVectors = new ArrayList<List<Double>>();
            for (int i = 0; i < slot.getColumns().getColumnCount(); ++i) {
                ArrayList<Double> columnVector = new ArrayList<Double>();
                Optional<Concept> measureConcept = slot.getColumns().getConcepts().stream().filter(concept -> concept.getConceptId().equals(BasicType.MEASURE.getOntologyConcept())).findAny();
                if (measureConcept.isPresent()) {
                    columnVector.addAll(MEASURE_VECTOR);
                    columnVector.add(0.0);
                    columnVector.add(this.getWeightedAverageStats(slot.getColumns().getMin()) / BUCKET_CEILING_FOR_MAX_MIN);
                    columnVector.add(this.getWeightedAverageStats(slot.getColumns().getMax()) / BUCKET_CEILING_FOR_MAX_MIN);
                } else {
                    Optional<Concept> locationConcept = slot.getColumns().getConcepts().stream().filter(concept -> concept.getConceptId().equals(BasicType.LOCATION.getOntologyConcept())).findAny();
                    Optional<Concept> dateConcept = slot.getColumns().getConcepts().stream().filter(concept -> concept.getConceptId().equals(BasicType.DATE.getOntologyConcept())).findAny();
                    if (locationConcept.isPresent()) {
                        columnVector.addAll(LOCATION_VECTOR);
                    } else if (dateConcept.isPresent()) {
                        columnVector.addAll(DATE_VECTOR);
                    } else {
                        columnVector.addAll(CATEGORY_VECTOR);
                    }
                    columnVector.add(this.getWeightedAverageStats(slot.getColumns().getDistinctCount()) / MAX_DISTINCT_COUNT_BUCKET);
                    columnVector.add(0.0);
                    columnVector.add(0.0);
                }
                columnVector.add(this.getWeightedAverageStats(slot.getColumns().getDensity()));
                int sumConceptFreq = 0;
                ArrayList<Double> conceptFrequencies = new ArrayList<Double>();
                for (String concept2 : chartConcepts) {
                    double freq = this.getConcepts(slot, concept2);
                    conceptFrequencies.add(freq);
                    sumConceptFreq = (int)((double)sumConceptFreq + freq);
                }
                Iterator<String> iterator = conceptFrequencies.iterator();
                while (iterator.hasNext()) {
                    double freq = (Double)((Object)iterator.next());
                    if (sumConceptFreq == 0) {
                        columnVector.add(0.0);
                        continue;
                    }
                    columnVector.add(freq / (double)sumConceptFreq);
                }
                listVectors.add(LearningUtils.normalizeVector(columnVector));
                slotToColumnVector.putIfAbsent(slot.getName(), listVectors);
            }
        }
        return slotToColumnVector;
    }

    public static List<Double> createColumnVectorFromFeatures(ExtractedFeatureSet feature) {
        ArrayList<Double> vector = new ArrayList<Double>();
        if (feature.getFeatureType() == BasicType.MEASURE) {
            vector.addAll(MEASURE_VECTOR);
            vector.add(0.0);
            Optional<Double> min = feature.getColumn().getStatistics().stream().filter(s -> s.getType() == StatisticType.MIN_VALUE).map(s -> s.getValue().doubleValue()).findFirst();
            if (min.isPresent()) {
                vector.add(SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.MIN_VALUE, min.get()) / BUCKET_CEILING_FOR_MAX_MIN);
            } else {
                vector.add(SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.MIN_VALUE, Double.NEGATIVE_INFINITY) / BUCKET_CEILING_FOR_MAX_MIN);
            }
            Optional<Double> max = feature.getColumn().getStatistics().stream().filter(s -> s.getType() == StatisticType.MAX_VALUE).map(s -> s.getValue().doubleValue()).findFirst();
            if (max.isPresent()) {
                vector.add(SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.MAX_VALUE, max.get()) / BUCKET_CEILING_FOR_MAX_MIN);
            } else {
                vector.add(SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.MAX_VALUE, Double.NEGATIVE_INFINITY) / BUCKET_CEILING_FOR_MAX_MIN);
            }
        } else {
            if (feature.getFeatureType() == BasicType.LOCATION) {
                vector.addAll(LOCATION_VECTOR);
            } else if (feature.getFeatureType() == BasicType.DATE) {
                vector.addAll(DATE_VECTOR);
            } else {
                vector.addAll(CATEGORY_VECTOR);
            }
            vector.add(SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.DISTINCT_COUNT, feature.getDistinctCount()) / MAX_DISTINCT_COUNT_BUCKET);
            vector.add(0.0);
            vector.add(0.0);
        }
        vector.add(SpecAnalyserAdapter.normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType.DENSITY, feature.getColumn().getDensity()));
        for (StdChartConcepts concept : StdChartConcepts.values()) {
            if (feature.getConcept().equals(concept.getId())) {
                vector.add(1.0);
                continue;
            }
            vector.add(0.0);
        }
        return LearningUtils.normalizeVector(vector);
    }

    private List<Double> getStatsFromSlot(com.ibm.bi.recommendationmodel.StatisticType statisticType, Slot slot) {
        List<Double> weightedAverageStats = new ArrayList<Double>();
        List<Object> buckets = new ArrayList();
        double boost = 1.0;
        switch (statisticType) {
            case DISTINCT_COUNT: {
                buckets = slot.getColumns().getConcepts().stream().map(c -> c.getConceptId()).anyMatch(c -> c.equals(BasicType.MEASURE.getOntologyConcept())) ? Arrays.asList(StatisticBucket.getStatisticBucketRange((com.ibm.bi.recommendationmodel.StatisticType)com.ibm.bi.recommendationmodel.StatisticType.DISTINCT_COUNT, (Double)0.0)) : slot.getColumns().getDistinctCount();
                boost = 2.0;
                break;
            }
            case DENSITY: {
                buckets = slot.getColumns().getDensity();
            }
        }
        int count = slot.getColumns().getColumnCount();
        if (slot.getColumns().getConcepts().stream().map(c -> c.getConceptId()).anyMatch(c -> c.equals(BasicType.MEASURE.getOntologyConcept()))) {
            count = slot.getColumns().getColumnCount() > 2 ? 2 : count;
            for (int i = 0; i < count; ++i) {
                weightedAverageStats.add(boost * this.getWeightedAverageStats(buckets));
            }
        } else if (slot.getColumns().getConcepts().stream().map(c -> c.getConceptId()).anyMatch(c -> c.equals(StdChartConcepts.HIERARCHY.getId()))) {
            weightedAverageStats.add(boost * this.getWeightedAverageStats(buckets));
        } else {
            for (int i = 0; i < count; ++i) {
                weightedAverageStats.add(boost * this.getWeightedAverageStats(buckets));
            }
        }
        if (statisticType == com.ibm.bi.recommendationmodel.StatisticType.DISTINCT_COUNT) {
            weightedAverageStats = weightedAverageStats.stream().map(e -> e / MAX_DISTINCT_COUNT_BUCKET).collect(Collectors.toList());
        }
        return weightedAverageStats;
    }

    private List<Double> getStatsForConceptsFromSlot(Slot slot) {
        ArrayList<Double> averageConcepts = new ArrayList<Double>();
        int count = slot.getColumns().getColumnCount();
        int sumConceptFreq = 0;
        ArrayList<Double> conceptFrequencies = new ArrayList<Double>();
        for (String concept : Stream.of(StdChartConcepts.values()).map(e -> e.getId()).collect(Collectors.toList())) {
            double freq = this.getConcepts(slot, concept);
            conceptFrequencies.add(freq);
            sumConceptFreq = (int)((double)sumConceptFreq + freq);
        }
        Iterator<Object> iterator = conceptFrequencies.iterator();
        while (iterator.hasNext()) {
            int i;
            double freq = (Double)iterator.next();
            if (slot.getColumns().getConcepts().stream().map(c -> c.getConceptId()).anyMatch(c -> c.equals(BasicType.MEASURE.getOntologyConcept()))) {
                count = slot.getColumns().getColumnCount() > 2 ? 2 : count;
                for (i = 0; i < count; ++i) {
                    if (sumConceptFreq == 0) {
                        averageConcepts.add(0.0);
                        continue;
                    }
                    averageConcepts.add(freq / (double)sumConceptFreq);
                }
                continue;
            }
            if (slot.getColumns().getConcepts().stream().map(c -> c.getConceptId()).anyMatch(c -> c.equals(StdChartConcepts.HIERARCHY.getId()))) {
                if (sumConceptFreq == 0) {
                    averageConcepts.add(0.0);
                    continue;
                }
                averageConcepts.add(freq / (double)sumConceptFreq);
                continue;
            }
            for (i = 0; i < count; ++i) {
                if (sumConceptFreq == 0) {
                    averageConcepts.add(0.0);
                    continue;
                }
                averageConcepts.add(freq / (double)sumConceptFreq);
            }
        }
        return averageConcepts;
    }

    private double getWeightedAverageStats(List<StatisticBucket> buckets) {
        double weightedSum = 0.0;
        int sum = 0;
        for (StatisticBucket bucket : buckets) {
            if (bucket.getFrequency() <= 0) continue;
            weightedSum = bucket.getEnd() == Double.POSITIVE_INFINITY ? (weightedSum += bucket.getStart() * (double)bucket.getFrequency()) : (bucket.getStart() == Double.NEGATIVE_INFINITY ? (weightedSum += bucket.getEnd() * (double)bucket.getFrequency()) : (weightedSum += (bucket.getEnd() + bucket.getStart()) * (double)bucket.getFrequency() / 2.0));
            sum += bucket.getFrequency();
        }
        if (sum == 0) {
            return 0.0;
        }
        return weightedSum / (double)sum;
    }

    private double getConcepts(Slot slot, String chartConcept) {
        if (chartConcept.equals(HIERARCHY)) {
            return slot.getColumns().getConceptHierarchyFrequency();
        }
        boolean categoryPresent = slot.getColumns().getConcepts().stream().anyMatch(c -> c.getConceptId().equals(BasicType.CATEGORY.getOntologyConcept()));
        boolean datePresent = slot.getColumns().getConcepts().stream().anyMatch(c -> c.getConceptId().equals(BasicType.DATE.getOntologyConcept()));
        if (categoryPresent && chartConcept.equals(BIVALUED)) {
            Optional<StatisticBucket> bucket = slot.getColumns().getDistinctCount().stream().filter(b -> b.getStart() == 0.0).findFirst();
            if (bucket.isPresent()) {
                return bucket.get().getFrequency();
            }
            return 0.0;
        }
        if (datePresent && chartConcept.equals(ORDINAL)) {
            chartConcept = BasicType.DATE.getOntologyConcept();
        }
        int freq = 0;
        for (Concept concept : slot.getColumns().getConcepts()) {
            if (!concept.getConceptId().equals(chartConcept)) continue;
            freq = concept.getFrequency();
            break;
        }
        return freq;
    }

    private static double normalizeStatsFromBuckets(com.ibm.bi.recommendationmodel.StatisticType statisticType, double value) {
        StatisticBucket statisticBucket = StatisticBucket.getStatisticBucketRange((com.ibm.bi.recommendationmodel.StatisticType)statisticType, (Double)value);
        if (statisticBucket == null) {
            return value;
        }
        double start = statisticBucket.getStart();
        double end = statisticBucket.getEnd();
        if (start != Double.NEGATIVE_INFINITY && end != Double.POSITIVE_INFINITY) {
            return (start + end) / 2.0;
        }
        if (start != Double.NEGATIVE_INFINITY) {
            return start;
        }
        if (end != Double.POSITIVE_INFINITY) {
            return end;
        }
        return value;
    }
}

