/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.visualization.recommender.internal.modeling;

import com.ibm.smarts.visualization.recommender.api.BasicType;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementType;
import com.ibm.smarts.visualization.recommender.internal.charts.ChartElementTypes;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BasicTypeAssocConcepts {
    private static BasicTypeAssocConcepts instance;
    private final Map<BasicType, Set<String>> basicTypeToConceptsMap = new EnumMap<BasicType, Set<String>>(BasicType.class);

    protected BasicTypeAssocConcepts() {
        for (ChartElementType t : ChartElementTypes.getTypes().values()) {
            String concept = t.getConcept();
            if (concept.equals("NONE")) continue;
            for (BasicType b : t.getTypes()) {
                Set concepts = this.basicTypeToConceptsMap.getOrDefault((Object)b, new HashSet());
                concepts.add(concept);
                this.basicTypeToConceptsMap.put(b, concepts);
            }
        }
    }

    public static synchronized BasicTypeAssocConcepts getInstance() {
        if (instance == null) {
            instance = new BasicTypeAssocConcepts();
        }
        return instance;
    }

    public Map<BasicType, Set<String>> getAssoc() {
        return this.basicTypeToConceptsMap;
    }
}

