/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.classifier;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.internal.ontology.api.Ontology;
import com.ibm.smarts.ontology.classifier.ClassificationStep;
import com.ibm.smarts.ontology.classifier.ConceptClassificationCommon;
import com.ibm.smarts.ontology.util.KnowledgeDiscoveryHelper;
import com.ibm.smarts.schema.ConceptInfo;
import java.util.List;
import java.util.Properties;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassificationStep<T>
extends ConceptClassificationCommon
implements ClassificationStep<T> {
    public static final IRI MEASURE_ROOT_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Measure");
    public static final IRI ENTITY_ROOT_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Entity");
    public static final IRI EMPTY_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#Empty");
    public static final IRI STRING_IRI = IRI.create((String)"http://www.ibm.com/ontologies/waca/domain/common#String");
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractClassificationStep.class);
    protected final RequestContext currentReqCtx;

    protected AbstractClassificationStep(RequestContext requestContext) {
        this.currentReqCtx = requestContext;
    }

    public static String getOntologyID(IRI iri) {
        return iri.getNamespace().substring(0, iri.getNamespace().length() - 1);
    }

    protected boolean isExecParallel() {
        Properties config = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getKnowledgeDiscoveryConfig();
        String execParallel = config.getProperty("smarts.ontology.classification.parallel");
        return Boolean.valueOf(execParallel);
    }

    protected boolean isVisibleClass(ConceptInfo concept, boolean bDefault) {
        return this.isVisibleClass(IRI.create((String)concept.getConceptID()), bDefault);
    }

    protected boolean isVisibleClass(IRI conceptID, boolean bDefault) {
        Ontology ontology = KnowledgeDiscoveryHelper.getOntologyResourceManager(this.currentReqCtx).getDomainOntologyManager().getOntology("http://www.ibm.com/ontologies/waca/domain/common");
        return this.isVisibleClass(conceptID, bDefault, (OWLOntology)ontology.getValue());
    }

    public static boolean inDetectedDomains(List<Ontology<OWLOntology>> ontologies, String conceptID) {
        String ontologyID = AbstractClassificationStep.getOntologyID(IRI.create((String)conceptID));
        return ontologies.stream().flatMap(onto -> ((OWLOntology)onto.getValue()).getImportsClosure().stream()).map(o -> ((IRI)o.getOntologyID().getOntologyIRI().get()).toString()).filter(oID -> !oID.equals("http://www.ibm.com/ontologies/waca/application")).anyMatch(oID -> oID.equals(ontologyID));
    }
}

