/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.reasoner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipNavigator
extends OWLClassExpressionVisitorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationshipNavigator.class);
    private final Set<OWLClass> visitedClasses = new HashSet<OWLClass>();
    private final Map<OWLClassExpression, Integer> classDistanceMap;
    private final OWLOntology ontology;
    private final IRI objectProperty;
    private final OWLReasoner reasoner;
    private int hop = 0;

    public RelationshipNavigator(@Nonnull OWLOntology onto, @Nonnull OWLReasoner areasoner, @Nonnull IRI property) {
        this.objectProperty = property;
        this.ontology = onto;
        this.reasoner = areasoner;
        this.classDistanceMap = new HashMap<OWLClassExpression, Integer>();
    }

    @Nonnull
    public Map<OWLClassExpression, Integer> getDistanceMap() {
        return this.classDistanceMap;
    }

    @Nonnull
    public Integer getDistance(OWLClass aClass) {
        return this.classDistanceMap.get(aClass);
    }

    public void visit(OWLClass desc) {
        if (!this.visitedClasses.contains(desc)) {
            this.visitedClasses.add(desc);
            Stream<OWLSubClassOfAxiom> subClassAxioms = this.ontology.getAxioms(OWLSubClassOfAxiom.class, OWLClass.class, (OWLObject)desc, Imports.INCLUDED, Navigation.IN_SUB_POSITION).stream().filter(a -> a.getSubClass().equals(desc));
            Map classExprs = subClassAxioms.map(OWLSubClassOfAxiom::getSuperClass).collect(Collectors.groupingBy(OWLClassExpression::isAnonymous, Collectors.toList()));
            LOGGER.info("Super classes of {}:", (Object)desc.getIRI().toString());
            classExprs.values().stream().map(s -> s.toString()).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            this.visit(classExprs.get(true));
            this.visit(classExprs.get(false));
        }
    }

    private void visit(List<OWLClassExpression> classExprs) {
        Optional.ofNullable(classExprs).ifPresent(c -> {
            ++this.hop;
            classExprs.stream().forEach(a -> a.accept((OWLClassExpressionVisitor)this));
            --this.hop;
        });
    }

    public void visit(OWLObjectSomeValuesFrom desc) {
        this.collect((OWLQuantifiedObjectRestriction)desc);
    }

    public void visit(OWLObjectAllValuesFrom desc) {
        this.collect((OWLQuantifiedObjectRestriction)desc);
    }

    private void collect(OWLQuantifiedObjectRestriction desc) {
        if (this.objectProperty.equals((Object)desc.getProperty().asOWLObjectProperty().getIRI())) {
            this.collect((OWLClassExpression)desc.getFiller());
            this.reasoner.getSubClasses((OWLClassExpression)desc.getFiller(), false).getFlattened().stream().filter(sub -> !sub.isBottomEntity()).filter(sub -> !this.isApplicationConcept((OWLClassExpression)sub)).forEach(sub -> this.classDistanceMap.compute((OWLClassExpression)sub, (k, v) -> v == null || Integer.compare(v, this.hop) > 0 ? this.hop : v));
        }
    }

    private void collect(OWLClassExpression filler) {
        if (!this.isApplicationConcept(filler)) {
            this.classDistanceMap.compute(filler, (k, v) -> v == null || Integer.compare(v, this.hop) > 0 ? this.hop : v);
        }
        filler.accept((OWLClassExpressionVisitor)this);
    }

    private boolean isApplicationConcept(OWLClassExpression owlClass) {
        return owlClass.asOWLClass().getIRI().getNamespace().startsWith("http://www.ibm.com/ontologies/waca/application");
    }

    public void dispose() {
        this.classDistanceMap.clear();
        this.visitedClasses.clear();
    }
}

