/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.ontology.util;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.smarts.internal.ontology.api.KnowledgeDiscoveryClient;
import com.ibm.smarts.ontology.classifier.ConceptClassificationCommon;
import com.ibm.smarts.ontology.reasoner.ReasonerWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptExtractor
extends ConceptClassificationCommon {
    private static final String COMMON_DOMAIN_ONTOLOGY_FILE = "/ontologies/domain/common_domain.owl";
    private static final String APPLICATION_ONTOLOGY_FILE = "/ontologies/application/application_ontology.owl";
    private static final String NAME = "name";
    private static final String ID = "IRI";
    private static final String ONTOLOGY_ID = "ontologyID";
    private static final String IS_VISIBLE = "isVisible";
    private static final String CHILDREN = "children";
    private static final String[] PROPERTIES = new String[]{"hasPositiveIndicator", "hasNeutralIndicator", "hasNegativeIndicator"};
    private static final Map<String, IRI> PROPERTIES_IRI = new HashMap<String, IRI>();
    private static final String CONCEPT_INFO_FILE = "../ontology-registry/src/main/resources/concepts.json";
    private static final Logger LOGGER;
    private static ConceptExtractor instance;

    public static ConceptExtractor getInstance() {
        return instance;
    }

    public static void main(String[] args) throws Exception {
        LOGGER.info("Extracting concepts from Ontology...");
        ConceptExtractor.getInstance().extractConcepts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractConcepts() throws Exception {
        JSONObject jRoot = new JSONObject();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology domainOntology = null;
        try {
            manager.loadOntologyFromOntologyDocument(KnowledgeDiscoveryClient.class.getResourceAsStream(APPLICATION_ONTOLOGY_FILE));
            domainOntology = manager.loadOntologyFromOntologyDocument(KnowledgeDiscoveryClient.class.getResourceAsStream(COMMON_DOMAIN_ONTOLOGY_FILE));
        }
        catch (OWLOntologyCreationException e) {
            LOGGER.error("Could not load ontology", (Throwable)e);
        }
        if (domainOntology != null) {
            ReasonerWrapper reasonerWrapper = new ReasonerWrapper(domainOntology);
            OWLReasoner reasoner = reasonerWrapper.getReasoner();
            Node topClass = reasoner.getTopClassNode();
            OWLClass root = (OWLClass)topClass.getRepresentativeElement();
            jRoot.put((Object)NAME, (Object)root.toString());
            jRoot.put((Object)ID, (Object)root.getIRI().toString());
            jRoot.put((Object)ONTOLOGY_ID, (Object)root.getIRI().getNamespace().substring(0, root.getIRI().getNamespace().length() - 1));
            jRoot.put((Object)IS_VISIBLE, (Object)this.isVisibleClass(root.getIRI(), false, domainOntology));
            this.handleSubClasses(jRoot, root, reasoner, domainOntology);
            String path = System.getProperty("BASE_DIR") == null ? "" : System.getProperty("BASE_DIR").concat(File.separator);
            path = path.concat(CONCEPT_INFO_FILE);
            try (OutputStreamWriter ow = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
                ow.write(jRoot.serialize());
                ow.flush();
                LOGGER.info("Extracted concepts into: " + path);
            }
            catch (IOException e) {
                LOGGER.error("Error in creating JSON", (Throwable)e);
            }
            finally {
                reasonerWrapper.close();
            }
        }
    }

    private void handleProperties(JSONObject obj, OWLClass c, OWLOntology domainOntology) {
        for (String property : PROPERTIES) {
            IRI iri = PROPERTIES_IRI.get(property);
            Set<OWLNamedIndividual> ind = this.getPropertyValues(c, domainOntology, iri);
            if (ind.isEmpty()) continue;
            String value = ind.iterator().next().getIRI().getShortForm();
            obj.put((Object)property, (Object)value);
        }
    }

    private void handleSubClasses(JSONObject jParent, OWLClass c, OWLReasoner reasoner, OWLOntology owlOntology) {
        this.handleProperties(jParent, c, owlOntology);
        Set classes = reasoner.getSubClasses((OWLClassExpression)c, true).getFlattened();
        if (!this.isEmpty(classes)) {
            JSONArray children = new JSONArray();
            jParent.put((Object)CHILDREN, (Object)children);
            for (OWLClass clazz : classes) {
                if (!c.isOWLThing() && !c.getIRI().getNamespace().equals(clazz.getIRI().getNamespace())) continue;
                JSONObject child = new JSONObject();
                String name = clazz.getIRI().getShortForm();
                child.put((Object)NAME, (Object)name);
                child.put((Object)ID, (Object)clazz.getIRI().toString());
                child.put((Object)ONTOLOGY_ID, (Object)clazz.getIRI().getNamespace().substring(0, clazz.getIRI().getNamespace().length() - 1));
                child.put((Object)IS_VISIBLE, (Object)this.isVisibleClass(clazz.getIRI(), true, owlOntology));
                children.add((Object)child);
                this.handleSubClasses(child, clazz, reasoner, owlOntology);
            }
        }
    }

    private boolean isEmpty(Set<OWLClass> classes) {
        OWLClass clazz;
        if (classes.isEmpty()) {
            return true;
        }
        return classes.size() == 1 && (clazz = classes.iterator().next()).isOWLNothing();
    }

    static {
        for (String property : PROPERTIES) {
            PROPERTIES_IRI.put(property, IRI.create((String)("http://www.ibm.com/ontologies/waca/domain/common#" + property)));
        }
        LOGGER = LoggerFactory.getLogger(ConceptExtractor.class);
        instance = new ConceptExtractor();
    }
}

