/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.nlp.api.grammar;

import com.ibm.smarts.nlp.api.grammar.SimplePartOfSpeech;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum PartOfSpeech {
    TOP("TOP", "Top of Parse", SimplePartOfSpeech.other),
    S("S", "Simple declarative clause", SimplePartOfSpeech.other),
    SBAR("", "Clause introduced by a subordinating conjunction", SimplePartOfSpeech.other),
    SBARQ("SBAR", "Direct question", SimplePartOfSpeech.other),
    SINV("SINV", "Inverted declarative sentence", SimplePartOfSpeech.other),
    SQ("SQ", "Inverted yes/no question", SimplePartOfSpeech.other),
    ADJP("ADJP", "Adjective Phrase", SimplePartOfSpeech.adjective),
    ADVP("ADVP", "Adverb Phrase", SimplePartOfSpeech.adverb),
    CONJP("CONJP", "Conjunction Phrase", SimplePartOfSpeech.other),
    FRAG("FRAG", "Fragment", SimplePartOfSpeech.other),
    INTJ("INTJ", "Interjection", SimplePartOfSpeech.other),
    LST("LST", "List marker", SimplePartOfSpeech.other),
    NAC("NAC", "Not a Constituent", SimplePartOfSpeech.other),
    NP("NP", "Noun Phrase ", SimplePartOfSpeech.noun),
    NX("NX", "Used within certain complex NPs to mark the head of the NP", SimplePartOfSpeech.other),
    PP("PP", "Prepositional Phrase", SimplePartOfSpeech.other),
    PRN("PRN", "Parenthetical ", SimplePartOfSpeech.other),
    PRT("PRT", "Particle ", SimplePartOfSpeech.other),
    QP("QP", "Quantifier Phrase ", SimplePartOfSpeech.other),
    RRC("RRC", "Reduced Relative Clause ", SimplePartOfSpeech.other),
    UCP("UCP", "Unlike Coordinated Phrase ", SimplePartOfSpeech.other),
    VP("VP", "Verb Phrase ", SimplePartOfSpeech.verb),
    WHADJP("WHADJP", "Wh-adjective Phrase", SimplePartOfSpeech.adjective),
    WHADVP("WHADVP", "Wh-adverb Phrase ", SimplePartOfSpeech.adverb),
    WHNP("WHNP", "Wh-noun Phrase", SimplePartOfSpeech.noun),
    WHPP("WHPP", "Wh-prepositional Phrase ", SimplePartOfSpeech.other),
    X("X", "Unknown, uncertain, or unbracketable", SimplePartOfSpeech.unknown),
    CC("CC", "Coordinating conjunction", SimplePartOfSpeech.other),
    CD("CD", "Cardinal number", SimplePartOfSpeech.noun),
    DT("DT", "Determiner", SimplePartOfSpeech.other),
    EX("DT", "Existential there", SimplePartOfSpeech.other),
    FW("FW", "Foreign word", SimplePartOfSpeech.unknown),
    IN("IN", "Preposition or subordinating conjunction", SimplePartOfSpeech.other),
    JJ("JJ", "Adjective", SimplePartOfSpeech.adjective),
    JJR("JJR", "Adjective, comparative", SimplePartOfSpeech.adjective),
    JJS("JJS", "Adjective, superlative", SimplePartOfSpeech.adjective),
    LS("LS", "List item marker", SimplePartOfSpeech.other),
    MD("MD", "Modal", SimplePartOfSpeech.other),
    NN("NN", "Noun, singular or mass", SimplePartOfSpeech.noun),
    NNS("NNS", "Noun, plural", SimplePartOfSpeech.noun),
    NNP("NNP", "Proper noun, singular", SimplePartOfSpeech.noun),
    NNPS("NNPS", "Proper noun, plural", SimplePartOfSpeech.noun),
    PDT("PDT", "Predeterminer", SimplePartOfSpeech.other),
    POS("POS", "Possessive ending", SimplePartOfSpeech.other),
    PRP("PRP", "Personal pronoun", SimplePartOfSpeech.other),
    PRP$("PRP$", "Possessive pronoun", SimplePartOfSpeech.noun),
    RB("RB", "Adverb", SimplePartOfSpeech.adverb),
    RBR("RBR", "Adverb, comparative", SimplePartOfSpeech.adverb),
    RBS("RBS", "Adverb, superlative", SimplePartOfSpeech.adverb),
    RP("RP", "Particle", SimplePartOfSpeech.other),
    SYM("SYM", "Symbol", SimplePartOfSpeech.other),
    TO("TO", "to", SimplePartOfSpeech.other),
    UH("UH", "Interjection", SimplePartOfSpeech.other),
    VB("VB", "Verb, base form", SimplePartOfSpeech.verb),
    VBD("VBD", "Verb, past tense", SimplePartOfSpeech.verb),
    VBG("VBG", "Verb, gerund or present participle", SimplePartOfSpeech.verb),
    VBN("VBN", "Verb, past participle", SimplePartOfSpeech.verb),
    VBP("VBP", "Verb, non-3rd person singular present", SimplePartOfSpeech.verb),
    VBZ("VBZ", "Verb, 3rd person singular present", SimplePartOfSpeech.verb),
    WDT("WDT", "Wh-determiner", SimplePartOfSpeech.other),
    WP("WP", "Wh-pronoun", SimplePartOfSpeech.noun),
    WP$("WP$", "Possessive wh-pronoun", SimplePartOfSpeech.noun),
    WRB("WRB", "Wh-adverb", SimplePartOfSpeech.adverb),
    PUNC(".", "punctuation, sentense closer", SimplePartOfSpeech.punctuation),
    COMMA(",", "punctuation, comma", SimplePartOfSpeech.punctuation),
    COLON(":", "punctuation, colon", SimplePartOfSpeech.punctuation),
    LPAREN("(", "punctuation, left paren", SimplePartOfSpeech.punctuation),
    RPAREN(")", "punctuation, tight paren", SimplePartOfSpeech.punctuation),
    OTHER("OTHER", "other", SimplePartOfSpeech.other);

    private final String description;
    private final SimplePartOfSpeech simplePartOfSpeech;
    private final String value;
    private static final Map<String, PartOfSpeech> nameToValueMap;

    private PartOfSpeech(String value, String description, SimplePartOfSpeech simplePartOfSpeech) {
        this.value = value;
        this.description = description;
        this.simplePartOfSpeech = simplePartOfSpeech;
    }

    public String descriptionString() {
        return this.value + "-" + this.description + " - " + this.name();
    }

    public SimplePartOfSpeech getSimplePartOfSpeech() {
        return this.simplePartOfSpeech;
    }

    public static PartOfSpeech getPOS(String value) {
        PartOfSpeech partOfSpeech = nameToValueMap.get(value);
        if (partOfSpeech == null) {
            partOfSpeech = OTHER;
        }
        return partOfSpeech;
    }

    static {
        nameToValueMap = new HashMap<String, PartOfSpeech>();
        for (PartOfSpeech pos : EnumSet.allOf(PartOfSpeech.class)) {
            nameToValueMap.put(pos.value, pos);
        }
    }
}

