/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common;

import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.store.SmartsFlowExecutorStore;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.pipeline.apis.FlowExecutor;
import com.ibm.smarts.schema.Clue;
import com.ibm.smarts.schema.DataClue;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.OntoVersion;
import com.ibm.smarts.store.api.IMultiRecordTrigger;
import com.ibm.smarts.store.api.IStoreFactory;
import com.ibm.smarts.store.api.ITypedStore;
import com.ibm.smarts.store.api.TypeNames;
import com.ibm.smarts.store.api.config.StoreConfig;
import com.ibm.smarts.store.api.multirec.MRTRecord;
import com.ibm.smarts.store.api.provider.IClueStore;
import com.ibm.smarts.store.api.provider.IDataClueStore;
import com.ibm.smarts.store.api.provider.IDataSourceStore;
import com.ibm.smarts.store.api.provider.IFeatureStore;
import com.ibm.smarts.store.api.provider.IFlowExecutorStore;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.provider.IMRTStore;
import com.ibm.smarts.store.api.provider.IObjectStore;
import com.ibm.smarts.store.api.provider.IOntoVersionStore;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.provider.IStoreProvider;
import com.ibm.smarts.store.api.provider.IUserActionStore;
import com.ibm.smarts.store.inmem.InMemStoreFactory;
import com.ibm.smarts.store.inmem.InMemTypedStore;
import com.ibm.smarts.store.provider.SmartsClueStore;
import com.ibm.smarts.store.provider.SmartsDataClueStore;
import com.ibm.smarts.store.provider.SmartsFeatureStore;
import com.ibm.smarts.store.provider.SmartsInMemUserActionStore;
import com.ibm.smarts.store.provider.SmartsMRTStore;
import com.ibm.smarts.store.provider.SmartsModulePersistenceStore;
import com.ibm.smarts.store.provider.SmartsModuleStore;
import com.ibm.smarts.store.provider.SmartsObjectStore;
import com.ibm.smarts.store.provider.SmartsOntoVersionStore;
import com.ibm.smarts.store.provider.SmartsPersistenceProvider;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.NotImplementedException;

public class SmartsStoreProvider
implements IStoreProvider {
    private final IStoreFactory storeFactory;
    private final Properties config;
    private static SmartsInMemUserActionStore inMemStore = null;
    private final IInMemoryModuleStore smartsModuleStore = new SmartsModuleStore();
    private final SmartsPersistenceProvider persistenceProvider = new SmartsPersistenceProvider((IInMemoryModuleStore)new SmartsModulePersistenceStore());
    private final SmartsFlowExecutorStore flowExecutorStore = new SmartsFlowExecutorStore((ITypedStore<FlowExecutor>)new InMemTypedStore(FlowExecutor.class, true));

    public SmartsStoreProvider(IStoreFactory storeFactory, Properties config) {
        this.storeFactory = storeFactory;
        this.config = config;
    }

    public IInMemoryModuleStore getModuleStore(RequestContext requestContext) {
        return this.smartsModuleStore;
    }

    public IInMemoryModuleStore getModuleStore(StoreConfig config, RequestContext requestContext) {
        return this.smartsModuleStore;
    }

    public IClueStore getClueStore(RequestContext requestContext) {
        return new SmartsClueStore(this.storeFactory.getStore(TypeNames.CLUE, requestContext, Clue.class));
    }

    public IClueStore getClueStore(Locale localeOverride, RequestContext requestContext) {
        return new SmartsClueStore(this.storeFactory.getStore(TypeNames.CLUE, localeOverride, requestContext, Clue.class));
    }

    public IDataClueStore getDataClueStore(RequestContext requestContext) {
        return new SmartsDataClueStore(this.storeFactory.getStore(TypeNames.DATA_CLUE, requestContext, DataClue.class));
    }

    public IDataClueStore getDataClueStore(Locale localeOverride, RequestContext requestContext) {
        return new SmartsDataClueStore(this.storeFactory.getStore(TypeNames.DATA_CLUE, localeOverride, requestContext, DataClue.class));
    }

    public IOntoVersionStore getOntoVersionStore(RequestContext requestContext) {
        return new SmartsOntoVersionStore(this.storeFactory.getStore(TypeNames.ONTO_VERSION, requestContext, OntoVersion.class));
    }

    public IOntoVersionStore getOntoVersionStore(Locale localeOverride, RequestContext requestContext) {
        return new SmartsOntoVersionStore(this.storeFactory.getStore(TypeNames.ONTO_VERSION, localeOverride, requestContext, OntoVersion.class));
    }

    public IMRTStore getMRTStore() {
        return new SmartsMRTStore(this.storeFactory.getStore(TypeNames.MRT, SmartsModuleMessageGroup.MESSAGE_GROUP_CONTEXT, MRTRecord.class));
    }

    public IFeatureStore getFeatureStore(RequestContext requestContext) {
        return new SmartsFeatureStore(this.storeFactory.getStore(TypeNames.FEATURE, requestContext, Feature.class));
    }

    public <T> IMultiRecordTrigger<T> getMultiRecordTrigger(String type, RequestContext requestContext, Class<T> klass) {
        return this.storeFactory.getMultiRecordTrigger(type, requestContext, klass);
    }

    public IStoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[SmartsStoreProvider @" + Integer.toHexString(this.hashCode()));
        sb.append(" config=" + this.config);
        sb.append(" storeFactory=" + this.storeFactory);
        sb.append("]");
        String ret = sb.toString();
        return ret;
    }

    public IPersistenceProvider getPersistenceProvider(StoreConfig config, RequestContext requestContext) {
        return this.persistenceProvider;
    }

    public IPersistenceProvider getPersistenceProvider(StoreConfig config) {
        return this.persistenceProvider;
    }

    public synchronized IUserActionStore getUserActionStore(StoreConfig config, RequestContext requestContext) {
        if (inMemStore == null) {
            InMemStoreFactory inMemStoreFactory = new InMemStoreFactory();
            ITypedStore actionStore = inMemStoreFactory.getStore(config, requestContext, ArrayList.class, true);
            ITypedStore actionStore2 = inMemStoreFactory.getStore(config, requestContext, ArrayList.class, true);
            ITypedStore actionStore3 = inMemStoreFactory.getStore(config, requestContext, ArrayList.class, true);
            inMemStore = new SmartsInMemUserActionStore(actionStore, actionStore2, actionStore3);
            inMemStore.setConsumerKeyStorageFactory((IStoreFactory)inMemStoreFactory, config, requestContext);
        }
        return inMemStore;
    }

    public IDataSourceStore getDataSourceStore(StoreConfig config, RequestContext requestContext) {
        throw new NotImplementedException("getDataSourceStore() is not implemented.");
    }

    public IFlowExecutorStore getFlowExecutorStore() {
        return this.flowExecutorStore;
    }

    public <T> IObjectStore<T> getObjectStore() {
        SmartsObjectStore smartsObjectStore = new SmartsObjectStore();
        return smartsObjectStore;
    }
}

