/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.modifiers;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.common.modifiers.BaseFilter;
import com.ibm.smarts.common.modifiers.FilterLogicalOperator;
import com.ibm.smarts.common.modifiers.FilterType;

public class CompositeFilter
extends BaseFilter {
    private BaseFilter filter1 = null;
    private BaseFilter filter2 = null;
    private FilterLogicalOperator operator = FilterLogicalOperator.AND;

    public CompositeFilter(String columnId, String filterId, String label, BaseFilter f1, BaseFilter f2, FilterLogicalOperator op) {
        super(columnId, filterId, label);
        this.filter1 = f1;
        this.filter2 = f2;
        this.operator = op;
    }

    public CompositeFilter(CompositeFilter filter) {
        super(filter.getColumnId(), filter.getFilterId(), filter.getLabel());
        this.filter1 = filter.getFilter1();
        this.filter2 = filter.getFilter2();
        this.operator = filter.getOperator();
    }

    public static CompositeFilter negate(CompositeFilter source) {
        CompositeFilter filter = new CompositeFilter(source);
        filter.getFilter1();
        filter.setFilter1(BaseFilter.negate(filter.getFilter1()));
        filter.getFilter2();
        filter.setFilter2(BaseFilter.negate(filter.getFilter2()));
        FilterLogicalOperator operator = filter.getOperator().equals((Object)FilterLogicalOperator.AND) ? FilterLogicalOperator.OR : FilterLogicalOperator.AND;
        filter.setOperator(operator);
        return filter;
    }

    @Override
    public FilterType getType() {
        return FilterType.COMPOSITE;
    }

    public BaseFilter getFilter1() {
        return this.filter1;
    }

    public void setFilter1(BaseFilter f) {
        this.filter1 = f;
    }

    public BaseFilter getFilter2() {
        return this.filter2;
    }

    public void setFilter2(BaseFilter f) {
        this.filter2 = f;
    }

    public FilterLogicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(FilterLogicalOperator co) {
        this.operator = co;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        super.toJSONObject(obj);
        obj.put((Object)"filter1", (Object)this.getFilter1().toJSONObject());
        obj.put((Object)"filter2", (Object)this.getFilter2().toJSONObject());
        obj.put((Object)"operator", (Object)this.getOperator().name());
        return obj;
    }
}

