/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mp.metrics;

import com.ibm.smarts.common.mp.metrics.MpMetricsAbstract;
import com.ibm.smarts.common.mp.metrics.MpMetricsDefault;
import com.ibm.smarts.common.mp.metrics.MpMetricsImpl;
import com.ibm.smarts.common.mp.metrics.MpMetricsInterface;
import com.ibm.smarts.common.mp.metrics.MpMetricsRegistry;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

public class MpMetricsBuilder {
    public String counterName = null;
    public String counterDesc = null;
    public String timerName = null;
    public String timerDesc = null;

    public MpMetricsBuilder() {
    }

    public MpMetricsBuilder(String cName, String cDesc, String tName, String tDesc) {
        this.counterName = cName;
        this.counterDesc = cDesc;
        this.timerName = tName;
        this.timerDesc = tDesc;
    }

    public MpMetricsBuilder SetCounterName(String cName) {
        this.counterName = cName;
        return this;
    }

    public MpMetricsBuilder SetCounterDesc(String cDesc) {
        this.counterDesc = cDesc;
        return this;
    }

    public MpMetricsBuilder SetTimerName(String tName) {
        this.timerName = tName;
        return this;
    }

    public MpMetricsBuilder SetTimerDesc(String tDesc) {
        this.timerDesc = tDesc;
        return this;
    }

    public MpMetricsInterface build() {
        MpMetricsAbstract mpMetric = MpMetricsDefault.getInstance();
        try {
            MetricRegistry smartsRegistry = MpMetricsRegistry.getInstance().GetSmartsRegistry();
            if (smartsRegistry != null) {
                Counter counter = null;
                Timer timer = null;
                Class.forName("com.ibm.smarts.common.mp.metrics.MpMetricsImpl");
                if (this.counterName != null) {
                    Metadata myCounterMetaData = new Metadata(this.counterName, null, this.counterDesc, MetricType.COUNTER, "none");
                    counter = smartsRegistry.counter(myCounterMetaData);
                }
                if (this.timerName != null) {
                    Metadata myTimerMetaData = new Metadata(this.timerName, null, this.timerDesc, MetricType.TIMER, "microseconds");
                    timer = smartsRegistry.timer(myTimerMetaData);
                }
                if (counter != null || timer != null) {
                    mpMetric = new MpMetricsImpl(counter, timer);
                }
            }
            return mpMetric;
        }
        catch (ClassNotFoundException e) {
            return mpMetric;
        }
    }
}

