/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq;

import com.ibm.smarts.common.mq.SmartsModuleMessageGroup;
import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.message.SmartsModuleStartMessage;
import com.ibm.smarts.core.api.Handlers;
import com.ibm.smarts.core.mq.MessageProducerProvider;
import com.ibm.smarts.core.mq.TypedMessageConsumer;
import com.ibm.smarts.core.mq.TypedMessageProducer;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.util.UniqueNameGenerator;
import com.ibm.smarts.schema.SmartsModule;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModuleStartConsumer
implements TypedMessageConsumer<SmartsModuleStartMessage>,
Handlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModuleStartConsumer.class);

    public void receiveMessage(RequestContext rc, MessageProducerProvider producerProvider, SmartsModuleStartMessage item) {
        this.handle(rc, context -> {
            SmartsModule smartsModule = item.smartsModule;
            LOGGER.info("Smarts Module start: " + smartsModule.getId());
            String smartsModuleId = smartsModule.getId();
            List datasets = smartsModule.getDatasets();
            datasets.forEach(d -> {
                String qualifiedId = UniqueNameGenerator.appendUniqueName((String)UniqueNameGenerator.createSingleNamePart((String)smartsModuleId), (String)d.getId());
                this.post((RequestContext)context, producerProvider, new SmartsModuleMessage(smartsModuleId, d.getId(), null));
            });
            return null;
        });
    }

    private void post(RequestContext context, MessageProducerProvider producerProvider, SmartsModuleMessage message) {
        TypedMessageProducer producer = producerProvider.producer(SmartsModuleMessage.class, context);
        producer.takeMessage(SmartsModuleMessageGroup.DEFAULT_COLUMN_NAME_QUEUE, (Object)message);
    }

    public Class<SmartsModuleStartMessage> getItemClass() {
        return SmartsModuleStartMessage.class;
    }
}

