/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.mq.message;

import com.ibm.smarts.common.mq.message.SmartsModuleMessage;
import com.ibm.smarts.common.mq.message.SmartsModuleStatus;
import com.ibm.smarts.core.util.ToString;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SmartsModuleMultiMessage
extends SmartsModuleMessage {
    private final List<Class<? extends SmartsModuleMessage>> expectedMessageTypes;
    private List<SmartsModuleMessage> messages;

    public SmartsModuleMultiMessage(List<Class<? extends SmartsModuleMessage>> expectedMessageTypes, String resourceURI) {
        super(null, null, resourceURI);
        this.expectedMessageTypes = expectedMessageTypes;
    }

    @Override
    public String toString() {
        return ToString.with((Object)super.toString()).field("expectedMessageTypes", this.expectedMessageTypes).field("messages", this.messages).get();
    }

    @Override
    public String getSmartsModuleId() {
        if (this.isComplete() && !this.messages.isEmpty()) {
            return this.messages.get(0).getSmartsModuleId();
        }
        return null;
    }

    @Override
    public String getDatasetId() {
        if (this.isComplete() && !this.messages.isEmpty()) {
            return this.messages.get(0).getDatasetId();
        }
        return null;
    }

    public boolean isComplete() {
        return this.messages != null && this.messages.size() == this.getExpectedMessageCount();
    }

    public int getExpectedMessageCount() {
        return this.expectedMessageTypes.size();
    }

    public boolean setMessages(List<SmartsModuleMessage> proposed) {
        if (this.messages != null) {
            this.messages.clear();
        }
        if (proposed.size() == this.getExpectedMessageCount()) {
            if (this.messages == null) {
                this.messages = new ArrayList<SmartsModuleMessage>();
            }
            proposed.forEach(m -> {
                for (Class<? extends SmartsModuleMessage> clazz : this.expectedMessageTypes) {
                    if (!clazz.isAssignableFrom(m.getClass())) continue;
                    this.messages.add((SmartsModuleMessage)m);
                    break;
                }
            });
        }
        return this.isComplete();
    }

    public <T extends SmartsModuleMessage> T getMessage(Class<T> clazz) {
        return (T)((SmartsModuleMessage)this.messages.stream().filter(m -> m.getClass().equals(clazz)).findFirst().orElse(null));
    }

    @Override
    public SmartsModuleStatus getStatus() {
        List errorMessages = this.messages.stream().filter(m -> m.getStatus() != null && !m.getStatus().isSuccess()).collect(Collectors.toList());
        Set errorsSet = errorMessages.stream().flatMap(m -> {
            if (m.getStatus().getErrors() != null) {
                return m.getStatus().getErrors().stream();
            }
            return null;
        }).collect(Collectors.toSet());
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(errorsSet);
        ArrayList<String> warnings = new ArrayList<String>();
        Set warningSet = this.messages.stream().filter(m -> m.getStatus() != null).map(SmartsModuleMessage::getStatus).map(SmartsModuleStatus::getWarnings).flatMap(l -> l == null ? null : l.stream()).collect(Collectors.toSet());
        warnings.addAll(warningSet);
        ArrayList<String> dataSourceExceptions = new ArrayList<String>();
        Set dataSourceExceptionSet = this.messages.stream().filter(m -> m.getStatus() != null).map(SmartsModuleMessage::getStatus).map(SmartsModuleStatus::getDataSourceException).flatMap(l -> l == null ? null : l.stream()).collect(Collectors.toSet());
        dataSourceExceptions.addAll(dataSourceExceptionSet);
        return new SmartsModuleStatus(errorMessages.isEmpty(), errors, warnings, dataSourceExceptions);
    }
}

