/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.provider.rest;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.smarts.common.pipeline.SampleQueryContext;
import com.ibm.smarts.common.provider.DataQueryContext;
import com.ibm.smarts.common.provider.DistinctValueData;
import com.ibm.smarts.common.provider.IDataProvider;
import com.ibm.smarts.common.provider.IDataProviderModuleInfo;
import com.ibm.smarts.common.provider.IDistinctValueData;
import com.ibm.smarts.common.provider.ISampleData;
import com.ibm.smarts.common.provider.SampleData;
import com.ibm.smarts.common.provider.rest.RestDataProviderInfo;
import com.ibm.smarts.common.provider.rest.RestDataProviderModuleInfo;
import com.ibm.smarts.common.rest.DatasetRestClient;
import com.ibm.smarts.common.rest.ModuleRestClient;
import com.ibm.smarts.common.rest.SmartsClientManager;
import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.common.util.UniqueNameParser;
import com.ibm.smarts.model.dataset.DatasetDataResult;
import com.ibm.smarts.model.qs.ResultSet;
import com.ibm.smarts.schema.DatasetInfo;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestDataProvider
implements IDataProvider {
    public static final String REST_DATA_PROVIDER_INFO_KEY = "com.ibm.smarts.restDataProviderInfo";
    private static final Logger LOGGER = LoggerFactory.getLogger(RestDataProvider.class);

    @Override
    public Module getModule(RequestContext requestContext, String moduleId) {
        try (Helper h = new Helper(requestContext);){
            Module module = h.getModule(moduleId);
            return module;
        }
    }

    @Override
    public ISampleData getSampleData(RequestContext requestContext, String qualifiedQuerySubjectId) {
        try (Helper h = new Helper(requestContext);){
            ISampleData iSampleData = h.getSampleData(qualifiedQuerySubjectId);
            return iSampleData;
        }
    }

    @Override
    public IDataProviderModuleInfo getDataProviderModuleInfo(RequestContext requestContext, String moduleId) {
        try (Helper h = new Helper(requestContext);){
            IDataProviderModuleInfo iDataProviderModuleInfo = h.getDataProviderModuleInfo(moduleId);
            return iDataProviderModuleInfo;
        }
    }

    @Override
    public ISampleData getSampleData(RequestContext requestContext, SampleQueryContext sampleQueryContext, DatasetInfo dataset) {
        throw new NotImplementedException("getSampleData() is not implemented");
    }

    @Override
    public ResultSet getData(RequestContext requestContext, DataQueryContext queryContext) {
        throw new NotImplementedException("getData() is not implemented");
    }

    private static final class Helper
    implements Closeable {
        private final RequestContext rc;
        private SmartsClientManager clientManager;

        public Helper(RequestContext rc) {
            this.rc = rc;
        }

        @Override
        public void close() {
            if (this.clientManager != null) {
                try {
                    this.clientManager.close();
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e, "failed to close SmartsClientManager", new Object[0]);
                }
            }
        }

        private SmartsClientManager getClientManager() {
            if (this.clientManager == null) {
                this.clientManager = SmartsClientManager.getClientManager(this.rc, SmartsClientManager.class);
            }
            return this.clientManager;
        }

        private RestDataProviderModuleInfo extractRestInfo(String moduleId) {
            RestDataProviderModuleInfo moduleInfo = null;
            RestDataProviderInfo restInfo = this.extractRestDataProviderInfo();
            if (restInfo != null) {
                moduleInfo = restInfo.getModuleInfo(moduleId);
            }
            if (moduleInfo == null) {
                LOGGER.info("no data provider info found in request context for " + moduleId);
            }
            return moduleInfo;
        }

        private RestDataProviderInfo extractRestDataProviderInfo() {
            RestDataProviderInfo restInfo = null;
            Object restInfoObject = this.rc.getRequestAttribute(RestDataProvider.REST_DATA_PROVIDER_INFO_KEY);
            if (restInfoObject instanceof RestDataProviderInfo) {
                restInfo = (RestDataProviderInfo)restInfoObject;
            }
            if (restInfo == null) {
                LOGGER.info("no rest data provider info found in request context");
            }
            return restInfo;
        }

        public Module getModule(String moduleId) {
            RestDataProviderModuleInfo moduleInfo = this.extractRestInfo(moduleId);
            if (moduleInfo == null) {
                return null;
            }
            String uri = moduleInfo.moduleUri;
            if (uri == null || uri.isEmpty()) {
                LOGGER.info("no module URI found in request context for " + moduleId);
                return null;
            }
            ModuleRestClient client = this.getClientManager().getModuleClient(moduleInfo.baseUri);
            return client.getModule(uri);
        }

        public IDataProviderModuleInfo getDataProviderModuleInfo(String moduleId) {
            return this.extractRestInfo(moduleId);
        }

        public ISampleData getSampleData(String qualifiedQuerySubjectId) {
            String[] idParts = this.parseQualifiedName(qualifiedQuerySubjectId, 2);
            String moduleId = idParts[0];
            RestDataProviderModuleInfo moduleInfo = this.extractRestInfo(moduleId);
            if (moduleInfo == null) {
                return null;
            }
            String querySubjectId = idParts[1];
            String uri = this.getSampleURI(moduleInfo, querySubjectId);
            if (uri == null) {
                LOGGER.info("no sample URI found in request context for " + qualifiedQuerySubjectId);
                return null;
            }
            DatasetRestClient client = this.getClientManager().getDatasetsClient(moduleInfo.baseUri);
            DatasetDataResult dataResult = client.getDatasetData(uri);
            if (dataResult != null) {
                return SampleData.from(querySubjectId, dataResult);
            }
            LOGGER.info("no samples found for " + qualifiedQuerySubjectId);
            return null;
        }

        public IDistinctValueData getIndexData(String qualifiedQueryItemId, int size) {
            String[] idParts = this.parseQualifiedName(qualifiedQueryItemId, 3);
            String moduleId = idParts[0];
            String dataSourceId = idParts[1];
            String queryItemId = dataSourceId + "." + idParts[2];
            RestDataProviderModuleInfo moduleInfo = this.extractRestInfo(moduleId);
            if (moduleInfo == null) {
                return null;
            }
            String uri = this.getIndexURI(moduleInfo, queryItemId);
            if (uri == null) {
                LOGGER.info("no da URI found in request context for " + queryItemId);
                return null;
            }
            DatasetRestClient client = this.getClientManager().getDatasetsClient(moduleInfo.baseUri);
            DatasetDataResult dataResult = client.getDatasetData(uri);
            if (dataResult != null) {
                return DistinctValueData.from(dataResult);
            }
            return null;
        }

        private String getSampleURI(RestDataProviderModuleInfo moduleInfo, String querySubjectId) {
            String uri = null;
            Map<String, String> sampleUris = moduleInfo.sampleUris;
            if (sampleUris != null) {
                uri = sampleUris.get(querySubjectId);
            }
            return uri != null && !uri.isEmpty() ? uri : null;
        }

        private String getIndexURI(RestDataProviderModuleInfo moduleInfo, String queryItemId) {
            String uri = null;
            Map<String, String> indexUris = moduleInfo.indexDataUris;
            if (indexUris != null) {
                uri = indexUris.get(queryItemId);
            }
            return uri != null && !uri.isEmpty() ? uri : null;
        }

        private String[] parseQualifiedName(String qualifiedName, int count) {
            String[] idParts = UniqueNameParser.parse((String)qualifiedName, (int)count);
            if (idParts.length < count) {
                throw new InternalException("qualified name must have " + count + " parts: " + qualifiedName, new Object[0]);
            }
            return idParts;
        }
    }
}

