/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.common.rest;

import com.ibm.json.java.JSONObject;
import com.ibm.smarts.core.exceptions.json.JsonDeserializeException;
import com.ibm.smarts.core.rest.client.RestClient;
import com.ibm.smarts.core.util.JsonParserHelper;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.dataset.DatasetDataResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.core.MediaType;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class DatasetRestClient
extends RestClient {
    private static final String DATASETS = "/bi/v1/datasets/";
    private static final String PREDICT_EXPLORE = "/predictexplore";
    private static final String PREDICT_DRIVERS = "/fastpatternkeydrivers";
    private static final String DATA = "/data";

    public DatasetRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri) {
        this(rccf, requestContext, uri, null);
    }

    public DatasetRestClient(RestClient.RestCallContextFactory rccf, RequestContext requestContext, String uri, Map<String, List<String>> headers) {
        super(rccf, requestContext, uri, headers);
    }

    public CompletableFuture<DatasetDataResult> getDatasetDataAsync(String requestUri) {
        String request = requestUri;
        if (request.startsWith(this.uri)) {
            request = request.substring(this.uri.length());
        }
        return this.getAsync(request).thenApply(json -> (DatasetDataResult)JsonParserHelper.fromJson((String)json, DatasetDataResult.class));
    }

    public DatasetDataResult getDatasetData(String uri) {
        CompletableFuture<DatasetDataResult> future = this.getDatasetDataAsync(uri);
        return (DatasetDataResult)this.get(future);
    }

    public CompletableFuture<String> getKeyDriversAsync(String moduleId, String sourceType, String keyDriversSpec) {
        String path = DATASETS + moduleId + PREDICT_DRIVERS;
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("type", new String[]{sourceType});
        MultipartEntityBuilder meb = MultipartEntityBuilder.create();
        meb.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        meb.addPart("keyDriverSpec", (ContentBody)new StringBody(keyDriversSpec, ContentType.MULTIPART_FORM_DATA));
        HttpEntity entity = meb.build();
        return this.postAsync(path, entity, queryParams, MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    public CompletableFuture<String> getDataAsync(String moduleId, String sourceType, String querySpec) {
        String path = DATASETS + moduleId + DATA;
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("type", new String[]{sourceType});
        queryParams.add("refreshmd", new String[]{"false"});
        MultipartEntityBuilder meb = MultipartEntityBuilder.create();
        meb.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        meb.addPart("querySpec", (ContentBody)new StringBody(querySpec, ContentType.MULTIPART_FORM_DATA));
        HttpEntity entity = meb.build();
        return this.postAsync(path, entity, queryParams, MediaType.MULTIPART_FORM_DATA_TYPE);
    }

    public String getKeyDrivers(String moduleId, String sourceType, String keyDriverSpec) {
        CompletableFuture<String> future = this.getKeyDriversAsync(moduleId, sourceType, keyDriverSpec);
        return (String)this.get(future);
    }

    public String getData(String moduleId, String sourceType, String querySpec) {
        CompletableFuture<String> future = this.getDataAsync(moduleId, sourceType, querySpec);
        return (String)this.get(future);
    }

    public CompletableFuture<JSONObject> getRelationshipStrengthAsync(String moduleId, String sourceType, String exploreSpec) {
        String path = DATASETS + moduleId + PREDICT_EXPLORE;
        RestClient.QueryParams queryParams = new RestClient.QueryParams();
        queryParams.add("type", new String[]{sourceType});
        MultipartEntityBuilder meb = MultipartEntityBuilder.create();
        meb.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        meb.addPart("exploreSpec", (ContentBody)new StringBody(exploreSpec, ContentType.MULTIPART_FORM_DATA));
        HttpEntity entity = meb.build();
        return this.postAsync(path, entity, queryParams, MediaType.MULTIPART_FORM_DATA_TYPE).thenApply(DatasetRestClient::unmarshalFromJSON);
    }

    public JSONObject getRelationshipStrength(String moduleId, String sourceType, String exploreSpec) {
        CompletableFuture<JSONObject> future = this.getRelationshipStrengthAsync(moduleId, sourceType, exploreSpec);
        return (JSONObject)this.get(future);
    }

    private static JSONObject unmarshalFromJSON(String json) {
        try {
            return JSONObject.parse((String)json);
        }
        catch (IOException e) {
            throw new JsonDeserializeException((Throwable)e, "unmarshal from json failed", new Object[]{json});
        }
    }
}

