/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.config.testing;

import com.ibm.bi.config.external.CheckedFileOutputStream;
import com.ibm.bi.config.external.FixedDelayPollingSchedulerOnYourExecutor;
import com.ibm.bi.config.external.PropertiesReader;
import com.ibm.bi.config.setup.ArchaiusSetup;
import com.ibm.bi.config.testing.FakeZookeeperData;
import com.ibm.bi.config.testing.TestConfigurationSourceFactory;
import com.ibm.bi.config.util.ConfigurationUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationTestCase {
    private static String os = null;
    protected URL cogLocaleUrl;
    private File tempDir;
    protected ArchaiusSetup archaiusSetup;
    protected File dispatcherProperties;
    private ScheduledExecutorService executorService;

    public void setUp() throws ConfigurationException {
        this.setupConfiguration();
    }

    public void cleanup() throws IOException {
        FileUtils.deleteDirectory((File)this.tempDir);
        this.executorService.shutdown();
    }

    public void setupConfiguration() throws ConfigurationException {
        URL url = ConfigurationTestCase.class.getClassLoader().getResource("installdir");
        String path = url.getPath();
        if ("jar".equals(url.getProtocol())) {
            System.err.println("warning: config-core test data is loaded from a jar.  Metadata properties are not available.");
        }
        this.setupConfiguration(new File(path));
    }

    public void setupConfiguration(File installDirForMetadata) throws ConfigurationException {
        System.setProperty("no.zookeeper.configuration", "true");
        ConfigurationTestCase.setupCmpLst();
        this.tempDir = com.google.common.io.Files.createTempDir();
        this.executorService = FixedDelayPollingSchedulerOnYourExecutor.makePollingExecutorService("com.ibm.bi.config.Poller");
        TestConfigurationSourceFactory configurationSourceFactory = new TestConfigurationSourceFactory(this.tempDir, this.executorService);
        URL url = ConfigurationTestCase.class.getClassLoader().getResource("installdir/cogstartup-plain.xml");
        configurationSourceFactory.setCogstartupUrl(url);
        this.cogLocaleUrl = ConfigurationTestCase.class.getClassLoader().getResource("installdir/coglocale.xml");
        configurationSourceFactory.setCogLocaleUrl(this.cogLocaleUrl);
        configurationSourceFactory.setPropertiesURL(this.setupDispatcherProperties());
        configurationSourceFactory.setMetadataPath(installDirForMetadata.getPath());
        System.setProperty("install.dir", ConfigurationTestCase.class.getClassLoader().getResource("installdir").getPath());
        PropertiesReader propertiesReader = configurationSourceFactory.getPropertiesReader();
        this.updateProperties(FakeZookeeperData.getTestProperties(), "global", propertiesReader);
        this.updateProperties(FakeZookeeperData.getTestProperties(), "nodeID1", propertiesReader);
        this.updateProperties(FakeZookeeperData.getTestProperties(), "nodeID2", propertiesReader);
        this.archaiusSetup = new ArchaiusSetup(configurationSourceFactory, propertiesReader, this.executorService);
        this.archaiusSetup.initialize();
    }

    private URL setupDispatcherProperties() {
        this.dispatcherProperties = new File(this.tempDir, "dispatcher.properties");
        this.writeDispatcherProperties("installdir/dispatcher.properties");
        try {
            return this.dispatcherProperties.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("unexpected exception getting URL of file", e);
        }
    }

    protected void writeDispatcherProperties(String resourceName) {
        try {
            File tmp = new File(this.tempDir, "dispatcher.properties.tmp");
            String content = IOUtils.toString((InputStream)ConfigurationTestCase.class.getClassLoader().getResourceAsStream(resourceName));
            FileUtils.write((File)tmp, (CharSequence)content);
            Files.move(tmp.toPath(), this.dispatcherProperties.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception updating dispatcher.properties", e);
        }
    }

    private void updateProperties(PropertiesConfiguration settings, String scope, PropertiesReader propertiesReader) throws ConfigurationException {
        File propFile = propertiesReader.getFileForPath(scope, 0);
        propFile.getParentFile().mkdirs();
        try (CheckedFileOutputStream os = new CheckedFileOutputStream(propFile);){
            settings.save((OutputStream)os);
        }
        catch (IOException iox) {
            throw new ConfigurationException((Throwable)iox);
        }
    }

    public static void setCogRootForWin() {
        ConfigurationUtils.resetInstallRootForTest();
        URL resource = ConfigurationTestCase.class.getClassLoader().getResource("installdir/cogroot.link");
        System.out.println("setCogRootForWin() setting URL to \"installdir/cogroot.link\" to " + resource == null ? "null" : resource.toString());
        ConfigurationUtils.setCogRootLinkUrlForTest(resource);
    }

    public static void setCogRootForUnix() {
        ConfigurationUtils.resetInstallRootForTest();
        ConfigurationUtils.setCogRootLinkFileNameForTest("installdir/cogroot_unix.link");
    }

    public static void setupCmpLst() {
        Properties cmpLstProps = new Properties();
        cmpLstProps.setProperty("CM_version", "11.0");
        ConfigurationUtils.setCmpLstPropertiesForTest(cmpLstProps);
    }

    public static String getPlatform() {
        if (os == null) {
            os = System.getProperty("os.name");
            os = os != null ? (os.toLowerCase().indexOf("win") != -1 ? "win" : "unix") : "win";
        }
        return os;
    }

    public static boolean isWindows() {
        return "win".equalsIgnoreCase(ConfigurationTestCase.getPlatform());
    }

    public static boolean isUnix() {
        return !ConfigurationTestCase.isWindows();
    }

    public static Document xmlStringToDocument(String xmlString) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(xmlString));
        return builder.parse(is);
    }

    public static NodeList getNodeList(String inputStr, String nodeName) throws IOException, ParserConfigurationException, SAXException {
        Document doc = ConfigurationTestCase.xmlStringToDocument(inputStr);
        Element rootElem = doc.getDocumentElement();
        if (rootElem != null) {
            return rootElem.getElementsByTagName(nodeName);
        }
        return null;
    }
}

