/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.generated.metadata;

import com.ibm.bi.platform.moser.common.generated.metadata.FeatureObject;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectFactory;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.nativeImpl.NativeImpl;
import com.ibm.bi.platform.moser.common.notify.INotificationListener;
import com.ibm.bi.platform.moser.common.notify.INotifier;
import com.ibm.bi.platform.moser.common.notify.Notification;
import com.ibm.bi.platform.moser.common.validation.Diagnostic;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public class MoserObject
implements Cloneable,
INotifier {
    @XmlTransient
    protected MoserObject _parent;
    @XmlTransient
    protected ArrayList<INotificationListener> _listeners;
    @XmlTransient
    protected ArrayList<INotificationListener> _recursiveListeners;
    @XmlTransient
    private List<Diagnostic> _diagnostics;

    @Override
    @XmlTransient
    public MoserObject getParent() {
        return this._parent;
    }

    public void setParent(MoserObject parent) {
        this._parent = parent;
    }

    @Override
    public void addListener(INotificationListener listener, boolean recursive) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
        if (recursive) {
            if (this._recursiveListeners == null) {
                this._recursiveListeners = new ArrayList();
            }
            this._recursiveListeners.add(listener);
        }
    }

    @Override
    public void removeListener(INotificationListener listener) {
        int i;
        if (this._listeners != null) {
            for (i = 0; i < this._listeners.size(); ++i) {
                if (!this._listeners.get(i).equals(listener)) continue;
                this._listeners.remove(i);
                break;
            }
        }
        if (this._recursiveListeners != null) {
            for (i = 0; i < this._recursiveListeners.size(); ++i) {
                if (!this._recursiveListeners.get(i).equals(listener)) continue;
                this._recursiveListeners.remove(i);
                break;
            }
        }
    }

    @Override
    public void notify(Notification notification, boolean isChildNotification) {
        if (isChildNotification && this._recursiveListeners != null) {
            for (INotificationListener listener : this._recursiveListeners) {
                listener.notifyChanged(notification);
            }
        } else if (this._listeners != null) {
            for (INotificationListener listener : this._listeners) {
                listener.notifyChanged(notification);
            }
        }
        if (this._parent != null) {
            this._parent.notify(notification, true);
        }
    }

    protected void setAndNotify(int featureID, Object oldValue, Object newValue, boolean isMoserObject, boolean isObjectType) {
        if (isMoserObject && newValue != null) {
            ((MoserObject)newValue)._parent = this;
        }
        if (isObjectType) {
            MoserObject.updatePropertyOverride((ObjectType)this, this, featureID, false);
        }
        Notification notification = new Notification(3, this, featureID, oldValue, newValue, -1);
        this.notify(notification, false);
    }

    protected void removeAtAndNotify(List list, int position, int featureID, boolean isMoserObject) {
        Object removed = list.get(position);
        list.remove(position);
        if (isMoserObject && removed != null) {
            ((MoserObject)removed)._parent = null;
        }
        Notification notification = new Notification(2, this, featureID, removed, null, position);
        this.notify(notification, false);
    }

    protected void addAtAndNotify(List list, int position, Object value, int featureID, boolean isMoserObject, boolean isObjectType) {
        list.add(position, value);
        if (isMoserObject && value != null) {
            ((MoserObject)value)._parent = this;
            if (isObjectType) {
                MoserObject.updatePropertyOverride((ObjectType)value, this, featureID, true);
            }
        }
        Notification notification = new Notification(1, this, featureID, null, value, position);
        this.notify(notification, false);
    }

    public String getObjectType() {
        return "MoserObject";
    }

    public List<FeatureObject> getFeatureList(ObjectFactory factory) {
        return new ArrayList<FeatureObject>();
    }

    @Override
    public void set(int featureID, Object value) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    protected void setList(int featureID, Object value) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    public Object get(int featureID) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    public Object basicGet(int featureID) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    @Override
    public void addAt(int featureID, int position, Object value) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    @Override
    public void add(int featureID, Object value) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    @Override
    public void removeAt(int featureID, int position) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    @Override
    public void remove(int featureID, Object item) {
        switch (featureID) {
            default: 
        }
        throw new RuntimeException("The feature " + featureID + " is not valid.");
    }

    public void addDiagnostic(Diagnostic diagnostic) {
        if (this._diagnostics == null) {
            this._diagnostics = new ArrayList<Diagnostic>();
        }
        this._diagnostics.add(diagnostic);
    }

    public List<Diagnostic> getDiagnostics() {
        if (this._diagnostics == null) {
            return new ArrayList<Diagnostic>();
        }
        return this._diagnostics;
    }

    public void clearDiagnostics() {
        this._diagnostics = null;
    }

    public FeatureObject createFeature(boolean isList, boolean isEnum, boolean isModelledObjList, int featureID, String featureName, Class<?> type) {
        FeatureObject feature = new FeatureObject();
        feature.setType(type);
        feature.setFeatureID(featureID);
        feature.setIsList(isList);
        feature.setIsEnum(isEnum);
        feature.setIsModelledObjList(isModelledObjList);
        feature.setFeatureName(featureName);
        return feature;
    }

    public int getFeatureID(String featureName) {
        List<FeatureObject> featureList = this.getFeatureList(null);
        int featureID = 0;
        for (int i = 0; i < featureList.size(); ++i) {
            FeatureObject feature = featureList.get(i);
            if (!feature.getFeatureName().equals(featureName)) continue;
            featureID = feature.getFeatureID();
            break;
        }
        return featureID;
    }

    public String getFeatureName(int featureID) {
        List<FeatureObject> featureList = this.getFeatureList(null);
        String featureName = null;
        for (int i = 0; i < featureList.size(); ++i) {
            FeatureObject feature = featureList.get(i);
            if (feature.getFeatureID() != featureID) continue;
            featureName = feature.getFeatureName();
            break;
        }
        return featureName;
    }

    public void removeDiagnostics() {
        this.clearDiagnostics();
        List<FeatureObject> featureList = this.getFeatureList(null);
        for (int i = 0; i < featureList.size(); ++i) {
            MoserObject child;
            FeatureObject feature = featureList.get(i);
            Object obj = this.get(feature.getFeatureID());
            if (obj == null) continue;
            if (feature.getIsList()) {
                List fieldList = (List)obj;
                for (int j = 0; j < fieldList.size(); ++j) {
                    Object field = fieldList.get(j);
                    if (field == null || !(field instanceof MoserObject)) continue;
                    MoserObject child2 = (MoserObject)field;
                    child2.removeDiagnostics();
                }
                continue;
            }
            if (!(obj instanceof MoserObject) || (child = (MoserObject)this.get(feature.getFeatureID())) == null) continue;
            child.removeDiagnostics();
        }
    }

    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        List<FeatureObject> featureList = this.getFeatureList(null);
        for (int i = 0; i < featureList.size(); ++i) {
            FeatureObject feature = featureList.get(i);
            String featureName = feature.getFeatureName();
            if ("clazz".equals(featureName)) {
                featureName = "class";
            } else if ("dbFunction".equals(featureName)) {
                featureName = "function";
            }
            Object obj = this.basicGet(feature.getFeatureID());
            if (obj == null) continue;
            if (feature.getIsList()) {
                List fieldList = (List)obj;
                if (fieldList.isEmpty()) continue;
                JSONArray refArray = new JSONArray();
                result.put((Object)featureName, (Object)refArray);
                for (int j = 0; j < fieldList.size(); ++j) {
                    Object field = fieldList.get(j);
                    if (field == null) continue;
                    if (field instanceof MoserObject) {
                        MoserObject child = (MoserObject)field;
                        refArray.add(j, (Object)child.toJSON());
                        continue;
                    }
                    refArray.add(j, field);
                }
                continue;
            }
            if (feature.getIsEnum()) {
                Class<?> clazz = feature.getType();
                Object value = NativeImpl.invokeMethodByReflection(clazz, "value", obj, null, null);
                result.put((Object)featureName, value);
                continue;
            }
            if (obj instanceof MoserObject) {
                MoserObject child = (MoserObject)obj;
                if (child == null) continue;
                result.put((Object)featureName, (Object)child.toJSON());
                continue;
            }
            if (obj == null) continue;
            result.put((Object)featureName, obj);
        }
        return result;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public static void fromJSONHelper(MoserObject result, List<FeatureObject> featureList, JSONObject json, ObjectFactory factory) {
        Module module = MoserObject.getModuleObject(result);
        boolean oldOverrideModeValue = false;
        if (module != null) {
            oldOverrideModeValue = module.isOverrideMode();
            module.setOverrideMode(false);
        }
        for (int i = 0; i < featureList.size(); ++i) {
            Object value;
            FeatureObject feature = featureList.get(i);
            String featureName = feature.getFeatureName();
            if ("clazz".equals(featureName)) {
                featureName = "class";
            } else if ("dbFunction".equals(featureName)) {
                featureName = "function";
            }
            if (feature.getIsList()) {
                JSONArray jsonArray = (JSONArray)json.get((Object)featureName);
                if (jsonArray == null) continue;
                if (jsonArray.size() == 0) {
                    result.get(feature.getFeatureID());
                }
                for (int j = 0; j < jsonArray.size(); ++j) {
                    Object obj = jsonArray.get(j);
                    if (obj == null) continue;
                    if (!(obj instanceof MoserObject || obj instanceof String || obj instanceof Boolean || obj instanceof Long)) {
                        Class<?> clazz = feature.getType();
                        Object value2 = NativeImpl.invokeMethodByReflection(clazz, "fromJSON", null, obj, factory);
                        result.addAt(feature.getFeatureID(), j, value2);
                        continue;
                    }
                    result.addAt(feature.getFeatureID(), j, obj);
                }
                continue;
            }
            if (feature.getIsEnum()) {
                String enumValue = (String)json.get((Object)featureName);
                if (enumValue == null) continue;
                Class<?> clazz = feature.getType();
                value = NativeImpl.invokeMethodByReflection(clazz, "fromValue", null, enumValue, null);
                result.set(feature.getFeatureID(), value);
                continue;
            }
            Object obj = json.get((Object)featureName);
            if (obj == null) continue;
            if (!(obj instanceof MoserObject || obj instanceof String || obj instanceof Boolean || obj instanceof Long)) {
                Class<?> clazz = feature.getType();
                value = NativeImpl.invokeMethodByReflection(clazz, "fromJSON", null, obj, factory);
                result.set(feature.getFeatureID(), value);
                continue;
            }
            result.set(feature.getFeatureID(), obj);
        }
        if (module != null) {
            module.setOverrideMode(oldOverrideModeValue);
        }
    }

    public static Module getModuleObject(MoserObject moserObj) {
        if (moserObj == null) {
            return null;
        }
        if (moserObj.getObjectType().equals("Module")) {
            return (Module)moserObj;
        }
        MoserObject parent = moserObj.getParent();
        if (parent != null) {
            return MoserObject.getModuleObject(parent);
        }
        return null;
    }

    public static void updatePropertyOverride(ObjectType objType, MoserObject moserObj, int featureID, boolean isAdd) {
        if (featureID == 166) {
            return;
        }
        Module module = MoserObject.getModuleObject(objType);
        if (module == null) {
            module = MoserObject.getModuleObject(moserObj);
        }
        if (module != null && module.isOverrideMode()) {
            String featureName = moserObj.getFeatureName(featureID);
            if (!isAdd) {
                objType.addPropertyOverride(featureName);
            } else {
                objType.addPropertyOverride("NEW");
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        MoserObject cloned = (MoserObject)super.clone();
        cloned._recursiveListeners = null;
        cloned._parent = null;
        cloned._listeners = null;
        cloned._diagnostics = null;
        if ("Module".equals(this.getObjectType())) {
            ((Module)cloned).setOverrideMode(false);
        }
        List<FeatureObject> featureList = this.getFeatureList(null);
        for (int i = 0; i < featureList.size(); ++i) {
            Object clonedObj;
            FeatureObject feature = featureList.get(i);
            String featureName = feature.getFeatureName();
            if ("clazz".equals(featureName)) {
                featureName = "class";
            } else if ("dbFunction".equals(featureName)) {
                featureName = "function";
            }
            Object obj = this.basicGet(feature.getFeatureID());
            if (obj == null) continue;
            if (feature.getIsList()) {
                clonedObj = ((ArrayList)obj).clone();
                cloned.setList(feature.getFeatureID(), clonedObj);
                if (!feature.getIsModelledObjList()) continue;
                ArrayList fieldList = (ArrayList)obj;
                ArrayList cloneObjList = (ArrayList)clonedObj;
                cloneObjList.clear();
                for (int j = 0; j < fieldList.size(); ++j) {
                    MoserObject field = (MoserObject)fieldList.get(j);
                    if (field == null) continue;
                    MoserObject clonedField = (MoserObject)field.clone();
                    clonedField._parent = cloned;
                    cloneObjList.add(clonedField);
                }
                continue;
            }
            if (!(obj instanceof MoserObject)) continue;
            clonedObj = ((MoserObject)obj).clone();
            cloned.set(feature.getFeatureID(), clonedObj);
        }
        if ("Module".equals(this.getObjectType())) {
            ((Module)cloned).setOverrideMode(((Module)this).isOverrideMode());
        }
        return cloned;
    }
}

