/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.generated.metadata.HighLevelDataType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.RegularAggregateType;
import com.ibm.bi.platform.moser.common.generated.metadata.UsageType;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MoserCommonUtils {
    private static final String ID_KEY = "id";
    private static final String MY_FOLDERS = ".my_folders";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String XQEDT_TIME_TZ = "TIME WITH TIME ZONE";
    public static final String XQEDT_TIMESTAMP_TZ = "TIMESTAMP WITH TIME ZONE";
    public static final String XQEDT_STRING = "STRING";
    public static final String DT_NVARCHAR_MAX = "NVARCHAR(MAX)";
    public static final String DT_TIME_TZ = "TIME_TZ";
    public static final String DT_TIMESTAMP_TZ = "TIMESTAMP_TZ";
    public static final String DT_BIT = "BIT";
    public static final String DT_BOOLEAN = "BOOLEAN";
    public static final String DT_CHAR = "CHAR";
    public static final String DT_LONGNVARCHAR = "LONGNVARCHAR";
    public static final String DT_LONGVARCHAR = "LONGVARCHAR";
    public static final String DT_NCHAR = "NCHAR";
    public static final String DT_NVARCHAR = "NVARCHAR";
    public static final String DT_VARCHAR = "VARCHAR";
    public static final String DT_DATALINK = "DATALINK";
    public static final String DT_JSON = "JSON";
    public static final String DT_SQLXML = "SQLXML";
    public static final String DT_CLOB = "CLOB";
    public static final String DT_NCLOB = "NCLOB";
    public static final String DT_BIGINT = "BIGINT";
    public static final String DT_DOUBLE = "DOUBLE";
    public static final String DT_FLOAT = "FLOAT";
    public static final String DT_INTEGER = "INTEGER";
    public static final String DT_REAL = "REAL";
    public static final String DT_SMALLINT = "SMALLINT";
    public static final String DT_TINYINT = "TINYINT";
    public static final String DT_DECIMAL = "DECIMAL";
    public static final String DT_LONG = "LONG";
    public static final String DT_NUMERIC = "NUMERIC";
    public static final String DT_DATE = "DATE";
    public static final String DT_TIME = "TIME";
    public static final String DT_TIMESTAMP = "TIMESTAMP";
    public static final String DT_INTERVAL_YEAR = "INTERVAL_YEAR";
    public static final String DT_INTERVAL_YEAR_TO_MONTH = "INTERVAL_YEAR_TO_MONTH";
    public static final String DT_INTERVAL_MONTH = "INTERVAL_MONTH";
    public static final String DT_INTERVAL_DAY = "INTERVAL_DAY";
    public static final String DT_INTERVAL_DAY_TO_HOUR = "INTERVAL_DAY_TO_HOUR";
    public static final String DT_INTERVAL_DAY_TO_MINUTE = "INTERVAL_DAY_TO_MINUTE";
    public static final String DT_INTERVAL_DAY_TO_SECOND = "INTERVAL_DAY_TO_SECOND";
    public static final String DT_INTERVAL_HOUR = "INTERVAL_HOUR";
    public static final String DT_INTERVAL_HOUR_TO_MINUTE = "INTERVAL_HOUR_TO_MINUTE";
    public static final String DT_INTERVAL_HOUR_TO_SECOND = "INTERVAL_HOUR_TO_SECOND";
    public static final String DT_INTERVAL_MINUTE = "INTERVAL_MINUTE";
    public static final String DT_INTERVAL_MINUTE_TO_SECOND = "INTERVAL_MINUTE_TO_SECOND";
    public static final String DT_INTERVAL_SECOND = "INTERVAL_SECOND";
    public static final String DT_ARRAY = "ARRAY";
    public static final String DT_ROWSET = "ROWSET";
    public static final String DT_LONGVARBINARY = "LONGVARBINARY";
    public static final String DT_BINARY = "BINARY";
    public static final String DT_VARBINARY = "VARBINARY";
    public static final String DT_BLOB = "BLOB";
    public static final String DT_REF = "REF";
    public static final String DT_DISTINCT = "DISTINCT";
    public static final String DT_JAVA_OBJECT = "JAVA_OBJECT";
    public static final String DT_OTHER = "OTHER";
    public static final String DT_STRUCT = "STRUCT";
    public static final String DT_NULL = "NULL";
    public static final String DT_ROWID = "ROWID";
    public static final String DT_VARIANT = "VARIANT";
    public static final String DT_PERIOD_DATE = "PERIOD_DATE";
    public static final String DT_PERIOD_TIME = "PERIOD_TIME";
    public static final String DT_PERIOD_TIME_TZ = "PERIOD_TIME_TZ";
    public static final String DT_PERIOD_TIMESTAMP = "PERIOD_TIMESTAMP";
    public static final String DT_PERIOD_TIMESTAMP_TZ = "PERIOD_TIMESTAMP_TZ";
    public static final String DT_UNKNOWN = "UNKNOWN";
    private static MoserCommonUtils instance = new MoserCommonUtils();
    private HashMap<String, HighLevelDataType> dataTypNameToDTC = new HashMap();

    private MoserCommonUtils() {
        this.dataTypNameToDTC.put(DT_BIT, HighLevelDataType.BOOLEAN);
        this.dataTypNameToDTC.put(DT_BOOLEAN, HighLevelDataType.BOOLEAN);
        this.dataTypNameToDTC.put(DT_CHAR, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_LONGNVARCHAR, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_LONGVARCHAR, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_NCHAR, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_NVARCHAR, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_VARCHAR, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_DATALINK, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_JSON, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_SQLXML, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_CLOB, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_NCLOB, HighLevelDataType.STRING);
        this.dataTypNameToDTC.put(DT_BIGINT, HighLevelDataType.INTEGER);
        this.dataTypNameToDTC.put(DT_DOUBLE, HighLevelDataType.DECIMAL);
        this.dataTypNameToDTC.put(DT_FLOAT, HighLevelDataType.DECIMAL);
        this.dataTypNameToDTC.put(DT_INTEGER, HighLevelDataType.INTEGER);
        this.dataTypNameToDTC.put(DT_REAL, HighLevelDataType.DECIMAL);
        this.dataTypNameToDTC.put(DT_SMALLINT, HighLevelDataType.INTEGER);
        this.dataTypNameToDTC.put(DT_TINYINT, HighLevelDataType.INTEGER);
        this.dataTypNameToDTC.put(DT_DECIMAL, HighLevelDataType.DECIMAL);
        this.dataTypNameToDTC.put(DT_LONG, HighLevelDataType.INTEGER);
        this.dataTypNameToDTC.put(DT_NUMERIC, HighLevelDataType.DECIMAL);
        this.dataTypNameToDTC.put(DT_DATE, HighLevelDataType.DATE);
        this.dataTypNameToDTC.put(DT_TIME, HighLevelDataType.TIME);
        this.dataTypNameToDTC.put(DT_TIME_TZ, HighLevelDataType.TIME);
        this.dataTypNameToDTC.put(DT_TIMESTAMP, HighLevelDataType.DATETIME);
        this.dataTypNameToDTC.put(DT_TIMESTAMP_TZ, HighLevelDataType.DATETIME);
        this.dataTypNameToDTC.put(DT_INTERVAL_YEAR, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_YEAR_TO_MONTH, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_MONTH, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_DAY, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_DAY_TO_HOUR, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_DAY_TO_MINUTE, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_DAY_TO_SECOND, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_HOUR, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_HOUR_TO_MINUTE, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_HOUR_TO_SECOND, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_MINUTE, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_MINUTE_TO_SECOND, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_INTERVAL_SECOND, HighLevelDataType.INTERVAL);
        this.dataTypNameToDTC.put(DT_ARRAY, HighLevelDataType.ARRAY);
        this.dataTypNameToDTC.put(DT_ROWSET, HighLevelDataType.ARRAY);
        this.dataTypNameToDTC.put(DT_LONGVARBINARY, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_BINARY, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_VARBINARY, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_BLOB, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_REF, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_DISTINCT, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_JAVA_OBJECT, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_OTHER, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_STRUCT, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_NULL, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_ROWID, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_VARIANT, HighLevelDataType.OBJECT);
        this.dataTypNameToDTC.put(DT_PERIOD_DATE, HighLevelDataType.PERIOD);
        this.dataTypNameToDTC.put(DT_PERIOD_TIME, HighLevelDataType.PERIOD);
        this.dataTypNameToDTC.put(DT_PERIOD_TIME_TZ, HighLevelDataType.PERIOD);
        this.dataTypNameToDTC.put(DT_PERIOD_TIMESTAMP, HighLevelDataType.PERIOD);
        this.dataTypNameToDTC.put(DT_PERIOD_TIMESTAMP_TZ, HighLevelDataType.PERIOD);
    }

    public static boolean isFirstClassObject(String type) {
        return MoserCommonUtils.isFolderObject(type) || "package".equals(type) || "dataSource".equals(type) || "dataSourceConnection".equals(type) || MoserCommonUtils.isContentObject(type);
    }

    public static boolean isAccountObject(String type) {
        return "account".equals(type);
    }

    public static boolean isFolderObject(String type) {
        return "folder".equals(type);
    }

    public static boolean isDirectoryObject(String type) {
        return "directory".equals(type);
    }

    public static boolean isContentObject(String type) {
        return "content".equals(type);
    }

    public static HighLevelDataType generateHighlevelDatatype(String dataType) {
        if (dataType == null) {
            return HighLevelDataType.INTEGER;
        }
        String jmdDataType = MoserCommonUtils.getJMDDataTypeName(dataType);
        HighLevelDataType hld = MoserCommonUtils.instance.dataTypNameToDTC.get(jmdDataType);
        if (HighLevelDataType.DECIMAL.equals((Object)hld) && (DT_NUMERIC.equals(jmdDataType) || DT_DECIMAL.equals(jmdDataType))) {
            Integer scale = MoserCommonUtils.getScale(dataType);
            return scale != null && scale <= 0 ? HighLevelDataType.INTEGER : hld;
        }
        return hld;
    }

    public static Integer getPrecision(String dataType) {
        String dt = dataType.trim();
        int index1 = dt.indexOf("(");
        int index2 = dt.indexOf(")");
        if (index1 == -1 || index2 == -1) {
            return null;
        }
        int index = (dt = dt.substring(index1 + 1, index2).replaceAll(SPACE, "")).indexOf(",");
        return index == -1 ? new Integer(dt) : new Integer(dt.substring(0, index));
    }

    public static Integer getScale(String dataType) {
        String dt = dataType.trim();
        int index1 = dt.indexOf("(");
        int index2 = dt.indexOf(")");
        if (index1 == -1 || index2 == -1) {
            String jmdDataType = MoserCommonUtils.getJMDDataTypeName(dataType);
            HighLevelDataType hld = MoserCommonUtils.instance.dataTypNameToDTC.get(jmdDataType);
            return HighLevelDataType.INTEGER.equals((Object)hld) ? new Integer(0) : null;
        }
        int index = (dt = dt.substring(index1 + 1, index2).replaceAll(SPACE, "")).indexOf(",");
        return index == -1 ? new Integer(0) : new Integer(dt.substring(index + 1));
    }

    public static String getJMDDataTypeName(String dataType) {
        String dt = dataType.trim();
        int index = dt.indexOf("(");
        if (index != -1) {
            dt = dt.substring(0, index);
        }
        if (XQEDT_TIME_TZ.toLowerCase().equals(dt.toLowerCase())) {
            return DT_TIME_TZ;
        }
        if (XQEDT_TIMESTAMP_TZ.toLowerCase().equals(dt.toLowerCase())) {
            return DT_TIMESTAMP_TZ;
        }
        if (XQEDT_STRING.toLowerCase().equals(dt.toLowerCase())) {
            return DT_NVARCHAR_MAX;
        }
        return dt.toUpperCase().replaceAll(SPACE, UNDERSCORE);
    }

    public static UsageType getUsageFromHighLevelDataType(HighLevelDataType highDT) {
        if (HighLevelDataType.DATE.equals((Object)highDT) || HighLevelDataType.TIME.equals((Object)highDT) || HighLevelDataType.DATETIME.equals((Object)highDT)) {
            return UsageType.IDENTIFIER;
        }
        if (HighLevelDataType.INTEGER.equals((Object)highDT) || HighLevelDataType.DECIMAL.equals((Object)highDT) || HighLevelDataType.INTERVAL.equals((Object)highDT)) {
            return UsageType.FACT;
        }
        if (HighLevelDataType.STRING.equals((Object)highDT)) {
            return UsageType.ATTRIBUTE;
        }
        return UsageType.AUTOMATIC;
    }

    public static RegularAggregateType getRegularAggregateTypeFromUsageAndHighLevelDataType(UsageType usage, HighLevelDataType highDT) {
        if (UsageType.AUTOMATIC.equals((Object)usage)) {
            return RegularAggregateType.NONE;
        }
        if (UsageType.IDENTIFIER.equals((Object)usage) || UsageType.ATTRIBUTE.equals((Object)usage)) {
            return RegularAggregateType.COUNT_DISTINCT;
        }
        return MoserCommonUtils.getRegularAggregateTypeFromHighLevelDataType(highDT);
    }

    public static RegularAggregateType getRegularAggregateTypeFromHighLevelDataType(HighLevelDataType highDT) {
        if (HighLevelDataType.DATE.equals((Object)highDT) || HighLevelDataType.TIME.equals((Object)highDT) || HighLevelDataType.DATETIME.equals((Object)highDT)) {
            return RegularAggregateType.MAXIMUM;
        }
        if (HighLevelDataType.INTEGER.equals((Object)highDT) || HighLevelDataType.DECIMAL.equals((Object)highDT) || HighLevelDataType.INTERVAL.equals((Object)highDT)) {
            return RegularAggregateType.TOTAL;
        }
        return RegularAggregateType.COUNT;
    }

    public static boolean areCompatibleDataTypes(String lDataType, String rDataType) {
        if (lDataType == null || rDataType == null) {
            return false;
        }
        String leftDTName = MoserCommonUtils.getJMDDataTypeName(lDataType);
        String rightDTName = MoserCommonUtils.getJMDDataTypeName(rDataType);
        HighLevelDataType leftHighDT = MoserCommonUtils.instance.dataTypNameToDTC.get(leftDTName);
        HighLevelDataType rightHighDT = MoserCommonUtils.instance.dataTypNameToDTC.get(rightDTName);
        if (leftHighDT == null || rightHighDT == null) {
            return false;
        }
        if (leftDTName.equals(DT_NULL) || rightDTName.equals(DT_NULL)) {
            return true;
        }
        if (leftDTName.equals(rightDTName)) {
            return true;
        }
        if (leftDTName.equals(DT_UNKNOWN) || rightDTName.equals(DT_UNKNOWN)) {
            return false;
        }
        if (leftHighDT == HighLevelDataType.STRING && rightHighDT == HighLevelDataType.STRING) {
            return true;
        }
        if (!(leftHighDT != HighLevelDataType.INTEGER && leftHighDT != HighLevelDataType.DECIMAL || rightHighDT != HighLevelDataType.INTEGER && rightHighDT != HighLevelDataType.DECIMAL)) {
            return true;
        }
        if (leftHighDT == HighLevelDataType.BOOLEAN && rightHighDT == HighLevelDataType.BOOLEAN) {
            return true;
        }
        if (leftHighDT == HighLevelDataType.DATE && rightHighDT == HighLevelDataType.DATE) {
            return true;
        }
        if (leftHighDT == HighLevelDataType.TIME && rightHighDT == HighLevelDataType.TIME) {
            return true;
        }
        if (leftHighDT == HighLevelDataType.DATETIME && rightHighDT == HighLevelDataType.DATETIME) {
            return true;
        }
        if (leftHighDT == HighLevelDataType.DATE) {
            return rightHighDT == HighLevelDataType.DATETIME;
        }
        if (leftHighDT == HighLevelDataType.DATETIME) {
            return rightHighDT == HighLevelDataType.DATE;
        }
        if (leftHighDT == HighLevelDataType.INTERVAL && rightHighDT == HighLevelDataType.INTERVAL) {
            return !(!leftDTName.equals(DT_INTERVAL_YEAR) && !leftDTName.equals(DT_INTERVAL_YEAR_TO_MONTH) && !leftDTName.equals(DT_INTERVAL_MONTH) || !rightDTName.equals(DT_INTERVAL_YEAR) && !rightDTName.equals(DT_INTERVAL_YEAR_TO_MONTH) && !rightDTName.equals(DT_INTERVAL_MONTH));
        }
        return false;
    }

    public static List<Module.UseSpec.Ancestors> createAncestors(JSONArray ancestorsResp, String myFoldersLabel, String teamContentLabel) {
        ArrayList<Module.UseSpec.Ancestors> ancestors = new ArrayList<Module.UseSpec.Ancestors>();
        if (ancestorsResp == null || ancestorsResp.isEmpty()) {
            return ancestors;
        }
        String parentType = null;
        for (Object o : ancestorsResp) {
            JSONObject a = (JSONObject)o;
            String type = (String)a.get((Object)"type");
            if (!MoserCommonUtils.isFirstClassObject(type) && !MoserCommonUtils.isMyFolderGlass(type, parentType, (String)a.get((Object)ID_KEY))) {
                parentType = type;
                continue;
            }
            String defaultName = MoserCommonUtils.getDefaultName(type, a, parentType, myFoldersLabel, teamContentLabel);
            if (defaultName == null) {
                parentType = type;
                continue;
            }
            Module.UseSpec.Ancestors ancestor = new Module.UseSpec.Ancestors();
            ancestor.setDefaultName(defaultName);
            if (type != null && MoserCommonUtils.isMyFolder(type, parentType)) {
                ancestor.setStoreID(MY_FOLDERS);
            } else if (type != null && MoserCommonUtils.isTeamContent(type, parentType)) {
                ancestor.setStoreID(".public_folders");
            } else {
                String id = (String)a.get((Object)ID_KEY);
                if (id != null) {
                    ancestor.setStoreID(id);
                }
            }
            parentType = type;
            ancestors.add(ancestor);
        }
        return ancestors;
    }

    private static boolean isMyFolderGlass(String type, String parentType, String id) {
        return parentType == null && MoserCommonUtils.isDirectoryObject(type) && MY_FOLDERS.equals(id);
    }

    private static String getDefaultName(String type, JSONObject a, String parentType, String myFoldersLabel, String teamContentLabel) {
        String defaultName = (String)a.get((Object)"name");
        if (defaultName == null) {
            defaultName = (String)a.get((Object)"defaultName");
        }
        if (myFoldersLabel != null && MoserCommonUtils.isMyFolder(type, parentType)) {
            return myFoldersLabel;
        }
        if (teamContentLabel != null && MoserCommonUtils.isTeamContent(type, parentType)) {
            return teamContentLabel;
        }
        return defaultName;
    }

    private static boolean isMyFolder(String type, String parentType) {
        return parentType == null && MoserCommonUtils.isDirectoryObject(type) || MoserCommonUtils.isAccountObject(parentType) && MoserCommonUtils.isFolderObject(type);
    }

    private static boolean isTeamContent(String type, String parentType) {
        return MoserCommonUtils.isContentObject(type) && parentType == null;
    }
}

