/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.platform.moser.common.utils;

import com.ibm.bi.platform.moser.common.generated.metadata.BaseObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.BaseQueryItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.Calculation;
import com.ibm.bi.platform.moser.common.generated.metadata.CardinalityType;
import com.ibm.bi.platform.moser.common.generated.metadata.DefLinkType;
import com.ibm.bi.platform.moser.common.generated.metadata.DrillGroup;
import com.ibm.bi.platform.moser.common.generated.metadata.FacetType;
import com.ibm.bi.platform.moser.common.generated.metadata.Filter;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.FolderType;
import com.ibm.bi.platform.moser.common.generated.metadata.InstanceType;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemHierarchy;
import com.ibm.bi.platform.moser.common.generated.metadata.ItemType;
import com.ibm.bi.platform.moser.common.generated.metadata.LocalRefType;
import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.MoserObject;
import com.ibm.bi.platform.moser.common.generated.metadata.NamedSet;
import com.ibm.bi.platform.moser.common.generated.metadata.ObjectType;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.bi.platform.moser.common.generated.metadata.Relationship;
import com.ibm.bi.platform.moser.common.generated.metadata.SortListType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ReferenceResolver {
    public static final String ID_SEPARATOR = ".";
    public static final String EMBEDDED_MODULE_ALIAS = "ES";
    public static final String MODULE_ALIAS_PREFIX = "M";
    public static final String RESOLVED_BASE_MODULE_ALIAS_PREFIX = "__Base";
    public static final String IMPORT_ALL = "*";
    public static final String PROP_NEW = "NEW";
    public static final String PROP_LABEL = "label";
    public static final String PROP_COMMENT = "comment";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_LOCALREF = "localRef";
    public static final String PROP_PROPERTY_DOT = "property.";
    public static final String PROP_SCREENTIP = "screenTip";
    public static final String PROP_ISHIDDEN = "hidden";
    public static final String PROP_FORMAT = "format";
    public static final String PROP_TAXONOMY = "taxonomy";
    public static final String PROP_USAGE = "usage";
    public static final String PROP_REGULARAGGREGATE = "regularAggregate";
    public static final String PROP_FACETDEFINITION = "facetDefinition";
    public static final String PROP_IMPORTED = "Imported";

    private ReferenceResolver() {
    }

    public static void resolve(Module module) {
        if (module == null) {
            return;
        }
        boolean overrideMode = module.isOverrideMode();
        module.setOverrideMode(false);
        ReferenceResolver.resolveItemHierarchyLocalRef(module);
        ReferenceResolver.resolveMDTVReferences(module);
        ReferenceResolver.resolveSegmentReferences(module);
        ReferenceResolver.resolveRelationships(module);
        ReferenceResolver.resolveFacetDef(module);
        module.setOverrideMode(overrideMode);
    }

    private static void resolveFacetDef(Module module) {
        if (module == null) {
            return;
        }
        List<QuerySubject> querySubjects = module.basicGetQuerySubject();
        if (querySubjects != null) {
            for (QuerySubject querySubject : querySubjects) {
                ReferenceResolver.resolveFacetDefFromQuerySubject(querySubject);
            }
        }
    }

    private static void resolveFacetDefFromQuerySubject(QuerySubject qs) {
        if (qs == null) {
            return;
        }
        List<ItemType> queryItemTypeList = qs.basicGetItem();
        if (queryItemTypeList != null) {
            for (ItemType queryItemType : queryItemTypeList) {
                ReferenceResolver.resolveFacetDefFromItemType(queryItemType, qs);
            }
        }
    }

    private static void resolveFacetDefFromQueryItemDirect(QueryItem item, QuerySubject qs) {
        FacetType.Context context;
        List<SortListType.SortItem> sortItems;
        if (item == null) {
            return;
        }
        FacetType ft = item.getFacetDefinition();
        if (ft == null) {
            return;
        }
        SortListType sl = ft.getSortList();
        if (sl != null && (sortItems = sl.basicGetSortItem()) != null) {
            for (SortListType.SortItem sortItem : sortItems) {
                String ref;
                BaseQueryItemType qi;
                if (sortItem.getReferencedObject() != null || (qi = ReferenceResolver.getQueryItemByIdAndQuerySubject(ref = sortItem.getRef(), qs, false)) == null) continue;
                sortItem.setReferencedObject(qi);
            }
        }
        if ((context = ft.getContext()) != null && context.getReferencedObject() == null) {
            String ref = context.getRef();
            BaseQueryItemType qi = ReferenceResolver.getQueryItemByIdAndQuerySubject(ref, qs, false);
            context.setReferencedObject(qi);
        }
    }

    private static void resolveFacetDefFromItemType(ItemType queryItemType, QuerySubject qs) {
        ItemType.Folder nestedFolder;
        QueryItem queryItem = queryItemType.getQueryItem();
        if (queryItem != null) {
            ReferenceResolver.resolveFacetDefFromItem(queryItem, qs);
        }
        if ((nestedFolder = queryItemType.getFolder()) != null) {
            ReferenceResolver.resolveFacetDefFromFolder(nestedFolder, qs);
        }
    }

    private static void resolveFacetDefFromItem(QueryItem item, QuerySubject qs) {
        ReferenceResolver.resolveFacetDefFromQueryItemDirect(item, qs);
        List<ItemType> queryItems = item.basicGetItem();
        if (queryItems != null) {
            for (ItemType queryItemType : queryItems) {
                ReferenceResolver.resolveFacetDefFromItemType(queryItemType, qs);
            }
        }
    }

    private static void resolveFacetDefFromFolder(ItemType.Folder folder, QuerySubject qs) {
        List<ItemType> queryItemTypeList = folder.basicGetItem();
        if (queryItemTypeList != null) {
            for (ItemType queryItemType : queryItemTypeList) {
                ReferenceResolver.resolveFacetDefFromItemType(queryItemType, qs);
            }
        }
    }

    private static void resolveRelationships(Module module) {
        if (module == null) {
            return;
        }
        List<Relationship> relationships = module.basicGetRelationship();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                ReferenceResolver.resolveRelationship(relationship, module);
            }
        }
    }

    public static void resolveRelationship(Relationship relationship, Module module) {
        ReferenceResolver.resolveCardinalityType(relationship.getLeft(), module);
        ReferenceResolver.resolveCardinalityType(relationship.getRight(), module);
        ReferenceResolver.resolveRelationshipLink(relationship);
    }

    public static void resolveRelationshipLink(Relationship relationship) {
        if (relationship == null) {
            return;
        }
        if (relationship.getLeft() != null && relationship.getRight() != null) {
            ReferenceResolver.resolveRelationshipLinkByQuerySubjects((QuerySubject)relationship.getLeft().getReferencedObject(), (QuerySubject)relationship.getRight().getReferencedObject(), relationship);
        }
    }

    private static void resolveRelationshipLinkByQuerySubjects(QuerySubject resolvedObjLeft, QuerySubject resolvedObjRight, Relationship relationship) {
        List<Relationship.Link> links = relationship.basicGetLink();
        if (links != null) {
            for (Relationship.Link link : links) {
                link.setReferencedObjectLeft(ReferenceResolver.getQueryItemByIdAndQuerySubject(link.getLeftRef(), resolvedObjLeft, false));
                link.setReferencedObjectRight(ReferenceResolver.getQueryItemByIdAndQuerySubject(link.getRightRef(), resolvedObjRight, false));
            }
        }
    }

    public static void resolveCardinalityType(CardinalityType cardinality, Module module) {
        DefLinkType defLinkType;
        if (cardinality == null || module == null) {
            return;
        }
        String ref = cardinality.getRef();
        MoserObject resolveObj = ReferenceResolver.getQuerySubjectById(ref, module);
        if (resolveObj == null && (defLinkType = ReferenceResolver.getDefLinkByIdForExpression(ref, module, false)) != null) {
            resolveObj = defLinkType.getReferencedObject();
        }
        cardinality.setReferencedObject(resolveObj);
    }

    private static DefLinkType getDefLinkByIdForExpression(String id, Module module, boolean isIdForQueryItem) {
        if (module == null) {
            return null;
        }
        DefLinkType result = null;
        List<FolderType> mdtv = module.basicGetMetadataTreeView();
        if (mdtv != null) {
            for (FolderType folderType : mdtv) {
                result = ReferenceResolver.getFolderTypeReferences(id, folderType, module, isIdForQueryItem);
            }
        }
        return result;
    }

    private static DefLinkType getFolderTypeReferences(String id, FolderType folderType, Module module, boolean isIdForQueryItem) {
        if (module == null) {
            return null;
        }
        DefLinkType result = null;
        List<FolderItemType> folderItemTypes = folderType.basicGetFolderItem();
        if (folderItemTypes != null) {
            FolderItemType folderItemType;
            FolderType nestedFolder;
            Iterator<FolderItemType> iterator = folderItemTypes.iterator();
            while (iterator.hasNext() && ((nestedFolder = (folderItemType = iterator.next()).getFolder()) == null || (result = ReferenceResolver.getFolderTypeReferences(id, nestedFolder, module, isIdForQueryItem)) == null)) {
                String defLinkId;
                DefLinkType defLinkType = folderItemType.getDefLink();
                if (defLinkType == null || (defLinkId = defLinkType.basicGetIdForExpression()) == null || !defLinkId.equals(id) && (!isIdForQueryItem || id.indexOf(defLinkId) != 0)) continue;
                result = defLinkType;
                break;
            }
        }
        return result;
    }

    private static void resolveSegmentReferences(Module module) {
        if (module == null) {
            return;
        }
        List<DrillGroup> drillGroups = module.basicGetDrillGroup();
        if (drillGroups != null) {
            for (DrillGroup drillGroup : drillGroups) {
                List<DrillGroup.Segment> segments = drillGroup.basicGetSegment();
                if (segments == null) continue;
                for (DrillGroup.Segment segment : segments) {
                    ReferenceResolver.resolveSegment(segment, module);
                }
            }
        }
    }

    public static void resolveSegment(DrillGroup.Segment segment, Module module) {
        if (segment != null && module != null) {
            MoserObject obj;
            DefLinkType defLinkType;
            BaseQueryItemType queryItem;
            int idx;
            String ref = segment.getRef();
            String id = segment.getIdentifier();
            if (id.indexOf("[") == 0 && id.indexOf("]") == id.length() - 1 && ref.indexOf(EMBEDDED_MODULE_ALIAS) == 0 && (idx = ref.indexOf(ID_SEPARATOR)) > -1) {
                ref = ref.substring(idx + 1);
                segment.setRef(ref);
            }
            if ((queryItem = ReferenceResolver.getQueryItemById(ref, module)) == null && (defLinkType = ReferenceResolver.getDefLinkByIdForExpression(ref, module, true)) != null && (obj = defLinkType.getReferencedObject()) instanceof QuerySubject) {
                queryItem = ReferenceResolver.getQueryItemByIdAndQuerySubject(ref, (QuerySubject)obj, true);
            }
            segment.setReferencedObject(queryItem);
        }
    }

    public static List<QuerySubject> getFlattenedQuerySubjectList(Module module) {
        ArrayList<QuerySubject> qsFlatList = new ArrayList<QuerySubject>();
        if (module == null) {
            return qsFlatList;
        }
        List<BaseObjectType> otFlatList = ReferenceResolver.getFlattenedBaseObjectTypeList(module);
        if (otFlatList != null) {
            for (BaseObjectType obj : otFlatList) {
                if (!(obj instanceof QuerySubject)) continue;
                qsFlatList.add((QuerySubject)obj);
            }
        }
        return qsFlatList;
    }

    public static List<Filter> getFlattenedFilterList(Module module) {
        ArrayList<Filter> filterFlatList = new ArrayList<Filter>();
        if (module == null) {
            return filterFlatList;
        }
        List<BaseObjectType> otFlatList = ReferenceResolver.getFlattenedBaseObjectTypeList(module);
        if (otFlatList != null) {
            for (BaseObjectType obj : otFlatList) {
                if (!(obj instanceof Filter)) continue;
                filterFlatList.add((Filter)obj);
            }
        }
        return filterFlatList;
    }

    public static List<Calculation> getFlattenedCalculationList(Module module) {
        ArrayList<Calculation> calcFlatList = new ArrayList<Calculation>();
        if (module == null) {
            return calcFlatList;
        }
        List<BaseObjectType> otFlatList = ReferenceResolver.getFlattenedBaseObjectTypeList(module);
        if (otFlatList != null) {
            for (BaseObjectType obj : otFlatList) {
                if (!(obj instanceof Calculation)) continue;
                calcFlatList.add((Calculation)obj);
            }
        }
        return calcFlatList;
    }

    private static List<BaseObjectType> getFlattenedBaseObjectTypeList(Module module) {
        if (module == null) {
            return null;
        }
        List<BaseObjectType> otFlatList = module.getFlattenedBaseObjectTypeList();
        if (otFlatList == null) {
            otFlatList = new ArrayList<BaseObjectType>();
            ReferenceResolver.resolveMDTVReferences(module, otFlatList);
        }
        return otFlatList;
    }

    public static void resolveMDTVReferences(Module module) {
        if (module == null) {
            return;
        }
        ArrayList<BaseObjectType> otFlatList = new ArrayList<BaseObjectType>();
        ReferenceResolver.resolveMDTVReferences(module, otFlatList);
    }

    public static void resolveMDTVReferences(Module module, List<BaseObjectType> otFlatList) {
        if (module == null) {
            return;
        }
        List<FolderType> mdtv = module.basicGetMetadataTreeView();
        if (mdtv != null) {
            for (FolderType folderType : mdtv) {
                ReferenceResolver.resolveFolderTypeReferences(null, folderType, module, otFlatList);
            }
        }
        if (otFlatList != null && !otFlatList.isEmpty()) {
            module.setFlattenedBaseObjectTypeList(otFlatList);
        }
    }

    private static void resolveFolderTypeReferences(String ancestorFolderTypeId, FolderType folderType, Module module, List<BaseObjectType> otFlatList) {
        List<FolderItemType> folderItemTypes;
        if (module == null) {
            return;
        }
        String folderTypeId = folderType.getIdentifier();
        if (folderTypeId == null) {
            folderTypeId = ancestorFolderTypeId;
        }
        if ((folderItemTypes = folderType.basicGetFolderItem()) != null) {
            for (FolderItemType folderItemType : folderItemTypes) {
                DefLinkType defLinkType;
                FolderType nestedFolder;
                String ref = folderItemType.getRef();
                if (ref != null && folderItemType.getReferencedObject() == null) {
                    ReferenceResolver.resolveByRef(null, ref, folderItemType, module, otFlatList);
                }
                if ((nestedFolder = folderItemType.getFolder()) != null) {
                    ReferenceResolver.resolveFolderTypeReferences(folderTypeId, nestedFolder, module, otFlatList);
                }
                if ((defLinkType = folderItemType.getDefLink()) == null) continue;
                String idToPrepend = null;
                if (defLinkType.getIdentifier() != null) {
                    idToPrepend = defLinkType.getIdentifier();
                    if (folderTypeId != null) {
                        idToPrepend = folderTypeId + ID_SEPARATOR + idToPrepend;
                    }
                }
                ReferenceResolver.resolveByRef(idToPrepend, defLinkType.getRef(), defLinkType, module, otFlatList);
            }
        }
    }

    private static void resolveByRef(String idToPrepend, String ref, MoserObject scope, Module module, List<BaseObjectType> otFlatList) {
        if (module == null) {
            return;
        }
        QuerySubject qs = ReferenceResolver.getQuerySubjectById(ref, module);
        if (qs != null) {
            ReferenceResolver.setResolvedObject(idToPrepend, scope, qs, otFlatList);
            return;
        }
        Calculation calc = ReferenceResolver.getCalculationById(ref, module);
        if (calc != null) {
            ReferenceResolver.setResolvedObject(idToPrepend, scope, calc, otFlatList);
            return;
        }
        Filter filter = ReferenceResolver.getFilterById(ref, module);
        if (filter != null) {
            ReferenceResolver.setResolvedObject(idToPrepend, scope, filter, otFlatList);
            return;
        }
        NamedSet namedSet = ReferenceResolver.getNamedSetById(ref, module);
        if (namedSet != null) {
            ReferenceResolver.setResolvedObject(idToPrepend, scope, namedSet, otFlatList);
            return;
        }
    }

    private static void updateQSLabel(QuerySubject qs, String label) {
        if (label != null && !label.isEmpty() && !label.equals(qs.getLabel())) {
            qs.setLabel(label);
        }
    }

    private static void setResolvedObject(String composedIdForExprn, MoserObject scope, BaseObjectType resolvedObj, List<BaseObjectType> otFlatList) {
        boolean isPackage = false;
        if (scope instanceof FolderItemType) {
            ((FolderItemType)scope).setReferencedObject(resolvedObj);
        } else if (scope instanceof DefLinkType) {
            isPackage = true;
            DefLinkType defLink = (DefLinkType)scope;
            resolvedObj.setIdForExpression(composedIdForExprn);
            defLink.setReferencedObject(resolvedObj);
            defLink.setIdForExpression(composedIdForExprn);
            if (otFlatList != null) {
                otFlatList.add(resolvedObj);
            }
            if (resolvedObj instanceof QuerySubject) {
                QuerySubject qs = (QuerySubject)resolvedObj;
                ReferenceResolver.resolveShortenedRootMember(qs, defLink.getIdForExpression());
                ReferenceResolver.updateQSLabel(qs, defLink.getLabel());
            }
        }
        if (resolvedObj instanceof QuerySubject && ((QuerySubject)resolvedObj).getInstanceType() != InstanceType.MISSING) {
            String idForExprn = composedIdForExprn;
            if (idForExprn == null || idForExprn.length() == 0) {
                idForExprn = ((QuerySubject)resolvedObj).getIdentifier();
            }
            ReferenceResolver.setQuerySubjectIdForExprn(idForExprn, (QuerySubject)resolvedObj, isPackage);
        }
    }

    private static void setQuerySubjectIdForExprn(String idToPrepend, QuerySubject querySubject, boolean isPackage) {
        List<ItemType> itemTypeList = querySubject.basicGetItem();
        if (itemTypeList != null) {
            for (ItemType itemType : itemTypeList) {
                ItemType.Folder folder;
                ItemHierarchy itemHierarchy;
                QueryItem queryItem = itemType.getQueryItem();
                if (queryItem != null && queryItem.basicGetIdForExpression() == null) {
                    ReferenceResolver.setQueryItemIdForExprn(queryItem, idToPrepend);
                }
                if ((itemHierarchy = itemType.getItemHierarchy()) != null && itemHierarchy.basicGetIdForExpression() == null) {
                    itemHierarchy.setIdForExpression(idToPrepend + ID_SEPARATOR + itemHierarchy.getIdentifier());
                }
                if ((folder = itemType.getFolder()) == null) continue;
                ReferenceResolver.setFolderIdForExprn(folder, idToPrepend);
            }
        }
    }

    private static void resolveItemHierarchyLocalRef(Module module) {
        if (module == null) {
            return;
        }
        List<QuerySubject> querySubjectList = module.basicGetQuerySubject();
        if (querySubjectList != null) {
            for (QuerySubject querySubject : querySubjectList) {
                List<ItemType> queryItemTypeList = querySubject.basicGetItem();
                if (queryItemTypeList == null) continue;
                for (ItemType queryItemType : queryItemTypeList) {
                    ItemHierarchy hierarchy = queryItemType.getItemHierarchy();
                    if (hierarchy == null) continue;
                    ReferenceResolver.resolveLocalRef(hierarchy, querySubject);
                }
            }
        }
    }

    private static void resolveLocalRef(ItemHierarchy hierarchy, QuerySubject querySubject) {
        List<LocalRefType> localRefList;
        if (hierarchy != null && querySubject != null && (localRefList = hierarchy.basicGetLocalRef()) != null) {
            for (LocalRefType localRef : localRefList) {
                String ref = localRef.getRef();
                if (ref == null) continue;
                BaseQueryItemType qi = ReferenceResolver.getQueryItemByIdAndQuerySubject(ref, querySubject, false);
                localRef.setReferencedObject(qi);
            }
        }
    }

    private static void setFolderIdForExprn(ItemType.Folder folder, String idToPrepend) {
        List<ItemType> queryItemTypeList = folder.basicGetItem();
        if (queryItemTypeList != null) {
            for (ItemType queryItemType : queryItemTypeList) {
                ItemType.Folder nestedFolder;
                QueryItem queryItem = queryItemType.getQueryItem();
                if (queryItem != null) {
                    ReferenceResolver.setQueryItemIdForExprn(queryItem, idToPrepend);
                }
                if ((nestedFolder = queryItemType.getFolder()) == null) continue;
                ReferenceResolver.setFolderIdForExprn(nestedFolder, idToPrepend);
            }
        }
    }

    private static void setQueryItemIdForExprn(QueryItem item, String idToPrepend) {
        List<ItemType> queryItems = item.basicGetItem();
        String newIdToPrepend = idToPrepend;
        if (newIdToPrepend != null) {
            newIdToPrepend = newIdToPrepend + ID_SEPARATOR + item.getIdentifier();
        }
        if (queryItems != null) {
            for (ItemType queryItemType : queryItems) {
                ItemType.Folder nestedFolder;
                NamedSet namedSet;
                QueryItem queryItem = queryItemType.getQueryItem();
                if (queryItem != null) {
                    ReferenceResolver.setQueryItemIdForExprn(queryItem, newIdToPrepend);
                }
                if ((namedSet = queryItemType.getNamedSet()) != null && namedSet.basicGetIdForExpression() == null) {
                    namedSet.setIdForExpression(newIdToPrepend + ID_SEPARATOR + namedSet.getIdentifier());
                }
                if ((nestedFolder = queryItemType.getFolder()) == null) continue;
                ReferenceResolver.setFolderIdForExprn(nestedFolder, newIdToPrepend);
            }
        }
        item.setIdForExpression(newIdToPrepend);
    }

    private static QuerySubject getQuerySubjectById(String id, Module module) {
        if (module == null) {
            return null;
        }
        QuerySubject querySubject = null;
        List<QuerySubject> qsList = module.basicGetQuerySubject();
        if (qsList != null) {
            for (QuerySubject qs : qsList) {
                if (!qs.getIdentifier().equals(id)) continue;
                querySubject = qs;
                break;
            }
        }
        return querySubject;
    }

    private static Calculation getCalculationById(String id, Module module) {
        if (module == null) {
            return null;
        }
        Calculation calculation = null;
        List<Calculation> calculations = module.basicGetCalculation();
        if (calculations != null) {
            for (Calculation calc : calculations) {
                if (!calc.getIdentifier().equals(id)) continue;
                calculation = calc;
                break;
            }
        }
        return calculation;
    }

    private static Filter getFilterById(String id, Module module) {
        if (module == null) {
            return null;
        }
        Filter filter = null;
        List<Filter> filterList = module.basicGetFilter();
        if (filterList != null) {
            for (Filter fltr : filterList) {
                if (!fltr.getIdentifier().equals(id)) continue;
                filter = fltr;
                break;
            }
        }
        return filter;
    }

    private static NamedSet getNamedSetById(String id, Module module) {
        if (module == null) {
            return null;
        }
        NamedSet namedSet = null;
        List<NamedSet> namedSetList = module.basicGetNamedSet();
        if (namedSetList != null) {
            for (NamedSet nSet : namedSetList) {
                if (!nSet.getIdentifier().equals(id)) continue;
                namedSet = nSet;
                break;
            }
        }
        return namedSet;
    }

    public static ObjectType findRefById(String ref, Module module) {
        if (module == null) {
            return null;
        }
        ObjectType obj = ReferenceResolver.getQuerySubjectById(ref, module);
        if (obj != null) {
            return obj;
        }
        obj = ReferenceResolver.getCalculationById(ref, module);
        if (obj != null) {
            return obj;
        }
        obj = ReferenceResolver.getFilterById(ref, module);
        if (obj != null) {
            return obj;
        }
        obj = ReferenceResolver.getNamedSetById(ref, module);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    private static BaseQueryItemType getQueryItemById(String qualifiedID, Module module) {
        if (module == null) {
            return null;
        }
        BaseQueryItemType queryItem = null;
        String qsId = ReferenceResolver.getFirstPart(qualifiedID);
        if (qsId != null && qsId.length() > 0) {
            QuerySubject qs = ReferenceResolver.getQuerySubjectById(qsId, module);
            String qiId = ReferenceResolver.getSecondPart(qualifiedID);
            if (qs != null && qiId != null && qiId.length() > 0) {
                queryItem = ReferenceResolver.getQueryItemByIdAndQuerySubject(qiId, qs, false);
            }
        }
        return queryItem;
    }

    public static List<BaseQueryItemType> getQueryItemListByIdExprListAndQuerySubject(List<String> idExprList, QuerySubject qs, boolean isIdForExprn) {
        ArrayList<BaseQueryItemType> qiList = new ArrayList<BaseQueryItemType>();
        if (qs == null || idExprList == null || idExprList.isEmpty()) {
            return qiList;
        }
        HashMap<String, BaseQueryItemType> idExprMap = new HashMap<String, BaseQueryItemType>();
        List<ItemType> items = qs.basicGetItem();
        if (items == null || items.isEmpty()) {
            return qiList;
        }
        ReferenceResolver.collectObjectByIdInItemList(items, idExprMap, isIdForExprn);
        for (String id : idExprList) {
            BaseQueryItemType aQI = idExprMap.get(id);
            if (aQI == null) continue;
            qiList.add(aQI);
        }
        return qiList;
    }

    private static void collectObjectByIdInItemList(List<ItemType> items, HashMap<String, BaseQueryItemType> idExprMap, boolean isIdForExprn) {
        if (items == null || items.isEmpty()) {
            return;
        }
        for (ItemType itm : items) {
            ReferenceResolver.collectObjectByIdInItem(itm, idExprMap, isIdForExprn);
        }
    }

    private static void collectObjectByIdInItem(ItemType itm, HashMap<String, BaseQueryItemType> idExprMap, boolean isIdForExprn) {
        QueryItem qi = itm.getQueryItem();
        if (qi != null) {
            ReferenceResolver.updateObjectMap(qi, idExprMap, isIdForExprn);
            List<ItemType> childItems = qi.basicGetItem();
            ReferenceResolver.collectObjectByIdInItemList(childItems, idExprMap, isIdForExprn);
            return;
        }
        NamedSet nmSet = itm.getNamedSet();
        if (nmSet != null) {
            ReferenceResolver.updateObjectMap(nmSet, idExprMap, isIdForExprn);
            List<ItemType> childItems = nmSet.basicGetItem();
            ReferenceResolver.collectObjectByIdInItemList(childItems, idExprMap, isIdForExprn);
            return;
        }
        ItemType.Folder fld = itm.getFolder();
        if (fld != null) {
            List<ItemType> childItems = fld.basicGetItem();
            ReferenceResolver.collectObjectByIdInItemList(childItems, idExprMap, isIdForExprn);
            return;
        }
    }

    private static void updateObjectMap(BaseQueryItemType baseItem, HashMap<String, BaseQueryItemType> idExprMap, boolean isIdForExprn) {
        String idExpr = isIdForExprn ? baseItem.basicGetIdForExpression() : baseItem.getIdentifier();
        if (idExpr != null) {
            idExprMap.put(idExpr, baseItem);
        }
    }

    public static BaseQueryItemType getQueryItemByIdAndQuerySubject(String id, QuerySubject qs, boolean isIdForExprn) {
        if (qs == null) {
            return null;
        }
        List<ItemType> queryItemTypeList = qs.basicGetItem();
        return ReferenceResolver.getQueryItemFromItemTypeList(id, queryItemTypeList, isIdForExprn);
    }

    public static ItemHierarchy getItemHierarchyByIdAndQuerySubject(String id, QuerySubject qs, boolean isIdForExprn) {
        ItemHierarchy itemHierarchy;
        block2: {
            ItemType itemType;
            if (qs == null) {
                return null;
            }
            itemHierarchy = null;
            List<ItemType> itemTypeList = qs.basicGetItem();
            if (itemTypeList == null) break block2;
            Iterator<ItemType> iterator = itemTypeList.iterator();
            while (iterator.hasNext() && (itemHierarchy = ReferenceResolver.getItemHierarchyFromItemType(id, itemType = iterator.next(), isIdForExprn)) == null) {
            }
        }
        return itemHierarchy;
    }

    public static Filter getItemFilterByIdAndQuerySubject(String id, QuerySubject qs, boolean isIdForExprn) {
        Filter filterItem;
        block2: {
            ItemType itemType;
            if (qs == null) {
                return null;
            }
            filterItem = null;
            List<ItemType> itemTypeList = qs.basicGetItem();
            if (itemTypeList == null) break block2;
            Iterator<ItemType> iterator = itemTypeList.iterator();
            while (iterator.hasNext() && (filterItem = ReferenceResolver.getFilterFromItemType(id, itemType = iterator.next(), isIdForExprn)) == null) {
            }
        }
        return filterItem;
    }

    private static BaseQueryItemType getQueryItemFromItem(String id, BaseQueryItemType item, boolean isIdForExprn) {
        if (item == null || item.getIdentifier() == null) {
            return null;
        }
        if (ReferenceResolver.isIdMatch(id, item, isIdForExprn)) {
            return item;
        }
        List<ItemType> queryItems = item.basicGetItem();
        return ReferenceResolver.getQueryItemFromItemTypeList(id, queryItems, isIdForExprn);
    }

    private static boolean isIdMatch(String id, ObjectType obj, boolean isIdForExprn) {
        String itemId;
        if (obj == null || obj.getIdentifier() == null) {
            return false;
        }
        String string = itemId = isIdForExprn ? obj.basicGetIdForExpression() : obj.getIdentifier();
        return id != null && id.equals(itemId);
    }

    private static ItemHierarchy getItemHierarchyFromItemType(String id, ItemType itemType, boolean isIdForExprn) {
        ItemHierarchy ih;
        ItemHierarchy itemHierarchy = itemType.getItemHierarchy();
        if (itemHierarchy != null && ReferenceResolver.isIdMatch(id, itemHierarchy, isIdForExprn)) {
            return itemHierarchy;
        }
        ItemType.Folder nestedFolder = itemType.getFolder();
        if (nestedFolder != null && (ih = ReferenceResolver.getItemHierarchyFromFolder(id, nestedFolder, isIdForExprn)) != null) {
            return ih;
        }
        return null;
    }

    private static Filter getFilterFromItemType(String id, ItemType itemType, boolean isIdForExprn) {
        List<ItemType> childItems;
        Filter flt;
        Filter itemFilter = itemType.getFilter();
        if (itemFilter != null && ReferenceResolver.isIdMatch(id, itemFilter, isIdForExprn)) {
            return itemFilter;
        }
        ItemType.Folder nestedFolder = itemType.getFolder();
        if (nestedFolder != null && (flt = ReferenceResolver.getFilterFromFolder(id, nestedFolder, isIdForExprn)) != null) {
            return flt;
        }
        QueryItem queryItem = itemType.getQueryItem();
        if (queryItem != null && (childItems = queryItem.basicGetItem()) != null) {
            for (ItemType cItemType : childItems) {
                flt = ReferenceResolver.getFilterFromItemType(id, cItemType, isIdForExprn);
                if (flt == null) continue;
                return flt;
            }
        }
        return null;
    }

    private static ItemHierarchy getItemHierarchyFromFolder(String id, ItemType.Folder folder, boolean isIdForExprn) {
        ItemHierarchy ih;
        block1: {
            ItemType itemType;
            ih = null;
            List<ItemType> itemTypeList = folder.basicGetItem();
            if (itemTypeList == null) break block1;
            Iterator<ItemType> iterator = itemTypeList.iterator();
            while (iterator.hasNext() && (ih = ReferenceResolver.getItemHierarchyFromItemType(id, itemType = iterator.next(), isIdForExprn)) == null) {
            }
        }
        return ih;
    }

    private static Filter getFilterFromFolder(String id, ItemType.Folder folder, boolean isIdForExprn) {
        Filter flt;
        block1: {
            ItemType itemType;
            flt = null;
            List<ItemType> itemTypeList = folder.basicGetItem();
            if (itemTypeList == null) break block1;
            Iterator<ItemType> iterator = itemTypeList.iterator();
            while (iterator.hasNext() && (flt = ReferenceResolver.getFilterFromItemType(id, itemType = iterator.next(), isIdForExprn)) == null) {
            }
        }
        return flt;
    }

    private static BaseQueryItemType getQueryItemFromFolder(String id, ItemType.Folder folder, boolean isIdForExprn) {
        List<ItemType> queryItemTypeList = folder.basicGetItem();
        return ReferenceResolver.getQueryItemFromItemTypeList(id, queryItemTypeList, isIdForExprn);
    }

    private static BaseQueryItemType getQueryItemFromItemTypeList(String id, List<ItemType> queryItemTypeList, boolean isIdForExprn) {
        if (queryItemTypeList != null) {
            for (ItemType queryItemType : queryItemTypeList) {
                BaseQueryItemType qi = ReferenceResolver.getQueryItemFromItemType(id, queryItemType, isIdForExprn);
                if (qi == null) continue;
                return qi;
            }
        }
        return null;
    }

    private static BaseQueryItemType getQueryItemFromItemType(String id, ItemType queryItemType, boolean isIdForExprn) {
        BaseQueryItemType qi;
        QueryItem queryItem = queryItemType.getQueryItem();
        if (queryItem != null && (qi = ReferenceResolver.getQueryItemFromItem(id, queryItem, isIdForExprn)) != null) {
            return qi;
        }
        Calculation calc = queryItemType.getCalculation();
        if (calc != null && (qi = ReferenceResolver.getQueryItemFromItem(id, calc, isIdForExprn)) != null) {
            return qi;
        }
        NamedSet namedSet = queryItemType.getNamedSet();
        if (namedSet != null && namedSet.getIdentifier() != null && ReferenceResolver.isIdMatch(id, namedSet, isIdForExprn)) {
            return namedSet;
        }
        ItemType.Folder nestedFolder = queryItemType.getFolder();
        if (nestedFolder != null && (qi = ReferenceResolver.getQueryItemFromFolder(id, nestedFolder, isIdForExprn)) != null) {
            return qi;
        }
        return null;
    }

    private static BaseQueryItemType getQueryItemByIdAndCalculation(String id, Calculation calc, boolean isIdForExprn) {
        if (calc == null) {
            return null;
        }
        List<ItemType> queryItemTypeList = calc.basicGetItem();
        return ReferenceResolver.getQueryItemFromItemTypeList(id, queryItemTypeList, isIdForExprn);
    }

    public static String getFirstPart(String qualifiedID) {
        if (qualifiedID == null) {
            return null;
        }
        int pos = qualifiedID.indexOf(ID_SEPARATOR);
        if (pos < 0) {
            return "";
        }
        return qualifiedID.substring(0, pos);
    }

    public static String getSecondPart(String qualifiedID) {
        if (qualifiedID == null) {
            return null;
        }
        int pos = qualifiedID.indexOf(ID_SEPARATOR);
        if (pos < 0) {
            return "";
        }
        return qualifiedID.substring(pos + 1);
    }

    private static void resolveShortenedRootMember(QuerySubject querySubject, String prefix) {
        if (querySubject == null) {
            return;
        }
        List<ItemType> itemList = querySubject.basicGetItem();
        if (itemList == null || itemList.isEmpty()) {
            return;
        }
        for (ItemType item : itemList) {
            String rootMember;
            QueryItem qi = item.getQueryItem();
            if (qi == null || (rootMember = qi.getRootMember()) == null || rootMember.indexOf(prefix) == 0 || rootMember.indexOf(ReferenceResolver.squareBracket(prefix)) == 0 || rootMember.isEmpty() || !ReferenceResolver.isShortened(rootMember)) continue;
            qi.setRootMember(prefix + ID_SEPARATOR + rootMember);
        }
    }

    private static String squareBracket(String theString) {
        return "[" + theString + "]";
    }

    private static boolean isShortened(String rootMember) {
        String[] mdParts = rootMember.split("\\.");
        if (mdParts != null && mdParts.length == 2) {
            return mdParts[1].indexOf("]->[") > 0;
        }
        return false;
    }

    public static MoserObject getMoserObjectByIdForExpression(String idForExprn, Module module) {
        MoserObject moserObject;
        block1: {
            FolderType folderType;
            List<FolderType> mdtv = module.basicGetMetadataTreeView();
            moserObject = null;
            if (mdtv == null) break block1;
            Iterator<FolderType> iterator = mdtv.iterator();
            while (iterator.hasNext() && (moserObject = ReferenceResolver.getMoserObjectFromFolderType(idForExprn, folderType = iterator.next())) == null) {
            }
        }
        return moserObject;
    }

    private static MoserObject getMoserObjectFromFolderType(String idForExprn, FolderType folderType) {
        MoserObject moserObject;
        block1: {
            DefLinkType defLinkType;
            FolderType nestedFolder;
            FolderItemType folderItemType;
            List<FolderItemType> folderItemTypes = folderType.basicGetFolderItem();
            moserObject = null;
            if (folderItemTypes == null) break block1;
            Iterator<FolderItemType> iterator = folderItemTypes.iterator();
            while (!(!iterator.hasNext() || (moserObject = ReferenceResolver.getMoserObjectByIdForExprnAndRefObj(idForExprn, (folderItemType = iterator.next()).getReferencedObject())) != null || (nestedFolder = folderItemType.getFolder()) != null && (moserObject = ReferenceResolver.getMoserObjectFromFolderType(idForExprn, nestedFolder)) != null || (defLinkType = folderItemType.getDefLink()) != null && (moserObject = ReferenceResolver.getMoserObjectByIdForExprnAndRefObj(idForExprn, defLinkType.getReferencedObject())) != null)) {
            }
        }
        return moserObject;
    }

    private static MoserObject getMoserObjectByIdForExprnAndRefObj(String idForExprn, MoserObject refObj) {
        if (refObj != null) {
            if (ReferenceResolver.foundMoserObjectByIdForExprn(idForExprn, refObj)) {
                return refObj;
            }
            if (refObj instanceof QuerySubject) {
                ObjectType obj = ReferenceResolver.getQueryItemByIdAndQuerySubject(idForExprn, (QuerySubject)refObj, true);
                if (obj == null) {
                    obj = ReferenceResolver.getItemHierarchyByIdAndQuerySubject(idForExprn, (QuerySubject)refObj, true);
                }
                if (obj == null) {
                    obj = ReferenceResolver.getItemFilterByIdAndQuerySubject(idForExprn, (QuerySubject)refObj, true);
                }
                return obj;
            }
            if (refObj instanceof Calculation) {
                return ReferenceResolver.getQueryItemByIdAndCalculation(idForExprn, (Calculation)refObj, true);
            }
        }
        return null;
    }

    private static boolean foundMoserObjectByIdForExprn(String idForExprn, MoserObject refObj) {
        BaseObjectType baseObjType;
        String id;
        return refObj != null && refObj instanceof BaseObjectType && (id = (baseObjType = (BaseObjectType)refObj).getIdForExpression()) != null && id.equals(idForExprn);
    }

    public static MoserObject bindMoserObject(Module module, String multiPartID) {
        MoserObject mo = ReferenceResolver.getMoserObjectByIdForExpression(multiPartID, module);
        if (mo == null) {
            mo = ReferenceResolver.getQueryItemById(multiPartID, module);
        }
        if (mo == null) {
            mo = ReferenceResolver.getCalculationById(multiPartID, module);
        }
        if (mo == null) {
            mo = ReferenceResolver.findRefById(multiPartID, module);
        }
        if (mo == null) {
            String alias;
            String newID;
            Module.UseSpec useSpec;
            String alias2;
            Iterator<Module.UseSpec> iterator = module.getUseSpec().iterator();
            while (iterator.hasNext() && ((alias2 = (useSpec = iterator.next()).getIdentifier()) == null || (mo = ReferenceResolver.getMoserObjectByIdForExpression(newID = alias2 + ID_SEPARATOR + multiPartID, module)) == null)) {
            }
            if (mo == null && (alias = ReferenceResolver.strBetween(multiPartID, "[", "].")) != null) {
                for (Module.UseSpec useSpec2 : module.getUseSpec()) {
                    if (!alias.equals(useSpec2.getIdentifier())) continue;
                    newID = alias + ID_SEPARATOR + ReferenceResolver.strAfter(multiPartID, "].");
                    return ReferenceResolver.bindMoserObject(module, newID);
                }
            }
        }
        return mo;
    }

    public static String strAfter(String inString, String after) {
        if (inString == null || inString.isEmpty()) {
            return inString;
        }
        if (after == null) {
            return "";
        }
        int pos = inString.indexOf(after);
        if (pos == -1) {
            return "";
        }
        return inString.substring(pos + after.length());
    }

    public static String strBetween(String inString, String str1, String str2) {
        if (inString == null || str1 == null || str2 == null) {
            return null;
        }
        int idxStr1 = inString.indexOf(str1);
        if (idxStr1 == -1) {
            return null;
        }
        int idxStr2 = inString.indexOf(str2, idxStr1 + str1.length());
        if (idxStr2 == -1) {
            return null;
        }
        return inString.substring(idxStr1 + str1.length(), idxStr2);
    }
}

