/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.ibm.bi.recommendationmodel.Categorical;
import com.ibm.bi.recommendationmodel.Context;
import com.ibm.bi.recommendationmodel.ContextKey;
import com.ibm.bi.recommendationmodel.Geography;
import com.ibm.bi.recommendationmodel.Measure;
import com.ibm.bi.recommendationmodel.Temporal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chart {
    private String name;
    private Map<ContextKey, Context> contextsMappings;

    @JsonCreator
    protected Chart(@JsonProperty(value="name") String name) {
        this.name = name;
        this.contextsMappings = new HashMap<ContextKey, Context>();
    }

    protected Chart(Chart chart, double freqWeight) {
        this.name = chart.getName();
        this.contextsMappings = new HashMap<ContextKey, Context>(chart.getContextsMappings().size());
        for (Context inputContext : chart.getContexts()) {
            ContextKey inputContextKey = inputContext.getContextKey();
            Context newContext = new Context(inputContext, freqWeight);
            this.contextsMappings.put(inputContextKey, newContext);
        }
    }

    public Context putIfAbsentAndReturn(Categorical categorical, Geography geography, Measure measure, Temporal temporal) {
        Context context = new Context(categorical, geography, measure, temporal);
        this.contextsMappings.putIfAbsent(context.getContextKey(), context);
        return this.contextsMappings.get(context.getContextKey());
    }

    @JsonGetter
    public String getName() {
        return this.name;
    }

    @JsonGetter
    public Collection<Context> getContexts() {
        return this.contextsMappings.values();
    }

    protected Chart() {
        this.name = null;
        this.contextsMappings = new HashMap<ContextKey, Context>();
    }

    @JsonSetter(value="contexts")
    protected void setContextsMappings(List<Context> contexts) {
        for (Context context : contexts) {
            this.contextsMappings.putIfAbsent(context.getContextKey(), context);
        }
    }

    private Map<ContextKey, Context> getContextsMappings() {
        return this.contextsMappings;
    }

    protected void merge(Chart sourceChart) {
        Map<ContextKey, Context> sourceContextsMappings = sourceChart.getContextsMappings();
        Map<ContextKey, Context> targetContextsMappings = this.getContextsMappings();
        for (Map.Entry<ContextKey, Context> sourceChartEntry : sourceContextsMappings.entrySet()) {
            Context sourceContext = sourceChartEntry.getValue();
            ContextKey sourceContextKey = sourceChartEntry.getKey();
            if (targetContextsMappings.containsKey(sourceContextKey)) {
                Context targetContext = targetContextsMappings.get(sourceContextKey);
                targetContext.merge(sourceContext);
                continue;
            }
            targetContextsMappings.put(sourceContextKey, sourceContext);
        }
    }
}

