/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ibm.bi.recommendationmodel.Categorical;
import com.ibm.bi.recommendationmodel.ContextKey;
import com.ibm.bi.recommendationmodel.ContextSerializer;
import com.ibm.bi.recommendationmodel.Geography;
import com.ibm.bi.recommendationmodel.Measure;
import com.ibm.bi.recommendationmodel.SlotMapping;
import com.ibm.bi.recommendationmodel.Temporal;
import com.ibm.smarts.common.learning.Sentiment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonSerialize(using=ContextSerializer.class)
public class Context {
    private ContextKey contextKey;
    private double score;
    private List<SlotMapping> slotMappings;
    private int frequency;
    private Sentiment sentiment = Sentiment.NONE;

    protected Context(Categorical categorical, Geography geography, Measure measure, Temporal temporal) {
        this.frequency = 0;
        this.slotMappings = new ArrayList<SlotMapping>();
        this.contextKey = new ContextKey(categorical, geography, measure, temporal);
    }

    protected Context(Context context, double freqWeight) {
        this.score = context.getScore();
        this.frequency = (int)Math.round((double)context.getFrequency() * freqWeight);
        this.slotMappings = new ArrayList<SlotMapping>(context.getSlotMappings().size());
        for (SlotMapping slotMapping : context.getSlotMappings()) {
            this.slotMappings.add(new SlotMapping(slotMapping, freqWeight));
        }
        this.contextKey = new ContextKey(context.getContextKey());
    }

    public SlotMapping putIfAbsentAndReturn(Map<String, Integer> slotColumnMappings) {
        SlotMapping newSlotMapping = new SlotMapping();
        for (SlotMapping slotMapping : this.slotMappings) {
            if (!slotMapping.isEqual(slotColumnMappings)) continue;
            return slotMapping;
        }
        this.slotMappings.add(newSlotMapping);
        return newSlotMapping;
    }

    public int getFrequency() {
        return this.frequency;
    }

    @JsonSetter
    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public void incrementFrequency() {
        ++this.frequency;
    }

    @JsonSetter
    public void setScore(double score) {
        this.score = score;
    }

    public double getScore() {
        return this.score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Context)) {
            return false;
        }
        Context context = (Context)o;
        return Double.compare(context.getScore(), this.getScore()) == 0 && this.getFrequency() == context.getFrequency() && Objects.equals(this.getContextKey(), context.getContextKey()) && Objects.equals(this.getSlotMappings(), context.getSlotMappings()) && this.getSentiment() == context.getSentiment();
    }

    public int hashCode() {
        return Objects.hash(this.getContextKey(), this.getScore(), this.getSlotMappings(), this.getFrequency(), this.getSentiment());
    }

    public Categorical getCategorical() {
        return this.getContextKey().getCategorical();
    }

    public Geography getGeography() {
        return this.getContextKey().getGeography();
    }

    public Measure getMeasure() {
        return this.getContextKey().getMeasure();
    }

    public Temporal getTemporal() {
        return this.getContextKey().getTemporal();
    }

    public Sentiment getSentiment() {
        return this.sentiment;
    }

    public void setSentiment(Sentiment sentiment) {
        this.sentiment = sentiment;
    }

    @JsonCreator
    protected Context(@JsonProperty(value="categorical") Categorical categorical, @JsonProperty(value="geography") Geography geography, @JsonProperty(value="measure") Measure measure, @JsonProperty(value="temporal") Temporal temporal, @JsonProperty(value="slotMappings") List<SlotMapping> slotMappings) {
        this.contextKey = new ContextKey(categorical, geography, measure, temporal);
        this.slotMappings = slotMappings;
    }

    public ContextKey getContextKey() {
        return this.contextKey;
    }

    public List<SlotMapping> getSlotMappings() {
        return this.slotMappings;
    }

    protected List<SlotMapping> getMostFrequentSlotMappings(int slotMappingsCount) {
        Collections.sort(this.slotMappings, (s1, s2) -> Integer.compare(s2.getFrequency(), s1.getFrequency()));
        return this.slotMappings.stream().limit(slotMappingsCount).collect(Collectors.toList());
    }

    @JsonSetter
    protected void setSlotMappings(List<SlotMapping> slotMappings) {
        this.slotMappings = slotMappings;
    }

    protected void merge(Context sourceContext) {
        this.score += sourceContext.getScore();
        this.frequency += sourceContext.getFrequency();
        for (SlotMapping sourceSlotMapping : sourceContext.getSlotMappings()) {
            SlotMapping mergeCandidate = this.getEqualSlotMapping(sourceSlotMapping);
            if (mergeCandidate != null) {
                mergeCandidate.merge(sourceSlotMapping);
                continue;
            }
            this.getSlotMappings().add(sourceSlotMapping);
        }
    }

    private SlotMapping getEqualSlotMapping(SlotMapping mapping) {
        for (SlotMapping targetSlotsMapping : this.getSlotMappings()) {
            if (!targetSlotsMapping.isEqual(mapping)) continue;
            return targetSlotsMapping;
        }
        return null;
    }
}

