/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.recommendationmodel;

import com.ibm.bi.recommendationmodel.StatisticType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatisticBucketRange {
    protected static final Map<Double, Double> DISTINCT_COUNT;
    protected static final Map<Double, Double> DENSITY;
    protected static final Map<Double, Double> MIN;
    protected static final Map<Double, Double> MAX;

    public static Double getFiniteUpperLimitForBucket(StatisticType statisticType) {
        switch (statisticType) {
            case DENSITY: {
                return StatisticBucketRange.findFiniteMax(DENSITY);
            }
            case DISTINCT_COUNT: {
                return StatisticBucketRange.findFiniteMax(DISTINCT_COUNT);
            }
            case MAX_VALUE: {
                return StatisticBucketRange.findFiniteMax(MAX);
            }
            case MIN_VALUE: {
                return StatisticBucketRange.findFiniteMax(MIN);
            }
        }
        return Double.NaN;
    }

    private static Double findFiniteMax(Map<Double, Double> statMap) {
        double max = Double.NaN;
        Optional<Double> maxKey = statMap.keySet().stream().filter(Objects::nonNull).max(Double::compareTo);
        if (maxKey.isPresent()) {
            max = statMap.get(maxKey.get()) == null ? maxKey.get().doubleValue() : statMap.get(maxKey.get()).doubleValue();
        }
        return max;
    }

    static {
        HashMap<Double, Double> map = new HashMap<Double, Double>();
        map.put(0.0, 2.0);
        map.put(3.0, 9.0);
        map.put(10.0, 19.0);
        map.put(20.0, 39.0);
        map.put(40.0, 79.0);
        map.put(80.0, null);
        DISTINCT_COUNT = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(0.0, 0.2);
        map.put(0.21, 0.4);
        map.put(0.41, 0.6);
        map.put(0.61, 0.8);
        map.put(0.81, 0.99);
        map.put(1.0, 1.0);
        DENSITY = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(null, -500.0);
        map.put(-500.01, 0.0);
        map.put(0.01, 500.0);
        map.put(500.01, null);
        MIN = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(null, -500.0);
        map.put(-500.01, 0.0);
        map.put(0.01, 500.0);
        map.put(500.01, null);
        MAX = Collections.unmodifiableMap(map);
    }
}

