/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.provider;

import com.ibm.smarts.schema.Clue;
import com.ibm.smarts.store.api.ITypedStore;
import com.ibm.smarts.store.api.provider.IClueStore;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.IRecordResult;
import com.ibm.smarts.store.api.query.IStoreQuery;
import com.ibm.smarts.store.api.query.IStoreQueryBuilder;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class SmartsClueStore
implements IClueStore {
    private final ITypedStore<Clue> store;

    public SmartsClueStore(ITypedStore<Clue> store) {
        this.store = store;
    }

    @Override
    public StoreStatus store(List<IRecord<Clue>> clues) {
        return this.store.store(clues, true);
    }

    @Override
    public IStoreQueryBuilder getQueryBuilder() {
        return this.store.getQueryBuilder();
    }

    @Override
    public List<IRecordResult<Clue>> executeSearch(IStoreQuery sq) {
        return this.store.executeSearch(sq);
    }

    @Override
    public CompletableFuture<List<IRecordResult<Clue>>> executeSearchAsync(IStoreQuery sq) {
        return this.store.executeSearchAsync(sq);
    }

    @Override
    public StoreStatus delete(String ontoId) {
        IStoreQuery sq = this.store.getQueryBuilder().addFilter("ontologyID", new String[]{ontoId}).build();
        return this.store.deleteByQuery(sq);
    }

    @Override
    public StoreStatus delete(String ontoId, String tenantId) {
        IStoreQuery sq = this.store.getQueryBuilder().addFilter("ontologyID", new String[]{ontoId}).addFilter("tenantID", new String[]{tenantId}).build();
        return this.store.deleteByQuery(sq);
    }

    @Override
    public StoreStatus delete(String ontoId, String tenantId, String userId) {
        IStoreQuery sq = this.store.getQueryBuilder().addFilter("ontologyID", new String[]{ontoId}).addFilter("tenantID", new String[]{tenantId}).addFilter("userID", new String[]{userId}).build();
        return this.store.deleteByQuery(sq);
    }

    @Override
    public boolean isExist() {
        return this.store.isExists();
    }
}

