/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.store.provider;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.store.api.exceptions.RecordAlreadyExistsException;
import com.ibm.smarts.store.api.exceptions.RecordNotFoundException;
import com.ibm.smarts.store.api.provider.IInMemoryModuleStore;
import com.ibm.smarts.store.api.query.IRecord;
import com.ibm.smarts.store.api.query.StoreStatus;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class SmartsModuleStore
implements IInMemoryModuleStore {
    private final Map<String, SmartsModule> modules = new ConcurrentHashMap<String, SmartsModule>();
    private final Map<String, DatasetInfo> datasets = new ConcurrentHashMap<String, DatasetInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreStatus apply(String moduleId, Function<SmartsModule, SmartsModule> updateLambda) {
        if (moduleId == null) {
            return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)new IllegalArgumentException(), "ModuleId null", new Object[0])));
        }
        SmartsModule module = this.modules.get(moduleId);
        if (module == null) {
            throw new RecordNotFoundException("id='" + moduleId + "'", new Object[0]);
        }
        SmartsModule smartsModule = module;
        synchronized (smartsModule) {
            try {
                SmartsModule cModule = SmartsModuleFactory.createSmartsModule();
                this.updateModule(module, cModule);
                this.updateModule(updateLambda.apply(cModule), module);
                return new StoreStatus(true, null);
            }
            catch (Exception e) {
                return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)e, e.getMessage(), new Object[0])));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreStatus apply(String moduleId, String datasetId, Function<DatasetInfo, DatasetInfo> updateLambda) {
        if (moduleId == null) {
            return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)new IllegalArgumentException(), "ModuleId null", new Object[0])));
        }
        if (datasetId == null) {
            return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)new IllegalArgumentException(), "datasetId null", new Object[0])));
        }
        String compositeDatasetId = IInMemoryModuleStore.buildDatasetCompositeId(moduleId, datasetId);
        DatasetInfo dataset = this.datasets.get(compositeDatasetId);
        if (dataset == null) {
            throw new RecordNotFoundException("id='" + compositeDatasetId + "'", new Object[0]);
        }
        DatasetInfo datasetInfo = dataset;
        synchronized (datasetInfo) {
            try {
                DatasetInfo newDataset = updateLambda.apply(dataset);
                this.datasets.put(compositeDatasetId, newDataset);
            }
            catch (Exception e) {
                return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)e, e.getMessage(), new Object[0])));
            }
        }
        return new StoreStatus(true, null);
    }

    @Override
    public CompletableFuture<StoreStatus> applyAsync(String moduleId, String datasetId, Function<DatasetInfo, DatasetInfo> updateLambda) {
        return CompletableFuture.completedFuture(this.apply(moduleId, datasetId, updateLambda));
    }

    @Override
    public CompletableFuture<StoreStatus> applyAsync(String moduleId, Function<SmartsModule, SmartsModule> updateLambda) {
        return CompletableFuture.completedFuture(this.apply(moduleId, updateLambda));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmartsModule getSmartsModulePart(String moduleId, String datasetId) {
        if (moduleId == null) {
            return null;
        }
        SmartsModule storedModule = this.modules.get(moduleId);
        if (storedModule == null) {
            return null;
        }
        SmartsModule module = SmartsModuleFactory.createSmartsModule();
        SmartsModule smartsModule = storedModule;
        synchronized (smartsModule) {
            this.updateModule(storedModule, module);
        }
        DatasetInfo storedDataset = this.datasets.get(IInMemoryModuleStore.buildDatasetCompositeId(moduleId, datasetId));
        if (storedDataset == null) {
            return null;
        }
        DatasetInfo datasetInfo = storedDataset;
        synchronized (datasetInfo) {
            module.getDatasets().add(storedDataset);
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoreStatus deleteById(String moduleId) {
        if (moduleId == null) {
            return new StoreStatus(false, Arrays.asList(new InternalException((Throwable)new IllegalArgumentException(), "ModuleId null", new Object[0])));
        }
        SmartsModule module = this.modules.get(moduleId);
        if (module != null) {
            SmartsModule smartsModule = module;
            synchronized (smartsModule) {
                this.modules.remove(moduleId);
                module.getDatasets().forEach(dataset -> this.datasets.remove(IInMemoryModuleStore.buildDatasetCompositeId(moduleId, dataset.getId())));
            }
        }
        return new StoreStatus(true, null);
    }

    @Override
    public StoreStatus store(IRecord<SmartsModule> moduleRecord, String resourceURI) {
        if (this.modules.containsKey(moduleRecord.getId())) {
            throw new RecordAlreadyExistsException("id='" + moduleRecord.getId() + "'", new Object[0]);
        }
        if (resourceURI == null) {
            return this.updateSmartsModule((SmartsModule)moduleRecord.getRecord());
        }
        return this.updateSmartsModule(moduleRecord, resourceURI);
    }

    @Override
    public SmartsModule getById(String moduleId) {
        return this.modules.get(moduleId);
    }

    @Override
    public CompletableFuture<SmartsModule> getByIdAsync(String moduleId) {
        return CompletableFuture.completedFuture(this.getById(moduleId));
    }

    private StoreStatus updateSmartsModule(SmartsModule module) {
        this.modules.put(module.getId(), module);
        module.getDatasets().forEach(d -> this.datasets.put(IInMemoryModuleStore.buildDatasetCompositeId(module.getId(), d.getId()), (DatasetInfo)d));
        return new StoreStatus(true, null);
    }

    private StoreStatus updateSmartsModule(IRecord<SmartsModule> moduleRecord, String resourceURI) {
        SmartsModule module = (SmartsModule)moduleRecord.getRecord();
        this.modules.put(resourceURI, module);
        module.getDatasets().forEach(d -> this.datasets.put(IInMemoryModuleStore.buildDatasetCompositeId(resourceURI, d.getId()), (DatasetInfo)d));
        return new StoreStatus(true, null);
    }

    private void updateModule(SmartsModule src, SmartsModule dst) {
        dst.setId(src.getId());
        dst.setName(src.getName());
        dst.setLabel(src.getLabel());
        dst.setDescription(src.getDescription());
        dst.setDescriptionLabel(src.getDescriptionLabel());
        dst.setComment(src.getComment());
        dst.setCancelOption(src.getCancelOption());
        dst.setComment(src.getComment());
        dst.setCommentLabel(src.getCommentLabel());
        dst.setType(src.getType());
        dst.setAnalysisMode(src.getAnalysisMode());
        dst.setLocale(src.getLocale());
        dst.setModuleCreationTime(src.getModuleCreationTime());
        dst.setModuleLastModifiedTime(src.getModuleLastModifiedTime());
        if (src.getAnalysisState() != null) {
            dst.setAnalysisState(src.getAnalysisState());
        }
    }
}

