/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.similarity.classifier.common.utils;

import com.ibm.smarts.schema.ColumnInfo;
import com.ibm.smarts.schema.SemanticInfo;
import com.ibm.smarts.schema.UsageType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SimilarityUtility {
    private static final Set<String> searchableConceptIds = new HashSet<String>(Arrays.asList("http://www.ibm.com/ontologies/waca/domain/common#City", "http://www.ibm.com/ontologies/waca/domain/common#Country", "http://www.ibm.com/ontologies/waca/domain/common#StateProvince", "http://www.ibm.com/ontologies/waca/domain/common#Continent", "http://www.ibm.com/ontologies/waca/domain/common#County", "http://www.ibm.com/ontologies/waca/domain/common#SubContinent", "http://www.ibm.com/ontologies/waca/domain/common#DayOfWeek", "http://www.ibm.com/ontologies/waca/domain/common#Month", "http://www.ibm.com/ontologies/waca/domain/common#Season"));
    private static final float SEARCHABLE_CONCEPS_THRESHOLD = 0.85f;

    public static boolean isSearchable(SemanticInfo semanticInfo) {
        long count = semanticInfo.getConcepts().stream().filter(c -> c.getConfidence() > 0.85f).filter(c -> searchableConceptIds.contains(c.getConceptID())).count();
        return count > 0L;
    }

    public static boolean isEncodable(ColumnInfo columnInfo) {
        return columnInfo.getUsage() != UsageType.FACT;
    }
}

