/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.impl;

import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.qa.api.Interpretation;
import com.ibm.smarts.qa.api.InterpretationUnit;
import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedEntity;
import com.ibm.smarts.schema.TokenInfo;
import com.ibm.smarts.store.api.query.IRecordResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang3.tuple.Pair;

public class SemanticSearchContext {
    private final RequestContext reqCtx;
    private final String question;
    private final Interpretation interpretation;
    private final String[] assetRefs;
    private final String assetTypes;
    private final List<InterpretationUnit> ius;
    private final List<TokenInfo> tokens;
    private final Map<String, MatchedValue> matchedValues;
    private final MultiMap matchedCandidateMap;
    private final Map<String, IRecordResult<Feature>> rawResultCache;
    private static final Map<String, Integer> conceptForValueRank = new HashMap<String, Integer>();
    private boolean inDataValue;

    SemanticSearchContext(RequestContext req, String question, Interpretation interpret, String assetTypes, String[] assetRefs) {
        this.reqCtx = req;
        this.question = question;
        this.interpretation = interpret;
        this.ius = this.interpretation.getUnits().stream().map(Function.identity()).collect(Collectors.toList());
        this.tokens = this.ius.stream().flatMap(iu -> iu.getPhraseInfo().getTokens().stream()).collect(Collectors.toList());
        this.matchedCandidateMap = new MultiValueMap();
        this.rawResultCache = new HashMap<String, IRecordResult<Feature>>();
        this.assetRefs = assetRefs;
        this.assetTypes = assetTypes;
        this.matchedValues = new HashMap<String, MatchedValue>(this.tokens.size());
        Object attr = req.getAttribute("inDataValue");
        if (attr != null) {
            this.setInDataValue(Boolean.parseBoolean((String)attr));
        }
    }

    void dispose() {
        this.matchedCandidateMap.clear();
        this.rawResultCache.clear();
        this.tokens.clear();
        this.ius.clear();
        this.matchedValues.clear();
    }

    void addMatchedValue(int start, int end, String value, String concept) {
        ArrayList<String> keysToRemove = null;
        for (String key : this.matchedValues.keySet()) {
            if (key.length() > value.length()) {
                if (!key.toLowerCase().contains(value.toLowerCase())) continue;
                return;
            }
            if (key.length() >= value.length() || !value.toLowerCase().contains(key.toLowerCase())) continue;
            if (keysToRemove == null) {
                keysToRemove = new ArrayList<String>();
            }
            keysToRemove.add(key);
        }
        if (keysToRemove != null) {
            this.matchedValues.keySet().removeAll(keysToRemove);
        }
        this.doAddMatchValue(start, end, value, concept);
    }

    private void doAddMatchValue(int start, int end, String value, String concept) {
        this.matchedValues.compute(value, (k, v) -> {
            if (v == null) {
                return new MatchedValue(start, end, value, concept);
            }
            int conceptRank = conceptForValueRank.get(concept) == null ? 0 : conceptForValueRank.get(concept);
            int vConceptRank = conceptForValueRank.get(v.getConcept()) == null ? 0 : conceptForValueRank.get(v.getConcept());
            return conceptRank > vConceptRank ? new MatchedValue(start, end, value, concept) : v;
        });
    }

    void cacheRawSearchResults(List<IRecordResult<Feature>> featureHits) {
        featureHits.forEach(hit -> this.rawResultCache.put(hit.getRecord().getId(), (IRecordResult<Feature>)hit));
    }

    void cacheRawSearchResult(IRecordResult<Feature> featureHit) {
        this.rawResultCache.put(featureHit.getRecord().getId(), featureHit);
    }

    boolean isNewHit(IRecordResult<Feature> hit) {
        return this.rawResultCache.get(hit.getRecord().getId()) == null;
    }

    Object lookupMatchedEntityCandidate(String key) {
        return this.matchedCandidateMap.get((Object)key);
    }

    void removeMatchedEntityCandidate(String key) {
        this.matchedCandidateMap.remove((Object)key);
    }

    void addMatchedEntityCandiate(MatchedEntityCandidate cand) {
        this.matchedCandidateMap.put((Object)cand.getCoveredText(), (Object)cand);
    }

    MultiMap getMatchedEntityCandidateMap() {
        return this.matchedCandidateMap;
    }

    Map<String, MatchedValue> getMatchedValues() {
        return this.matchedValues;
    }

    List<TokenInfo> getTokens() {
        return this.tokens;
    }

    RequestContext getReqCtx() {
        return this.reqCtx;
    }

    String getQuestion() {
        return this.question;
    }

    Interpretation getInterpretation() {
        return this.interpretation;
    }

    String getAssetTypes() {
        return this.assetTypes;
    }

    String[] getAssetRefs() {
        return this.assetRefs;
    }

    List<InterpretationUnit> getIUs() {
        return this.ius;
    }

    public boolean isInDataValue() {
        return this.inDataValue;
    }

    public void setInDataValue(boolean inDataValue) {
        this.inDataValue = inDataValue;
    }

    static {
        conceptForValueRank.put("Month", 2);
    }

    static class MatchedEntityCandidate
    extends MatchedEntity {
        private float similarityScore;
        private List<Pair<Integer, MatchReason>> bestMatchedQTokenVector;

        MatchedEntityCandidate() {
        }

        List<Pair<Integer, MatchReason>> getBestMatchedQTokenVector() {
            return this.bestMatchedQTokenVector;
        }

        void setBestMatchedQTokenVector(List<Pair<Integer, MatchReason>> best) {
            this.bestMatchedQTokenVector = best;
        }

        void setSimilarityScore(float score) {
            this.similarityScore = score;
        }

        float getSimilarityScore() {
            return this.similarityScore;
        }

        boolean isFullMatch() {
            return Float.compare(this.similarityScore, 1.0f) == 0;
        }

        List<Pair<Integer, MatchReason>> getMatchedQTokenVector() {
            return this.bestMatchedQTokenVector;
        }

        List<Integer> getMatchedQTokenIndexes() {
            if (null == this.bestMatchedQTokenVector) {
                ArrayList<Integer> matchedTokenIndexes = new ArrayList<Integer>(this.tokenEnd - this.tokenBegin + 1);
                for (int i = this.tokenBegin; i <= this.tokenEnd; ++i) {
                    matchedTokenIndexes.add(i);
                }
                return matchedTokenIndexes;
            }
            return this.bestMatchedQTokenVector.stream().map(Pair::getLeft).collect(Collectors.toList());
        }
    }

    static class MatchedValue {
        private int start;
        private int end;
        private String value;
        private String concept;

        public MatchedValue(int start, int end, String value, String conceptLabel) {
            this.start = start;
            this.end = end;
            this.value = value;
            this.concept = conceptLabel;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String getValue() {
            return this.value;
        }

        public String getConcept() {
            return this.concept;
        }

        public String toString() {
            return "MatchedValue [start=" + this.start + ", end=" + this.end + ", value=" + this.value + ", concept=" + this.concept + "]";
        }
    }
}

