/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.schema.Feature;
import com.ibm.smarts.schema.MatchReason;
import com.ibm.smarts.schema.MatchedFeature;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import com.ibm.smarts.store.api.query.IRecordResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateLexicalAndLemmaResults
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateLexicalAndLemmaResults.class);
    private SearchContext searchContext;

    public AggregateLexicalAndLemmaResults(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext entityContext) {
        ArrayList<IRecordResult<Feature>> featureHits = new ArrayList<IRecordResult<Feature>>(entityContext.getRawResultCache().values());
        if (featureHits.isEmpty()) {
            return;
        }
        List prunedHits = featureHits.stream().map(hit -> {
            MatchedFeature aMatch = SemanticSearchHelper.convertToMatchedFeature((IRecordResult<Feature>)hit);
            MatchReason matchReason = SemanticSearchHelper.evaluateMatchReason(entityContext.getNluPhraseInfo(), aMatch.getFeature());
            if (matchReason == MatchReason.PARTIAL_CONCEPT) {
                entityContext.cacheRawSearchResultForConcepts((IRecordResult<Feature>)hit);
                return null;
            }
            return hit;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList<MatchedFeature> allMatchedFeatures = new ArrayList<MatchedFeature>();
        for (int i = 0; i < prunedHits.size(); ++i) {
            MatchedFeature aMatch = SemanticSearchHelper.convertToMatchedFeature((IRecordResult<Feature>)((IRecordResult)prunedHits.get(i)));
            MatchReason matchReason = SemanticSearchHelper.evaluateMatchReason(entityContext.getNluPhraseInfo(), aMatch.getFeature());
            aMatch.setMatchReason(matchReason);
            aMatch.setScore(((IRecordResult)prunedHits.get(i)).getScore());
            if (matchReason == MatchReason.FULL) {
                aMatch.setConfidence(1.0f);
            } else {
                aMatch.setConfidence(SemanticSearchHelper.normalize(aMatch.getScore()));
            }
            allMatchedFeatures.add(aMatch);
        }
        entityContext.getMatchedFeatures().addAll(allMatchedFeatures);
    }
}

