/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.semanticsearch.pipeline;

import com.ibm.smarts.schema.PhraseInfo;
import com.ibm.smarts.schema.TimeEntity;
import com.ibm.smarts.semanticsearch.impl.NLUEntityContext;
import com.ibm.smarts.semanticsearch.impl.SearchContext;
import com.ibm.smarts.semanticsearch.pipeline.IAnnotator;
import com.ibm.smarts.semanticsearch.util.SemanticSearchHelper;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAnnotator
implements IAnnotator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAnnotator.class);
    private SearchContext searchContext;
    private static final String DASH = "-";
    private static final String YEAR_CONCEPT = "Year";

    public TimeAnnotator(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    @Override
    public void accept(NLUEntityContext entityContext) {
        PhraseInfo phraseInfo = entityContext.getNluPhraseInfo();
        phraseInfo.getEntities().stream().filter(Objects::nonNull).forEach(mentionEntity -> {
            TimeEntity te = mentionEntity.getTimeEntity();
            if (te != null && StringUtils.isNotBlank((CharSequence)mentionEntity.getTimeEntity().getValue())) {
                String[] values = te.getValue().split(DASH);
                String yearValue = values[0];
                if (entityContext.getNluEntity().getText().contains(yearValue)) {
                    String entityText = entityContext.getNluEntity().getText();
                    Float normalizedScore = Float.valueOf(1.0f - SemanticSearchHelper.findEditDistance(entityText, yearValue));
                    entityContext.getHighestConceptScoreMap().put(YEAR_CONCEPT, normalizedScore);
                }
            }
        });
    }
}

