/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.autoca;

import com.cognos.accman.autoca.MainServerThread;
import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.CryptoProviderManager;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.accman.res.MessageSet;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.math.BigInteger;

public class CaServer {
    private static final String SERIAL_FILE_NAME = CCLConfigurationFactory.getInstance().resolveEffectivePath("../configuration/caSerial");
    private static BigInteger nextCertSerial = null;
    private static MainServerThread mainServerThread;

    public static synchronized BigInteger getNextCertSerial() throws CAMCryptoException {
        BigInteger thisCertSerial = nextCertSerial;
        nextCertSerial = nextCertSerial.add(BigInteger.ONE);
        CaServer.writeNextCertSerialToFile();
        return thisCertSerial;
    }

    public static void runOnThread() throws CAMCryptoException {
        mainServerThread = new MainServerThread();
        mainServerThread.checkStartupIsPossible();
        mainServerThread.start();
        while (!mainServerThread.isAlive()) {
            Thread.yield();
        }
    }

    public static void shutdownServer() {
        try {
            CaServer.writeNextCertSerialToFile();
        }
        catch (CAMCryptoException cce) {
            System.out.println(MessageSet.getMessage("CAM_CRP_cert_serial_update_error"));
        }
        mainServerThread.shutdown();
    }

    public static void main(String[] args) throws Exception {
        System.exit(-1);
        if (args.length != 1) {
            System.out.println("Missing parameter: start or stop");
            System.exit(-1);
        }
        CryptoProviderManager cpmgr = CryptoProviderManager.getInstance();
        cpmgr.configureSecurityProviders();
        IConfiguration config = Configuration.getInstanceWithDefaultConfig(false);
        if (args[0].equals("start")) {
            if (!config.getCAIsEnabledForThisServer()) {
                System.out.println("The Certificate Authority Service is not enabled for this server.  It was not started.");
                System.exit(0);
            }
            mainServerThread = new MainServerThread();
            mainServerThread.checkStartupIsPossible();
            mainServerThread.start();
            System.out.println(MessageSet.getMessage("CAM_CRP_auto_ca_started"));
            try {
                mainServerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println(MessageSet.getMessage("CAM_CRP_auto_ca_stopped"));
        } else if (args[0].equals("stop")) {
            if (!config.getCAIsEnabledForThisServer()) {
                System.out.println("The Certificate Authority Service is not enabled for this server.  It was not started.");
                System.exit(0);
            }
            System.out.println(MessageSet.getMessage("CAM_CRP_auto_ca_stopped"));
        } else {
            System.out.println("Invalid parameter. Use start or stop");
            System.exit(-1);
        }
    }

    private static void writeNextCertSerialToFile() throws CAMCryptoException {
        try {
            FileWriter serialWriter = new FileWriter(SERIAL_FILE_NAME);
            serialWriter.write(nextCertSerial.toString());
            serialWriter.close();
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_cert_serial_update_error"));
        }
    }

    static {
        try {
            FileReader serialFile = new FileReader(SERIAL_FILE_NAME);
            BufferedReader bufSerialReader = new BufferedReader(serialFile);
            String serialStr = bufSerialReader.readLine();
            if (serialStr != null) {
                long nextSerialLong = Long.parseLong(serialStr);
                nextCertSerial = BigInteger.valueOf(nextSerialLong);
            }
            bufSerialReader.close();
            serialFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nextCertSerial == null) {
            nextCertSerial = BigInteger.ONE;
        }
    }
}

