/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.CAMX509KeyManager14;
import com.cognos.accman.jcam.crypto.misc.CAMX509TrustManager14;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.KeyStoreAccess;
import com.cognos.accman.res.MessageSet;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;

public class JSSEDynamicSocketFactoryInitializer {
    static final String defaultProtocol = "TLSv1.2";

    static SSLServerSocketFactory getJRE14ServerSocketFactory(String provider, String algorithm) throws CAMCryptoException {
        SSLContext sslctx = JSSEDynamicSocketFactoryInitializer.createSSLContext(provider, algorithm);
        return sslctx.getServerSocketFactory();
    }

    static SSLSocketFactory getJRE14SocketFactory(String provider, String algorithm) throws CAMCryptoException {
        SSLContext sslctx = JSSEDynamicSocketFactoryInitializer.createSSLContext(provider, algorithm);
        return sslctx.getSocketFactory();
    }

    static SSLContext createSSLContext(String provider, String algorithm) throws CAMCryptoException {
        KeyStore trustStore = KeyStoreAccess.getCAKeyStoreForSSLTrustManager();
        TrustManager[] tms = new TrustManager[]{new CAMX509TrustManager14(trustStore)};
        KeyManagerFactory kmf = null;
        char[] pwd = Configuration.getInstance().getCAKeyPassword().toCharArray();
        try {
            kmf = KeyManagerFactory.getInstance(algorithm, provider);
            kmf.init(KeyStoreAccess.getEncryptionKeyStore(), pwd);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_couldnt_setup_jsse_trust_manager"));
        }
        String encKeyPairAlias = "encryption";
        KeyManager[] kms = kmf.getKeyManagers();
        for (int i = 0; i < kms.length; ++i) {
            if (!(kms[i] instanceof X509KeyManager)) continue;
            kms[i] = new CAMX509KeyManager14(kms[i], encKeyPairAlias);
        }
        SSLContext sslctx = null;
        try {
            sslctx = SSLContext.getInstance(defaultProtocol, provider);
            sslctx.init(kms, tms, null);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_couldnt_setup_jsse_trust_manager"));
        }
        return sslctx;
    }

    static SSLServerSocketFactory getPKCS12ServerSocketFactory(String pkcs12File, String pkcs12FilePassword, String provider, String algorithm) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        SSLContext sslctx = null;
        sslctx = JSSEDynamicSocketFactoryInitializer.createPKCS12SSLContext(pkcs12File, pkcs12FilePassword, provider, algorithm, sslctx);
        return sslctx.getServerSocketFactory();
    }

    static SSLSocketFactory getPKCS12SocketFactory(String pkcs12File, String pkcs12FilePassword, String provider, String algorithm) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        SSLContext sslctx = null;
        sslctx = JSSEDynamicSocketFactoryInitializer.createPKCS12SSLContext(pkcs12File, pkcs12FilePassword, provider, algorithm, sslctx);
        return sslctx.getSocketFactory();
    }

    private static SSLContext createPKCS12SSLContext(String pkcs12File, String pkcs12FilePassword, String provider, String algorithm, SSLContext sslctx) throws CAMCryptoException, CertificateExpiredException, CertificateNotYetValidException {
        KeyStore keyStore = null;
        KeyStore.PrivateKeyEntry privatekKeyEntry = null;
        try (FileInputStream fis = new FileInputStream(pkcs12File);){
            keyStore = KeyStore.getInstance("PKCS12-DEF");
            keyStore.load(fis, pkcs12FilePassword.toCharArray());
            Enumeration<String> entryEnum = keyStore.aliases();
            while (entryEnum.hasMoreElements()) {
                String alias = entryEnum.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                privatekKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(pkcs12FilePassword.toCharArray()));
                break;
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_couldnt_setup_jsse_trust_manager"));
        }
        X509Certificate x509Cert = (X509Certificate)privatekKeyEntry.getCertificate();
        x509Cert.checkValidity();
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(algorithm, provider);
            tmf.init(keyStore);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_couldnt_setup_jsse_trust_manager"));
        }
        TrustManager[] tms = tmf.getTrustManagers();
        KeyManagerFactory kmf = null;
        try {
            kmf = KeyManagerFactory.getInstance(algorithm, provider);
            kmf.init(keyStore, pkcs12FilePassword.toCharArray());
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_couldnt_setup_jsse_trust_manager"));
        }
        KeyManager[] kms = kmf.getKeyManagers();
        try {
            sslctx = SSLContext.getInstance(defaultProtocol, provider);
            sslctx.init(kms, tms, null);
        }
        catch (Exception e) {
            throw new CAMCryptoException(e, MessageSet.getMessage("CAM_CRP_couldnt_setup_jsse_trust_manager"));
        }
        return sslctx;
    }
}

