/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.accman.jcam.crypto.misc;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IPFTraceLogger;
import com.cognos.accman.jcam.crypto.misc.KeyStoreManager;
import com.cognos.accman.jcam.crypto.misc.KeyStoreReader;
import com.cognos.accman.jcam.crypto.misc.KeyStoreWriter;
import com.cognos.accman.res.MessageSet;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;

public class KeyExpiryChecker {
    private static KeyStoreManager ksMgr = KeyStoreManager.getInstance();
    static IPFTraceLogger cskTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CSK");
    static IPFTraceLogger pkiTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.PKI");
    static IPFTraceLogger caTraceLogger = new IPFTraceLogger("Trace.CAM.JCAM.KeyManagement.CA");
    static Object calock = new Object();
    static Object csklock = new Object();

    public static boolean checkForCSKExpiry() throws CAMCryptoException {
        cskTraceLogger.logEnter();
        if (KeyExpiryChecker.hasCSKExpired()) {
            Configuration config = Configuration.getInstance();
            if (config.isMDMRunning()) {
                KeyStoreWriter.updateCSK();
                cskTraceLogger.logExit(true);
                return true;
            }
            KeyStoreWriter.syncCSKKeystoreWithCM();
            if (!KeyExpiryChecker.hasCSKExpired()) {
                cskTraceLogger.logExit(false);
                return false;
            }
            try {
                KeyStoreWriter.updateCSK();
                cskTraceLogger.logExit(true);
                return true;
            }
            catch (CAMCryptoException ce) {
                CAMCryptoException cce = new CAMCryptoException(ce, MessageSet.getMessage("CAM_CRP_csk_expired_renew_error"));
                cskTraceLogger.logExit(cce);
                throw cce;
            }
        }
        cskTraceLogger.logExit(false);
        return false;
    }

    public static boolean hasCSKExpired() throws CAMCryptoException {
        Date currentTime;
        Date expiryDate;
        cskTraceLogger.logEnter();
        Configuration config = Configuration.getInstance();
        String alias = config.getCSKAlias();
        Date cskCreationDate = null;
        try {
            KeyStore ks = ksMgr.getCSKKeystore();
            cskCreationDate = ks.getCreationDate(alias);
        }
        catch (KeyStoreException e) {
            String msg = MessageSet.getMessage("CAM_CRP_load_key_keystore_load", new String[]{alias});
            CAMCryptoException cce = new CAMCryptoException(e, msg);
            cskTraceLogger.logExit(cce);
            throw cce;
        }
        if (cskCreationDate != null && (expiryDate = new Date(cskCreationDate.getTime() + config.getCSKLifetime() * 86400000L)).before(currentTime = new Date())) {
            cskTraceLogger.logExit(true);
            return true;
        }
        cskTraceLogger.logExit(false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForEncryptionKeyExpiry() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Object object = calock;
        synchronized (object) {
            X509Certificate encCert = (X509Certificate)KeyStoreReader.getEncryptionCertificateFromKeystore();
            try {
                encCert.checkValidity();
            }
            catch (CertificateExpiredException e) {
                try {
                    KeyStoreWriter.updateEncryptionKeyPair();
                    pkiTraceLogger.logExit(true);
                    return true;
                }
                catch (CAMCryptoException ce) {
                    CAMCryptoException cce = new CAMCryptoException(ce, MessageSet.getMessage("CAM_CRP_enc_key_pair_expired_renew_error"));
                    pkiTraceLogger.logExit(cce);
                    throw cce;
                }
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
        }
        pkiTraceLogger.logExit(false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForSigningKeyExpiry() throws CAMCryptoException {
        pkiTraceLogger.logEnter();
        Object object = calock;
        synchronized (object) {
            X509Certificate signCert = (X509Certificate)KeyStoreReader.getSigningCertificate();
            try {
                signCert.checkValidity();
            }
            catch (CertificateExpiredException e) {
                try {
                    KeyStoreWriter.updateSigningKeyPair();
                    pkiTraceLogger.logExit(true);
                    return true;
                }
                catch (CAMCryptoException ce) {
                    CAMCryptoException cce = new CAMCryptoException(ce, MessageSet.getMessage("CAM_CRP_enc_key_pair_expired_renew_error"));
                    pkiTraceLogger.logExit(cce);
                    throw cce;
                }
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
        }
        pkiTraceLogger.logExit(false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForCAKeyExpiry() throws CAMCryptoException {
        caTraceLogger.logEnter();
        Object object = calock;
        synchronized (object) {
            X509Certificate caCert = (X509Certificate)KeyStoreReader.getCACertificate();
            try {
                caCert.checkValidity();
            }
            catch (CertificateExpiredException e) {
                try {
                    KeyStoreWriter.updateCAKeyPair();
                    caTraceLogger.logExit(true);
                    return true;
                }
                catch (CAMCryptoException ce) {
                    CAMCryptoException cce = new CAMCryptoException(ce, MessageSet.getMessage("CAM_CRP_ca_key_pair_expired_renew_error"));
                    caTraceLogger.logExit(cce);
                    throw cce;
                }
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
        }
        caTraceLogger.logExit(false);
        return false;
    }
}

