/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.internal;

import com.ibm.smarts.common.pipeline.DeltaAnalysisScope;
import com.ibm.smarts.common.pipeline.SampleQueryContext;
import com.ibm.smarts.common.pipeline.SmartsTaskContext;
import com.ibm.smarts.pipeline.apis.IContext;
import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import com.ibm.smarts.pipeline.internal.FlowData;
import com.ibm.smarts.pipeline.internal.Task;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.smartsmodule.builder.SmartsModuleBuilderSettings;
import com.ibm.smarts.smartsmodule.builder.tasks.ClassifyColumnsTask;
import com.ibm.smarts.smartsmodule.builder.tasks.ColumnEmbeddingTask;
import com.ibm.smarts.smartsmodule.builder.tasks.InitialPublishingTask;
import com.ibm.smarts.smartsmodule.builder.tasks.PredictTask;
import com.ibm.smarts.smartsmodule.builder.tasks.PublishingTask;
import com.ibm.smarts.smartsmodule.builder.tasks.SamplesTask;
import com.ibm.smarts.smartsmodule.builder.tasks.TokenizeColumnsTask;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class AnalysisFlowBuilder {
    public static List<FlowData<SmartsTaskContext>> buildAnalysisFlow(@Nonnull String smartsModuleUri, @Nonnull SmartsModule smartsModule, @Nonnull Map<String, List<DeltaAnalysisScope>> analysisScopes, @Nonnull SmartsModuleBuilderSettings settings) {
        ArrayList<FlowData<SmartsTaskContext>> flows = new ArrayList();
        if (settings.isOverwriting()) {
            flows = smartsModule.getDatasets().stream().filter(d -> !analysisScopes.containsKey(d.getId())).map(d -> AnalysisFlowBuilder.buildPublishOnlyAnalysisFlow(smartsModuleUri, d.getId(), settings)).collect(Collectors.toList());
        }
        flows.addAll(analysisScopes.entrySet().stream().map(e -> AnalysisFlowBuilder.buildAnalysisFlow(smartsModuleUri, (String)e.getKey(), (List)e.getValue(), settings)).collect(Collectors.toList()));
        return flows;
    }

    public static FlowData<SmartsTaskContext> buildPublishOnlyAnalysisFlow(@Nonnull String smartsModuleUri, @Nonnull String datasetId, @Nonnull SmartsModuleBuilderSettings settings) {
        SmartsTaskContext context = AnalysisFlowBuilder.createSmartsTaskContext(smartsModuleUri, datasetId, null, settings);
        context.setStatus(ExecutionStatus.COMPLETE);
        return new FlowData((IContext)context, Collections.emptyList(), PublishingTask.getInstance(), null);
    }

    public static FlowData<SmartsTaskContext> buildAnalysisFlow(@Nonnull String SmartsModuleUri, @Nonnull String datasetId, @Nonnull List<DeltaAnalysisScope> analysisScopes, @Nonnull SmartsModuleBuilderSettings settings) {
        SmartsTaskContext context = AnalysisFlowBuilder.createSmartsTaskContext(SmartsModuleUri, datasetId, analysisScopes, settings);
        boolean isGlobalDataset = context.getDatasetId().equals("_global_calculations") || context.getDatasetId().equals("_global_namedSets");
        List<Task<SmartsTaskContext>> tasks = AnalysisFlowBuilder.convertToTasks(analysisScopes, settings.isDeepAnalysis(), isGlobalDataset, settings.isEmbeddingEnabled());
        if (settings.isPublishing()) {
            return new FlowData((IContext)context, tasks, InitialPublishingTask.getInstance(), PublishingTask.getInstance());
        }
        return new FlowData((IContext)context, tasks);
    }

    private static SmartsTaskContext createSmartsTaskContext(String SmartsModuleUri, String datasetId, List<DeltaAnalysisScope> analysisScopes, SmartsModuleBuilderSettings settings) {
        SmartsTaskContext context = new SmartsTaskContext(SmartsModuleUri, datasetId, analysisScopes, settings.getRequestContext(), settings.getStoreProvider());
        context.setMasterSmartsModuleURI(settings.getMasterSmartsModuleUri());
        context.setProperty("nlp", (Object)settings.getNLP());
        context.setProperty("dataProvider", (Object)settings.getDataProvider());
        context.setProperty("moduleHasOverwrites", (Object)settings.moduleHasOverwrites());
        context.setProperty("prettifyLabels", (Object)settings.getSmartsModuleOptions().isPrettifyLabels());
        SampleQueryContext sampleContext = settings.getSampleQueryContext();
        if (sampleContext != null) {
            context.setProperty("SampleQueryContext", (Object)sampleContext);
        }
        return context;
    }

    private static List<Task<SmartsTaskContext>> convertToTasks(List<DeltaAnalysisScope> analysisScopes, boolean isDeepAnalysis, boolean isGlobalDataset, boolean isEmbeddingEnabled) {
        ArrayList<Task<SmartsTaskContext>> tasks = new ArrayList<Task<SmartsTaskContext>>();
        if (isDeepAnalysis && !isGlobalDataset) {
            tasks.add(SamplesTask.getInstance());
            tasks.add(PredictTask.getInstance());
            if (isEmbeddingEnabled) {
                tasks.add(ColumnEmbeddingTask.getInstance());
            }
        }
        analysisScopes.forEach(delta -> {
            if (delta.getScopedTask() == DeltaAnalysisScope.ScopedTask.ALL) {
                tasks.add(TokenizeColumnsTask.getInstance());
                tasks.add(ClassifyColumnsTask.getInstance());
            } else if (delta.getScopedTask() == DeltaAnalysisScope.ScopedTask.TOKENIZE) {
                tasks.add(TokenizeColumnsTask.getInstance());
            } else if (delta.getScopedTask() == DeltaAnalysisScope.ScopedTask.CLASSIFY) {
                tasks.add(ClassifyColumnsTask.getInstance());
            }
        });
        return tasks;
    }
}

