/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.internal;

import com.ibm.smarts.core.exceptions.InternalException;
import com.ibm.smarts.pipeline.apis.IProgressUpdater;
import com.ibm.smarts.pipeline.constants.ExecutionStatus;
import com.ibm.smarts.pipeline.progress.TaskStatus;
import com.ibm.smarts.schema.AnalysisPhase;
import com.ibm.smarts.schema.AnalysisStateType;
import com.ibm.smarts.schema.AnalysisTask;
import com.ibm.smarts.schema.AnalysisTaskStatus;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.smartsmodule.builder.SmartsModuleBuilder;
import com.ibm.smarts.store.api.provider.IModuleStore;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class ModuleStoreProgressUpdater
implements IProgressUpdater {
    private IModuleStore moduleStore;
    private Consumer<String> publisher;
    private AtomicInteger counter = new AtomicInteger(0);
    private int publishingBatchSize;

    public ModuleStoreProgressUpdater(IModuleStore moduleStore, Consumer<String> publisher, int publishingBatchSize) {
        this.moduleStore = moduleStore;
        this.publisher = publisher;
        this.publishingBatchSize = publishingBatchSize > 0 ? publishingBatchSize : 1;
    }

    public void setBatchProgress(String batchId, ExecutionStatus executionStatus) {
        SmartsModule smartsModule = this.moduleStore.getById(batchId);
        if (smartsModule == null) {
            throw new InternalException("SmartsModule with Id: {0} is absent in the module store, while setting batch progress ", new Object[]{batchId});
        }
        smartsModule.setAnalysisState(this.getAnalysisStateTypeFromExecutionStatus(executionStatus));
    }

    public void setAtomicProgress(String batchId, String atomId, ExecutionStatus executionStatus) {
        int finishes;
        SmartsModule smartsModule = this.moduleStore.getById(batchId);
        if (smartsModule == null) {
            throw new InternalException("SmartsModule with Id: {0} is absent in the module store, while setting batch progress ", new Object[]{batchId});
        }
        DatasetInfo datasetInfo = SmartsModuleBuilder.mapDatasetInfo(smartsModule, atomId);
        if (datasetInfo == null) {
            throw new InternalException("Dataset with Id: {0} is absent in the module store, while setting atomic progress ", new Object[]{atomId});
        }
        if (datasetInfo.getAnalysisPhases().isEmpty()) {
            throw new InternalException("Analysis Phase for the Dataset with Id : {0} is not available, while setting atomic progress ", new Object[]{atomId});
        }
        ((AnalysisPhase)datasetInfo.getAnalysisPhases().get(0)).setAnalysisState(this.getAnalysisStateTypeFromExecutionStatus(executionStatus));
        if (((AnalysisPhase)datasetInfo.getAnalysisPhases().get(0)).getAnalysisState() != AnalysisStateType.IN_PROGRESS && (finishes = this.counter.incrementAndGet()) % this.publishingBatchSize == 0) {
            this.publisher.accept(batchId);
        }
    }

    public void setTaskProgress(String batchId, String atomId, String taskId, TaskStatus taskStatus) {
        SmartsModule smartsModule = this.moduleStore.getById(batchId);
        if (smartsModule == null) {
            throw new InternalException("SmartsModule with Id: {0} is absent in the module store, while setting batch progress ", new Object[]{batchId});
        }
        DatasetInfo datasetInfo = SmartsModuleBuilder.mapDatasetInfo(smartsModule, atomId);
        if (datasetInfo == null) {
            throw new InternalException("Dataset with Id: {0} is absent in the module store, while setting task progress ", new Object[]{atomId});
        }
        if (datasetInfo.getAnalysisPhases().isEmpty()) {
            throw new InternalException("Analysis Phase for the Dataset with Id : {0} is not available, while setting task progress ", new Object[]{atomId});
        }
        List analysisTasks = ((AnalysisPhase)datasetInfo.getAnalysisPhases().get(0)).getCompletedTasks();
        if (analysisTasks.isEmpty()) {
            throw new InternalException("Analysis tasks for the Dataset with Id  : {0} are not available, while setting task progress ", new Object[]{atomId});
        }
        AnalysisTask analysisTask = analysisTasks.stream().filter(t -> t.getId().equalsIgnoreCase(taskId)).findFirst().orElse(null);
        if (analysisTask == null) {
            throw new InternalException("Analysis task with Id  : {0} is not available, while setting task progress ", new Object[]{taskId});
        }
        AnalysisTaskStatus analysisTaskStatus = this.getAnalysisTaskStatusFromTaskStatus(taskStatus);
        analysisTask.setStatus(analysisTaskStatus);
    }

    private AnalysisTaskStatus getAnalysisTaskStatusFromTaskStatus(TaskStatus taskStatus) {
        AnalysisTaskStatus analysisTaskStatus = new AnalysisTaskStatus();
        analysisTaskStatus.getErrors().addAll(taskStatus.getErrors());
        analysisTaskStatus.getWarnings().addAll(taskStatus.getWarnings());
        analysisTaskStatus.getDataSourceException().addAll(taskStatus.getDataSourceExceptions());
        if (taskStatus.getStatus() != null && taskStatus.getStatus().equals((Object)ExecutionStatus.COMPLETE)) {
            analysisTaskStatus.setSuccess(true);
        }
        return analysisTaskStatus;
    }

    private AnalysisStateType getAnalysisStateTypeFromExecutionStatus(ExecutionStatus executionStatus) {
        AnalysisStateType analysisStateType;
        switch (executionStatus) {
            case NOT_STARTED: {
                analysisStateType = AnalysisStateType.IN_PROGRESS;
                break;
            }
            case IN_PROGRESS: {
                analysisStateType = AnalysisStateType.IN_PROGRESS;
                break;
            }
            case ERROR: {
                analysisStateType = AnalysisStateType.FAILED;
                break;
            }
            case CANCELLED_BY_ERROR: {
                analysisStateType = AnalysisStateType.FAILED;
                break;
            }
            case CANCELLED: {
                analysisStateType = AnalysisStateType.CANCELED;
                break;
            }
            case COMPLETE: {
                analysisStateType = AnalysisStateType.DONE;
                break;
            }
            default: {
                analysisStateType = AnalysisStateType.IN_PROGRESS;
            }
        }
        return analysisStateType;
    }
}

