/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.smartsmodule.builder.internal;

import com.ibm.bi.platform.moser.common.generated.metadata.Module;
import com.ibm.bi.platform.moser.common.generated.metadata.QueryItem;
import com.ibm.bi.platform.moser.common.generated.metadata.QuerySubject;
import com.ibm.smarts.ca.core.impl.SmartsCaCoreHelper;
import com.ibm.smarts.core.rest.client.util.JaxRs20Exceptions;
import com.ibm.smarts.core.util.RequestContext;
import com.ibm.smarts.model.builder.SmartsModuleInfo;
import com.ibm.smarts.model.builder.SmartsModuleOptions;
import com.ibm.smarts.model.common.util.ModuleUtil;
import com.ibm.smarts.model.common.util.SmartsModuleBuilder;
import com.ibm.smarts.schema.AnalysisScope;
import com.ibm.smarts.schema.BaseItemObject;
import com.ibm.smarts.schema.BaseObject;
import com.ibm.smarts.schema.DatasetInfo;
import com.ibm.smarts.schema.DatasetType;
import com.ibm.smarts.schema.InScopeTable;
import com.ibm.smarts.schema.ItemType;
import com.ibm.smarts.schema.SmartsModule;
import com.ibm.smarts.schema.util.SmartsModuleFactory;
import com.ibm.smarts.schema.util.SmartsModuleUtil;
import com.ibm.smarts.smartsmodule.builder.SmartsModuleBuilderSettings;
import com.ibm.smarts.smartsmodule.builder.exceptions.SmartsBuilderException;
import com.ibm.smarts.smartsmodule.builder.internal.CommonUtil;
import com.ibm.smarts.store.api.provider.IPersistenceProvider;
import com.ibm.smarts.store.api.query.IRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartsModulePreProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartsModulePreProcessor.class);

    private SmartsModulePreProcessor() {
    }

    public static SmartsModule process(Module module, SmartsModuleInfo smartsModuleInfo, SmartsModuleBuilderSettings settings) throws SmartsBuilderException {
        String resoureceURI;
        if (settings == null) {
            throw new SmartsBuilderException("settings are required");
        }
        AnalysisScope analysisScope = settings.getAnalysisScope();
        boolean isDeepAnalysis = settings.isDeepAnalysis();
        boolean isUpdateSmartsModule = settings.isUpdate();
        SmartsModule smartsModule = smartsModuleInfo != null ? smartsModuleInfo.getSmartsModule() : null;
        String string = resoureceURI = smartsModuleInfo != null ? smartsModuleInfo.getSmartsModuleUri() : null;
        if (smartsModule != null) {
            if (analysisScope != null) {
                SmartsModulePreProcessor.shrinkSmartsModule(smartsModule, analysisScope);
            }
        } else if (isUpdateSmartsModule) {
            try {
                smartsModule = SmartsModulePreProcessor.retrieveSmartsModuleFromStorage(settings, resoureceURI, analysisScope);
            }
            catch (IOException e) {
                throw new SmartsBuilderException((Exception)e);
            }
        }
        if (smartsModule != null) {
            return smartsModule;
        }
        if (!isDeepAnalysis) {
            return SmartsModulePreProcessor.getInitialSmartsModuleWithInheritance(settings.getRequestContext(), module, settings.getPersistenceProvider(), settings.getSmartsModuleOptions());
        }
        return SmartsModulePreProcessor.createEmptySmartsModule(module);
    }

    public static void shrinkSmartsModule(SmartsModule smartsModule, AnalysisScope analysisScope) throws SmartsBuilderException {
        if (analysisScope == null) {
            return;
        }
        Set tableIds = analysisScope.getInScopeTables().stream().map(InScopeTable::getTableID).collect(Collectors.toSet());
        Set excludedTableIds = analysisScope.getOutScopeTables().stream().map(InScopeTable::getTableID).collect(Collectors.toSet());
        Set smDSIds = smartsModule.getDatasets().stream().map(BaseObject::getId).collect(Collectors.toSet());
        if (smDSIds.isEmpty()) {
            return;
        }
        if (!smDSIds.containsAll(tableIds)) {
            throw new SmartsBuilderException("tableIDs in analysisScope were not found in SmartsModule");
        }
        if (!tableIds.isEmpty()) {
            smartsModule.getDatasets().removeIf(ds -> !tableIds.contains(ds.getId()));
        }
        smartsModule.getDatasets().removeIf(ds -> excludedTableIds.contains(ds.getId()));
    }

    public static SmartsModule retrieveSmartsModuleFromStorage(SmartsModuleBuilderSettings settings, String resourceURI, AnalysisScope analysisScope) throws IOException, SmartsBuilderException {
        if (resourceURI == null) {
            throw new SmartsBuilderException("Resource URI must be provided to retrieve the smartsModule");
        }
        String id = SmartsCaCoreHelper.extractModuleId((String)resourceURI);
        SmartsModule smartsModule = (SmartsModule)settings.getPersistenceProvider().get(settings.getRequestContext(), id, Collections.emptyList(), settings.getSmartsModuleOptions()).getRecord();
        if (smartsModule == null) {
            throw new SmartsBuilderException("Can't update a non existent smarts module");
        }
        SmartsModulePreProcessor.shrinkSmartsModule(smartsModule, analysisScope);
        return smartsModule;
    }

    private static SmartsModule getInitialSmartsModuleWithInheritance(RequestContext context, Module module, IPersistenceProvider persistenceProvider, SmartsModuleOptions options) throws SmartsBuilderException {
        if (module == null) {
            throw new SmartsBuilderException("No Module provided");
        }
        HashMap<String, SmartsModule> parentSmartsModules = new HashMap<String, SmartsModule>();
        if (persistenceProvider != null) {
            for (Module.UseSpec spec : module.getUseSpec()) {
                SmartsModule sm = null;
                String storeID = spec.getStoreID();
                if (storeID != null) {
                    try {
                        IRecord record = persistenceProvider.get(context, storeID, Collections.emptyList(), options);
                        sm = record != null ? (SmartsModule)record.getRecord() : null;
                    }
                    catch (JaxRs20Exceptions.ResponseProcessingException e) {
                        sm = null;
                    }
                }
                if (sm == null) continue;
                parentSmartsModules.put(spec.getIdentifier(), sm);
            }
        }
        return SmartsModulePreProcessor.inheritFromParentsSmartsModules(module, parentSmartsModules);
    }

    public static SmartsModule inheritFromParentsSmartsModules(Module module, Map<String, SmartsModule> parentSmartsModules) {
        HashMap<String, String> dsId2ParentDsId = new HashMap<String, String>();
        SmartsModule sm = SmartsModulePreProcessor.getNewSmartsModule(module, parentSmartsModules, dsId2ParentDsId);
        SmartsModulePreProcessor.removeExcessBivariatesAndLogicalGroups(sm, parentSmartsModules, dsId2ParentDsId);
        return sm;
    }

    private static void removeExcessBivariatesAndLogicalGroups(SmartsModule sm, Map<String, SmartsModule> parentSmartsModules, Map<String, String> dsId2ParentDsId) {
        if (parentSmartsModules != null && !parentSmartsModules.isEmpty()) {
            HashMap<String, List<String>> dsIDToColumnIds = new HashMap<String, List<String>>();
            SmartsModulePreProcessor.populateDsIdToColIdsMap(parentSmartsModules.values(), dsIDToColumnIds);
            sm.getDatasets().forEach(ds -> {
                List currentColumnIds = SmartsModuleUtil.getFlattenedColumns((BaseItemObject)ds).stream().map(BaseObject::getId).collect(Collectors.toList());
                ((List)dsIDToColumnIds.get(dsId2ParentDsId.get(ds.getId()))).stream().filter(id -> !currentColumnIds.contains(id)).forEach(id -> {
                    CommonUtil.cleanupBivariates(ds, id);
                    CommonUtil.cleanupLogicalGroups(ds, id);
                });
            });
        }
    }

    private static SmartsModule getSMDataSetWithFilteredColumnInfo(SmartsModule parentSmartsModule, String parentQuerySubjectId, QuerySubject moduleQS, Map<String, QueryItem> idToVisibleQueryItemsMapFromModule) {
        SmartsModule shellSmartsModule = null;
        Optional<DatasetInfo> dataset = parentSmartsModule.getDatasets().stream().filter(ds -> ds.getId() != null && ds.getId().equals(parentQuerySubjectId)).findAny();
        DatasetInfo datasetWithFilteredColumns = dataset.map(datasetInfo -> SmartsModulePreProcessor.copyDataSetInfoFilteringOnColumnsFound(datasetInfo, moduleQS, idToVisibleQueryItemsMapFromModule)).orElse(null);
        if (datasetWithFilteredColumns != null) {
            shellSmartsModule = SmartsModuleFactory.createSmartsModule();
            shellSmartsModule.setId(parentSmartsModule.getId());
            shellSmartsModule.getDatasets().add(datasetWithFilteredColumns);
        }
        return shellSmartsModule;
    }

    private static DatasetInfo copyDataSetInfoFilteringOnColumnsFound(DatasetInfo datasetFromParent, QuerySubject moduleQS, Map<String, QueryItem> idToVisibleQueryItemsMapFromModule) {
        DatasetInfo result = new DatasetInfo();
        result.setId(moduleQS.getIdentifier());
        result.setIdForExpression(moduleQS.getIdForExpression());
        result.setName(datasetFromParent.getName());
        result.setLabel(datasetFromParent.getLabel());
        result.setDescription(datasetFromParent.getDescription());
        result.setDescriptionLabel(datasetFromParent.getDescriptionLabel());
        result.setComment(datasetFromParent.getComment());
        result.setCommentLabel(datasetFromParent.getCommentLabel());
        result.setType(datasetFromParent.getType());
        result.getLogicalGroups().addAll(datasetFromParent.getLogicalGroups());
        result.getHierarchies().addAll(datasetFromParent.getHierarchies());
        result.getBivariateStatistics().addAll(datasetFromParent.getBivariateStatistics());
        result.getAnalysisPhases().addAll(datasetFromParent.getAnalysisPhases());
        result.getColumnEmbeddings().addAll(datasetFromParent.getColumnEmbeddings());
        if (idToVisibleQueryItemsMapFromModule != null && !idToVisibleQueryItemsMapFromModule.isEmpty()) {
            List<ItemType> items = SmartsModulePreProcessor.getFilteredItems(datasetFromParent, idToVisibleQueryItemsMapFromModule);
            result.getItem().addAll(items);
        } else {
            result.getItem().addAll(datasetFromParent.getItem());
        }
        return result;
    }

    private static List<ItemType> getFilteredItems(DatasetInfo parentDataSet, Map<String, QueryItem> idToQIMapFromModule) {
        ArrayList<ItemType> filteredItemsFromParent = new ArrayList<ItemType>(parentDataSet.getItem());
        SmartsModulePreProcessor.filterItems(filteredItemsFromParent, parentDataSet.getId(), idToQIMapFromModule);
        return filteredItemsFromParent;
    }

    private static void filterItems(List<ItemType> itemsFromParent, String parentId, Map<String, QueryItem> idToQiMap) {
        ListIterator<ItemType> itemsFromParentItr = itemsFromParent.listIterator();
        while (itemsFromParentItr.hasNext()) {
            ItemType type = itemsFromParentItr.next();
            if (type.getFolder() != null) {
                SmartsModulePreProcessor.filterItems(type.getFolder().getItem(), parentId, idToQiMap);
                if (!type.getFolder().getItem().isEmpty()) continue;
                itemsFromParentItr.remove();
                continue;
            }
            if (!idToQiMap.containsKey(CommonUtil.getUniqueId(parentId, type.getColumn().getId()))) {
                itemsFromParentItr.remove();
                continue;
            }
            String idForExpression = idToQiMap.get(CommonUtil.getUniqueId(parentId, type.getColumn().getId())).getIdForExpression();
            type.getColumn().setIdForExpression(idForExpression);
            SmartsModulePreProcessor.filterItems(type.getColumn().getItem(), CommonUtil.getUniqueId(parentId, type.getColumn().getId()), idToQiMap);
        }
    }

    private static void populateDsIdToColIdsMap(Collection<SmartsModule> sms, HashMap<String, List<String>> dsIDToColumnIds) {
        sms.forEach(smartsModule -> {
            List datasetInfoList = smartsModule.getDatasets();
            datasetInfoList.forEach(datasetInfo -> dsIDToColumnIds.put(datasetInfo.getId(), SmartsModuleUtil.getFlattenedColumns((BaseItemObject)datasetInfo).stream().map(BaseObject::getId).collect(Collectors.toList())));
        });
    }

    private static SmartsModule getNewSmartsModule(Module module, Map<String, SmartsModule> parentSmartsModules, Map<String, String> dsId2ParentDsId) {
        SmartsModule sm = SmartsModulePreProcessor.createEmptySmartsModule(module);
        Consumer<QuerySubject> copyMatchingParentQS = qs -> {
            SmartsModule smParent;
            List refs = qs.getRef();
            if (ModuleUtil.isSingleFMSourceModule((Module)module)) {
                dsId2ParentDsId.put(qs.getIdentifier(), qs.getIdentifier());
                Map<String, QueryItem> idToQuerySubjectMap = CommonUtil.getVisibleQueryItems(qs, qs.getIdentifier());
                smParent = SmartsModulePreProcessor.getSMDataSetWithFilteredColumnInfo((SmartsModule)parentSmartsModules.values().iterator().next(), qs.getIdentifier(), qs, idToQuerySubjectMap);
            } else {
                String ref2Parent = !refs.isEmpty() ? (String)refs.get(0) : qs.getIdentifier();
                smParent = ref2Parent == null || ref2Parent.indexOf(46) == -1 ? null : SmartsModulePreProcessor.getParentSmartsModule(parentSmartsModules, qs, ref2Parent, dsId2ParentDsId);
            }
            if (smParent != null) {
                DatasetInfo dsInfo = (DatasetInfo)smParent.getDatasets().get(0);
                dsInfo.setType(DatasetType.DATASETS);
                dsInfo.setId(qs.getIdentifier());
                dsInfo.setIdForExpression(qs.getIdForExpression());
                sm.getDatasets().add(dsInfo);
            }
        };
        if (parentSmartsModules != null && !parentSmartsModules.isEmpty()) {
            module.getQuerySubject().stream().filter(qs -> SmartsModuleBuilder.isQuerySubjectVisible((Module)module, (QuerySubject)qs)).forEach(copyMatchingParentQS);
        }
        return sm;
    }

    private static SmartsModule createEmptySmartsModule(Module module) {
        SmartsModule sm = SmartsModuleFactory.createSmartsModule();
        if (module == null) {
            return sm;
        }
        sm.setId(module.getIdentifier());
        sm.setName(module.getLabel());
        sm.setComment(module.getComment());
        sm.setDescription(module.getDescription());
        XMLGregorianCalendar cal = null;
        try {
            cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            LOGGER.error(String.format("Exception while setting smarts module creation time: %s", e));
        }
        sm.setModuleLastModifiedTime(cal);
        sm.setModuleCreationTime(cal);
        return sm;
    }

    private static SmartsModule getParentSmartsModule(Map<String, SmartsModule> parentSmartsModules, QuerySubject qs, String id, Map<String, String> dsId2ParentDsId) {
        int index = id.indexOf(46);
        String useSpecId = id.substring(0, index);
        String parentQsId = id.substring(index + 1);
        dsId2ParentDsId.put(qs.getIdentifier(), parentQsId);
        Map<String, QueryItem> qis = CommonUtil.getVisibleQueryItems(qs, parentQsId);
        SmartsModule smParent = SmartsModulePreProcessor.getSMDataSetWithFilteredColumnInfo(parentSmartsModules.get(useSpecId), parentQsId, qs, qis);
        return smParent;
    }
}

