/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.smarts.core.rest.client.simple;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.smarts.core.rest.client.simple.SimpleRestClientConfig;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRestClient
implements Closeable {
    private static final String UTF_8 = "utf-8";
    private static Logger LOGGER = LoggerFactory.getLogger(SimpleRestClient.class);
    protected HttpClient client;
    protected SimpleRestClientConfig config;
    protected HttpClientContext context;
    protected HttpResponse response;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private String trustToken;

    @Deprecated
    protected SimpleRestClient(HttpClient client, SimpleRestClientConfig config) {
        this(client, new HttpClientContext(), config);
    }

    protected SimpleRestClient(HttpClient client, HttpClientContext context, SimpleRestClientConfig config) {
        this.client = client;
        this.config = config;
        this.context = context;
    }

    protected URI buildURI(String path) throws URISyntaxException {
        if (path.startsWith("http")) {
            return new URI(path);
        }
        UriBuilder builder = UriBuilder.fromUri((URI)this.config.getBaseURI());
        int n = path.indexOf(63);
        if (n == -1) {
            builder.path(path);
        } else {
            builder.path(path.substring(0, n));
            builder.replaceQuery(path.substring(n + 1));
        }
        return builder.build(new Object[0]);
    }

    @Override
    public void close() throws IOException {
        this.prepareForNewRequest();
    }

    protected void prepareForNewRequest() {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            this.response = null;
        }
    }

    public int getResource(String path) throws IOException {
        HttpRequestBase method = this.createGetRequest(path);
        try {
            return this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    public ObjectNode getResponseAsJsonObject() throws IOException {
        InputStream response = this.getResponseStream();
        if (response != null) {
            return (ObjectNode)new ObjectMapper().readTree(response);
        }
        return null;
    }

    public JsonNode getResource(String path, String mediaType) throws IOException {
        JsonNode resource = null;
        try {
            resource = new ObjectMapper().readTree(this.getResourceStream(path, mediaType));
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return resource;
    }

    public InputStream getResourceStream(String path, String mediaType) throws IOException {
        InputStream is = null;
        this.accept(mediaType);
        HttpRequestBase method = this.createGetRequest(path);
        try {
            this.executeMethod(method);
            is = this.getResponseStream();
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return is;
    }

    protected HttpEntity getEntity() {
        if (this.response == null) {
            return null;
        }
        Header[] encoding = this.response.getHeaders("Content-Encoding");
        Object respEntity = encoding != null && encoding.length > 0 && encoding[0].getValue().equalsIgnoreCase("gzip") ? new GzipDecompressingEntity(this.response.getEntity()) : this.response.getEntity();
        return respEntity;
    }

    public InputStream getResponseStream() throws IOException {
        HttpEntity entity = this.getEntity();
        if (entity != null) {
            return entity.getContent();
        }
        return null;
    }

    public String getMediaType() {
        Header[] headers;
        String mediaType = null;
        if (this.response != null && (headers = this.response.getHeaders("Content-Type")) != null && headers.length > 0) {
            mediaType = headers[0].getValue();
        }
        return mediaType;
    }

    public int createResource(String path, String mediaType, JsonNode model) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPostRequest(path, mediaType, model);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int createResource(String path, String mediaType, long length, InputStream stream) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPostRequest(path, mediaType, length, stream);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int createResource(String path, HttpEntity entity) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPostRequest(path, entity);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int updateResource(String path, String mediaType, JsonNode model) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPutRequest(path, mediaType, model);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int updateResource(String path, String mediaType, long length, InputStream stream) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createPutRequest(path, mediaType, length, stream);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public int deleteResource(String path, String mediaType) throws IOException {
        int sc = -1;
        HttpRequestBase method = this.createDeleteRequest(path, mediaType);
        try {
            sc = this.reallyExecuteMethod(method, false);
        }
        catch (IOException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            this.close();
        }
        return sc;
    }

    public String getHeader(String name) {
        return this.responseHeaders.get(name.toLowerCase());
    }

    public String getResponseHeader(String name) {
        return this.responseHeaders.get(name.toLowerCase());
    }

    public Header[] getResponseHeaders() {
        if (this.response != null) {
            return this.response.getAllHeaders();
        }
        return null;
    }

    public void setRequestHeader(String name, String value) {
        this.config.setRequestHeader(name, value);
    }

    public void clearRequestHeaders() {
        this.config.clearRequestHeaders();
    }

    public Collection<Header> getRequestHeaders() {
        return this.config.getRequestHeaders();
    }

    public JsonNode getErrorResponse() throws IOException {
        InputStream is = this.getErrorResponseStream();
        return is != null ? new ObjectMapper().readTree(is) : null;
    }

    public InputStream getErrorResponseStream() throws IOException {
        Header[] contentType;
        if (this.response == null) {
            return null;
        }
        InputStream errorStream = null;
        if (this.response.getStatusLine().getStatusCode() >= 400 && (contentType = this.response.getHeaders("Content-Type")) != null && contentType.length > 0 && contentType[0].getValue().equalsIgnoreCase("application/json")) {
            errorStream = this.getResponseStream();
        }
        return errorStream;
    }

    public String getErrorResponseString() throws IOException {
        if (this.response == null) {
            return null;
        }
        if (this.response.getStatusLine().getStatusCode() >= 400) {
            return EntityUtils.toString((HttpEntity)this.getEntity());
        }
        return null;
    }

    protected void setHeaders(Header[] headers) {
        this.responseHeaders.clear();
        for (Header header : headers) {
            this.responseHeaders.put(header.getName().toLowerCase(), header.getValue());
        }
    }

    protected int executeMethod(HttpRequestBase method) throws IOException {
        return this.reallyExecuteMethod(method, true);
    }

    @Deprecated
    protected int executeMethod(HttpRequestBase method, boolean throwOnError) throws IOException {
        return this.reallyExecuteMethod(method, throwOnError);
    }

    protected int reallyExecuteMethod(HttpRequestBase method, boolean throwOnError) throws IOException {
        this.prepareForNewRequest();
        this.response = this.client.execute((HttpUriRequest)method, (HttpContext)this.context);
        int statusCode = this.response.getStatusLine().getStatusCode();
        if (throwOnError && statusCode >= 400) {
            throw new RuntimeException(String.format("[%d] %s", statusCode, this.response.getStatusLine().getReasonPhrase()));
        }
        this.setHeaders(this.response.getAllHeaders());
        return statusCode;
    }

    protected void setupMethod(HttpRequestBase method, String path) {
        try {
            this.close();
            method.setURI(this.buildURI(path));
            this.copyRequestHeaders(method);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void copyRequestHeaders(HttpRequestBase method) {
        for (Header header : this.getRequestHeaders()) {
            method.addHeader(header);
        }
    }

    protected HttpRequestBase createGetRequest(String path) {
        HttpGet httpGet = new HttpGet();
        this.setupMethod((HttpRequestBase)httpGet, path);
        return httpGet;
    }

    protected HttpRequestBase createHeadRequest(String path) {
        HttpHead httpHead = new HttpHead();
        this.setupMethod((HttpRequestBase)httpHead, path);
        return httpHead;
    }

    protected HttpRequestBase createPostRequest(String path, String mediaType, JsonNode resource) {
        byte[] body = resource.toString().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(body);
        return this.createPostRequest(path, mediaType, body.length, is);
    }

    protected HttpRequestBase createPostRequest(String path, String mediaType, long length, InputStream stream) {
        InputStreamEntity entity = length != -1L ? new InputStreamEntity(stream, length, ContentType.create((String)mediaType)) : new InputStreamEntity(stream, ContentType.create((String)mediaType));
        return this.createPostRequest(path, (HttpEntity)entity);
    }

    protected HttpRequestBase createPostRequest(String path, HttpEntity entity) {
        HttpPost httpPost = new HttpPost();
        this.setupMethod((HttpRequestBase)httpPost, path);
        httpPost.setEntity(entity);
        return httpPost;
    }

    protected HttpRequestBase createPutRequest(String path, String mediaType, JsonNode resource) {
        byte[] body = resource.toString().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(body);
        this.accept(mediaType);
        return this.createPutRequest(path, mediaType, body.length, is);
    }

    protected HttpRequestBase createPutRequest(String path, String mediaType, long length, InputStream stream) {
        InputStreamEntity entity = length != -1L ? new InputStreamEntity(stream, length, ContentType.create((String)mediaType)) : new InputStreamEntity(stream, ContentType.create((String)mediaType));
        return this.createPutRequest(path, (HttpEntity)entity);
    }

    protected HttpRequestBase createPutRequest(String path, HttpEntity entity) {
        HttpPut httpPut = new HttpPut();
        this.setupMethod((HttpRequestBase)httpPut, path);
        httpPut.setEntity(entity);
        return httpPut;
    }

    protected HttpRequestBase createDeleteRequest(String path, String mediaType) {
        this.accept(mediaType);
        return this.createDeleteRequest(path);
    }

    protected HttpRequestBase createDeleteRequest(String path) {
        HttpDelete httpDelete = new HttpDelete();
        this.setupMethod((HttpRequestBase)httpDelete, path);
        return httpDelete;
    }

    protected HttpRequestBase createPatchRequest(String path, HttpEntity entity) {
        HttpPatch httpPatch = new HttpPatch();
        this.setupMethod((HttpRequestBase)httpPatch, path);
        httpPatch.setEntity(entity);
        return httpPatch;
    }

    public void accept(String mediaType) {
        this.setRequestHeader("Accept", mediaType);
    }

    public int getResponseCode() {
        if (this.response == null) {
            return 500;
        }
        return this.response.getStatusLine().getStatusCode();
    }
}

